<?php 

/* Text element */

function forge_element_heading($atts, $content = null){
	$attributes = extract(shortcode_atts(array(
	'size' => '',
	'tag' => '',
	'color' => '',
	'position' => '',
	'weight' => '',
	), 
	$atts));
	
	$element_size = '';
	$element_position = ' forge-element-heading-'.esc_attr($position);
	$element_tag = 'h2';
	$element_color = '';
	$element_weight = '';
	
	if($tag != ''){
		$element_tag = esc_attr($tag);
	}
	
	if($color != ''){
		$element_color = ' color:'.$color.';';
	}
	
	$element_class = '';
	if(intval($size) != ''){
		$element_size = ' font-size:'.intval($size).'px;';
		if(intval($size) > 40){
			$element_class .= ' forge-element-heading-large';
		}
	}
	
	if($weight != '' && $weight != 'inherit'){
		$element_weight = ' font-weight:'.intval($weight).';';
	}
	
	$element_style = ' style="'.$element_size.$element_color.$element_weight.'"';
	
	$output = '';
	$output .= '<div class="forge-element-heading-container '.$element_class.$element_position.'">';
	$output .= '<'.$element_tag.' class="forge-element-heading-item'.$element_weight.'"'.$element_style.'>';
	$output .= $content;
	$output .= '</'.$element_tag.'>';		
	$output .= '</div>';		
	return $output;
}


add_filter('forge_elements', 'forge_element_heading_metadata');
function forge_element_heading_metadata($data){
	$data['heading'] = array(
	'title' => __('Heading', 'forge'),
	'description' => __('Opening title of different sizes', 'forge'),
	'featured' => 30,
	'group' => 'layout',
	'callback' => 'forge_element_heading',
	'fields' => array(
		array(
		'name' => 'content',
		'label' => __('Content', 'forge'),
		'type' => 'text',
		'default' => 'This is a heading',
		'live' => array(
			'selector' => '.forge-element-heading-item',
			'property' => 'html',
		)),
		
		array(
		'name' => 'size',
		'label' => __('Size', 'forge').' (px)',
		'type' => 'number',
		'width' => '50px',
		'min' => '10',
		'max' => '99',
		'default' => '20',
		'live' => array(
			'selector' => '.forge-element-heading-item',
			'property' => 'css',
			'attribute' => 'font-size',
			'format' => '%VALUE%px',
		)),
		
		array(
		'name' => 'position',
		'label' => __('Position', 'forge'),
		'type' => 'list',
		'choices' => array(
			'left' => __('Left', 'forge'),
			'center' => __('Centered', 'forge'),
			'right' => __('Right', 'forge'),
		),
		'default' => 'left',
		'live' => array(
			'selector' => '.forge-element-heading-container',
			'property' => 'class',
			'format' => 'forge-element-heading-%VALUE%',
		)),
		
		array(
		'name' => 'color',
		'label' => __('Color', 'forge'),
		'type' => 'color',
		'default' => '',
		'live' => array(
			'selector' => '.forge-element-heading-item',
			'property' => 'css',
			'attribute' => 'color',
		)),
		
		array(
		'name' => 'weight',
		'label' => __('Font Weight', 'forge'),
		'type' => 'list',
		'choices' => array(
			'inherit' => __('(Default)', 'forge'),
			'300' => __('Light', 'forge'),
			'400' => __('Regular', 'forge'),
			'700' => __('Bold', 'forge'),
		),
		'default' => 'inherit',
		'live' => array(
			'selector' => '.forge-element-heading-item',
			'property' => 'css',
			'attribute' => 'font-weight',
		)),
		
		array(
		'name' => 'tag',
		'label' => __('Heading Tag', 'forge'),
		'type' => 'list',
		'choices' => array(
			'span' => __('Span', 'forge'),
			'h1' => __('H1', 'forge'),
			'h2' => __('H2', 'forge'),
			'h3' => __('H3', 'forge'),
			'h4' => __('H4', 'forge'),
			'h5' => __('H5', 'forge'),
			'h6' => __('H6', 'forge'),
		),
		'default' => 'h2'),
	));
	
	return $data;
}