<?php 

/* Text element */

function forge_element_image($atts, $content = null){
	$attributes = extract(shortcode_atts(array(
	'image' => '',
	'position' => '',
	'url' => '',
	'style' => '',
	), 
	$atts));
	
	$source = forge_image_url($image);
	$element_url = '';
	$element_position = ' forge-image-'.esc_attr($position);
	$element_style = ' forge-image-'.esc_attr($style);
	
	$element_tag = 'div';
	if($url != ''){
		$element_url = ' href="'.esc_url($url).'"';
		$element_tag = 'a';
	}
	
	$output = '';
	$output .= '<'.$element_tag.$element_url.' class="forge-image-wrap '.$element_position.'">';
	if($source){
		$output .= '<img class="forge-image '.$element_style.'" src="'.$source.'"/>';
	}else{
		$output .= '<div class="forge-image-placeholder"></div>';
	}
	$output .= '</'.$element_tag.'>';		
	return $output;
}


add_filter('forge_elements', 'forge_element_image_metadata');
function forge_element_image_metadata($data){
	$data['image'] = array(
	'title' => __('Image', 'forge'),
	'description' => __('Single, responsive image element.', 'forge'),
	'featured' => 40,
	'group' => 'layout',
	'callback' => 'forge_element_image',
	'fields' => array(
		array(
		'name' => 'image',
		'label' => __('Image', 'forge'),
		'type' => 'image',
		'default' => ''),
		
		array(
		'name' => 'url',
		'label' => __('Destination URL', 'forge'),
		'type' => 'text',
		'placeholder' => 'http://',
		'default' => ''),
		
		array(
		'name' => 'position',
		'label' => __('Image Alignment', 'forge'),
		'type' => 'list',
		'choices' => array(
			'left' => __('Left', 'forge'),
			'center' => __('Center', 'forge'),
			'right' => __('Right', 'forge'),
			'wide' => __('Full Width', 'forge'),
		),
		'default' => 'none',
		'live' => array(
			'selector' => '.forge-image-wrap',
			'property' => 'class',
			'format' => 'forge-image-%VALUE%',
		)),
		
		array(
		'name' => 'style',
		'label' => __('Image Style', 'forge'),
		'type' => 'list',
		'choices' => array(
			'square' => __('Square', 'forge'),
			'normal' => __('Normal', 'forge'),
			'round' => __('Rounded', 'forge'),
			'oval' => __('Oval', 'forge'),
			'circle' => __('Circle', 'forge'),
		),
		'default' => 'none',
		'live' => array(
			'selector' => '.forge-image',
			'property' => 'class',
			'format' => 'forge-image-%VALUE%',
		)),
	));

	return $data;
}
	