<?php 

//set settings defaults
add_filter('cpotheme_customizer_controls', 'cpotheme_customizer_controls');
function cpotheme_customizer_controls($data){ 
	//Layout
	$data['home_order']['default'] = 'slider,tagline,features,portfolio,content';
	$data['home_posts']['default'] = true;
	$data['slider_height']['default'] = 500;
	$data['features_columns']['default'] = 3;
	$data['portfolio_columns']['default'] = 3;
	//Typography
	$data['type_headings']['default'] = 'Habibi';
	$data['type_nav']['default'] = 'Roboto';
	$data['type_body']['default'] = 'Roboto';
	//Colors
	$data['primary_color']['default'] = '#775555';
	$data['secondary_color']['default'] = '#666666';
	$data['type_headings_color']['default'] = '#444444';
	$data['type_widgets_color']['default'] = '#444444';
	$data['type_nav_color']['default'] = '#444444';
	$data['type_body_color']['default'] = '#666666';
	$data['type_link_color']['default'] = '#996b43';
	
	return $data;
}


add_filter('cpotheme_background_args', 'cpotheme_background_args');
function cpotheme_background_args($data){ 
	$data = array('default-color' => 'eeeeee');
	return $data;
}


add_action('wp_head', 'cpotheme_styling_custom', 19);
function cpotheme_styling_custom(){
	$primary_color = cpotheme_get_option('primary_color'); ?>
	<style type="text/css">			
		<?php if($primary_color != ''): ?>
		.menu-main .current_page_ancestor > a,
		.menu-main .current-menu-item > a { color:<?php echo $primary_color; ?>; }
		<?php endif; ?>
    </style>
	<?php
}