<?php
/**
 * @package Lola
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
        <div class="featured-post">
			<?php _e( 'Featured post', 'lola' ); ?>
		</div>
		<?php endif; ?>
    <?php if ( is_single() ) : ?>
			<h1 class="entry-title"><?php the_title(); ?></h1>
			<?php else : ?>
			<h1 class="entry-title">
				<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
			</h1>
			<?php endif; // is_single() ?>
    <footer class="entry-meta">
        <span>Published by <span class="author-by"><?php the_author_link(); ?></span> | <?php get_option( 'date_format' ); ?> | <?php comments_number( 'No Comments', 'One Comment', '% Comments' ); ?> </span>
<div class="should-be-hidden"><?php lola_entry_meta(); ?>
			<?php edit_post_link( __( 'Edit', 'lola' ), '<span class="edit-link">', '</span>' ); ?>
			<?php if ( is_singular() && get_the_author_meta( 'description' ) && is_multi_author() ) : // If a user has filled out their description and this is a multi-author blog, show a bio on their entries. ?> </div>	
				<div class="author-info">
					<div class="author-avatar">
						<?php
						/** This filter is documented in author.php */
						$author_bio_avatar_size = apply_filters( 'lola_author_bio_avatar_size', 68 );
						echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
						?>
					</div><!-- .author-avatar -->
					<div class="author-description">
						<h2><?php printf( __( 'About %s', 'lola' ), get_the_author() ); ?></h2>
						<p><?php the_author_meta( 'description' ); ?></p>
						<div class="author-link">
							<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
								<?php printf( __( 'View all posts by %s <span class="meta-nav">&rarr;</span>', 'lola' ), get_the_author() ); ?>
							</a>
						</div><!-- .author-link	-->
					</div><!-- .author-description -->
				</div><!-- .author-info -->
			<?php endif; ?>
		</footer><!-- .entry-meta -->
		<header class="entry-header">
            <?php if ( has_post_thumbnail()) : // Check if Thumbnail exists ?>
				<div class="category-ribbon"><span><?php
					$category = get_the_category(); 
					echo '<span>' . $category[0]->cat_name . '</span>';?>
                    </div>
				<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( get_the_title() ); ?>" class="thumbnail post_thumbnail" >
					<?php echo the_post_thumbnail(); // Declare pixel size you need inside the array ?>
				</a>
<div class="circle-avatar">
    <?php echo get_avatar( get_the_author_meta( 'user_email' ), 90 ); ?></div>
			<?php endif; ?>
			<?php if ( comments_open() ) : ?>
				<div class="comments-link">
					<?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a reply', 'lola' ) . '</span>', __( '1 Reply', 'lola' ), __( '% Replies', 'lola' ) ); ?>
				</div><!-- .comments-link -->
			<?php endif; // comments_open() ?>
		</header><!-- .entry-header -->
		<?php if ( is_search() ) : // Only display Excerpts for Search ?>
		<div class="entry-summary">
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
		<?php else : ?>
		<div class="entry-content">
			<?php the_excerpt(); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'lola' ), 'after' => '</div>' ) ); ?>
		</div><!-- .entry-content -->
		<?php endif; ?>
	</article><!-- #post -->