<?php

/**

 * Sample implementation of the Custom Header feature

 * http://codex.wordpress.org/Custom_Headers

 *

 * You can add an optional custom header image to header.php like so ...



	<?php if ( get_header_image() ) : ?>

	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">

		<img src="<?php header_image(); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="">

	</a>

	<?php endif; // End header image check. ?>



 *

 * @package Lola

 */



/**

 * Set up the WordPress core custom header feature.

 *

 * @uses lola_header_style()

 * @uses lola_admin_header_style()

 * @uses lola_admin_header_image()

 */



function lola_custom_header_setup() {

	$args = array(

		// Text color and image (empty to use none).

		'default-text-color'     => '515151',

		'default-image'          => '',



		// Set height and width, with a maximum value for the width.

        'default-image'         => get_template_directory_uri() . '/images/lola-header.png',

        'header-text'           => false,

		'height'                 => 160,

		'width'                  => 158,

		'max-width'              => 2000,



		// Support flexible height and width.

		'flex-height'            => false,

		'flex-width'             => false,



		// Random image rotation off by default.

		'random-default'         => false,



		// Callbacks for styling the header and the admin preview.

		'wp-head-callback'       => 'lola_header_style',

		'admin-head-callback'    => 'lola_admin_header_style',

		'admin-preview-callback' => 'lola_admin_header_image',

	);



	add_theme_support( 'custom-header', $args );

}

add_action( 'after_setup_theme', 'lola_custom_header_setup' );



function lola_custom_header_fonts() {

	$font_url = lola_get_font_url();

	if ( ! empty( $font_url ) )

		wp_enqueue_style( 'lola-fonts', esc_url_raw( $font_url ), array(), null );

}

add_action( 'admin_print_styles-appearance_page_custom-header', 'lola_custom_header_fonts' );



function lola_header_style() {

	$text_color = get_header_textcolor();



	// If no custom options for text are set, let's bail

	if ( $text_color == get_theme_support( 'custom-header', 'default-text-color' ) )

		return;



	// If we get this far, we have custom styles.

	?>

	<style type="text/css" id="lola-header-css">

	<?php

		// Has the text been hidden?

		if ( ! display_header_text() ) :

	?>

		.site-title,

		.site-description {

			position: absolute;

			clip: rect(1px 1px 1px 1px); /* IE7 */

			clip: rect(1px, 1px, 1px, 1px);

		}

	<?php

		// If the user has set a custom color for the text, use that.

		else :

	?>

		.site-header h1 a,

		.site-header h2 {

			color: #<?php echo $text_color; ?>;

		}

	<?php endif; ?>

	</style>

	<?php

}



function lola_admin_header_style() {

?>

	<style type="text/css" id="lola-admin-header-css">

	.appearance_page_custom-header #headimg {

		border: none;

		font-family: "Open Sans", Helvetica, Arial, sans-serif;

	}

	#headimg h1,

	#headimg h2 {

		line-height: 1.84615;

		margin: 0;

		padding: 0;

	}

	#headimg h1 {

		font-size: 26px;

	}

	#headimg h1 a {

		color: #515151;

		text-decoration: none;

	}

	#headimg h1 a:hover {

		color: #21759b !important; /* Has to override custom inline style. */

	}

	#headimg h2 {

		color: #757575;

		font-size: 13px;

		margin-bottom: 24px;

	}

	#headimg img {

		max-width: <?php echo get_theme_support( 'custom-header', 'max-width' ); ?>px;

	}

	</style>

<?php

}



function lola_admin_header_image() {

	?>

	<div id="headimg">

		<?php

		if ( ! display_header_text() )



			$style = ' style="display:none;"';

		else

			$style = ' style="color:#' . get_header_textcolor() . ';"';

		?>

		<h1 class="displaying-header-text"><a id="name"<?php echo $style; ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"  tabindex="-1"><?php bloginfo( 'name' ); ?></a></h1>

		<h2 id="desc" class="displaying-header-text"<?php echo $style; ?>><?php bloginfo( 'description' ); ?></h2>

		<?php $header_image = get_header_image();

		if ( ! empty( $header_image ) ) : ?>

			<img src="<?php echo esc_url( $header_image ); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="" />

		<?php endif; ?>

	</div>

<?php }

