const SVG = {
	logoOnly: <svg xmlns="http://www.w3.org/2000/svg" width="17.29"
			height="17.29" viewBox="0 0 17.29 17.29">
		<path
				d="M14.76,14.76A8.61,8.61,0,0,1,12,16.6a8.42,8.42,0,0,1-3.36.69,8.66,8.66,0,0,1-2.72-.44,8.14,8.14,0,0,1-2.38-1.23,9.74,9.74,0,0,1-1.87-1.87A8.27,8.27,0,0,1,.44,11.37,8.67,8.67,0,0,1,0,8.64,8.54,8.54,0,0,1,.68,5.29,8.72,8.72,0,0,1,2.52,2.53,8.71,8.71,0,0,1,5.29.69,8.5,8.5,0,0,1,12,.69a8.78,8.78,0,0,1,2.76,1.84A8.72,8.72,0,0,1,16.6,5.29a8.5,8.5,0,0,1,0,6.71A8.72,8.72,0,0,1,14.76,14.76ZM1.58,5.54A7.66,7.66,0,0,0,1,8.64,7.68,7.68,0,0,0,2.14,12.8a7.51,7.51,0,0,0,3.13,2.84ZM8.29,8.25,7.2,5.3l-.79-.07c-.14,0-.24-.1-.28-.28a.84.84,0,0,1,0-.52c.07-.18.17-.26.31-.26l.33,0,.84,0,.84,0c.54,0,1.23,0,2.06-.11a.31.31,0,0,1,.3.25.92.92,0,0,1,0,.52c0,.18-.14.28-.28.29l-.07,0a.85.85,0,0,1-.25.07,2.3,2.3,0,0,1-.39,0l2.62,7.23.3-.79a19,19,0,0,0,.61-1.88,6.73,6.73,0,0,0,.3-1.65,4.33,4.33,0,0,0-.47-2.13,2.38,2.38,0,0,1-.19-.3l-.2-.32s-.07-.14-.14-.27A1.82,1.82,0,0,1,12.56,5a2.83,2.83,0,0,1-.07-.28,1.22,1.22,0,0,1,0-.32,1.3,1.3,0,0,1,.46-1.08,1.23,1.23,0,0,1,1-.29,7.63,7.63,0,0,0-2.4-1.49A7.49,7.49,0,0,0,8.64,1a7.61,7.61,0,0,0-3.7.93A7.47,7.47,0,0,0,2.19,4.43h.5c.53,0,1.21,0,2.05-.09a.29.29,0,0,1,.3.22.75.75,0,0,1,0,.47.34.34,0,0,1-.28.27l-1,.07,3,7.91ZM7.64,13.2c-.49,1.42-.81,2.36-1,2.84a6.7,6.7,0,0,0,2,.29A7.28,7.28,0,0,0,11,15.94l-2.23-6C8.5,10.68,8.12,11.77,7.64,13.2Zm4.89,2.17a7.4,7.4,0,0,0,2.77-2.81,7.71,7.71,0,0,0,1-3.92A7.51,7.51,0,0,0,15.42,5,9,9,0,0,1,15.5,6.1c0,.36,0,.65,0,.88a4.17,4.17,0,0,1-.13.73c-.06.27-.11.44-.14.53l-.15.4Q14.66,9.66,12.53,15.37Z"/>
	</svg>,
	logoTopTitle: <svg xmlns="http://www.w3.org/2000/svg" width="14.04"
			height="17.33" viewBox="0 0 14.04 17.33">
		<path
				d="M10.13,7.51a4.39,4.39,0,0,1-1.4.93A4.32,4.32,0,0,1,7,8.8a4.64,4.64,0,0,1-1.39-.22A4.22,4.22,0,0,1,4.43,8a4.5,4.5,0,0,1-.95-1,3.77,3.77,0,0,1-.63-1.21A4.37,4.37,0,0,1,3,2.7,4.58,4.58,0,0,1,3.9,1.29,4.59,4.59,0,0,1,5.3.35,4.32,4.32,0,0,1,7,0,4.22,4.22,0,0,1,8.72.35a4.39,4.39,0,0,1,1.4.93,4.26,4.26,0,0,1,.94,1.4,4.2,4.2,0,0,1,.36,1.71,4.48,4.48,0,0,1-1.29,3.12ZM3.42,2.83a3.84,3.84,0,0,0-.31,1.58,3.92,3.92,0,0,0,.6,2.11A3.83,3.83,0,0,0,5.31,8C5,7.24,4.41,5.52,3.42,2.83ZM6.84,4.2,6.28,2.7l-.4,0c-.07,0-.12-.05-.15-.14a.5.5,0,0,1,0-.27c0-.08.08-.13.15-.12h.17l.43,0,.43,0c.27,0,.62,0,1-.06.07,0,.12,0,.16.13a.46.46,0,0,1,0,.26A.17.17,0,0,1,8,2.66l0,0-.12,0-.2,0L9,6.41,9.13,6c.1-.27.21-.59.31-1a3.38,3.38,0,0,0,.15-.84,2.16,2.16,0,0,0-.24-1.08L9.25,3l-.1-.17a1.11,1.11,0,0,1-.07-.13A.85.85,0,0,1,9,2.52a1.55,1.55,0,0,1,0-.15.88.88,0,0,1,0-.16.69.69,0,0,1,.23-.55.66.66,0,0,1,.49-.15A3.75,3.75,0,0,0,8.45.75,4.08,4.08,0,0,0,7,.49,3.81,3.81,0,0,0,5.13,1a3.78,3.78,0,0,0-1.4,1.29H4c.27,0,.62,0,1.05,0,.07,0,.12,0,.15.11a.33.33,0,0,1,0,.24.15.15,0,0,1-.14.13l-.51,0,1.51,4ZM6.51,6.71,6,8.16a3.33,3.33,0,0,0,1,.15,3.76,3.76,0,0,0,1.19-.2L7.08,5C7,5.43,6.76,6,6.51,6.71ZM9,7.82a3.87,3.87,0,0,0,1.41-1.43,4,4,0,0,0,.52-2,3.85,3.85,0,0,0-.47-1.87,3.86,3.86,0,0,1,0,.58c0,.18,0,.33,0,.44a3,3,0,0,1-.06.38c0,.13-.06.22-.08.26s0,.12-.07.21C10.15,4.73,9.72,5.88,9,7.82Z"/>
		<path d="M3.06,10.54v.7H2v2.95H1.14V11.24H0v-.7Z"/>
		<path d="M3.59,10.54h.82v3.65H3.59Z"/>
		<path d="M8,10.54v.7H6.86v2.95H6V11.24H4.94v-.7Z"/>
		<path d="M10.93,13.48v.71H8.49V10.54h.82v2.94Z"/>
		<path d="M11.45,14.19V10.54h2.47v.69H12.27v.71h1.46v.68H12.27v.88H14v.69Z"/>
		<path d="M2,14.93v.46H1.24v1.89H.71V15.39H0v-.46Z"/>
		<path
				d="M3.58,17.28c0-.08-.05-.16-.08-.25l-.09-.26H2.49L2.4,17c0,.09-.06.17-.08.25H1.77l.25-.7L2.25,16l.23-.54c.07-.17.15-.33.23-.5h.5l.23.5.22.54c.08.19.16.4.24.61l.25.7ZM3,15.47l-.06.14-.07.2-.1.25-.11.29h.67c0-.1-.07-.19-.1-.29s-.07-.18-.1-.25S3,15.66,3,15.6Z"/>
		<path
				d="M5.51,15.34a.62.62,0,0,0-.53.21.85.85,0,0,0-.17.56,1.46,1.46,0,0,0,0,.31.77.77,0,0,0,.12.24.65.65,0,0,0,.21.16.61.61,0,0,0,.28.06h.26V16h.53v1.17a1.68,1.68,0,0,1-.3.07,2.54,2.54,0,0,1-.52,0A1.42,1.42,0,0,1,5,17.25,1.18,1.18,0,0,1,4.58,17a1,1,0,0,1-.23-.38,1.46,1.46,0,0,1-.09-.52,1.38,1.38,0,0,1,.09-.52,1.21,1.21,0,0,1,.26-.39A1.18,1.18,0,0,1,5,15a1.39,1.39,0,0,1,.46-.08l.3,0L6,15l.16.06.09.05-.15.42-.25-.1A1.55,1.55,0,0,0,5.51,15.34Z"/>
		<path d="M8.31,16.83v.45H6.74V14.93h.53v1.9Z"/>
		<path d="M8.65,14.93h.53v2.35H8.65Z"/>
		<path
				d="M11.3,17.28c-.15-.27-.32-.53-.49-.79a8.69,8.69,0,0,0-.57-.75v1.54H9.72V14.93h.43l.25.28.28.35.28.38c.09.13.17.26.26.38V14.93h.52v2.35Z"/>
		<path d="M12.28,17.28V14.93h1.59v.45H12.81v.46h.94v.43h-.94v.57H14v.44Z"/>
	</svg>,
	logoTitle: <svg xmlns="http://www.w3.org/2000/svg" width="51.83"
			height="17.29" viewBox="0 0 51.83 17.29">
		<path
				d="M14.76,14.76A8.61,8.61,0,0,1,12,16.6a8.42,8.42,0,0,1-3.36.69,8.66,8.66,0,0,1-2.72-.44,8.14,8.14,0,0,1-2.38-1.23,9.74,9.74,0,0,1-1.87-1.87A8.27,8.27,0,0,1,.44,11.37,8.67,8.67,0,0,1,0,8.64,8.54,8.54,0,0,1,.68,5.29,8.72,8.72,0,0,1,2.52,2.53,8.88,8.88,0,0,1,5.29.69,8.5,8.5,0,0,1,12,.69a9,9,0,0,1,2.76,1.84A8.72,8.72,0,0,1,16.6,5.29a8.5,8.5,0,0,1,0,6.71A8.72,8.72,0,0,1,14.76,14.76ZM1.58,5.54A7.66,7.66,0,0,0,1,8.64,7.68,7.68,0,0,0,2.14,12.8a7.51,7.51,0,0,0,3.13,2.84ZM8.29,8.25,7.2,5.3l-.79-.07c-.14,0-.24-.1-.28-.28a.84.84,0,0,1,0-.52c.07-.18.17-.26.31-.26l.33,0,.84,0,.84,0c.54,0,1.23,0,2.06-.11a.31.31,0,0,1,.3.25.92.92,0,0,1,0,.52c0,.18-.14.28-.28.29l-.07,0a.85.85,0,0,1-.25.07,2.3,2.3,0,0,1-.39,0l2.62,7.23.3-.79a19,19,0,0,0,.61-1.88,6.73,6.73,0,0,0,.3-1.65,4.36,4.36,0,0,0-.47-2.13,2.38,2.38,0,0,1-.19-.3l-.2-.32s-.07-.14-.14-.27A1.82,1.82,0,0,1,12.56,5a2.83,2.83,0,0,1-.07-.28,1.22,1.22,0,0,1,0-.32,1.3,1.3,0,0,1,.46-1.08,1.23,1.23,0,0,1,1-.29A7.74,7.74,0,0,0,8.64,1,7.65,7.65,0,0,0,2.19,4.43h.5c.53,0,1.21,0,2.05-.09a.29.29,0,0,1,.3.22.75.75,0,0,1,0,.47.34.34,0,0,1-.28.27l-1,.07,3,7.91ZM7.64,13.2c-.49,1.42-.81,2.36-1,2.84a6.7,6.7,0,0,0,2,.29A7.28,7.28,0,0,0,11,15.94l-2.23-6C8.5,10.68,8.12,11.77,7.64,13.2Zm4.89,2.17a7.4,7.4,0,0,0,2.77-2.81,7.71,7.71,0,0,0,1-3.92A7.51,7.51,0,0,0,15.42,5,9,9,0,0,1,15.5,6.1c0,.36,0,.65,0,.88a4.17,4.17,0,0,1-.13.73c-.06.27-.11.44-.14.53l-.15.4Q14.66,9.66,12.53,15.37Z"/>
		<path d="M26.82.91v1.6h-2.5V9.23H22.44V2.51h-2.5V.91Z"/>
		<path d="M28,.91H29.9V9.23H28Z"/>
		<path d="M38,.91v1.6h-2.5V9.23H33.6V2.51H31.1V.91Z"/>
		<path d="M44.74,7.62V9.23H39.18V.91h1.88V7.62Z"/>
		<path
				d="M45.94,9.23V.91h5.62V2.48H47.81V4.12h3.33V5.65H47.81v2h4V9.23Z"/>
		<path d="M24.28,10.93v1H22.67v4.33H21.46V12H19.85v-1Z"/>
		<path
				d="M28,16.28c-.06-.19-.12-.38-.19-.58l-.21-.58H25.52c-.06.19-.13.39-.2.59s-.13.38-.19.57H23.88c.2-.58.39-1.11.57-1.6s.36-.95.53-1.38.35-.85.52-1.23.34-.77.52-1.14h1.14c.17.37.35.75.52,1.14s.34.79.52,1.23.34.89.53,1.38.37,1,.57,1.6Zm-1.45-4.14c0,.08-.06.18-.11.32a4.45,4.45,0,0,0-.18.46c-.07.17-.14.37-.22.58s-.17.43-.25.66h1.53q-.12-.35-.24-.66c-.08-.22-.15-.41-.22-.58l-.18-.47A2.65,2.65,0,0,0,26.56,12.14Z"/>
		<path
				d="M32.4,11.85a1.46,1.46,0,0,0-1.21.47,2,2,0,0,0-.38,1.28,2.26,2.26,0,0,0,.1.71,1.49,1.49,0,0,0,.27.55,1.19,1.19,0,0,0,.47.36,1.45,1.45,0,0,0,.65.13h.34a1,1,0,0,0,.25,0V13.45h1.2V16.1a3.61,3.61,0,0,1-.69.18,6.41,6.41,0,0,1-1.18.1,3.11,3.11,0,0,1-1.09-.19,2.17,2.17,0,0,1-.84-.54,2.56,2.56,0,0,1-.54-.87,3.6,3.6,0,0,1-.19-1.18,3.12,3.12,0,0,1,.21-1.19,2.57,2.57,0,0,1,.57-.88A2.33,2.33,0,0,1,31.2,11a2.75,2.75,0,0,1,1-.19,4.61,4.61,0,0,1,.68,0l.53.12a2.37,2.37,0,0,1,.36.13l.21.11-.35,1A2.71,2.71,0,0,0,33.1,12,2.52,2.52,0,0,0,32.4,11.85Z"/>
		<path d="M38.79,15.24v1H35.21V10.93h1.21v4.31Z"/>
		<path d="M39.56,10.93h1.2v5.35h-1.2Z"/>
		<path
				d="M45.59,16.28c-.35-.62-.72-1.22-1.12-1.82a19.7,19.7,0,0,0-1.28-1.69v3.51H42V10.93h1a7.39,7.39,0,0,1,.56.62c.21.25.42.51.63.79s.43.57.64.88l.59.86V10.93h1.2v5.35Z"/>
		<path d="M47.83,16.28V10.93h3.62v1H49V13h2.14v1H49v1.29h2.59v1Z"/>
	</svg>,
	titleLogo: <svg xmlns="http://www.w3.org/2000/svg" width="51.65"
			height="17.29" viewBox="0 0 51.65 17.29">
		<path
				d="M49.12,14.76a8.69,8.69,0,0,1-2.76,1.85,8.57,8.57,0,0,1-3.35.68,8.67,8.67,0,0,1-2.73-.44,8.27,8.27,0,0,1-2.38-1.23A9.74,9.74,0,0,1,36,13.75a8.27,8.27,0,0,1-1.23-2.38,8.67,8.67,0,0,1-.44-2.73,8.69,8.69,0,0,1,2.53-6.11A8.72,8.72,0,0,1,39.65.69a8.5,8.5,0,0,1,6.71,0,8.83,8.83,0,0,1,2.76,1.84A8.72,8.72,0,0,1,51,5.29,8.5,8.5,0,0,1,51,12,8.72,8.72,0,0,1,49.12,14.76ZM35.94,5.54a7.66,7.66,0,0,0-.62,3.1A7.68,7.68,0,0,0,36.5,12.8a7.51,7.51,0,0,0,3.13,2.84Zm6.71,2.71L41.56,5.3l-.79-.07c-.14,0-.23-.1-.28-.28a.77.77,0,0,1,0-.52c.06-.18.16-.26.3-.26l.34,0,.83,0,.84,0c.54,0,1.23,0,2.06-.11a.31.31,0,0,1,.3.25.84.84,0,0,1,0,.52c0,.18-.14.28-.28.29l-.07,0a.77.77,0,0,1-.25.07,2.3,2.3,0,0,1-.39,0l2.62,7.23.3-.79a19,19,0,0,0,.61-1.88,6.73,6.73,0,0,0,.3-1.65,4.36,4.36,0,0,0-.47-2.13,2.38,2.38,0,0,1-.19-.3l-.19-.32s-.08-.14-.15-.27A1.82,1.82,0,0,1,46.92,5a2.83,2.83,0,0,1-.07-.28,1.22,1.22,0,0,1,0-.32,1.3,1.3,0,0,1,.46-1.08,1.24,1.24,0,0,1,1-.29,7.86,7.86,0,0,0-2.4-1.49A7.73,7.73,0,0,0,43,1a7.65,7.65,0,0,0-6.46,3.47h.5c.53,0,1.21,0,2.05-.09a.29.29,0,0,1,.3.22.75.75,0,0,1,0,.47.34.34,0,0,1-.28.27l-1,.07,3,7.91ZM42,13.2c-.49,1.42-.81,2.37-1,2.84a6.72,6.72,0,0,0,2,.29,7.27,7.27,0,0,0,2.34-.39l-2.23-6Zm4.89,2.17a7.33,7.33,0,0,0,2.77-2.81,7.71,7.71,0,0,0,1-3.92A7.51,7.51,0,0,0,49.78,5a9,9,0,0,1,.08,1.13c0,.36,0,.65,0,.88a4.17,4.17,0,0,1-.13.73c-.06.27-.11.44-.14.53l-.15.4Q49,9.66,46.89,15.37Z"/>
		<path d="M7,.91v1.6H4.47V9.23H2.59V2.51H.09V.91Z"/>
		<path d="M8.17.91h1.88V9.23H8.17Z"/>
		<path d="M18.13.91v1.6h-2.5V9.23H13.75V2.51h-2.5V.91Z"/>
		<path d="M24.89,7.62V9.23H19.33V.91h1.88V7.62Z"/>
		<path d="M26.09,9.23V.91h5.62V2.48H28V4.12h3.33V5.65H28v2h4V9.23Z"/>
		<path d="M4.43,10.93v1H2.82v4.33H1.61V12H0v-1Z"/>
		<path
				d="M8.16,16.28C8.1,16.09,8,15.9,8,15.7l-.21-.58H5.67c-.06.19-.13.39-.2.59s-.13.38-.19.57H4c.2-.58.39-1.11.57-1.6s.36-.95.53-1.38l.51-1.23c.17-.39.35-.77.53-1.14H7.31c.17.37.35.75.52,1.14s.34.79.51,1.23.35.89.54,1.38.37,1,.57,1.6ZM6.71,12.14a2.32,2.32,0,0,1-.12.32c0,.13-.11.28-.17.46s-.14.37-.22.58-.17.43-.25.66H7.48l-.24-.66c-.08-.22-.15-.41-.22-.58l-.18-.47A2.65,2.65,0,0,0,6.71,12.14Z"/>
		<path
				d="M12.55,11.85a1.46,1.46,0,0,0-1.21.47A2,2,0,0,0,11,13.6a2.26,2.26,0,0,0,.1.71,1.49,1.49,0,0,0,.27.55,1.19,1.19,0,0,0,.47.36,1.45,1.45,0,0,0,.65.13h.34a1,1,0,0,0,.25,0V13.45h1.2V16.1a3.61,3.61,0,0,1-.69.18,6.41,6.41,0,0,1-1.18.1,3.11,3.11,0,0,1-1.09-.19,2.17,2.17,0,0,1-.84-.54,2.56,2.56,0,0,1-.54-.87,3.6,3.6,0,0,1-.19-1.18,3.12,3.12,0,0,1,.21-1.19,2.57,2.57,0,0,1,.57-.88,2.37,2.37,0,0,1,.85-.54,2.84,2.84,0,0,1,1.05-.19,4.61,4.61,0,0,1,.68,0l.53.12a2.37,2.37,0,0,1,.36.13l.21.11-.35,1a3,3,0,0,0-.57-.23A2.57,2.57,0,0,0,12.55,11.85Z"/>
		<path d="M18.94,15.24v1H15.36V10.93h1.21v4.31Z"/>
		<path d="M19.71,10.93h1.2v5.35h-1.2Z"/>
		<path
				d="M25.74,16.28c-.35-.62-.72-1.22-1.12-1.82a19.7,19.7,0,0,0-1.28-1.69v3.51H22.15V10.93h1a7.39,7.39,0,0,1,.56.62c.21.25.42.51.63.79s.43.57.64.88l.59.86V10.93h1.2v5.35Z"/>
		<path
				d="M28,16.28V10.93H31.6v1H29.19V13h2.14v1H29.19v1.29h2.59v1Z"/>
	</svg>,
	px: <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
		<g>
			<path
					d="M10,10.71a5.32,5.32,0,0,1-.2,1.49,3.53,3.53,0,0,1-.59,1.16,2.67,2.67,0,0,1-1,.75,3.1,3.1,0,0,1-1.33.27,3.89,3.89,0,0,1-.78-.08,4,4,0,0,1-.69-.23v2.66h-2V7.42l.62-.15.73-.13.78-.09.76,0a4.48,4.48,0,0,1,1.56.26A3.26,3.26,0,0,1,9,8a3,3,0,0,1,.72,1.16A4.39,4.39,0,0,1,10,10.71Zm-2,.06a2.42,2.42,0,0,0-.42-1.49,1.44,1.44,0,0,0-1.23-.56l-.5,0-.37,0V12.4a1.51,1.51,0,0,0,.49.2,2.1,2.1,0,0,0,.61.09C7.48,12.69,8,12.05,8,10.77Z"/>
			<path
					d="M14.1,9.16l1.41-2h2.06l-2.45,3.43a22.48,22.48,0,0,1,1.5,1.93c.43.64.78,1.2,1.05,1.7H15.52l-.27-.5-.36-.63a3.88,3.88,0,0,0-.42-.56L14,12.13l-.42.39a2.43,2.43,0,0,0-.39.52c-.13.21-.25.42-.37.63s-.23.39-.33.57h-2c.11-.22.26-.48.44-.79s.39-.62.61-.95.46-.64.71-.95.51-.59.76-.86c-.44-.63-.86-1.23-1.27-1.8l-1.2-1.71h2.16Z"/>
		</g>
	</svg>,
	em: <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
		<g>
			<path
					d="M.9,10.72a4.18,4.18,0,0,1,.29-1.64A3.62,3.62,0,0,1,1.94,7.9,3.26,3.26,0,0,1,3,7.19,3.35,3.35,0,0,1,4.28,7a3.14,3.14,0,0,1,2.38.92,3.78,3.78,0,0,1,.87,2.7c0,.12,0,.25,0,.39s0,.26,0,.37H3a1.37,1.37,0,0,0,.58,1,2.34,2.34,0,0,0,1.37.36A6.38,6.38,0,0,0,6,12.57a4.38,4.38,0,0,0,.87-.25l.26,1.62a2.39,2.39,0,0,1-.43.17c-.18.05-.37.1-.59.14l-.71.1c-.25,0-.5,0-.75,0A4.61,4.61,0,0,1,3,14.11a3.25,3.25,0,0,1-1.17-.78,3,3,0,0,1-.68-1.16A4.54,4.54,0,0,1,.9,10.72ZM5.6,10a2.1,2.1,0,0,0-.09-.5A1.37,1.37,0,0,0,5.28,9a1.22,1.22,0,0,0-.39-.31,1.28,1.28,0,0,0-.58-.12,1.43,1.43,0,0,0-.58.11,1.13,1.13,0,0,0-.4.31,1.31,1.31,0,0,0-.25.43A3.18,3.18,0,0,0,3,10Z"/>
			<path
					d="M13,10.45a2.84,2.84,0,0,0-.25-1.37,1,1,0,0,0-.86-.4l-.39,0-.38.05V14.2h-2V7.38c.17,0,.37-.09.6-.14l.73-.14q.38-.06.78-.09L12,7a3.35,3.35,0,0,1,1.25.19,3,3,0,0,1,.78.46,3.79,3.79,0,0,1,1-.48A3.31,3.31,0,0,1,16,7a3.51,3.51,0,0,1,1.39.23,2.07,2.07,0,0,1,.86.67,2.37,2.37,0,0,1,.44,1,5.87,5.87,0,0,1,.13,1.31v4h-2V10.45a2.86,2.86,0,0,0-.24-1.37,1,1,0,0,0-.86-.4,2.13,2.13,0,0,0-.45.08,1.89,1.89,0,0,0-.47.2,3.55,3.55,0,0,1,.12.65c0,.23,0,.48,0,.74V14.2H13Z"/>
		</g>
	</svg>,
	percent: <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
		<g>
			<path
					d="M9.1,7.7c0,0.8-0.2,1.5-0.6,1.9s-1,0.7-1.7,0.7S5.4,10.1,5,9.7S4.3,8.6,4.3,7.7S4.5,6.3,5,5.8s1-0.7,1.7-0.7     S8,5.4,8.4,5.8S9.1,6.9,9.1,7.7z M7.5,7.7c0-0.5-0.1-0.8-0.2-1C7.1,6.5,6.9,6.4,6.7,6.4c-0.3,0-0.5,0.1-0.6,0.3s-0.2,0.5-0.2,1     s0.1,0.8,0.2,1C6.2,9,6.4,9.1,6.7,9.1c0.2,0,0.5-0.1,0.6-0.3C7.5,8.5,7.5,8.2,7.5,7.7z M11.7,5.4h1.9l-5.2,9.3H6.4L11.7,5.4z      M15.7,12.3c0,0.8-0.2,1.5-0.6,1.9c-0.4,0.4-1,0.7-1.7,0.7s-1.3-0.2-1.7-0.7s-0.6-1.1-0.6-1.9c0-0.8,0.2-1.5,0.6-1.9     c0.4-0.4,1-0.7,1.7-0.7s1.3,0.2,1.7,0.7C15.5,10.8,15.7,11.4,15.7,12.3z M14.2,12.3c0-0.5-0.1-0.8-0.2-1     c-0.2-0.2-0.4-0.3-0.6-0.3c-0.3,0-0.5,0.1-0.6,0.3c-0.2,0.2-0.2,0.5-0.2,1s0.1,0.8,0.2,1s0.4,0.3,0.6,0.3c0.2,0,0.5-0.1,0.6-0.3     C14.1,13,14.2,12.7,14.2,12.3z"/>
		</g>
	</svg>,
	buttonFill: <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32.58 11.01"
			className="button-filled-svg">
		<rect width="32.58" height="11.01" rx="1"/>
		<path d="M5,7.93V3.07H8.22V4H6.06V5H8v.91H6.06v2Z"/>
		<path d="M9,3.07h1.09V7.93H9Z"/>
		<path d="M14.45,7v.94H11.21V3.07H12.3V7Z"/>
		<path d="M18.4,7v.94H15.16V3.07h1.09V7Z"/>
		<path d="M19.11,7.93V3.07h3.28V4H20.2v1h1.94v.9H20.2V7h2.35v.92Z"/>
		<path
				d="M27.62,5.5a2.88,2.88,0,0,1-.2,1.1,2.11,2.11,0,0,1-.56.78,2.38,2.38,0,0,1-.88.46A4.13,4.13,0,0,1,24.82,8c-.2,0-.43,0-.69,0a6.48,6.48,0,0,1-.77-.1V3.13A6.35,6.35,0,0,1,24.15,3l.7,0A4.45,4.45,0,0,1,26,3.15a2.32,2.32,0,0,1,.87.45,1.92,1.92,0,0,1,.56.77A2.93,2.93,0,0,1,27.62,5.5ZM24.45,7h.42a1.59,1.59,0,0,0,1.22-.41,1.61,1.61,0,0,0,.4-1.14,1.62,1.62,0,0,0-.38-1.16A1.6,1.6,0,0,0,24.91,4h-.23l-.23,0Z"/>
	</svg>,
	buttonOutline: <svg xmlns="http://www.w3.org/2000/svg"
			viewBox="0 0 39.01 12.01"
			className="button-outline-svg">
		<rect className="a" x="0.5" y="0.5" width="38.01" height="11.01"
				rx="1.08"/>
		<path
				d="M9.38,6A2.83,2.83,0,0,1,9.19,7.1a2.12,2.12,0,0,1-.51.8,2.14,2.14,0,0,1-.76.48,2.76,2.76,0,0,1-1,.16A2.65,2.65,0,0,1,6,8.38a2.18,2.18,0,0,1-.77-.48,2.14,2.14,0,0,1-.52-.8A2.83,2.83,0,0,1,4.54,6a2.88,2.88,0,0,1,.19-1.1,2.54,2.54,0,0,1,.53-.8A2.32,2.32,0,0,1,6,3.63,2.58,2.58,0,0,1,7,3.47a2.69,2.69,0,0,1,.94.16,2.27,2.27,0,0,1,.77.48,2.36,2.36,0,0,1,.52.8A2.88,2.88,0,0,1,9.38,6ZM5.67,6a2.11,2.11,0,0,0,.09.64,1.38,1.38,0,0,0,.25.5,1.13,1.13,0,0,0,.4.32A1.35,1.35,0,0,0,7,7.58a1.33,1.33,0,0,0,.54-.11,1.17,1.17,0,0,0,.41-.32,1.56,1.56,0,0,0,.25-.5A2.11,2.11,0,0,0,8.25,6a2.17,2.17,0,0,0-.09-.65,1.47,1.47,0,0,0-.25-.5,1.17,1.17,0,0,0-.41-.32A1.33,1.33,0,0,0,7,4.43a1.35,1.35,0,0,0-.55.11,1.16,1.16,0,0,0-.4.33,1.31,1.31,0,0,0-.25.5A2.11,2.11,0,0,0,5.67,6Z"/>
		<path
				d="M12.19,8.54a2.58,2.58,0,0,1-.88-.14,1.79,1.79,0,0,1-.62-.4,1.55,1.55,0,0,1-.35-.61,2.47,2.47,0,0,1-.12-.79v-3h1.1V6.51a1.75,1.75,0,0,0,.06.5,1.2,1.2,0,0,0,.18.34.73.73,0,0,0,.28.19,1.44,1.44,0,0,0,.37,0,.92.92,0,0,0,.65-.24,1.19,1.19,0,0,0,.24-.84V3.58h1.1v3a2.47,2.47,0,0,1-.12.79,1.62,1.62,0,0,1-.36.61,1.7,1.7,0,0,1-.63.4A2.66,2.66,0,0,1,12.19,8.54Z"/>
		<path d="M18.86,3.58v.93H17.39V8.44H16.3V4.51H14.83V3.58Z"/>
		<path d="M22.81,7.5v.94H19.56V3.58h1.09V7.5Z"/>
		<path d="M23.51,3.58H24.6V8.44H23.51Z"/>
		<path
				d="M29,8.44q-.46-.82-1-1.65a16.16,16.16,0,0,0-1.16-1.53V8.44H25.73V3.58h.89q.22.22.51.57t.57.72c.2.25.39.52.58.79l.54.79V3.58h1.09V8.44Z"/>
		<path
				d="M31,8.44V3.58h3.28V4.5H32.13v1h1.94v.9H32.13V7.52h2.35v.92Z"/>
	</svg>,
	capitalize: <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
		<g>
			<path
					d="M8.84,14.2c-.11-.32-.22-.66-.34-1s-.23-.68-.35-1H4.51l-.35,1q-.18.51-.33,1H1.66c.35-1,.68-1.93,1-2.78s.62-1.65.92-2.4.6-1.47.89-2.14.6-1.34.91-2h2c.3.65.6,1.31.9,2s.6,1.38.9,2.14.61,1.55.92,2.4.65,1.78,1,2.78ZM6.32,7c-.05.14-.11.32-.2.55s-.2.51-.31.81l-.39,1c-.14.36-.28.75-.43,1.15H7.65L7.24,9.36c-.14-.36-.26-.7-.38-1l-.32-.81C6.45,7.32,6.38,7.13,6.32,7Z"/>
			<path
					d="M14.53,7a4.81,4.81,0,0,1,1.48.2,2.43,2.43,0,0,1,.95.58,2.18,2.18,0,0,1,.5.91,4.48,4.48,0,0,1,.15,1.2V14l-1.2.22a12.06,12.06,0,0,1-1.85.13,5.86,5.86,0,0,1-1.24-.12,2.7,2.7,0,0,1-1-.4,1.74,1.74,0,0,1-.62-.72A2.52,2.52,0,0,1,11.52,12a2.08,2.08,0,0,1,.25-1,1.93,1.93,0,0,1,.67-.69,3,3,0,0,1,1-.37,5.8,5.8,0,0,1,1.11-.11c.26,0,.49,0,.7,0a3.65,3.65,0,0,1,.49.09V9.74a1.14,1.14,0,0,0-.31-.82,1.55,1.55,0,0,0-1.08-.31,6.63,6.63,0,0,0-1,.08,4.16,4.16,0,0,0-.86.21l-.26-1.61.44-.12c.17,0,.36-.08.57-.11L13.84,7Q14.19,7,14.53,7Zm.16,5.85h.57l.43,0V11.23l-.37-.05-.44,0a3,3,0,0,0-.53,0,1.42,1.42,0,0,0-.44.12.81.81,0,0,0-.29.26.7.7,0,0,0-.11.4.69.69,0,0,0,.32.65A1.75,1.75,0,0,0,14.69,12.8Z"/>
		</g>
	</svg>,
	lowercase: <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
		<g>
			<path
					d="M6.05,7a4.77,4.77,0,0,1,1.48.2,2.43,2.43,0,0,1,1,.58,2.18,2.18,0,0,1,.5.91,4.48,4.48,0,0,1,.15,1.2V14l-1.2.22a12.06,12.06,0,0,1-1.85.13,5.86,5.86,0,0,1-1.24-.12,2.78,2.78,0,0,1-1-.4,1.74,1.74,0,0,1-.62-.72A2.52,2.52,0,0,1,3,12a2.08,2.08,0,0,1,.25-1A1.93,1.93,0,0,1,4,10.29a3.09,3.09,0,0,1,1-.37A5.83,5.83,0,0,1,6,9.81q.39,0,.69,0a3.65,3.65,0,0,1,.49.09V9.74a1.14,1.14,0,0,0-.31-.82,1.55,1.55,0,0,0-1.08-.31,6.63,6.63,0,0,0-1,.08A4.33,4.33,0,0,0,4,8.9L3.7,7.29l.44-.12c.17,0,.36-.08.57-.11L5.36,7Q5.71,7,6.05,7Zm.16,5.85h.57l.43,0V11.23l-.37-.05-.44,0a3,3,0,0,0-.53,0,1.5,1.5,0,0,0-.44.12.81.81,0,0,0-.29.26A.7.7,0,0,0,5,12a.69.69,0,0,0,.32.65A1.75,1.75,0,0,0,6.21,12.8Z"/>
			<path
					d="M13.48,7a4.7,4.7,0,0,1,1.47.2,2.36,2.36,0,0,1,1,.58,2,2,0,0,1,.5.91,4.48,4.48,0,0,1,.15,1.2V14l-1.19.22a12.11,12.11,0,0,1-1.86.13,5.93,5.93,0,0,1-1.24-.12,2.78,2.78,0,0,1-1-.4,1.81,1.81,0,0,1-.62-.72A2.52,2.52,0,0,1,10.47,12a2,2,0,0,1,.25-1,1.9,1.9,0,0,1,.66-.69,3.15,3.15,0,0,1,1-.37,5.72,5.72,0,0,1,1.11-.11q.39,0,.69,0a3.37,3.37,0,0,1,.49.09V9.74a1.1,1.1,0,0,0-.31-.82,1.5,1.5,0,0,0-1.07-.31,6.77,6.77,0,0,0-1,.08,4.33,4.33,0,0,0-.86.21l-.25-1.61.43-.12.57-.11L12.79,7Q13.12,7,13.48,7Zm.16,5.85h.56l.43,0V11.23l-.36-.05-.44,0a2.93,2.93,0,0,0-.53,0,1.42,1.42,0,0,0-.44.12.85.85,0,0,0-.3.26.7.7,0,0,0-.1.4.68.68,0,0,0,.31.65A1.76,1.76,0,0,0,13.64,12.8Z"/>
		</g>
	</svg>,
	uppercase: <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
		<g>
			<path
					d="M7.39,14.2c-.11-.32-.22-.66-.34-1s-.23-.68-.35-1H3.06l-.35,1q-.18.51-.33,1H.21c.35-1,.68-1.93,1-2.78s.62-1.65.92-2.4.6-1.47.89-2.14.6-1.34.91-2h2c.3.65.61,1.31.9,2s.6,1.38.9,2.14.61,1.55.92,2.4.65,1.78,1,2.78ZM4.87,7c0,.14-.11.32-.2.55s-.2.51-.31.81S4.12,9,4,9.37s-.28.75-.43,1.15H6.2L5.79,9.36c-.14-.36-.26-.7-.38-1l-.32-.81C5,7.32,4.93,7.13,4.87,7Z"/>
			<path
					d="M17.56,14.2c-.1-.32-.21-.66-.33-1l-.36-1H13.24c-.12.33-.24.67-.35,1s-.23.67-.33,1H10.38c.35-1,.68-1.93,1-2.78S12,9.77,12.3,9s.6-1.47.89-2.14.6-1.34.91-2h2c.31.65.61,1.31.91,2s.59,1.38.9,2.14.61,1.55.92,2.4.65,1.78,1,2.78ZM15.05,7l-.21.55-.3.81-.39,1c-.14.36-.29.75-.43,1.15h2.66c-.14-.4-.28-.79-.42-1.16s-.26-.7-.38-1l-.31-.81Z"/>
			<path
					d="M7.38,14.2c-.1-.32-.21-.66-.33-1l-.36-1H3.06q-.18.49-.36,1l-.33,1H.2c.35-1,.68-1.93,1-2.78s.62-1.65.92-2.4.6-1.47.89-2.14.59-1.34.91-2h2c.31.65.61,1.31.91,2S7.4,8.26,7.7,9s.61,1.55.93,2.4.64,1.78,1,2.78ZM4.86,7c0,.14-.11.32-.2.55s-.19.51-.31.81S4.11,9,4,9.37s-.29.75-.44,1.15H6.19L5.78,9.36c-.13-.36-.26-.7-.38-1l-.32-.81C5,7.32,4.92,7.13,4.86,7Z"/>
			<path
					d="M17.56,14.2c-.11-.32-.22-.66-.34-1s-.23-.68-.35-1H13.23l-.35,1q-.18.51-.33,1H10.38c.35-1,.68-1.93,1-2.78S12,9.77,12.29,9s.6-1.47.89-2.14.6-1.34.91-2h2c.3.65.6,1.31.9,2s.6,1.38.9,2.14.61,1.55.92,2.4.65,1.78,1,2.78ZM15,7c0,.14-.11.32-.2.55s-.2.51-.31.81-.24.64-.39,1-.28.75-.43,1.15h2.66L16,9.36c-.14-.36-.26-.7-.38-1l-.32-.81C15.17,7.32,15.1,7.13,15,7Z"/>
		</g>
	</svg>
};

export default SVG;
