# Neve #
**Contributors:** [themeisle](https://profiles.wordpress.org/themeisle)  
**Tags:** blog, custom-logo, e-commerce, rtl-language-support, post-formats, grid-layout, one-column, two-columns, custom-background, custom-colors, custom-header, custom-menu, featured-image-header, featured-images, flexible-header, full-width-template, sticky-post, theme-options, threaded-comments, translation-ready, accessibility-ready, wide-blocks, block-styles, footer-widgets, portfolio, left-sidebar, right-sidebar  
**Requires at least:** 4.0  
**Tested up to:** 5.3  
**Stable tag:** 1.0.23  
**Requires PHP:** 5.4.0  
**License:** GPLv2 or later  
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html  

Neve is a super fast, easily customizable, multi-purpose theme. Perfect for blogs, small business, startups, agencies, firms & e-commerce shops.

## Description ##
Neve is a super fast, easily customizable, multi-purpose theme. It’s perfect for blogs, small business, startups, agencies, firms, e-commerce shops (WooCommerce storefront) as well as personal portfolio sites and most types of projects. A fully AMP optimized and responsive theme, Neve will load in mere seconds and adapt perfectly on any viewing device. While it is lightweight and has a minimalist design, the theme is highly extendable, it has a highly SEO optimized code, resulting in top rankings in Google search results. Neve works perfectly with Gutenberg and the most popular page builders (Elementor, Brizy, Beaver Builder, Visual Composer, SiteOrigin, Divi). Neve is also WooCommerce ready, responsive, RTL & translation ready. Look no further. Neve is the perfect theme for you!

## Copyright ##
Neve WordPress theme, Copyright 2018 Themeisle
Neve is distributed under the terms of the GNU GPLv2 or later

## Changelog ##
### 2.5.4 - 2019-12-19  ###

* [Feat] New styling options for buttons in the header builder
* [Feat] New dynamic tags for the header and footer builder
* [Fix] External fonts not loading in editor
* [Fix] Removed unnecessary post metadata saved in the database
* [Fix] Improved primary menu closing animation on mobile
* [Fix] Button block preview in the editor
* [Fix] Compatibility with the latest update of Gutenberg
* [Fix] Improved padding and margin components layout
* [Fix] Button border-radius control default value not allowing a zero value
* [Fix] Made default layout full width when the sidebar is empty


### 2.5.3 - 2019-12-05  ###

* [Feat] New option to allow both logo and site and tagline in different layouts
* [Feat] New dedicated typography controls for the Primary, Secondary and Footer menus, HTML, Copyright, Cart and Search icons components on the header builder
* [Fix] Embeds compatibility issues with Jetpack and the Embed Plus for YouTube – Gallery, [Fix] Channel, Playlist, Live Stream plugin
* [Fix] Excerpt compatibility with the Seriously Simple Podcasting plugin
* [Fix] Removed list styling from the All Products block in the WooCommerce Block plugin
* [Fix] Content width live preview on mobile devices
* [Fix] Replaced the Last menu item option with dedicated components for new users
* [Fix] Removed Neve Visual Integration causing issues in the editor
* [Fix] Copyright component striping spaces before and after links
* [Fix] Replaced buttons old padding control with a new version
* [Fix] Padding for the Menu Icon component
* [Fix] Lists spacing alignment
* [Fix] Updated Google Fonts list
* [Fix] Getting post meta value for single product page meta-box


### 2.5.2 - 2019-11-19  ###

* [Feat] Improved mobile header/footer builder UX
* [Feat] New styling controls for the Menu Icon component
* [Feat] New Filled and Outline style options for buttons
* [Fix] Uploading background images in the header/footer builder
* [Fix] Content alignment when Gutenberg is activated
* [Fix] Multiple embeds not visible on the single post page
* [Fix] Better alignment for small icon components of the header/footer builder
* [Fix] Excerpts now inherit text color
* [Fix] Single product titles now inherit H1 typography options
* [Fix] Typography units changes did not trigger control refresh
* [Fix] Enlarged the narrow content in the editor
* [Fix] Removed hover effect on table rows overriding block colors
* [Fix] Overriding header/footer builder templates using child themes


### 2.5.1 - 2019-11-04  ###

* [Fix] Correct migration of body font size to new version


### 2.5.0 - 2019-11-04  ###

* [Feat] Improve header/footer builder UX
* [Feat] Increased header/footer builder row height to 700px
* [Feat] Improve typography controls, adds Text Transform, Font Weight, Letter Spacing controls for headings.
* [Feat] Shadow option for the blog thumbnails
* [Fix] Removed extra padding-top on embeds
* [Fix] Embeds not visible on the blog page
* [Fix] Small compatibility issues with WP 5.3
* [Fix] Cover block text color not updating
* [Fix] Reply comments mechanism when Yoast is installed
* [Fix] Scroll on mobile and tablet and wireframe view in the Divi editor
* [Fix] Content width on full-width container
* [Fix] Headings blocks errors with Gutenberg 6.8.0
* New Beaver Builder Starter Sites
* New Brizy Starter Sites



### 2.4.3 - 2019-10-10  ###

* [Feat] Compatibility with the Header Footer for Beaver Builder plugin
* [Feat] Integrate Cypress E2E testing
* [Fix] Header button component padding affected by general buttons options
* [Fix] Set newly created pages to Full width
* [Fix] Embeds in the Classic Editor
* [Fix] Compatibility with the Smush Lazy Loading

* [Fix] Alignment options for the Secondary and Footer menus
* [Fix] Style ul/li on WooCommerce single product short descriptions
* [Fix] Add support for responsive embeds
* New Beaver Builder Starter Sites: Freelancer & Life Coach


### 2.4.1 - 2019-09-13  ###

* [Feat] New background image options for the header and the footer
* [Feat] Allow custom shortcodes in the HTML components of the header
* [Fix] Improve the cart menu icon, remove empty products message on the dropdown menu
* [Fix] Issue with duplicating thumbnails when using SG Optimizer Lazy Load option
* [Fix] On-print behavior, causing duplicating of the header elements
* [Fix] Page scroll while menu sidebar is open
* [Fix] Search icon alignment options
* [Fix] Issue with hiding the thumbnail on single post pages
* [Fix] Improve header customization UX
* [Fix] Validation errors in AMP
* New Starter Sites
* Tattoo - https://themeisle.com/demo/?theme=Tattoo
* Life Coach - https://themeisle.com/demo/?theme=Life%20Coach
* Creative Portfolio - https://themeisle.com/demo/?theme=Creative%20Portfolio
* Redesigned Starter Sites
* Energy Panels - https://themeisle.com/demo/?theme=Energy%20Panels
* Lawyers - https://themeisle.com/demo/?theme=Lawyers
* Freelancer - https://themeisle.com/demo/?theme=Freelancer
* New Beaver Builder Starter Sites


### 2.4.0 - 2019-08-14  ###

* Fix issue with standard fonts not loading
* Fix compatibility with Async loading of javascript files
* Fix issue with page title on pages built with Elementor
* Adds individual line-height option
* Adds breadcrumbs compatibility with Yoast, Seopress, Rankmath and NavXT
* Performance improvements to the codebase, optimize CSS/JS file loading
* Adds 5 more starter sites



### 2.3.22 - 2019-08-02  ###

* Speed updates for the Starter Sites Library


### 2.3.21 - 2019-07-30  ###

* [Feat] Color options for each header and footer rows
* [Feat] New Starter Sites in the library: Architecture, Fitness, Vacation Rental, and Music Band
* [Fix] Posts overlapping when the Masonry layout was enabled on a slow Internet connection
* [Fix] Importing options from any child theme of Zelle
* [Fix] Updated the Google Fonts Library
* [Fix] Improved layout of the My Account page
* [Fix] Updated components default width in the Header builder to better accommodate each one
* [Fix] Issue with multiple Shipping methods not aligning properly on the Cart page
* [Fix] Sale tag that was cut off in the Exclusive Product section
* [Fix] Redone the spacing control option
* [Fix] Removed Neve's custom integration with Gutenberg by default
* [Fix] Vertically align widgets in the footer area
* [Fix] Slightly larger default height for buttons and inputs for a better layout
* [Perf] Moved customizer CSS code to inline code for better speed results


### 2.3.20 - 2019-07-15  ###

* Updated composer
* Fixed z-index issue with the About page


### 2.3.19 - 2019-07-15  ###

* Release


### 2.3.18 - 2019-07-15  ###

* Multiple speed optimizations: minified scripts, improved enqueued scripts logic, proper size for the gravatar images
* Removed author gravatar image by default and created a new option for it
* Updates for current Starter Sites library
* New Brizy Starter Sites library


### 2.3.17 - 2019-07-08  ###

* Fixed theme check warning


### 2.3.16 - 2019-07-08  ###

* Fixed divider layout in the custom Mega Menu integration
* Fixed onboarding popup for child themes
* Fixed lists styling in the comments area
* Fixed warnings from order control


### 2.3.15 - 2019-06-28  ###

* Fixed primary menu on mobile devices not closing for anchor links
* Fixed menu items description layout in the primary menu
* Auto-focus in the search input


### 2.3.14 - 2019-06-25  ###

* Fixed compatibility issues with the Max Mega Menu plugin
* Fixed compatibility with Neve's custom Mega Menu integration
* Fixed extra padding for the gallery block
* Fixed author bio's image size and alignment
* Fixed accessibility and RTL issues with the header builder
* Fixed lists styling in the comments area
* Compatibility for Neve Pro's Typekit module


### 2.3.12 - 2019-06-17  ###

* Added missing strings in the translation file wpml-config.xml file
* Updated the min PHP version in the readme file
* Upsells for Neve Pro


### 2.3.11 - 2019-06-12  ###

* Redone the layout for the About page
* Added fallbacks for JS features in AMP mode
* Added compatibility between the LifterLMS plugin and the buttons options
* Improved the WooCommerce My Account page layout on mobile devices


### 2.3.10 - 2019-06-04  ###

* New color, padding and border radius options for Primary and Secondary Buttons
* Fixed issue with duplicated posts on the blog page
* Fixed onboarding sites options throwing warnings after the last menu item migration
* Updated the screenshot


### 2.3.9 - 2019-05-27  ###

* Fixed issues with redirects to Otter and WPForms dashboards in the onboarding process


### 2.3.8 - 2019-05-27  ###

* Redone the Last item in menu control to accommodate more items
* Accessibility fixes
* Improved footer widgets logic to better accommodate the footer builder
* Exclusive Products section layout improvements
* WooCommerce buttons enhancements
* New hooks added


### 2.3.7 - 2019-05-07  ###

* New Margin and Padding controls for each header builder component
* Reorganized layout for the header/footer builder using tabs
* Option for the mobile menu to slide from the left side or dropdown toggle
* Basic compatibility with LifterLMS plugin
* New Exclusive Products section on single product pages
* Added animations to the main Gutenberg starter site
* Updates for the Doctors, Restaurant, Vet Center starter sites
* Updates for the latest version of Otter Blocks


### 2.3.6 - 2019-04-22  ###

* Fixed primary menu in AMP mode
* Notice for Otter Blocks for WordPress 5 users
* Fixed vertical alignment in IE
* Remove title appearing in the navigation cart in the latest update of WooCommerce
* Updated the component alignment control in the header/footer builder


### 2.3.5 - 2019-04-15  ###

* Fixed header HTML component stripping HTML code
* Fixed Jetpack's comment form layout issue
* Fixed dropdown menu not working in Microsoft Edge
* Fixed main content shifted to the right in IE11
* Fixed migration from Zelle
* Fixed audio block not displaying in Chrome
* Fixed compatibility with Elementor Pro Theme Locations API
* Added new wp_body_open() function for WP 5.2
* Replaced neve icons with SVGs for a better loading time
* New Shop starter site


### 2.3.4 - 2019-04-05  ###

* Removed unused strings


### 2.3.3 - 2019-04-05  ###

* Fixed AMP issues with the header footer builder
* Smaller header spacing on mobile devices
* Fixed toggle button layout on WooCommerce pages


### 2.3.2 - 2019-04-05  ###

* Header footer builder fixed sanitization


### 2.3.1 - 2019-04-05  ###

* Fixed missing sanitization functions
* Fixed Gutenberg integration with the typography options


### 2.3.0 - 2019-04-04  ###

* NEW Header/Footer builder
* Compatibility with the Header, Footer & Blocks for Elementor plugin
* New option to allow disabling of the custom Gutenberg integration
* Updated the tag list with the newly added tags


### 2.2.0 - 2019-03-18  ###

* New Original starter site created in the new Gutenberg editor for WordPress 5 users
* Improved onboarding page layout
* Compatibility with the Neve Hooks plugin
* WPML compatibility
* Update Contact us with the correct link


### 2.1.0 - 2019-03-07  ###

* Two newly added Elementor Starter Sites
* Small updates to the Starter Sites library
* Improved WooCommerce page layouts
* Improved onboarding page layout
* Fixed issue with .aligncenter class not working properly
* Fixed issue with sidebar not aligned properly on Safari 10
* Fixed SSL issue for generated stylesheets


### 2.0.0 - 2019-02-26  ###

* Refactor the code to allow child themes to override the views folder - https://docs.themeisle.com/article/985-how-to-create-a-child-theme-for-neve
* Updated the onboarding notice to provide more information
* Fixed issue with the image source for the Video block for Otter
* Updated starter sites to use Anchor widgets


### 1.1.4 - 2019-02-08  ###

* Fixed alignment issues with the Gallery widget


### 1.1.3 - 2019-02-07  ###

* Fixed list styling in Elementor


### 1.1.2 - 2019-02-07  ###

* New Gutenberg Blocks added for Otter
* Fixed lists styling
* Fixed issue with Gutenberg Blocks images not visible in an online environment


### 1.1.1 - 2019-02-04  ###

* Fixed issue with content missing on the single post page
* Fixed issue with the Footer Gutenberg block for Otter
* Improved the Neve Energy Panel starter site


### 1.1.0 - 2019-01-31  ###

* NEW Neve Specific Gutenberg blocks for Otter Blocks
* NEW Posts navigation control
* Display category description of categories archive pages
* Fixed issue with the Neve Restaurant starter site not importing in some cases
* Fixed issue with the starter sites not importing when Jetpack is installed
* Fixed issue with scrolling not working on mobile devices for anchored links
* Fixed issue with lists not displaying properly in Elementor
* Fixed fatal error for lower PHP versions


### 1.0.29 - 2019-01-21  ###

* Improved the onboarding process
* Fixed issue with the read more button not appearing for the articles using the read more tag
* Recommend the WeGlot plugin


### 1.0.28 - 2019-01-15  ###

* Layout updates for the starter sites
* Improved layout of the onboarding notice
* Fixed style issues for the select elements


### 1.0.27 - 2019-01-09  ###

* Review the theme to make it Accessibility-ready
* Improved performance for the .alignfull and .alignwide classes in the new WordPress editor
* Fixed alignment of the Polylang language switcher in the navigation menu
* Optimized images used in the Neve starter site
* Fixed compatibility with the Lazy Load plugin duplicating images


### 1.0.26 - 2018-12-17  ###

* Fixed issues in IE with the Neve 2018 Site
* Fixed issues in AMP with the navigation menu


### 1.0.25 - 2018-12-14  ###

* Optimized images for Neve demo and fixed issue with IE
* Fixed issue with primary navigation menu in IE
* Fixed issue with date format in languages different than English


### 1.0.24 - 2018-12-14  ###

* Fixed problems with logo and blog images on AMP
* Fixed problem with the autoloader on specific servers


### 1.0.23 - 2018-12-13  ###

* Fixed style layout for the pullquote Gutenberg block
* Fixed AMP errors


### 1.0.22 - 2018-12-10  ###

* Fixed alt attribute for the author gravatar image
* Improved My Account page layout
* Small fixes for the Gutenberg default blocks


### 1.0.21 - 2018-12-07  ###

* Styled basic Gutenberg blocks
* Fixed issue with the search input icon


### 1.0.20 - 2018-12-05  ###

* New Neve Charity demo
* Updated the text for the upgrade PHP notice
* Style spacing on the checkout page
* Added color for the current menu item in the primary menu
* Fixed menu anchors in the Neve demos


### 1.0.19 - 2018-12-03  ###

* Hide menu cart icon on the Cart page
* Improved code usability
* Fixed issues with the metabox on the Blog page not working


### 1.0.18 - 2018-11-29  ###

* Fixed issue with Gutenberg columns width
* Fixed issues with the content width option
* Refactor the menu class
* Updated theme copyright
* Recommend Otter Blocks plugin
* Added Last menu items options to the fallback primary menu


### 1.0.16 - 2018-11-27  ###

* New Neve Restaurant demo
* Fixed default value for the footer copyright


### 1.0.15 - 2018-11-23  ###

* Fixed issue with thumbnail hiding on single post page


### 1.0.14 - 2018-11-23  ###

* Fixed container width in Gutenberg


### 1.0.13 - 2018-11-23  ###

* Fixed escaping issues
* Changed Gutenberg font size controls


### 1.0.12 - 2018-11-22  ###

* Fixed content width and sidebar background on mobile


### 1.0.11 - 2018-11-22  ###

* Fixed issue with the content width option not updating correctly


### 1.0.10 - 2018-11-22  ###

* Gutenberg integration
* New options for controling the content width and sidebar layout of pages from customizer and individual metabox
* Disable compatibility with AMP version lower than 1.0.0 where paired mode is added
* Improved Neve Options page layout
* New Neve Lawyers demo
* New Neve Doctors demo



### 1.0.9 ###

* AMP integration
* Accessibility ready
* New color options to better fit themes options
* New options to allow reordering the elements on the single post pages
* New individual options to allow disabling specific elements on single posts/pages
* Basic Mega Menu integration
* Improved the onboarding process alongside the import from Zelle
* Improved navigation layout
* Improved comments area style
* Improved WooCommerce layout
* Other small design improvements
* Added fallback menu for the primary menu

### 1.0.8 ###
* Google Search Console compatibility
* Fixed theme check issues
* Changed the onboarding mechanism
* Fixed escaping issues

### 1.0.7 ###
* Accessibility ready
* Refactored the About Neve page
* Design improvements
* Import Zelle ( Zerif ) options if the theme was previously activated
* Remove tags on the archives page header
* Compatibility with Beaver Themer plugin
* Compatibility with Gutenberg
* Updated the readme file

### 1.0.3 ###
* Release Date - 2018-09-24*
* Add proper Elementor Header and Footer support
* Fixed warning caused by forgotten "var_dump" in page / post metabox handler

### v1.0.2 ###
* Release Date - 2018-09-07*
* Demo data for Neve 2018 template

### 1.0.1 ###
* Release Date - 2018-09-07*
* Updated description and screenshot

### 1.0.0 ###
* Release Date - 2018-09-06*
* Lowercase file names.


## Resources ##
* Neve Icons based on Font Awesome Icons licensed under CC BY 4.0 License (https://creativecommons.org/licenses/by/4.0/).

All  images are licensed under CC0.

Screenshot resources:

* http://mystock.themeisle.com/photo/statue-2/
* https://mystock.themeisle.com/photo/path/

Starter Sites screenshots resources:

- Original
* http://mystock.themeisle.com/photo/statue-2/
* https://mystock.themeisle.com/photo/path/

- Restaurant
* https://stocksnap.io/photo/3IRQDGCL7J
* https://stocksnap.io/photo/ZPMWWMHBDE
* https://stocksnap.io/photo/2HEQC6X2DF

- Charity
* https://stocksnap.io/photo/AEENLCARXY

- Vet Center
* https://mystock.themeisle.com/photo/street-dog-sitting-on-a-beach/
* https://mystock.themeisle.com/photo/dog-4/

- Doctors
* https://stocksnap.io/photo/GSBJXWRSDV

- Energy Panels
* http://mystock.themeisle.com/photo/sunny-rome/
* http://mystock.themeisle.com/photo/tour-eiffel/

- Lawyers
* http://mystock.themeisle.com/photo/architecture-3/
* http://mystock.themeisle.com/photo/architecture-2/

- Freelancer
* http://mystock.themeisle.com/photo/programming-laptop/
* http://mystock.themeisle.com/photo/code-in-wp/

- Shop
* https://stocksnap.io/photo/SS2GVMJTWH
* https://stocksnap.io/photo/KQECHSBAOC
* https://stocksnap.io/photo/1CXI0CSPE5
* https://stocksnap.io/photo/JBCWCLO4JI
* https://stocksnap.io/photo/AEENLCARXY

- Travel Agency
* https://mystock.themeisle.com/photo/amsterdam/

- Coffee Shop
* https://stocksnap.io/photo/HOHJK6B7TD
* https://stocksnap.io/photo/DTKOOFPC06

- Constructions
* https://stocksnap.io/photo/T78VYSKHFS
* https://stocksnap.io/photo/ZWTCO4R3G6
* https://stocksnap.io/photo/6EAB6C3900
* https://stocksnap.io/photo/BZ4FJO6KZE

- Showcase
* http://mystock.themeisle.com/photo/mountain/
* http://mystock.themeisle.com/photo/mountain-at-sunset/
* http://mystock.themeisle.com/photo/forest-landscape/

- Business Consulting
* http://mystock.themeisle.com/photo/photographer-2/
* http://mystock.themeisle.com/photo/cameras/

- Architecture
* http://mystock.themeisle.com/photo/wind/
* http://mystock.themeisle.com/photo/architectural-ceiling/
* http://mystock.themeisle.com/photo/glass-building/
* http://mystock.themeisle.com/photo/city-view/
* http://mystock.themeisle.com/photo/trump-tower/
* http://mystock.themeisle.com/photo/white-building/

- Fashion
* https://stocksnap.io/photo/K00RNBNJGC
* https://stocksnap.io/photo/TFK0XBHMRE
* https://stocksnap.io/photo/BRDLQ22VO4
* https://stocksnap.io/photo/HZBJUNAK7H
* https://stocksnap.io/photo/Y7WNWJC6NA

- Fitness
* https://stocksnap.io/photo/M5791YB6J9
* https://stocksnap.io/photo/SRWV8BAHE6

- Vacation Rental
* http://mystock.themeisle.com/photo/pool/

- Music Band
* https://stocksnap.io/photo/G22LER7CJQ
* https://stocksnap.io/photo/E9E65D3D04
* https://stocksnap.io/photo/V2TT0P34KE
* https://stocksnap.io/photo/BG80NXTTHY
* https://stocksnap.io/photo/NV1FLKIE9U
* https://stocksnap.io/photo/IUFVZUDPO5

- Wedding
* https://stocksnap.io/photo/3RI84R6CYH
* https://stocksnap.io/photo/GEVAEIZQH1
* https://stocksnap.io/photo/UXZ782X55D

- TheMotion
* http://mystock.themeisle.com/photo/code-in-wp/
* http://mystock.themeisle.com/photo/empty-beach-2/
* http://mystock.themeisle.com/photo/traffic-sign/
* http://mystock.themeisle.com/photo/android/

- Life Coach
* http://mystock.themeisle.com/photo/city-park-night/
* http://mystock.themeisle.com/photo/temple-2/

- Tattoo
* http://mystock.themeisle.com/photo/unconventional-store-with-unicorn-in-the-window/
* http://mystock.themeisle.com/photo/street-at-night/

- Job Listing
* http://mystock.themeisle.com/photo/registration/
* http://mystock.themeisle.com/photo/stockholm-street/

- Barber Shop
* https://stocksnap.io/photo/R9YRHH2JQY
* http://mystock.themeisle.com/photo/fancy-restaurant/

- Personal Trainer
* http://mystock.themeisle.com/photo/street-vendor-selling-fruits-on-his-fruit-cart/
* http://mystock.themeisle.com/photo/yoga-2/
* http://mystock.themeisle.com/photo/mac-and-cheese-pizza/
* http://mystock.themeisle.com/photo/hotel-with-terrace-on-the-sea/
* http://mystock.themeisle.com/photo/indian-restaurant-dishes/

- Creative Portfolio
* http://mystock.themeisle.com/photo/rocking-chair-on-a-blue-carpet/
* http://mystock.themeisle.com/photo/vintage-framed-photo-of-desserts/
* http://mystock.themeisle.com/photo/bathtub-in-the-center-of-the-room/
* http://mystock.themeisle.com/photo/registration/
* http://mystock.themeisle.com/photo/big-ben/
* http://mystock.themeisle.com/photo/glass-building/

- Real Estate
* http://mystock.themeisle.com/photo/city/
* http://mystock.themeisle.com/photo/glass-building-2/

- Events
* http://mystock.themeisle.com/photo/young-boy-attending-a-concert/
* http://mystock.themeisle.com/photo/performing-artist-with-cool-projections-behind/
* http://mystock.themeisle.com/photo/drummer-plays-drums-kit/
* http://mystock.themeisle.com/photo/concert/
* http://mystock.themeisle.com/photo/rock-on/

- Wedding Photography
* http://mystock.themeisle.com/photo/wedding-flower-decorations/
* http://mystock.themeisle.com/photo/bride-and-groom-table-decorated-with-flowers-2/
* http://mystock.themeisle.com/photo/bride-and-groom/

- Photography Studio
* https://stocksnap.io/photo/3IJLXXN9OY
* https://stocksnap.io/photo/83PSG6Y1FM

- Video Agency
* http://mystock.themeisle.com/photo/cameras/
* http://mystock.themeisle.com/photo/protest/
* http://mystock.themeisle.com/photo/selfie/
* http://mystock.themeisle.com/photo/flatiron-2/

- Furniture Shop
* http://mystock.themeisle.com/photo/bathtub-in-the-center-of-the-room/
* http://mystock.themeisle.com/photo/resort-premium-room/
* http://mystock.themeisle.com/photo/rocking-chair-on-a-blue-carpet/
* http://mystock.themeisle.com/photo/resort-room-with-a-view/
* http://mystock.themeisle.com/photo/couch-with-two-green-pillows/

- Farm
* http://mystock.themeisle.com/photo/yellow-and-green/
* http://mystock.themeisle.com/photo/oranges/
* http://mystock.themeisle.com/photo/swamp/
* http://mystock.themeisle.com/photo/strawberries-and-oranges-for-sale-in-baskets/
* http://mystock.themeisle.com/photo/rosehip/

- Photographer
* http://mystock.themeisle.com/photo/old-casino/
* http://mystock.themeisle.com/photo/photographer-3/
* http://mystock.themeisle.com/photo/sea-breeze/
* http://mystock.themeisle.com/photo/church/
* http://mystock.themeisle.com/photo/flatiron-2/

- Kindergarten
* https://stocksnap.io/photo/NY963ZH6T2
* https://stocksnap.io/photo/PBHFF6RJPH

- Florist
* https://stocksnap.io/photo/01SN8V4M9O
* http://mystock.themeisle.com/photo/wedding-bouquet/
* http://mystock.themeisle.com/photo/wedding-flower-decorations/

- Cake Shop
* https://stocksnap.io/photo/F6DNP46F78
* https://stocksnap.io/photo/7G24TFZEKU

- Transport
* http://mystock.themeisle.com/photo/docks/
* http://mystock.themeisle.com/photo/industrial-boat/

- eBook
* http://mystock.themeisle.com/photo/the-statue-of-liberty-at-sunset/
* http://mystock.themeisle.com/photo/brasov-old-city/
* http://mystock.themeisle.com/photo/mysterious-man-2/

- Speed
* http://mystock.themeisle.com/photo/couch-with-two-green-pillows/
* http://mystock.themeisle.com/photo/mannequin/
* http://mystock.themeisle.com/photo/grooms-suite/
* http://mystock.themeisle.com/photo/luggage-tag-label-on-suitcase-or-bag-with-the-sea-behind-it/

- Food Magazine
* https://mystock.themeisle.com/photo/caesar-salad/
* https://mystock.themeisle.com/photo/indian-restaurant-dishes/
* https://mystock.themeisle.com/photo/mac-and-cheese-pizza/
* https://mystock.themeisle.com/photo/delicious-morning-breakfast-served-on-a-tray/

- Web Design
* https://mystock.themeisle.com/photo/programming-laptop/
* https://mystock.themeisle.com/photo/ipad/

- Yoga Studio
* https://stocksnap.io/photo/OYD9ZOOCCQ
* https://stocksnap.io/photo/TL7LKEE0HR
* https://stocksnap.io/photo/W23EUNXBCG
* https://stocksnap.io/photo/MM6OVJGYRU
* https://mystock.themeisle.com/photo/floor-pattern/

- Sales Funnel
* https://mystock.themeisle.com/photo/cityscape-of-new-york-2/

- Church
* https://mystock.themeisle.com/photo/vatican-streets/
* https://stocksnap.io/photo/M2XAYFTTEN
* https://stocksnap.io/photo/MOUVID40QD
* https://stocksnap.io/photo/AM7OQR2274

- Fashion Magazine
* https://stocksnap.io/photo/F08ZV0M412
* https://stocksnap.io/photo/V5A73VEOJO
* https://stocksnap.io/photo/AOOC3CJARN
* https://stocksnap.io/photo/HKTKMOVXNO

- Winery
* https://stocksnap.io/photo/CM4WVU6WO0

- News Magazine
* https://mystock.themeisle.com/photo/man-sitting-under-a-tree/
* https://mystock.themeisle.com/photo/smartphone/
* https://mystock.themeisle.com/photo/protest/
* https://mystock.themeisle.com/photo/indian-food-bhel-puri-2/
* https://mystock.themeisle.com/photo/skiers/
* https://mystock.themeisle.com/photo/new-york-skyscrapers-on-a-cloudy-wheather/
* https://mystock.themeisle.com/photo/metropolitan-museum/

- Coworking
* https://mystock.themeisle.com/photo/hotel-lobby/
* https://mystock.themeisle.com/photo/code-in-wp/

- Fishing
* https://mystock.themeisle.com/photo/boat-on-a-volcanic-green-lake-surrounded-of-a-forest-2/

- Car Rental
* https://stocksnap.io/photo/5XRZI55HKV
* https://stocksnap.io/photo/Q1KQCULDV5
* https://stocksnap.io/photo/OYLXO1QZ5K

- Ski Resort
* https://stocksnap.io/photo/Z5WEX57EKA
* https://mystock.themeisle.com/photo/mountain/
* https://mystock.themeisle.com/photo/gondola-2/
* https://stocksnap.io/photo/QT3VEK73I5
* https://stocksnap.io/photo/JJE5DPU0U9
* https://stocksnap.io/photo/KRXK7LH6XL

- Digital Product
* https://mystock.themeisle.com/photo/cityscape-of-new-york-2/

- Moving Company
* https://stocksnap.io/photo/YF3WGBL0AK

- Translation Services
* https://mystock.themeisle.com/photo/metropolitan-museum/

- Blogger
* https://mystock.themeisle.com/photo/passing-girl/

- Coupons
* https://mystock.themeisle.com/photo/gift-shop-in-punjim/
* https://mystock.themeisle.com/photo/teddy/
* https://mystock.themeisle.com/photo/couch-with-two-green-pillows/
* https://mystock.themeisle.com/photo/luggage-tag-label-on-suitcase-or-bag-with-the-sea-behind-it/

- Escape Room
* https://mystock.themeisle.com/photo/scary-nymph-group-holding-hands-2/
* https://mystock.themeisle.com/photo/mannequin/
* https://mystock.themeisle.com/photo/light-carpet/
* https://mystock.themeisle.com/photo/mannequin-with-unicorn-mask-standing-in-the-window/

- Resume
* https://mystock.themeisle.com/photo/programming-laptop-2/
* https://mystock.themeisle.com/photo/thinking-time/

- Wellness Spa
* https://mystock.themeisle.com/photo/bathtub-in-the-center-of-the-room/
* https://mystock.themeisle.com/photo/hotel-with-terrace-on-the-sea/
* https://mystock.themeisle.com/photo/exotic-beach-in-maldives/

- Courses
* https://stocksnap.io/photo/SCC00WCQ3I
* https://mystock.themeisle.com/photo/code-in-wp/
* https://mystock.themeisle.com/photo/photographer-2/
* https://mystock.themeisle.com/photo/browser-tabs/

- Fashion Model Agency
* https://mystock.themeisle.com/photo/thinking-time/
* https://mystock.themeisle.com/photo/bride-and-groom/
* https://mystock.themeisle.com/photo/mannequin/
* https://stocksnap.io/photo/WB9WHQU68Q
* https://stocksnap.io/photo/F08ZV0M412
* https://stocksnap.io/photo/Q8FQMQWYKB
* https://stocksnap.io/photo/D626O6RC44

- IT Technology Agency
* https://mystock.themeisle.com/photo/programming-laptop-2/
* https://mystock.themeisle.com/photo/couple-jogging-together-along-the-river-coas/
* https://mystock.themeisle.com/photo/new-york-skyscrapers-on-a-cloudy-wheather/

- Christmas Market
* https://stocksnap.io/photo/A8CFE9WADG
* https://mystock.themeisle.com/photo/young-boy-attending-a-concert/
* https://mystock.themeisle.com/photo/pool-party/

- Podcast
* https://mystock.themeisle.com/photo/tour-eiffel/
* https://mystock.themeisle.com/photo/new-york-skyscrapers-on-a-cloudy-wheather/
* https://mystock.themeisle.com/photo/harbour-air-seaplanes-docked-in-maldives-2/
* https://mystock.themeisle.com/photo/fancy-restaurant/
* https://mystock.themeisle.com/photo/registration/

- Digital Agency
* https://stocksnap.io/photo/RCFX768X06
* https://mystock.themeisle.com/photo/bucharest-at-night/
* https://mystock.themeisle.com/photo/browser-tabs/
* https://mystock.themeisle.com/photo/code-in-wp/
* https://mystock.themeisle.com/photo/tourists/
