-- ------------------------------------------------------
-- ------------------------------------------------------
--
-- WPBackItUp Database Export 
--
-- Created: 2020/06/11 on 06:12
--
-- Database : weadag5_wp496
--
-- Backup   Table  : wpus_blc_instances
-- Snapshot Table  : 1591899135_blc_instances
--
-- SQL    : SELECT * FROM wpus_blc_instances LIMIT 0,10000
-- Offset : 0
-- Rows   : 798
-- ------------------------------------------------------
-- ------------------------------------------------------
SET AUTOCOMMIT = 0 ;
SET FOREIGN_KEY_CHECKS=0 ;

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40101 SET SESSION sql_mode = '' */;

--
-- Table structure for table `1591899135_blc_instances`
--
DROP TABLE  IF EXISTS `1591899135_blc_instances`;
CREATE TABLE `1591899135_blc_instances` (
  `instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int(10) unsigned NOT NULL,
  `container_id` int(10) unsigned NOT NULL,
  `container_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `link_text` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parser_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link',
  `container_field` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_context` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `raw_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`instance_id`),
  KEY `link_id` (`link_id`),
  KEY `source_id` (`container_type`,`container_id`),
  KEY `parser_type` (`parser_type`)
) ENGINE=MyISAM AUTO_INCREMENT=3787 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



--
-- Data for table `wpus_blc_instances`
-- Number of rows: 798
--
INSERT INTO `1591899135_blc_instances` VALUES 
(1,1,3,'page','Electric Frontier Foundation','link','post_content','','https://www.eff.org/'),
 (2,2,3,'page','Privacy Badger','link','post_content','','https://www.eff.org/privacybadger'),
 (3,3,3,'page','uBlock','link','post_content','','https://www.ublock.org/'),
 (4,4,3,'page','http://dmweade.com/welcome/','plaintext-url','post_content','','http://dmweade.com/welcome/'),
 (5,5,3,'page','https://automattic.com/privacy/','plaintext-url','post_content','','https://automattic.com/privacy/'),
 (3786,53,35,'page','Animated Real Paint FX','link','post_content','','https://graphicriver.net/item/animated-real-paint-fx-photoshop-addon-extension/23116581'),
 (3785,52,35,'page','Vector images','link','post_content','','https://inkscape.org/'),
 (3784,51,35,'page','Free image editor','link','post_content','','https://www.gimp.org/'),
 (3783,50,35,'page','Free audio editor','link','post_content','','https://www.audacityteam.org/'),
 (3782,49,35,'page','Watercolour World','link','post_content','','https://www.watercolourworld.org/'),
 (3781,48,35,'page','Freepix','link','post_content','','https://www.freepik.com/'),
 (3780,47,35,'page','Pixeden','link','post_content','','https://www.pixeden.com/'),
 (3777,44,35,'page','Stockio','link','post_content','','https://www.stockio.com/'),
 (3778,45,35,'page','Gratisography','link','post_content','','https://gratisography.com/'),
 (3779,46,35,'page','Travel Coffee Book','link','post_content','','http://travelcoffeebook.com/'),
 (3774,41,35,'page','Resource Cards','link','post_content','','https://resourcecards.com/'),
 (3775,42,35,'page','Pixabay','link','post_content','','https://pixabay.com/'),
 (3776,43,35,'page','Free Design Resources','link','post_content','','https://freedesignresources.net/'),
 (3773,40,35,'page','Video.LibreStock','link','post_content','','https://video.librestock.com/'),
 (3771,38,35,'page','Growth Supply','link','post_content','','http://growthsupply.com/free/'),
 (3772,39,35,'page','LibreStock','link','post_content','','https://librestock.com/'),
 (3770,37,35,'page','Design a Vintage Travel Poster','link','post_content','','https://design.tutsplus.com/tutorials/how-to-design-a-vintage-travel-poster-in-adobe-illustrator-and-photoshop--cms-26075'),
 (3769,36,35,'page','500+ Free Art Books from the Met','link','post_content','','https://www.metmuseum.org/art/metpublications/titles-with-full-text-online?searchtype=F'),
 (3768,35,35,'page','100 Type Ornaments to Use in Your Book','link','post_content','','https://www.thebookdesigner.com/2018/10/110-type-ornaments-to-use-in-your-book-plus-a-free-download/?utm_source=Jane+Friedman+%2F+Electric+Speed&utm_campaign=64484ef8ec-EMAIL_CAMPAIGN_2017_12_30_COPY_01&utm_medium=email&utm_term=0_b84a4334ba-64484ef8ec-332623045'),
 (3767,34,35,'page','Zap Splat','link','post_content','','https://www.zapsplat.com/sound-effect-categories/'),
 (3751,18,35,'page','Font Awesome','link','post_content','','https://fontawesome.com/'),
 (3752,19,35,'page','More Image Libraries','link','post_content','','https://github.com/heyalexej/awesome-images'),
 (3753,20,35,'page','Subtle Patterns','link','post_content','','https://www.toptal.com/designers/subtlepatterns/'),
 (3754,21,35,'page','Vecteasy','link','post_content','','https://www.vecteezy.com/free-vector/free-vector-pattern-background'),
 (3755,22,35,'page','Pattern Library','link','post_content','','http://thepatternlibrary.com/'),
 (3756,23,35,'page','Free Vector','link','post_content','','https://www.freevector.com/'),
 (3757,24,35,'page','Google Fonts','link','post_content','','https://fonts.google.com/'),
 (3758,25,35,'page','Dafont','link','post_content','','https://www.dafont.com/'),
 (3759,26,35,'page','Font Squirrel','link','post_content','','https://www.fontsquirrel.com/'),
 (3760,27,35,'page','TSR fonts','link','post_content','','https://www.kirith.com/tsr-fonts/'),
 (3761,28,35,'page','tree fonts','link','post_content','','https://www.1001fonts.com/trees-fonts.html'),
 (3762,29,35,'page','70+ Free for Commercial Use','link','post_content','','https://www.websiteplanet.com/blog/best-free-fonts/'),
 (3763,30,35,'page','Open Game Art','link','post_content','','https://opengameart.org/'),
 (3764,31,35,'page','Free Sound','link','post_content','','https://freesound.org/'),
 (3765,32,35,'page','BBC Sound Effects','link','post_content','','http://bbcsfx.acropolis.org.uk/'),
 (3766,33,35,'page','Story Blocks','link','post_content','','https://www.audioblocks.com/royalty-free-audio/sound-effects'),
 (3738,338,39,'page','','image','post_content','','https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png'),
 (3737,776,39,'page','A Medieval Lady\'s Closet','link','post_content','','https://www.historyundressed.com/2009/06/medieval-ladys-closet.html'),
 (3736,775,39,'page','Fashion History of the High and Late Middle Ages—Medieval Clothing','link','post_content','','https://bellatory.com/fashion-industry/FashionHistoryoftheHIghandLateMiddleAgesClothingo-the11th-15thCentury'),
 (3732,398,39,'page','Orders of Chivalry for Women','link','post_content','','https://en.wikipedia.org/wiki/Orders_of_chivalry_for_women'),
 (3733,399,39,'page','Women Knights in the Middle Ages','link','post_content','','https://www.heraldica.org/topics/orders/wom-kn.htm'),
 (3734,400,39,'page','Remains Of Ancient Female Fighters Discovered','link','post_content','','https://www.npr.org/2020/01/12/795661047/remains-of-ancient-female-fighters-discovered'),
 (3735,401,39,'page','What Did Historical Swords Weigh?','link','post_content','','http://www.thearma.org/essays/weights.htm'),
 (3731,397,39,'page','Why Fantasy Knights are Unrealistic','link','post_content','','https://timothyrjeveland.com/2019/06/28/why-fantasy-knights-are-unrealistic/'),
 (3729,395,39,'page','How Salt Helped Win the Civil War','link','post_content','','https://www.atlasobscura.com/articles/civil-war-salt'),
 (3730,396,39,'page','Training a Knight','link','post_content','','http://www.medieval-life.net/knight_training.htm'),
 (3717,383,39,'page','Lamps','link','post_content','','http://www.larsdatter.com/lamps.htm'),
 (3718,384,39,'page','candlesticks','link','post_content','','http://www.larsdatter.com/candleholders.htm'),
 (3719,385,39,'page','lanterns','link','post_content','','http://www.larsdatter.com/lanterns.htm'),
 (3720,386,39,'page','torches','link','post_content','','http://www.larsdatter.com/torches.htm'),
 (3721,387,39,'page','Medieval &amp; Renaissance Material Culture','link','post_content','','http://www.larsdatter.com/index.html'),
 (3722,388,39,'page','Life in a Medieval Castle','link','post_content','','http://www.castlewales.com/life.html'),
 (3723,389,39,'page','The Guardian\'s Story of Cities series','link','post_content','','https://www.theguardian.com/cities/series/the-story-of-cities?page=3'),
 (3724,390,39,'page','The Bronze Age Collapse','link','post_content','','https://www.neilport.com/2019/04/the-bronze-age-collapse.html'),
 (3725,391,39,'page','History of the canvas bedroll','link','post_content','','https://www.wynnchester.com/history-of-the-canvas-bedroll/'),
 (3726,392,39,'page','When Was the Worst Time to be Alive in Human History','link','post_content','','https://www.iflscience.com/environment/what-was-the-worst-time-to-be-alive-in-human-history/'),
 (3727,393,39,'page','Alcohol in Ancient/Medieval India','link','post_content','','https://history.stackexchange.com/questions/14343/did-ancient-medieval-indians-produce-and-consume-alcohol'),
 (3728,394,39,'page','4,000 Year History of the Turban','link','post_content','','https://www.cnn.com/style/article/turbans-tales-history/index.html'),
 (3716,382,39,'page','3','link','post_content','','http://jillwilliamson.com/2010/05/medieval-facts-lighting-part-three-oil-lamps/'),
 (3715,381,39,'page','2','link','post_content','','http://jillwilliamson.com/2010/01/medieval-facts-lighting-part-two-torches/'),
 (3714,777,39,'page','1','link','post_content','','https://jillwilliamson.com/medieval-facts-lighting-part-one/'),
 (3713,379,39,'page','Gold Price History from 30 B.C. to Today ','link','post_content','','https://www.thebalance.com/gold-price-history-3305646'),
 (3712,378,39,'page','List of Prices of Medieval Items','link','post_content','','http://medieval.ucdavis.edu/120D/Money.html'),
 (3706,372,39,'page','International Heraldry and Heralds','link','post_content','','http://www.internationalheraldry.com/'),
 (3707,373,39,'page','Glossary of terms','link','post_content','','https://www.heraldsnet.org/saitou/parker/index.htm'),
 (3708,374,39,'page','World Languages Electronic Resources','link','post_content','','https://www.nypl.org/blog/2018/08/23/electronic-resources-world-languages'),
 (3709,375,39,'page','ConLang: How to Construct a Language','link','post_content','','https://ocw.mit.edu/courses/linguistics-and-philosophy/24-917-conlangs-how-to-construct-a-language-fall-2018/index.htm'),
 (3710,376,39,'page','Old Scottish Sayings','link','post_content','','https://scotlandwelcomesyou.com/scottish-sayings/'),
 (3711,377,39,'page','Medieval Prices and Wages','link','post_content','','https://thehistoryofengland.co.uk/resource/medieval-prices-and-wages/'),
 (3705,371,39,'page','Roof shapes','link','post_content','','https://www.thisoldhouse.com/ideas/roof-shapes'),
 (3704,370,39,'page','Ultimate Hat Guide','link','post_content','','https://www.hatsunlimited.com/hat-styles-guide/'),
 (3703,369,39,'page','Settlement Hierarchies (names/usage)','link','post_content','','https://en.wikipedia.org/wiki/Settlement_hierarchy'),
 (3702,368,39,'page','What the Color ‘Haint Blue’ Means to the Descendants of Enslaved Africans','link','post_content','','https://www.atlasobscura.com/articles/what-haint-blue-means-to-descendants-enslaved-africans'),
 (3701,367,39,'page','The Language of Flowers','link','post_content','','http://www.allflorists.co.uk/advice_flowerMeanings.asp'),
 (3699,365,39,'page','Sorcerer\'s Arsenal of Charms','link','post_content','','https://news.artnet.com/art-world/sorcerer-trove-discovered-pompeii-1623607'),
 (3700,366,39,'page','Will There Ever Be New Colors That We Can See?','link','post_content','','https://gizmodo.com/will-there-ever-be-new-colors-that-we-can-see-1834500228'),
 (3695,361,39,'page','Profile of shoe','link','post_content','','https://kottke.org/12/05/moonshiners-cow-shoes'),
 (3696,362,39,'page','Bottom view','link','post_content','','https://www.mentalfloss.com/article/65110/footwear-helped-moonshiners-evade-police'),
 (3697,363,39,'page','A Sneaky Theory of Where Language Came From','link','post_content','','https://www.theatlantic.com/science/archive/2018/06/toolmaking-language-brain/562385/'),
 (3698,364,39,'page','Jungle Prince of Delhi','link','post_content','','https://www.nytimes.com/2019/11/22/world/asia/the-jungle-prince-of-delhi.html'),
 (3690,356,39,'page','Fantastic Beasts and How to Rank Them','link','post_content','','https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster'),
 (3691,357,39,'page','14 Bizarre Pirate Traditions Most People Don\'t Know About','link','post_content','','https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton'),
 (3692,358,39,'page','Eight of the Deadliest Assassin Groups in History','link','post_content','','https://historycollection.co/assassination-bureau-8-groups-assassins-history/'),
 (3693,359,39,'page','Nigerian Witch Doctors','link','post_content','','http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1'),
 (3694,360,39,'page','Here Are All the Ways You Can (Legally) Dispose of a Dead Body','link','post_content','','https://lifehacker.com/here-are-all-the-ways-you-can-dispose-of-a-dead-body-1836055910'),
 (3688,354,39,'page','Fake Britain: A Map Of Fictional Locations In England, Scotland And Wales','link','post_content','','http://londonist.com/london/maps/fake-britain-map-fictional-locations-england-scotland-wales'),
 (3689,355,39,'page','10 Fascinating Mummies','link','post_content','','https://mobile.twitter.com/DrLindseyFitz/status/1083778992052858880'),
 (3684,350,39,'page','Terragen','link','post_content','','https://planetside.co.uk/terragen-product-comparison/'),
 (3685,351,39,'page','Fantasy City Generator','link','post_content','','https://watabou.itch.io/medieval-fantasy-city-generator'),
 (3686,352,39,'page','Twitter follower blocker','link','post_content','','https://chrome.google.com/webstore/detail/twitter-follower-blocker/clmjfekijbbiblcnelcmmfnlaaancehn?hl=en'),
 (3687,353,39,'page','Divination and medicine','link','post_content','','https://www.forbiddenhistories.com/uromancy-lindsey-fitzharris/'),
 (3683,349,39,'page','World Machine','link','post_content','','http://www.world-machine.com/'),
 (3682,348,39,'page','AutoREALM: Vector based drawing for RPGs (mapping)','link','post_content','','https://sourceforge.net/projects/autorealm/'),
 (3678,344,39,'page','Milanote','link','post_content','','https://milanote.com/'),
 (3679,345,39,'page','Scapple','link','post_content','','https://www.literatureandlatte.com/scapple/overview'),
 (3680,346,39,'page','Mind Meister','link','post_content','','https://www.mindmeister.com/'),
 (3681,347,39,'page','Best mind map software of 2018','link','post_content','','https://www.techradar.com/news/best-mind-map-software'),
 (3677,343,39,'page','Aeon Timeline ','link','post_content','','https://www.aeontimeline.com/'),
 (3675,341,39,'page','list of \"obscure colour terms.\"','link','post_content','','http://phrontistery.info/colours.html'),
 (3676,342,39,'page','Scrivener','link','post_content','','https://www.literatureandlatte.com/scrivener/overview'),
 (3674,340,39,'page','Complete list of Crayola Crayon colors.','link','post_content','','http://www.wikiwand.com/en/List_of_Crayola_crayon_colors'),
 (3673,339,39,'page','Color Thesaurus','link','post_content','','https://ingridsnotes.wordpress.com/2014/02/04/the-color-thesaurus/'),
 (3672,338,39,'page','<img src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" class=\"wp-image-141\"/>','link','post_content','','https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png'),
 (3671,337,39,'page','Model Management','link','post_content','','https://www.modelmanagement.com/'),
 (3670,336,39,'page','Body language cheat sheets','link','post_content','','https://writerswrite.co.za/cheat-sheets-for-writing-body-language/'),
 (3669,335,39,'page','Bodies in Motion','link','post_content','','https://www.bodiesinmotion.photo/'),
 (3668,334,39,'page','Red Hair Color Shades','link','post_content','','https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades'),
 (3667,333,39,'page','400+ Ways to Describe Eyes','link','post_content','','https://kathysteinemann.com/Musings/eyes/'),
 (3666,332,39,'page','What color are your eyes exactly?','link','post_content','','https://www.edow.com/general-eye-care/eyecolor/'),
 (3665,331,39,'page','Handy Words for Skin Tones','link','post_content','','https://everything4writers.tumblr.com/post/98365413596/skin-tones-human-skin-colours-range-from-palest/amp'),
 (3664,330,39,'page','Skin Undertone and Colour Matching','link','post_content','','https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M'),
 (3663,329,39,'page','The Problem of the Improper Princess','link','post_content','','https://pictorial.jezebel.com/the-problem-of-the-improper-princess-1836498155'),
 (3662,328,39,'page','Stereotypes and Tropes Navigation','link','post_content','','https://writingwithcolor.tumblr.com/Navigation2'),
 (3661,779,39,'page','Women Share The Biggest Mistakes Male Authors Make With Female Characters','link','post_content','','https://www.femalista.com/women-share-the-biggest-mistakes-male-authors-make-with-female-characters/amp/'),
 (3660,326,39,'page','\"How does kids dressing up as Pocahontas reinforce genocide?\"','link','post_content','','https://mobile.twitter.com/lilrednacho/status/909914206270615552'),
 (3659,325,39,'page','Sensitivity Readers! What are they good for?','link','post_content','','https://www.publishersweekly.com/pw/by-topic/columns-and-blogs/soapbox/article/77726-sensitivity-readers-what-are-they-good-for-a-lot.html?utm_source=Publishers+Weekly&utm_campaign=e9fbb28448-EMAIL_CAMPAIGN_2018_08_13_02_56&utm_medium=email&utm_term=0_0bb2959cbb-e9fbb28448-306103905'),
 (3658,324,39,'page','300 Words to Describe Skin','link','post_content','','https://kathysteinemann.com/Musings/words-to-describe-skin/'),
 (3657,323,39,'page','A discussion of describing the skin tone of people of color','link','post_content','','https://mythicscribes.com/community/threads/describing-pocs-skin.17082/'),
 (3655,321,39,'page','Writing About Color Resources','link','post_content','','https://writingwithcolor.tumblr.com/Recommendations'),
 (3656,322,39,'page','7 Casually Racist Things That White Authors Do','link','post_content','','https://bookriot.com/2018/02/05/casually-racist-things-that-white-authors-do/'),
 (3654,320,39,'page','Writing People of Color (if you happen to be a person of another color)','link','post_content','','http://midnightbreakfast.com/writing-people-of-color'),
 (3653,319,39,'page','Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone','link','post_content','','http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for'),
 (3652,318,39,'page','Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions','link','post_content','','http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several'),
 (3651,317,39,'page','Writing the Other: A Practical Approach','link','post_content','','http://writingtheother.com/roundtable-stay-lane/'),
 (3650,317,39,'page','Writing the Other Roundtable: How to Stay in Your lane','link','post_content','','http://writingtheother.com/roundtable-stay-lane/'),
 (3649,145,39,'page','Gender Neutral Pronouns','link','post_content','','https://lgbtrc.usc.edu/trans/transgender/pronouns/'),
 (3648,316,39,'page','Gender Neutral Pronouns: What They Are &amp; How to Use Them','link','post_content','','https://blog.hubspot.com/marketing/gender-neutral-pronouns'),
 (3647,315,39,'page','Disability in Kidlit','link','post_content','','http://disabilityinkidlit.com/'),
 (3644,312,39,'page','20 Key Scenes','link','post_content','','https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/'),
 (3645,313,39,'page','The Essential Elements of Writing a Romance Novel','link','post_content','','http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf'),
 (3646,314,39,'page','Future Today Institute','link','post_content','','https://futuretodayinstitute.com/'),
 (3643,311,39,'page','Arthur Conan Doyle: Researching Crimes and Detectives with NYPL\'s E-Resources','link','post_content','','https://www.nypl.org/blog/2017/05/22/arthur-conan-doyle?utm_campaign=SocialFlow&utm_source=twitter.com&utm_medium=referral'),
 (3641,309,39,'page','The 8 Habits of Highly Successful Young-Adult Fiction Authors','link','post_content','','https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/'),
 (3642,310,39,'page','5 Key Ingredients All Young Adult Novels Must Have','link','post_content','','https://www.standoutbooks.com/key-ingredients-young-adult-novels/'),
 (3640,308,39,'page','New Space Navigation Technique','link','post_content','','https://www.sciencealert.com/x-ray-pulsar-space-navigation-nasa-world-first-success'),
 (3632,301,39,'page','Literary Magic Systems','link','post_content','','https://myliteraryquest.wordpress.com/2017/09/19/magic-systems-101-pt-4-literary-magic-systems/'),
 (3633,302,39,'page','Create Your Own Magic System','link','post_content','','https://myliteraryquest.wordpress.com/2017/09/25/magic-systems-101-pt-5-create-your-own-magic-system/'),
 (3634,303,39,'page','Make Magical Sachets with Herbs','link','post_content','','http://www.lunalunamagazine.com/dark/how-to-make-magikal-sachets-with-herbs'),
 (3635,212,39,'page','Writing Magical Realism','link','post_content','','https://www.writermag.com/improve-your-writing/fiction/writing-magical-realism/'),
 (3636,304,39,'page','Atomic Rockets','link','post_content','','http://www.projectrho.com/public_html/rocket/sfbackground.php'),
 (3637,305,39,'page','Starship Travel','link','post_content','','http://www.projectrho.com/public_html/rocket/mission.php#id--Tourist_Season'),
 (3638,306,39,'page','Science Fiction \\ Space Technology : Tools for Learning','link','post_content','','https://er.jsc.nasa.gov/seh/scifi.html'),
 (3639,307,39,'page','Science Fiction Space Technology Terms','link','post_content','','https://er.jsc.nasa.gov/seh/SFTerms.html'),
 (3631,300,39,'page','Sanderson\'s Laws of Magic','link','post_content','','https://myliteraryquest.wordpress.com/2017/09/15/magic-systems-101-pt-3-sandersons-laws-of-magic/'),
 (3630,299,39,'page','Hard Magic vs Soft Magic','link','post_content','','https://myliteraryquest.wordpress.com/2017/09/13/magic-systems-101-pt-2-hard-magic-vs-soft-magic/'),
 (3629,298,39,'page','Why Write Good Magic','link','post_content','','https://myliteraryquest.wordpress.com/2017/09/08/magic-systems-101-pt-1-why-write-good-magic/'),
 (3627,296,39,'page','1','link','post_content','','https://goteenwriters.com/2013/09/06/storyworld-building-types-of-magic/'),
 (3628,297,39,'page','2','link','post_content','','https://paranormal.lovetoknow.com/clairvoyant-abilities/types-magic'),
 (3625,294,39,'page','Inflation Calculator','link','post_content','','https://www.usinflationcalculator.com/'),
 (3626,295,39,'page','Society of Primitive Technology','link','post_content','','http://www.hollowtop.com/spt_html/spt.html'),
 (3623,292,39,'page','The People\'s History','link','post_content','','http://www.thepeoplehistory.com/'),
 (3624,293,39,'page','Cost of Cars by Year','link','post_content','','https://blog.chron.com/carsandtrucks/2016/04/cost-of-a-car-in-the-year-you-were-born/'),
 (3622,291,39,'page','Dogs Re-imagined as Warriors','link','post_content','','https://www.rearfront.com/dogs-as-warriors/'),
 (3615,285,39,'page','Sirens','link','post_content','','https://www.rachaeltalibart.com/ocean'),
 (3616,286,39,'page','Dirty Thunderstorm','link','post_content','','https://en.wikipedia.org/wiki/Dirty_thunderstorm'),
 (3617,287,39,'page','Dirty Storms','link','post_content','','https://mobile.twitter.com/iamshinerk/status/1013365513659904000'),
 (3618,270,39,'page','Storms from a cockpit','link','post_content','','https://digitalcollections.nypl.org/'),
 (3619,288,39,'page','South Dakota supercell','link','post_content','','https://mobile.twitter.com/welcomet0nature/status/1086926308565811200'),
 (3620,289,39,'page','Roman Boteen\'s hobo nickels','link','post_content','','https://hotco.co/collections/roman-booteen'),
 (3621,290,39,'page','Rare 19th-century images show China at the dawn of photography','link','post_content','','https://www.cnn.com/style/article/china-photos-19th-century-loewentheil-collection/index.html'),
 (3614,284,39,'page','People Pot Pies','link','post_content','','https://www.atlasobscura.com/articles/pies-that-look-like-people'),
 (3613,283,39,'page','Hieronymous Bosch Pinatas','link','post_content','','https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez'),
 (3604,275,39,'page','20 Abandoned Places That Were Overrun By Nature','link','post_content','','https://www.rd.com/home/nature-takes-over-abandoned-homes/?trkid=soc-rd-atlas&fbclid=IwAR1LJORFDxpX8CrR0FDKngHaaQ7ysmvQYkqBPjF0M7wrtN1TR7dO04tca3c'),
 (3605,276,39,'page','Animals Drawn Based on Bones Alone','link','post_content','','https://www.sunnyskyz.com/blog/2932/If-We-Drew-Modern-Animals-The-Way-We-Draw-Dinosaurs-Based-On-Bones-Alone'),
 (3606,277,39,'page','Game Art from Bastion','link','post_content','','https://kotaku.com/this-is-who-we-thank-for-bastions-gorgeous-art-5940147'),
 (3607,278,39,'page','Fairy-Tale Cottages','link','post_content','','https://somuchviral.com/27-dreamy-cottages/'),
 (3608,279,39,'page','1','link','post_content','','https://blog.vitalchek.com/vital-records/best-vacations-to-see-fall-colors-in-2018/'),
 (3609,280,39,'page','Giethoorn Canal Village','link','post_content','','https://abandonedspaces.co/this-magical-village-with-no-roads-at-all-is-straight-out-of-a-fairy-tale-book/'),
 (3610,281,39,'page','Makeup Artist Creates Optical Illusions On Her Face','link','post_content','','https://50nerdsofgrey.com/this-makeup-artist-creates-optical-illusions-on-her-face-to-mess-with-peoples-minds/'),
 (3612,282,39,'page','Art of Magic the Gathering','link','post_content','','http://www.artofmtg.com/'),
 (3611,270,39,'page','Mountains Shot in Infrared','link','post_content','','https://digitalcollections.nypl.org/'),
 (3600,271,39,'page','Images by J.R.R. Tolkien','link','post_content','','http://tolkiengateway.net/wiki/Category:Images_by_J.R.R._Tolkien'),
 (3601,273,39,'page','29 Surreal Landscapes','link','post_content','','https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see'),
 (3602,270,39,'page','The Beauty and the Power of African Blacksmiths','link','post_content','','https://digitalcollections.nypl.org/'),
 (3603,274,39,'page','Macro Shots Inside Instruments','link','post_content','','https://arthusiast.art/amazing-macro-shots-taken-inside-instruments-by-adrian-borda/'),
 (3594,266,39,'page','AstroSynthesis','link','post_content','','https://www.nbos.com/products/astrosynthesis'),
 (3595,267,39,'page','Cartography Resources','link','post_content','','https://www.cartographyassets.com/'),
 (3596,268,39,'page','Spring Walk nature sounds generator','link','post_content','','https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php'),
 (3597,269,39,'page','Long Ambients1: Calm. Sleep.','link','post_content','','http://moby.com/la1/'),
 (3598,252,39,'page','Descriptionari','link','post_content','','https://www.descriptionari.com/'),
 (3599,270,39,'page','NY Public Library digital collections','link','post_content','','https://digitalcollections.nypl.org/'),
 (3591,263,39,'page','Hexographer','link','post_content','','http://www.hexographer.com/'),
 (3592,264,39,'page','Matthäus Merian\'s beautiful 1636 map of the Republic of Venice','link','post_content','','https://mobile.twitter.com/foxtosser/status/1085558337947820032'),
 (3593,265,39,'page','What does a fantasy map look like?','link','post_content','','https://www.tor.com/2019/03/19/what-does-a-fantasy-map-look-like/?utm_source=exacttarget&utm_medium=newsletter&utm_term=tordotcom-tordotcomnewsletter&utm_content=na-readblog-blogpost&utm_campaign=tor&e=a3087719b835fd5916a5573381c09d776d7afc81b1e52fca47987d075cb3131c'),
 (3589,261,39,'page','How Writers Map Their Imaginary Worlds','link','post_content','','https://www.atlasobscura.com/articles/writers-maps?utm_source=twitter.com&utm_medium=referral&utm_campaign=SocialFlow'),
 (3590,262,39,'page','Medieval Fantasy City Generator','link','post_content','','http://www.fantasyliterature.com/reviews/modern-fantasy-the-100-best-novels-1946-1987/'),
 (3587,259,39,'page','MapFrappe','link','post_content','','http://mapfrappe.com/'),
 (3588,260,39,'page','National Geographic Vintage Map Archive','link','post_content','','https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&utm_medium=Social&utm_content=link_tw20180511news-vintagemaps&utm_campaign=Content&sf189367684=1'),
 (3586,258,39,'page','Payhip - sell digital memberships and downloads','link','post_content','','https://payhip.com/'),
 (3585,257,39,'page','Premium Book Design Templates','link','post_content','','https://www.bookdesigntemplates.com/'),
 (3584,256,39,'page','Responsive Storytelling Best Practices','link','post_content','','https://pudding.cool/process/responsive-scrollytelling/'),
 (3583,255,39,'page','Sigil: multi-platform EPUB ebook Editor','link','post_content','','https://sigil-ebook.com/get/'),
 (3582,254,39,'page','Vellum: Create Beautiful Books','link','post_content','','https://vellum.pub/'),
 (3579,251,39,'page','Fifteen Thousand Useful Phrases by Grenville Kleiser','link','post_content','','http://www.gutenberg.org/ebooks/18362'),
 (3580,252,39,'page','Descriptionari','link','post_content','','https://www.descriptionari.com/'),
 (3581,253,39,'page','Time-Travelling with Merriam-Webster’s Dictionary','link','post_content','','https://www.newyorker.com/culture/rabbit-holes/time-travelling-with-merriam-websters-dictionary'),
 (3578,250,39,'page','Specialty glossaries','link','post_content','','http://phrontistery.info/glossaries.html'),
 (3577,249,39,'page','The Phrontistery','link','post_content','','http://phrontistery.info/index.html'),
 (3567,239,39,'page','Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation','link','post_content','','http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html'),
 (3576,248,39,'page','Etymology.com','link','post_content','','https://www.etymonline.com/'),
 (3575,247,39,'page','Green’s Dictionary of Slang','link','post_content','','https://greensdictofslang.com/'),
 (3574,246,39,'page','Urban Dictionary','link','post_content','','https://www.urbandictionary.com/'),
 (3573,245,39,'page','English Language and Usage Q&amp;A','link','post_content','','https://english.stackexchange.com/'),
 (3572,244,39,'page','Power Thesaurus','link','post_content','','https://www.powerthesaurus.org/'),
 (3571,243,39,'page','Capitalize My Title','link','post_content','','https://capitalizemytitle.com/'),
 (3569,241,39,'page','Lousy Writer','link','post_content','','http://www.lousywriter.com/'),
 (3570,242,39,'page','English Grammar 101','link','post_content','','https://www.englishgrammar101.com/'),
 (3568,240,39,'page','Edufind\'s Online English Grammar Resources','link','post_content','','http://www.edufind.com/English/Grammar/'),
 (3566,238,39,'page','Grammar Girl: Quick and Dirty Tips','link','post_content','','http://grammar.quickanddirtytips.com/'),
 (3565,237,39,'page','Guide to Grammar and Writing','link','post_content','','http://grammar.ccc.commnet.edu/grammar/#'),
 (3564,236,39,'page','Free ebook','link','post_content','','http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&camp=1789&creative=390957&creativeASIN=B005IT0V8O&linkCode=as2&tag=regardtomor07-20&linkId=WVIFICFUILJLJC6M'),
 (3563,234,39,'page','Pocket copy','link','post_content','','http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&camp=1789&creative=390957&creativeASIN=B00BQ1P142&linkCode=as2&tag=regardtomor07-20&linkId=KRBIWOZK7TET774S'),
 (3562,233,39,'page','Strunk\'s <em>The Elements of Style</em>','link','post_content','','http://www.bartleby.com/141/'),
 (3561,232,39,'page','The Editorium\'s Freebies','link','post_content','','http://www.editorium.com/freebies.htm'),
 (3560,231,39,'page','The Organized Writer','link','post_content','','https://annieneugebauer.com/the-organized-writer-2/'),
 (3559,230,39,'page','Checklists and Tip Sheets','link','post_content','','https://onestopforwriters.com/image_tips'),
 (3558,229,39,'page','INFOGRAPHIC: The 69 Rules of Punctuation','link','post_content','','https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7'),
 (3557,228,39,'page','Inkilicious Cheat Sheet','link','post_content','','http://www.inkalicious.com/cheatsheets.html'),
 (3556,227,39,'page','Writer\'s Cheat Sheet','link','post_content','','http://www.writerscheatsheet.com/writing/cheatsheet.pdf'),
 (3555,226,39,'page','11 Years of Best Selling Novel Covers','link','post_content','','https://pudding.cool/2019/07/book-covers/'),
 (3554,225,39,'page','TVtropes','link','post_content','','https://tvtropes.org/pmwiki/pmwiki.php/Main/Tropes'),
 (3552,223,39,'page','Massive List of Generators','link','post_content','','https://donjon.bin.sh/'),
 (3553,224,39,'page','Random Logline Generator','link','post_content','','http://www.lifeformz.com/cgi-bin/idea/idea.fcgi'),
 (3550,221,39,'page','Witch name generator','link','post_content','','https://www.fantasynamegenerators.com/witch-names.php'),
 (3551,222,39,'page','Seventh Sanctum name generators (many types)','link','post_content','','https://www.seventhsanctum.com/index-name.php'),
 (3549,220,39,'page','Anthony Ryan On Naming Fantasy Characters','link','post_content','','https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/'),
 (3548,219,39,'page','Medieval Names Archive','link','post_content','','https://s-gabriel.org/names/index.shtml'),
 (3547,218,39,'page','Write a Fight Scene: Hero Fends Off an Attack to Protect Friend','link','post_content','','http://www.betternovelproject.com/blog/attack-fight-scene/'),
 (3546,95,39,'page','The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine','link','post_content','','https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/'),
 (3545,217,39,'page','The System I Used to Write 5 Books and Over 1,000 Blog Posts','link','post_content','','https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461'),
 (3541,213,39,'page','Holly Lisle','link','post_content','','http://hollylisle.com/'),
 (3542,214,39,'page','Jim Butcher','link','post_content','','https://jimbutcher.livejournal.com/'),
 (3543,215,39,'page','Best Opening Lines in Young Adult Books','link','post_content','','http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/'),
 (3544,216,39,'page','How to Write Deep POV','link','post_content','','http://penultimateword.com/editing-blogs/how-to-write-deep-pov-its-all-in-your-perspective/'),
 (3538,211,39,'page','How Rowling Revised ‘Harry Potter and the Order of the Phoenix’','link','post_content','','https://thefriendlyeditor.com/2015/03/26/how-rowling-revised-harry-potter-phoenix/'),
 (3539,212,39,'page','Writing Magical Realism','link','post_content','','https://www.writermag.com/improve-your-writing/fiction/writing-magical-realism/'),
 (3540,151,39,'page','Infuse Microtension in Your Novel','link','post_content','','https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/'),
 (3536,209,39,'page','The Real Reason Fans Hate the Last Season of Game of Thrones - sociological vs psychological story styles','link','post_content','','https://blogs.scientificamerican.com/observations/the-real-reason-fans-hate-the-last-season-of-game-of-thrones/?redirect=1'),
 (3537,210,39,'page','Medieval inspiration: what the fantasy genre owes to the 14th century','link','post_content','','https://www.historyextra.com/period/medieval/history-middle-ages-fantasy-stories-genre-how-inspired-inspiration/?fbclid=IwAR2H_15zvFmiOHaK0S_ToEVnMM_E01iKSw0yoXy_PIfcQoue_n-0CB7jBc8'),
 (3530,203,39,'page','For N. K. Jemisin, World-Building Is a Lesson in Oppression','link','post_content','','https://www.wired.com/story/nk-jemisin-how-to-write-science-fiction-wired25/'),
 (3531,204,39,'page','Fairy Tales and the Necessity of Fear','link','post_content','','https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/'),
 (3532,205,39,'page','Fantastic Beasts and How to Rank Them','link','post_content','','https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t'),
 (3533,206,39,'page','In the shadows of dark forests','link','post_content','','https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/'),
 (3534,207,39,'page','What Tolkien Knew About Love','link','post_content','','https://www.nytimes.com/2019/04/17/opinion/what-tolkien-knew-about-love.html'),
 (3535,208,39,'page','Maps of Hidden Structures of Choose Your Own Adventure Books','link','post_content','','https://www.atlasobscura.com/articles/cyoa-choose-your-own-adventure-maps?utm_source=facebook.com&utm_medium=atlas-page'),
 (3529,202,39,'page','25 Things You Should Know About Worldbuilding','link','post_content','','http://terribleminds.com/ramble/2013/09/17/25-things-you-should-know-about-worldbuilding/'),
 (3528,201,39,'page','Against Worldbuilding','link','post_content','','https://electricliterature.com/against-worldbuilding-700e4861c26b'),
 (3521,194,39,'page','5 Common Worldbuilding Mistakes in New Manuscripts','link','post_content','','https://mythcreants.com/blog/five-common-worldbuilding-mistakes-in-new-manuscripts/'),
 (3522,195,39,'page','Creating a Mountain Setting','link','post_content','','https://mythcreants.com/blog/creating-a-mountain-setting/'),
 (3523,196,39,'page','Fantasy World Building 101: how to create a breathing world for your fantasy novel','link','post_content','','https://nybookeditors.com/2017/07/fantasy-world-building-101-create-breathing-world-fantasy-novel/'),
 (3524,197,39,'page','Part 1','link','post_content','','https://www.lostkingdom.net/worldbuilding-guide-1/'),
 (3525,198,39,'page','Part 2','link','post_content','','http://www.lostkingdom.net/worldbuilding-guide-2/'),
 (3526,199,39,'page','Fantasy Economics 101','link','post_content','','http://www.lostkingdom.net/fantasy-world-economics-101-introduction/'),
 (3527,200,39,'page','Economics: labour and wages','link','post_content','','http://www.lostkingdom.net/fantasy-world-economics-101-labour-and-wages/'),
 (3520,193,39,'page','7 Deadly Sins of Worldbuilding','link','post_content','','https://io9.gizmodo.com/7-deadly-sins-of-worldbuilding-998817537'),
 (3519,192,39,'page','Worldbuilding Questions at SFWA','link','post_content','','https://www.sfwa.org/?s=fantasy+worldbuilding+questions'),
 (3518,191,39,'page','Don\'t do these things. Please.','link','post_content','','https://magazine.metaphorosis.com/guidelines/dont-do-this/'),
 (3517,190,39,'page','Eliminate non-words','link','post_content','','https://prowritingaid.com/art/933/clean-up-your-content:-eliminate-the-non-words.aspx'),
 (3514,188,39,'page','A Good Short Story Is “A Pill That Lets Us See the Real”','link','post_content','','https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267'),
 (3515,189,39,'page','Filter Words by Sooz','link','post_content','','https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/'),
 (3516,189,39,'page','Are These Filter Words Weakening Your Fiction?','link','post_content','','https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/'),
 (3510,184,39,'page','John August’s How to Write a Scene','link','post_content','','http://johnaugust.com/2007/write-scene'),
 (3511,185,39,'page','Jim Butcher on Scenes','link','post_content','','https://jimbutcher.livejournal.com/2647.html#'),
 (3512,186,39,'page','Jim Butcher on Sequels','link','post_content','','https://jimbutcher.livejournal.com/2880.html#'),
 (3513,187,39,'page','Self-Editing Checklist for Short Story Writers','link','post_content','','https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168'),
 (3508,182,39,'page','ANVL 3D Printed Characters','link','post_content','','https://anvl.co/custom-miniatures'),
 (3509,183,39,'page','How (And Why) To Treat Your Setting Like A Character','link','post_content','','https://www.thecreativepenn.com/2019/05/01/writing-tips-how-and-why-to-treat-your-setting-like-a-character/?utm_campaign=writing-tips-how-and-why-to-treat-your-setting-like-a-character'),
 (3504,178,39,'page','Mining the Mind of your Character','link','post_content','','https://prowritingaid.com/art/1041/how-to-develop-a-character.aspx?utm_source=twitter&utm_medium=ad&utm_content=how-to-develop-a-character'),
 (3505,179,39,'page','Write Authentic Emotion','link','post_content','','https://prowritingaid.com/art/856/character-research:-how-to-write-authentic-emotion.aspx?utm_content=buffer7d661&utm_medium=social&utm_source=twitter.com&utm_campaign=buffer'),
 (3506,180,39,'page','Dialogue in Fiction','link','post_content','','http://penultimateword.com/fiction/dialect-in-dialogue-how-to-write-authentic-dialect-and-foreign-accents/'),
 (3507,181,39,'page','How to Construct a 3D Main Character','link','post_content','','https://prowritingaid.com/art/308/How-to-Construct-a-3D-Main-Character.aspx'),
 (3501,175,39,'page','Tags and Traits: Characterization and Building Empathy','link','post_content','','http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html'),
 (3502,176,39,'page','8 Absurdities we Force on Female Characters','link','post_content','','https://mythcreants.com/blog/eight-absurdities-we-force-on-female-characters/'),
 (3503,177,39,'page','10 Things Get Wrong About PTSD','link','post_content','','https://www.huffpost.com/entry/post-traumatic-stress-disorder-ptsd-myths_l_5cf11d36e4b0a1997b68d87e'),
 (3495,169,39,'page','25 Things A Great Character Needs','link','post_content','','http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/'),
 (3496,170,39,'page','Ten Things About Strong Female Characters','link','post_content','','https://mobile.twitter.com/Joannechocolat/status/888811458179543041'),
 (3497,171,39,'page','From Wonder Woman to Spirited Away: what really makes a superhero?','link','post_content','','https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero'),
 (3498,172,39,'page','Thread on what Strength means for female characters','link','post_content','','https://mobile.twitter.com/fozmeadows/status/903600239109484544'),
 (3499,173,39,'page','Characters by Jim Butcher','link','post_content','','https://jimbutcher.livejournal.com/1698.html'),
 (3500,174,39,'page','From Basic to Beauty: Transformations of Female Villains in Batman Films','link','post_content','','https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b'),
 (3494,168,39,'page','11 Secrets to Writing an Effective Character Description','link','post_content','','http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description'),
 (3493,167,39,'page','Creating Characters by Jim Butcher','link','post_content','','https://glichy.wordpress.com/2016/09/13/creating-characters-according-to-jim-butcher/'),
 (3492,166,39,'page','Writing Excuses 9.13: Three Pronged Character Development','link','post_content','','https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/'),
 (3482,156,39,'page','A Four Act Structure','link','post_content','','http://blog.karenwoodward.org/2014/03/a-four-act-structure.html'),
 (3483,157,39,'page','20 Master Plots and How to Build Them','link','post_content','','http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf'),
 (3484,158,39,'page','41 Ways to Create and Heighten Suspense','link','post_content','','http://www.ian-irvine.com/on-writing/41-ways-to-create-and-heighten-suspense/'),
 (3485,159,39,'page','Six Tried and Tested Methods for Writing a Novel','link','post_content','','https://prowritingaid.com/art/387/Six-Tried-and-Tested-Methods-for-Writing-a-Novel.aspx?utm_source=twitter&utm_medium=social'),
 (3486,160,39,'page','Fictionary - Online Story Editing Tool','link','post_content','','https://fictionary.co/'),
 (3487,161,39,'page','Fabula Deck - Card Deck story structure framework','link','post_content','','https://fabuladeck.com/'),
 (3488,162,39,'page','10 Ways to Master Pacing in Writing and Keep Your Readers Riveted','link','post_content','','https://thewritepractice.com/pacing-writing/'),
 (3489,163,39,'page','Creating a book series “bible” using Scrivener, Scapple, and Aeon Timeline','link','post_content','','https://hollowlands.com/2014/09/creating-a-book-series-bible-using-scrivener-scapple-and-aeon-timeline/'),
 (3491,165,39,'page','Character Traits as Sliding Scales','link','post_content','','https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/'),
 (3490,164,39,'page','The Benefits of Story Subplot','link','post_content','','https://writingcooperative.com/the-benefits-of-story-subplot-8a61031f1ab3'),
 (3475,149,39,'page','Blue Light reduction','link','post_content','','https://www.lifewire.com/reduce-eye-strain-with-blue-light-filter-apps-4134615'),
 (3476,150,39,'page','The MICE Quotient: How to Structure Your Story','link','post_content','','http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html'),
 (3477,151,39,'page','Infusing Microtension in Your Novel','link','post_content','','https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/'),
 (3478,152,39,'page','My Outlining Process: How I Prepare to Draft My Novels','link','post_content','','http://www.well-storied.com/blog/my-outlining-process'),
 (3479,153,39,'page','Four Acts, Not Three','link','post_content','','https://narrativefirst.com/articles/four-acts-not-three/'),
 (3480,154,39,'page','The Paradigm Worksheet','link','post_content','','https://sydfield.com/writers-tools/the-paradigm-worksheet/'),
 (3481,155,39,'page','Trilogy Building: Star Wars and Halo Plots','link','post_content','','http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/'),
 (3473,147,39,'page','Master List of English Words','link','post_content','','https://raw.githubusercontent.com/dwyl/english-words/master/words.txt'),
 (3474,148,39,'page','Boosting Creativity - 10 Easy Steps','link','post_content','','https://www.psychologytoday.com/us/blog/the-intelligent-divorce/201411/boosting-creativity-10-easy-steps'),
 (3471,145,39,'page','Gender Neutral Pronouns','link','post_content','','https://lgbtrc.usc.edu/trans/transgender/pronouns/'),
 (3472,146,39,'page','The Compelling, Emotional Complex Sentence','link','post_content','','https://writerunboxed.com/2020/01/17/the-compelling-emotional-complex-sentence/#more-61189'),
 (3467,141,39,'page','Useless Words to Seek Out and Destroy in Your Manuscript','link','post_content','','https://writingcooperative.com/useless-words-to-seek-out-and-destroy-in-your-manuscript-a6198beedc38'),
 (3468,142,39,'page','Anaphora','link','post_content','','https://prowritingaid.com/en/GrammarChecker/Category/Anaphora'),
 (3469,143,39,'page','Adverbs','link','post_content','','https://prowritingaid.com/en/GrammarChecker/Category/Adverbs'),
 (3470,144,39,'page','Everything You Need to Know About Titles','link','post_content','','https://prowritingaid.com/art/968/mr,-mrs,-ms-and-miss:-everything-you-need-to-know-about-titles.aspx'),
 (3465,139,39,'page','Kindle Keyword Strategies for Fiction Authors','link','post_content','','https://kindlepreneur.com/kindle-keywords-fiction-author-strategy/'),
 (3466,140,39,'page','Amazon Blurb Previewer','link','post_content','','https://www.hiddengemsbooks.com/amazon-blurb-tool/'),
 (3464,138,39,'page','Here\'s what I\'ve learned from recording 25 of my own audiobooks','link','post_content','','https://blog.findawayvoices.com/what-ive-learned-from-recording-25-of-my-own-audiobooks/'),
 (3460,134,39,'page','Inked Voices Critique Guide','link','post_content','','https://www.inkedvoices.com/quick-guide-to-critique/'),
 (3461,135,39,'page','10 Questions to Ask Beta-readers','link','post_content','','https://morganhazelwood.com/2016/12/08/10-qas-for-beta-readers/'),
 (3462,136,39,'page','Research scams to get a fair deal on your writing','link','post_content','','http://www.sfwa.org/other-resources/for-authors/writer-beware/'),
 (3463,137,39,'page','Getting Access to Paywalled Papers','link','post_content','','http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/'),
 (3459,133,39,'page','5 Biggest Mistakes Bloggers Make','link','post_content','','https://prowritingaid.com/art/999/the-5-biggest-mistakes-bloggers-make.aspx'),
 (3457,131,39,'page','Clockpunk Studios: Professional Wordpress design and development for authors','link','post_content','','https://www.clockpunkstudios.com/our-work/'),
 (3458,132,39,'page','Tagdef','link','post_content','','https://tagdef.com/en/'),
 (3456,130,39,'page','Grow and Email List From Nothing','link','post_content','','https://prowritingaid.com/art/924/grow-your-email-list-from-nothing.aspx'),
 (3454,128,39,'page','How to Properly Disclose Affiliate Links and Endorsements Online','link','post_content','','https://prowritingaid.com/art/921/how-to-properly-disclose-affiliate-links-and-endorsements-online.aspx?utm_source=twitter&utm_medium=affiliatelinks'),
 (3452,126,39,'page','Building an Author Website: The First Step to Publishing','link','post_content','','https://thewritepractice.com/building-an-author-website/'),
 (3451,125,39,'page','Growth Tools','link','post_content','','https://growthtools.com/#tools'),
 (3455,129,39,'page','5 Helpful Tools for the Constant Blogger','link','post_content','','https://prowritingaid.com/art/907/5-helpful-tools-for-the-constant-blogger.aspx?utm_source=twitter&utm_medium=constantblogger'),
 (3449,123,39,'page','How to Build your own author platform - from scratch','link','post_content','','https://writingcooperative.com/how-to-build-your-own-author-platform-from-scratch-9d6123858bac'),
 (3453,127,39,'page','A 201 guide for taking your newsletters to the next level — growing the lists, making money, and more.','link','post_content','','https://newsletterguide.org/'),
 (3450,124,39,'page','Comparison of 10 Website Builders','link','post_content','','https://hostingfacts.com/website-builders/'),
 (3447,121,39,'page','Anchor Podcasting App','link','post_content','','https://anchor.fm/'),
 (3448,122,39,'page','Storyboard Podcasts','link','post_content','','https://trystoryboard.com/'),
 (3446,120,39,'page','Note to All Creatives: Marketing is Your Job','link','post_content','','https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf'),
 (3439,113,39,'page','Using Third Person vs First Person Novel Narratives ','link','post_content','','https://writersinthestormblog.com/2018/02/third-vs-first-person-narratives/'),
 (3440,114,39,'page','13 Kick-Ass Tips For Writing Fantasy From Professional Fantasy Editors','link','post_content','','https://blog.reedsy.com/writing-fantasy/'),
 (3441,115,39,'page','4 Authors Share Their Best Tips for Writing Fantasy &amp; Science-Fiction','link','post_content','','https://www.writersdigest.com/writing-articles/by-writing-genre/science-fiction-fantasy/4-authors-share-their-best-tips-for-writing-fantasy-science-fiction'),
 (3442,116,39,'page','An example of supporting others through your site','link','post_content','','https://www.annfriedman.com/recommendations/'),
 (3443,117,39,'page','The Art and Business of Author Platform','link','post_content','','https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view'),
 (3444,118,39,'page','Build Your Author Platform Through Blogging','link','post_content','','//www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar'),
 (3445,119,39,'page','Make money online with your writing','link','post_content','','http://www.wealthywebwriter.com/'),
 (3436,110,39,'page','Best Books About Writing Fiction','link','post_content','','https://prowritingaid.com/art/874/best-books-about-writing-fiction.aspx?utm_source=twitter&utm_medium=booksaboutwritingfiction'),
 (3437,111,39,'page','Finding and Working with an Editor','link','post_content','','https://yeahwrite.me/writing-help-finding-editor/'),
 (3433,107,39,'page','Emotional Labor of Editing','link','post_content','','https://mobile.twitter.com/ccfinlay/status/1141088811553660928'),
 (3434,108,39,'page','Thirteen Things (some) Writers Need to Remind Themselves of','link','post_content','','http://www.jayoconnell.com/2019/06/thirteen-things-some-writers-need-to-remind-themselves/'),
 (3430,104,39,'page','Novel Writing Training Plan','link','post_content','','https://cdn.prowritingaid.com/ebook/ProWritingAid_EBook2.pdf'),
 (3431,105,39,'page','8 Ways to Make Your Story Boring','link','post_content','','https://prowritingaid.com/art/374/8-Ways-to-Make-Your-Story-Boring-.aspx?utm_source=twitter&utm_medium=social'),
 (417,404,86,'page','3D Printer Product Chart','link','post_content','','https://www.productchart.com/3d_printers/'),
 (418,405,86,'page','Smart enclosure','link','post_content','','https://www.thingiverse.com/thing:2792618'),
 (419,406,86,'page','Enclosure filter','link','post_content','','https://www.fabbaloo.com/blog/2015/3/1/finally-a-3d-printer-filter-accessory'),
 (420,407,86,'page','Watchdog Fire Extinguisher','link','post_content','','https://www.htgsupply.com/products/the-watch-dog-automatic-fire-extinguisher-2-kg/'),
 (421,408,86,'page','PLA suggestions','link','post_content','','https://www.facebook.com/groups/makerbot/permalink/1656440171140147/'),
 (422,409,86,'page','PetG Filament Overview','link','post_content','','https://all3dp.com/1/petg-filament-3d-printing/'),
 (423,410,86,'page','3D Printing Materials: Pros and Cons','link','post_content','','https://www.tomsguide.com/us/3d-printing-materials,news-24392.html'),
 (424,411,86,'page','Anthracite Grey PLA','link','post_content','','https://www.feel-color.com/3d-filament-pla-anthracite-grey?___store=en_en&___from_store=en_en'),
 (425,412,86,'page','How to Dry Filament','link','post_content','','https://all3dp.com/2/how-to-dry-filament-pla-abs-and-nylon/'),
 (426,413,86,'page','Build a $30 Filament Dryer','link','post_content','','https://letsprint3d.net/2018/04/20/how-to-make-a-filament-dryer/'),
 (427,414,86,'page','PLA Filament Guide','link','post_content','','https://all3dp.com/1/pla-filament-3d-printing/'),
 (428,415,86,'page','3D Printer Filament Guide','link','post_content','','https://all3dp.com/1/3d-printer-filament-types-3d-printing-3d-filament/#basic'),
 (429,416,86,'page','Tinkercad','link','post_content','','https://www.tinkercad.com/'),
 (430,417,86,'page','EZ gimbal for z-banding','link','post_content','','https://www.thingiverse.com/thing:2480577'),
 (431,418,86,'page','one','link','post_content','','https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1894586220635343/'),
 (432,419,86,'page','Stepper cables','link','post_content','','https://smile.amazon.com/dp/B0785LH2DC/ref=tsm_1_fb_lk?sa-no-redirect=1'),
 (433,420,86,'page','Spool weight measurement','link','post_content','','https://www.thingiverse.com/thing:2878127'),
 (434,421,86,'page','Marlin firmware','link','post_content','','https://github.com/JimBrown/MarlinTarantula'),
 (435,422,86,'page','How to Connect Your Hotbed to a Mosfet','link','post_content','','https://3dprint.wiki/reprap/electronics/heatbed_mosfet'),
 (436,423,86,'page','T-slotted Extrusion Bar Covers','link','post_content','','https://m.aliexpress.com/item/32839714006.html?trace=wwwdetail2mobilesitedetail&productId=32839714006&productSubject=Random-Black-White-Blue-2meter-6mm-Flat-Seal-2020-Aluminum-Profile-Slot-Cover-Panel-Holder-For&aff_platform=link-c-tool&cpt=1519665605635&sk=jA6URzB&aff_trace_key=98f848353aa440eb95f00c86e4a50c9a-1519665605635-09573-jA6URzB&terminal_id=29d0825156634f92a8c46080751efb13'),
 (437,424,86,'page','To Ferrule or Not to Ferrule? (wire ends)','link','post_content','','https://hackaday.com/2018/04/12/to-ferrule-or-not-to-ferrule/'),
 (438,425,86,'page','26 Tarantula upgrades','link','post_content','','https://all3dp.com/1/tevo-tarantula-upgrades-mods/'),
 (439,426,86,'page','19 Must-have Tarantula upgrades','link','post_content','','https://all3dp.com/1/tevo-tornado-upgrades-mods-3d-printer/'),
 (440,427,86,'page','Rich Lee','link','post_content','','https://www.facebook.com/rwarwqerwqer?fref=gs&hc_ref=ARSbYY5WmlcdREC7rwKx6frURtGQ-rfSgHYAVuxAC53Kr4Qcy2-CWloIptE-pFc_Of0&dti=197938987045417&hc_location=group'),
 (441,428,86,'page','https://www.thingiverse.com/thing:2818547','link','post_content','','https://www.thingiverse.com/thing:2818547'),
 (442,429,86,'page','Snapware 40-cup Airtight container','link','post_content','','https://smile.amazon.com/gp/product/B007V4IWIU/r'),
 (443,430,86,'page','4mm Pneumatic connectors (\"Push Fit\")','link','post_content','','https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&field-keywords=4mm+pneumatic+connectors+push+fit'),
 (444,431,86,'page','2mm ID / 4mm OD PTFE (Teflon™) Tubing','link','post_content','','https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&field-keywords=2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing&rh=i%3Aaps%2Ck%3A2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing'),
 (445,432,86,'page','Filament runout sensor','link','post_content','','https://www.thingiverse.com/thing:2814724'),
 (446,433,86,'page','Z-banding','link','post_content','','https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1722003637893603/'),
 (447,434,86,'page','Ten 3D Printable Calibration &amp; Test Print Things','link','post_content','','https://3dprint.com/207828/103dp-calibration-test-prints/'),
 (448,435,86,'page','41 Common Problems','link','post_content','','https://m.all3dp.com/1/common-3d-printing-problems-troubleshooting-3d-printer-issues/'),
 (449,436,86,'page','Print Quality Troubleshooting Guide','link','post_content','','https://www.simplify3d.com/support/print-quality-troubleshooting/'),
 (450,437,86,'page','How to Cold-pull a Clogged Nozzle','link','post_content','','https://www.antonmansson.com/how-to-cold-pull-clogged-nozzle/'),
 (451,438,86,'page','MyMiniFactory','link','post_content','','https://www.myminifactory.com/'),
 (452,439,86,'page','Fab365','link','post_content','','https://fab365.net/'),
 (453,440,86,'page','Thingiverse','link','post_content','','https://www.thingiverse.com'),
 (454,441,86,'page','Print onto Fabric','link','post_content','','https://www.instructables.com/id/How-to-3D-Print-Onto-Fabric/'),
 (455,442,86,'page','Self forming structures on pre-stretched fabric','link','post_content','','https://n-e-r-v-o-u-s.com/blog/?p=8011'),
 (456,443,86,'page','3D Printing Data Sets','link','post_content','','https://phys.org/news/2018-06-d-printer-physical.html'),
 (457,444,86,'page','Cubemail Fabric','link','post_content','','https://www.myminifactory.com/object/3d-print-cubemail-bowl-49476'),
 (458,445,86,'page','Kitchen items list','link','post_content','','http://www.geeetech.com/blog/2018/03/8-diy-3d-prints-for-every-kitchen/'),
 (459,446,86,'page','Harry Potter Tower','link','post_content','','https://cults3d.com/en/3d-model/art/owl-tower-harry-potter?utm_source=social&utm_medium=owlery'),
 (460,447,86,'page','Print-a-brick','link','post_content','','https://printabrick.org/'),
 (461,448,86,'page','Foldable car','link','post_content','','https://fab365.net/items/145'),
 (462,449,86,'page','Bladeless Fans','link','post_content','','https://www.yankodesign.com/2019/02/07/you-can-now-3d-print-your-own-iconic-bladeless-fan/'),
 (463,450,86,'page','Clocks','link','post_content','','https://www.thingiverse.com/search?q=clock&dwh=15cb3d020cda08'),
 (464,451,86,'page','Printing at 300 mm/s','link','post_content','','https://dyzedesign.com/2016/10/printing-300-mm-s-part-1-basics-hardware/'),
 (465,452,86,'page','Baking PLA for Strength','link','post_content','','https://hackaday.com/2017/03/24/half-baked-idea-put-your-pla-in-the-oven/'),
 (466,453,86,'page','10 things you need to know about 3D printing &amp; food safety','link','post_content','','https://pinshape.com/blog/3d-printing-food-safe/'),
 (467,454,86,'page','3D Food Printer Platform','link','post_content','','https://www.instructables.com/id/Pinya3-a-3d-food-printer-platform/'),
 (468,455,86,'page','Ikea’s 3D-printed add-ons make its furniture more accessible for people with disabilities','link','post_content','','https://www.theverge.com/2019/3/12/18261893/ikea-thisables-3d-printed-add-ons-people-with-disabilities'),
 (469,456,86,'page','8 Best 3D Scanning Apps','link','post_content','','https://www.aniwaa.com/best-3d-scanning-apps-smartphones/'),
 (470,457,101,'page','The Black Company','link','post_content','','https://www.torforgeblog.com/2018/07/31/series-order-chronicles-of-the-black-company/'),
 (471,458,101,'page','The Tower of Fear','link','post_content','','https://us.macmillan.com/books/9781466831155'),
 (472,459,101,'page','The Dread Empire','link','post_content','','https://www.goodreads.com/series/42332-dread-empire'),
 (473,460,101,'page','Garrett P.I.','link','post_content','','https://www.penguinrandomhouse.com/series/AX3/garrett-pi'),
 (474,461,101,'page','Vlad Taltos','link','post_content','','https://www.torforgeblog.com/2017/10/17/where-to-start-with-vlad-taltos/'),
 (475,462,101,'page','Khaavren Romances','link','post_content','','https://en.wikipedia.org/wiki/Khaavren_Romances'),
 (476,463,101,'page','The Cool Stuff Theory of Literature','link','post_content','','https://www.goodreads.com/quotes/889625-the-cool-stuff-theory-of-literature-is-as-follows-all'),
 (477,464,101,'page','Death of the Necromancer','link','post_content','','https://www.marthawells.com/death.htm'),
 (478,465,101,'page','Element of Fire','link','post_content','','https://www.marthawells.com/element.htm'),
 (479,466,101,'page','Fall of Ile-Rien','link','post_content','','https://www.marthawells.com/ilerien.htm'),
 (480,467,101,'page','The Potter’s Daughter','link','post_content','','https://www.marthawells.com/betweenworlds.htm'),
 (481,468,101,'page','Harper Hall trilogy','link','post_content','','https://en.wikipedia.org/wiki/The_Harper_Hall_Trilogy'),
 (482,469,101,'page','the Witcher','link','post_content','','https://en.wikipedia.org/wiki/The_Witcher'),
 (483,470,101,'page','Drenai series','link','post_content','','https://en.wikipedia.org/wiki/David_Gemmell#Drenai_Series'),
 (484,471,101,'page','Rigante series','link','post_content','','https://en.wikipedia.org/wiki/David_Gemmell#Rigante_series'),
 (485,472,101,'page','Soft Apocalypse','link','post_content','','https://www.tor.com/2011/04/13/the-gradual-collapse-of-a-society-a-review-of-soft-apocalypse-by-will-mcintosh/'),
 (486,473,101,'page','Bridesicle','link','post_content','','https://scificats.files.wordpress.com/2011/04/bridesicle.pdf'),
 (487,474,101,'page','Love Minus Eighty','link','post_content','','https://smile.amazon.com/Love-Minus-Eighty-Will-McIntosh/dp/B01L9CV2AE?smdm-noredirect=true'),
 (488,475,101,'page','audio recording','link','post_content','','http://escapepod.org/2010/07/01/ep247-bridesicle/'),
 (489,476,101,'page','The Peripheral,','link','post_content','','https://williamgibsonbooks.com/books/the-peripheral/'),
 (490,477,101,'page','Deryni series','link','post_content','','https://en.wikipedia.org/wiki/Deryni_novels'),
 (491,478,101,'page','Chronicles of Amber','link','post_content','','https://en.wikipedia.org/wiki/The_Chronicles_of_Amber'),
 (492,479,101,'page','Wattpad','link','post_content','','https://www.wattpad.com/'),
 (493,480,101,'page','Uncanny Magazine','link','post_content','','https://uncannymagazine.com/'),
 (494,481,101,'page','Curious Fictions','link','post_content','','https://curiousfictions.com/'),
 (495,482,101,'page','Shimmer','link','post_content','','https://www.shimmerzine.com/'),
 (496,483,101,'page','Enkare Review','link','post_content','','http://enkare.org/'),
 (497,484,101,'page','Abyss &amp; Apex','link','post_content','','http://www.abyssapexzine.com/'),
 (498,485,101,'page','Beowulf by All','link','post_content','','https://texttechnologies.stanford.edu/publications/beowulf-all'),
 (499,486,101,'page','Visions, Ventures, Escape Velocities: A Collection of Space Futures','link','post_content','','https://csi.asu.edu/books/vvev/'),
 (500,487,101,'page','Whetstone: Amateur Magazine of Pulp Sword and Sorcery','link','post_content','','https://whetstonemag.blogspot.com/'),
 (501,488,101,'page','Journal of Evolution and Technology','link','post_content','','https://jetpress.org/contents.htm'),
 (502,489,101,'page','More Perfect Novels for Every Dungeons &amp; Dragons Character Class: Bards, Barbarians, Druids, and Paladins','link','post_content','','https://www.barnesandnoble.com/blog/sci-fi-fantasy/more-perfect-novels-for-every-dungeons-dragons-character-class-bards-barbarians-druids-and-paladins/'),
 (503,490,101,'page','26 Underrated Sci-Fi and Fantasy Gems You Shouldn’t Miss','link','post_content','','http://www.unboundworlds.com/2017/09/26-underrated-sci-fi-fantasy-gems-shouldnt-miss/?ref=PRH6F3D45E1F3&aid=randohouseinc10373-20&linkid=PRH6F3D45E1F3'),
 (504,491,101,'page','The Book That Terrified Neil Gaiman. And Carmen Maria Machado. And Dan Simmons.','link','post_content','','https://www.nytimes.com/2018/07/16/books/review/author-recommended-scary-books.html?action=click&module=Editors%20Picks&pgtype=Homepage'),
 (505,492,101,'page','10 New Sci-Fi &amp; Fantasy Novels by Women You Shouldn’t Miss','link','post_content','','http://www.unboundworlds.com/2018/07/10-new-fantasysf-novels-women-read/'),
 (506,493,101,'page','11 books on the future of humanity that everyone should read','link','post_content','','https://www.weforum.org/agenda/2017/08/11-books-on-the-future-of-humanity-that-everyone-should-read?utm_content=bufferf4c90&utm_medium=social&utm_source=twitter.com&utm_campaign=buffer'),
 (507,494,101,'page','10 Gothic Gems of Historical Fiction','link','post_content','','https://electricliterature.com/10-gothic-gems-of-historical-fiction-f54c36611ec'),
 (508,495,101,'page','101 books about where and how we live','link','post_content','','https://www.curbed.com/2017/11/22/16679866/best-books-cities-black-friday-cyber-monday'),
 (509,496,101,'page','17 brilliantly awesome short stories I read in June','link','post_content','','https://mariahaskins.com/2017/06/30/17-brilliantly-awesome-short-stories-i-read-in-june/?utm_content=bufferfae6f&utm_medium=social&utm_source=twitter.com&utm_campaign=buffer/'),
 (510,497,101,'page','9 Afrofuturist Books to Enjoy if You’re Homesick for Wakanda','link','post_content','','https://electricliterature.com/9-afrofuturist-books-to-enjoy-if-youre-homesick-for-wakanda-ebb591cd9e53'),
 (511,498,101,'page','2018 Locus Award Finalists','link','post_content','','http://locusmag.com/2018/04/2018-locus-awards-finalists/?utm_source=dlvr.it&amp;utm_medium=twitter'),
 (512,499,101,'page','17 SFF Books by Asian Women We Want To See As Movies','link','post_content','','http://www.syfy.com/syfywire/17-sff-books-by-asian-women-we-want-to-see-as-movies'),
 (513,500,101,'page','9 Extra Stellar Short Stories I Read In April','link','post_content','','https://mariahaskins.com/2018/05/06/10-stellar-short-stories-i-read-in-april/'),
 (514,501,101,'page','Me, Myself, and I: First Person Narratives in Fantasy','link','post_content','','https://litreactor.com/columns/me-myself-and-i-first-person-narratives-in-fantasy'),
 (515,502,101,'page','A Request and Suggestions about Descents into the Underworld','link','post_content','','https://mobile.twitter.com/RobGMacfarlane/status/995651627225960448'),
 (516,503,101,'page','Wonder Woman Read-alikes','link','post_content','','https://www.nypl.org/blog/2017/07/28/only-love-will-save-world-wonder-woman-readalikes?utm_campaign=SocialFlow&utm_source=twitter.com&utm_medium=referral'),
 (517,504,101,'page','Let\'s Get Graphic: 100 Favorite Comics and Graphic Novels','link','post_content','','https://www.npr.org/2017/07/12/533862948/lets-get-graphic-100-favorite-comics-and-graphic-novels'),
 (518,505,101,'page','6 Literary Visions of the Future','link','post_content','','https://www.tor.com/2018/08/23/six-literary-visions-of-the-future/?utm_source=exacttarget&utm_medium=newsletter&utm_term=tordotcom-tordotcomnewsletter&utm_content=na-readblog-blogpost&utm_campaign=tor'),
 (519,506,101,'page','2018 Locus Award Finalists','link','post_content','','http://www.fantasyliterature.com/reviews/2018-locus-award-finalists/'),
 (520,507,101,'page','9 Slim Horror Reads','link','post_content','','https://www.barnesandnoble.com/blog/sci-fi-fantasy/9-slim-horror-reads-to-squeeze-in-before-halloween/'),
 (521,508,101,'page','Sci-Fi &amp; Fantasy Short Fiction Roundup: October 2019','link','post_content','','https://www.barnesandnoble.com/blog/sci-fi-fantasy/sci-fi-fantasy-short-fiction-roundup-october-2019/'),
 (522,509,101,'page','17 of the best fantasy books everyone should read','link','post_content','','https://www.wired.co.uk/article/best-fantasy-books-novels-series'),
 (523,510,101,'page','Top Finished Fantasy Trilogies You Should Read','link','post_content','','https://thetattooedbookgeek.wordpress.com/2018/08/06/top-finished-fantasy-trilogies-you-should-read/'),
 (524,511,101,'page','365 Books by Women Authors to Celebrate International Women’s Day All Year','link','post_content','','https://www.nypl.org/blog/2017/03/08/365-books-women-authors-international-womens-day?utm_campaign=SocialFlow&utm_source=twitter.com&utm_medium=referral'),
 (525,512,101,'page','Best Books Written by Black Women','link','post_content','','https://prowritingaid.com/art/845/best-books-written-by-black-women.aspx'),
 (526,513,101,'page','20 Must-Read African Novels','link','post_content','','https://bookriot.com/2019/01/22/african-fantasy-novels/'),
 (527,514,101,'page','10 Essential Sci-Fi Novels By Women That Show What The Genre Can Do','link','post_content','','https://www.bustle.com/p/10-essential-sci-fi-novels-by-women-that-show-what-the-genre-can-do-17307273'),
 (528,515,101,'page','6 Books Featuring Killer Blade Fights','link','post_content','','https://www.barnesandnoble.com/blog/sci-fi-fantasy/6-books-featuring-killer-blade-fights/'),
 (529,516,101,'page','List of Novels with Historically Accurate Epic Fantasy','link','post_content','','https://mobile.twitter.com/ellle_em/status/1110640670266585089'),
 (530,517,101,'page','Post-post-collapse fiction','link','post_content','','https://ask.metafilter.com/333129/Post-post-collapse-fiction'),
 (531,518,101,'page','30 Best YA Fantasy Books for Teens','link','post_content','','https://reedsy.com/discovery/blog/best-ya-fantasy-books'),
 (532,519,101,'page','15 of Your Best Picks for the Best Modern Fantasy Series&nbsp;','link','post_content','','https://bookriot.com/2018/10/15/best-modern-fantasy-series/'),
 (533,520,101,'page','Brainy and Brave: A Salute to Hermione Granger','link','post_content','','https://www.nypl.org/blog/2016/09/16/brainy-brave-hermione-granger?utm_campaign=SocialFlow&utm_source=twitter.com&utm_medium=referral'),
 (534,262,101,'page','100 Best Novels','link','post_content','','http://www.fantasyliterature.com/reviews/modern-fantasy-the-100-best-novels-1946-1987/'),
 (535,521,101,'page','Outside the Lines: Unique Narrative Devices in Fantasy','link','post_content','','https://www.tor.com/2018/09/12/outside-the-lines-unique-narrative-devices-in-fantasy/?utm_source=exacttarget&utm_medium=newsletter&utm_term=tordotcom-tordotcomnewsletter&utm_content=na-readblog-blogpost&utm_campaign=9781250175489'),
 (536,522,101,'page','Shortbooks','link','post_content','','http://shortbooks.co/'),
 (537,523,101,'page','All her online fiction','link','post_content','','http://nnedi.com/books/online_fiction.html'),
 (538,524,101,'page','2019 Awards-Eligible Stories from Beneath Ceaseless Skies','link','post_content','','http://www.beneath-ceaseless-skies.com/2019/01/24/2019-awards-eligible-stories-from-bcs/'),
 (539,525,101,'page','Middle of Nowhere','link','post_content','','http://www.abyssapexzine.com/2018/03/middle-of-nowhere/'),
 (540,526,101,'page','10 Harlan Ellison Short Stories That Changed Sci-Fi','link','post_content','','https://www.barnesandnoble.com/blog/sci-fi-fantasy/10-harlan-ellison-short-stories-that-changed-sci-fi/'),
 (541,527,101,'page','17 Sci-Fi, Fantasy, and Horror Anthologies to Celebrate Short Story Month','link','post_content','','https://www.barnesandnoble.com/blog/sci-fi-fantasy/17-recent-sci-fi-fantasy-and-horror-anthologies-to-celebrate-short-story-month/'),
 (542,528,101,'page','\"The Winds of Harmattan\" by Nnedi Okorafor','link','post_content','','https://player.fm/series/levar-burton-reads/live-in-chicago-the-winds-of-harmattan-by-nnedi-okorafor'),
 (543,529,101,'page','\"The Baboon War\" by Nnedi Okorafor','link','post_content','','https://one.npr.org/?sharedMediaId=585302372:585302374'),
 (544,475,101,'page','Bridesicle by Will McIntosh','link','post_content','','http://escapepod.org/2010/07/01/ep247-bridesicle/'),
 (545,530,153,'page','Athletes have healthier brains that can actually hear better','link','post_content','','https://www.cnn.com/2019/12/09/health/sports-improves-brain-health-wellness/index.html#'),
 (546,531,153,'page','What a Brief Jog Can Do For Your Brain','link','post_content','','https://qz.com/quartzy/1413808/heres-what-a-brief-jog-can-do-for-your-brain/'),
 (547,532,153,'page','10 Biggest Myths of Fitness','link','post_content','','https://www.theguardian.com/lifeandstyle/2020/feb/24/10-biggest-myths-in-fitness-scales-are-pointless'),
 (548,533,153,'page','Hazards of Sitting Too Long','link','post_content','','https://lifehacker.com/this-graphic-explains-all-the-health-hazards-of-sitting-1595834900'),
 (549,534,153,'page','24 Podcasts to Make You Smarter','link','post_content','','https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f'),
 (550,535,153,'page','Intellectual Humility','link','post_content','','https://www.vox.com/science-and-health/2019/1/4/17989224/intellectual-humility-explained-psychology-replication'),
 (551,536,153,'page','20 Ways To Be A Happier Person In 2020, According To Therapists','link','post_content','','https://www.huffpost.com/entry/ways-to-be-happier-2020_l_5dfc23a9e4b05b08bab2981c'),
 (552,534,153,'page','14 Ways Reading Improves Your Mind and Body','link','post_content','','https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f'),
 (553,537,153,'page','15 Signs Your Life is More on Track Than You Think it is','link','post_content','','https://www.businessinsider.com/15-signs-your-life-more-on-track-you-may-think-2019-8'),
 (554,538,153,'page','Off Your Mental Game? You Could Be Mildly Dehydrated','link','post_content','','https://www.npr.org/sections/health-shots/2018/07/30/632480321/off-your-mental-game-you-could-be-mildly-dehydrated'),
 (555,539,153,'page','Minimalist Workout for All-Around Strength','link','post_content','','https://www.outsideonline.com/2243691/absolute-minimalists-strength-workout'),
 (556,540,153,'page','7 Essential Exercises For Building A Strong Core','link','post_content','','https://www.fatherly.com/health-science/7-best-core-exercises-for-men/?utm_content=fatherly&utm_campaign=twowned&utm_source=twitter&utm_medium=social'),
 (557,541,153,'page','Get Closer to Doing a Handstand in 12 Minutes','link','post_content','','https://vitals.lifehacker.com/get-closer-to-doing-a-handstand-in-12-minutes-1796377028'),
 (558,542,153,'page','Periodic Table of Exercises','link','post_content','','http://strength.stack52.com/periodic-table-of-bodyweight-exercises/'),
 (559,543,153,'page','Gymnastic Rings 101: A Beginner’s Routine &amp; FAQs','link','post_content','','https://www.artofmanliness.com/articles/gymnastic-rings-101-a-beginners-routine-faqs/'),
 (560,544,153,'page','Gymnastic rings workout exercises for beginners','link','post_content','','https://www.urbanstrength.com.au/blogs/articles/gymnastic-rings-workout-exercises-for-beginners#'),
 (561,545,153,'page','Four Minute Workout','link','post_content','','https://well.blogs.nytimes.com/2013/06/19/the-4-minute-workout/?runwell&_r=1'),
 (562,546,153,'page','Scientific Seven Minute Workout','link','post_content','','https://well.blogs.nytimes.com/2013/05/09/the-scientific-7-minute-workout/?_r=0'),
 (563,547,153,'page','YMCA Live On Demand Group Exercise','link','post_content','','https://www.youtube.com/watch?v=WiCgWNLl56w&list=PLgS9GW2BKv-OixUzY3WCbwT8QJVBjH7tu&index=2&t=0s'),
 (564,548,153,'page','Only 5 Exercises You\'ll Ever Need','link','post_content','','https://www.gq.com/story/five-moves-full-body-workout'),
 (565,549,153,'page','11 Moves To Help Get Better With Age','link','post_content','','https://www.outsideonline.com/2049441/11-moves-help-athletes-get-better-age'),
 (566,550,153,'page','8 Exercises to Improve Hip Mobility &amp; Loosen Tight Hips','link','post_content','','https://gmb.io/hip-mobility/'),
 (567,551,153,'page','12 everyday stretches to stay flexible and fit at any age','link','post_content','','https://www.businessinsider.com/best-everyday-stretches-2016-4'),
 (568,552,153,'page','Yoga with Adrienne','link','post_content','','https://www.youtube.com/user/yogawithadriene'),
 (569,553,153,'page','10 Minute Stretch Routine for Back Pain','link','post_content','','https://healthnewstips.today/backpain/index98162569.html?voluumdata=deprecated&eda=deprecated&cep=k2FyJKJn-Y1fpOlglraghl9fpoCpNsvuoP8auhdbU7xF0QVEZgiWIsBpXBfd9Af8CPwaP3xtQ-c2oHAVk8V-0ZNrYIR0_7ASQDP1PitsvckG5eUEuSpqPry5nG-Mq2AwQnFS_bMORRQGiCLRoNyzDYSUgv1X5YnFguq3iNzLkOEcJfHa20_3thkMS3Ck3Nn_j0mkqEyZAlAekg4ByjxQAS4ua_M3Wg6QYGjFQb6eKyBfKGIWYOwLzbUGitp9hds0aFhiJFLZKU0BhNQGTDtGHqmCOLxNiG4d6YdK9kn9PBU5FUQKutHvPpLdelRMpgc2wzdj53hBqEpM6SSqjPwtzr2ARJovBeCRBe-RP05oyfe6zI55xsaq-2KJX6DaZWKlklm7THPUJok5kpmrWvtTb_wgINGr6ulyqSz9UIMgjrmTEPrddv1HQLwu-MJqASfZLeaDKjic4RVVbRC0tZ0q9Mvh0myuTMImfHFn1SGB9xlXrdm_MZN6aoBanP571QuLEMm_U8NFJ1-mf3eyeM7gCM3g2kfR6c-GVerzlD7iQtNLN7FTV5jGCcy-y0zwmUVT_53gRdwfcvzx50GDeYhrJQU2dehy7URlKmPkTq5rgxf7FeJOtlxjyUAfeCtd7Qevi2O7N_X04R5C9ypkkitlRk1e_tSwApso6ZNQKkYNfs4&utm_content=Chiropractors%20Baffled:%20Simple%20Stretch%20Relieves%20Years%20of%20Back%20Pain%20(Wat&utm_term=002f47524a4d52e792bdafd472a8a59f46&Doc_title=Erase%20My%20Back%20Pain%20%7C%20Health%20News%20Tips&utm_site=espn.com/blog&utm_pub=ESPN%20(ESPN)&newad=2&utm_adid=0099e7015bc5f22a3ffd6c2f75588d3a8a&utm_doc_id=0050095ecbe5398c9b98b4d8cecb4f189b&utm_new=002f47524a4d52e792bdafd472a8a59f46_espn.com/blog&utm_cam=TabTier1NewVersion&ob_click_id=7cb27d9a197ff36ebc26e48764a37bc1-000be295f74876f5c74c82e3c8a2545eae'),
 (570,554,153,'page','High Intensity Interval Training','link','post_content','','https://www.bodybuilding.com/content/what-is-the-best-hiit-workout.html'),
 (571,555,153,'page','Fixing Elbow Pain','link','post_content','','https://gmb.io/elbows/?utm_source=drip&utm_medium=email&utm_campaign=17%2F10%2F30+Elbows&utm_content=The+loneliest+body+part'),
 (572,556,153,'page','3 Exercises for Hunched Posture','link','post_content','','https://lifehacker.com/do-these-three-exercises-in-four-minutes-to-improve-you-1777522021?utm_campaign=socialflow_lifehacker_facebook&utm_source=lifehacker_facebook&utm_medium=socialflow'),
 (573,557,153,'page','A comprehensive guide to the new science of treating lower back pain','link','post_content','','https://www.vox.com/science-and-health/2017/8/4/15929484/chronic-back-pain-treatment-mainstream-vs-alternative'),
 (574,558,153,'page','Exercise adjustments if injured','link','post_content','','https://darebee.com/modifications.html'),
 (575,559,153,'page','7 Exercises to Fix Shoulder Pain','link','post_content','','https://www.outsideonline.com/2407208/shoulder-pain-exercises-rotator-cuff-injury'),
 (576,560,153,'page','Planning and Construction','link','post_content','','https://www.climbing.com/skills/home-wall-primer-part-1planning-and-construction/'),
 (577,561,153,'page','Choosing Holds','link','post_content','','https://www.climbing.com/skills/home-wall-primer-choosing-holds/'),
 (578,562,153,'page','Route Setting','link','post_content','','https://www.climbing.com/skills/home-wall-primer-route-setting/'),
 (579,563,153,'page','How to Build a Home Climbing Wall','link','post_content','','https://www.rei.com/blog/climb/build-home-climbing-wall'),
 (580,564,153,'page','Element Climbing bulk clearance','link','post_content','','https://www.elementclimbing.com/Bulk-Climbing-Holds-s/1826.htm'),
 (581,565,153,'page','Escape Climbing factory seconds','link','post_content','','https://escapeclimbing.com/collections/holds/products/factory-seconds'),
 (582,566,153,'page','Rocky Mountain Climbing Gear $15 sample pack','link','post_content','','https://www.rockymountainclimbinggear.com/sample-pack'),
 (583,567,153,'page','Atomic Climbing free holds sample','link','post_content','','https://www.atomikclimbingholds.com/free-sample-holds-bolt-on'),
 (584,568,755,'page','dweade@gmail.com','link','post_content','','mailto:dweade@gmail.com'),
 (585,569,755,'page','Common Sense Media','link','post_content','','https://www.commonsensemedia.org/'),
 (586,570,755,'page','Homeschooling is NOT the Same as Crisis Schooling: advice during coronavirus COVID -19 shut downs','link','post_content','','https://www.heatheranneworld.com/post/homeschooling-is-not-the-same-as-crisis-schooling-advice-during-coronavirus-covid-19-shut-downs'),
 (587,571,755,'page','Who Should Take Care of Kids When Parents Are Too Sick With Coronavirus?','link','post_content','','https://jezebel.com/who-should-take-care-of-kids-when-parents-are-too-sick-1842613702'),
 (588,572,755,'page','Be Internet Awesome','link','post_content','','https://beinternetawesome.withgoogle.com/en_us'),
 (589,573,755,'page','Garfield\'s eLearning','link','post_content','','https://iamcybersafe.org/s/newsarticle/a094R00001Ny6SwQAJ/free-cyber-resources-for-children-during-covid19'),
 (590,574,755,'page','Education Companies Offering Free Subscriptions due to School Closings','link','post_content','','http://www.amazingeducationalresources.com/'),
 (591,575,755,'page','We Are Teachers: 190+ (and growing) resource links','link','post_content','','https://www.weareteachers.com/free-online-learning-resources/'),
 (592,576,755,'page','Amazing Educational Resources','link','post_content','','https://www.amazingeducationalresources.com/'),
 (593,577,755,'page','Virtual Gifted and Talented Enrichment Support Materials','link','post_content','','https://docs.google.com/document/d/1UbaobL2ymO4_MW4N0eVvdBEfMPLyGaH7KipH27Onmg0/mobilebasic'),
 (594,578,755,'page','Resources That Support Distance Learning','link','post_content','','https://www.cde.ca.gov/ls/he/hn/appendix1.asp'),
 (595,579,755,'page','Tech for Learners','link','post_content','','https://www.techforlearners.org/'),
 (596,580,755,'page','Hoopla','link','post_content','','https://www.hoopladigital.com/'),
 (597,581,755,'page','Overdrive/Libby','link','post_content','','https://www.overdrive.com/'),
 (598,582,755,'page','RBDigital','link','post_content','','https://rbdigital.com/'),
 (599,583,755,'page','Twinkl School Closure Hub Free Resources','link','post_content','','https://www.twinkl.com/resources/usa-resources/school-closure-resources-usa'),
 (600,584,755,'page','While at Home','link','post_content','','https://whileathome.org/'),
 (601,585,755,'page','Stretch-n-Grow','link','post_content','','https://stretchngrowva.com/'),
 (602,586,755,'page','1','link','post_content','','https://www.youtube.com/watch?v=aG5kDIBoVzA&feature=youtu.be'),
 (603,587,755,'page','Watch and Engage graphic','link','post_content','','https://drive.google.com/file/d/1Hcp5my75qNZ0MGJ5jgX-SyKHzTXt6ddS/view'),
 (604,588,755,'page','1','link','post_content','','https://www.youtube.com/watch?v=DIt6geiZGl4&feature=youtu.be'),
 (605,589,755,'page','1','link','post_content','','https://www.youtube.com/watch?v=kTWAlUbAXlM&feature=youtu.be'),
 (606,590,755,'page','1','link','post_content','','https://www.youtube.com/watch?v=XDhqp5HM63Y&feature=youtu.be'),
 (607,591,755,'page','At Home Lessons','link','post_content','','https://www.youtube.com/channel/UCP1D2qNGgVic2obTMqF43xg'),
 (608,592,755,'page','Rompy\'s House at Home','link','post_content','','https://www.youtube.com/playlist?list=PLku2xLKblRzQqxwG1ttyF5Fy5zSqplUcQ'),
 (609,593,755,'page','Life Little Feet Classes','link','post_content','','https://www.facebook.com/phoenixartsdance/'),
 (610,594,755,'page','Cosmic Yoga lessons for 3+','link','post_content','','https://www.youtube.com/user/CosmicKidsYoga'),
 (611,595,755,'page','Audible Little Listeners Free Audiobooks','link','post_content','','https://stories.audible.com/discovery/enterprise-discovery-21122358011?ref=adbl_ent_anon_ds_ds_dccs_sbtp-0-0'),
 (612,596,755,'page','We\'re Going on a Bear Hunt','link','post_content','','https://www.youtube.com/watch?v=5_ShP3fiEhU'),
 (613,597,755,'page','Goldfish Song','link','post_content','','https://www.youtube.com/watch?v=uCF3vBuxXS8&list=PLU2qP19qYErGAXsQ014XbbHJNB106KVlW&index=14'),
 (614,598,755,'page','Printable Playdough Mats','link','post_content','','https://www.playdoughtoplato.com/100-free-playdough-mats/'),
 (615,599,755,'page','Playdough recipe','link','post_content','','https://livingwellmom.com/easy-homemade-playdough-recipe/'),
 (616,600,755,'page','Sing and Dance music','link','post_content','','https://www.colormehealthy.com/songs-and-lyrics/'),
 (617,601,755,'page','Primrose Pre-K Online with Og activities ','link','post_content','','https://learning.primroseschools.com/week1/'),
 (618,602,755,'page','Best Homeschool Resources Online','link','post_content','','https://www.parents.com/kids/education/home-schooling/the-best-homeschooling-resources-online/'),
 (619,603,755,'page','Top Ten Preschool Curriculum Options','link','post_content','','https://www.homeschool.com/blog/2019/08/top-10-preschool-curriculum-options/'),
 (620,604,755,'page','The Top 10 Early Childhood Education Subscription Box Programs','link','post_content','','https://www.earlychildhoodeducationzone.com/top-early-childhood-education-subscription-boxes/'),
 (621,605,755,'page','What Parents Need to Know About Home Schooling','link','post_content','','https://www.huffpost.com/entry/home-schooling-remote-learning-covid-19_n_5e7b813bc5b62a1870d65417'),
 (622,606,755,'page','Camp Hello Bello Stay-at-home Camp','link','post_content','','https://www.camphellobello.com/'),
 (623,607,755,'page','Disney Magic Moments (stories, videos, activities)','link','post_content','','https://news.disney.com/magicmoments'),
 (624,608,755,'page','Free Printable Activities (mazes, letter tracing, cut and paste worksheets)','link','post_content','','https://www.kidscanhavefun.com/index.htm'),
 (625,609,755,'page','Khan Academy','link','post_content','','https://www.khanacademy.org/'),
 (626,610,755,'page','Prodigy','link','post_content','','https://www.prodigygame.com/'),
 (627,611,755,'page','Puku Vocabulary App from Merriam-Webster','link','post_content','','https://apps.apple.com/us/app/puku-learn-new-words/id1460784777'),
 (628,612,755,'page','Mystery Science remote learning lessons','link','post_content','','https://mysteryscience.com/school-closure-planning'),
 (629,613,755,'page','3rd Grade Multiplication sample','link','post_content','','https://www.khanacademy.org/khan-for-educators/khan-kids-page/cc-third-grade-math/intro-to-multiplication'),
 (630,614,755,'page','Scholastic Learning at Home','link','post_content','','https://classroommagazines.scholastic.com/support/learnathome.html?utm_source=Jane+Friedman+%2F+Electric+Speed&utm_campaign=7e21e39536-EMAIL_CAMPAIGN_2017_12_30_COPY_01&utm_medium=email&utm_term=0_b84a4334ba-7e21e39536-332623045'),
 (631,615,755,'page','Lunch Doodles with Mo Willems','link','post_content','','https://www.kennedy-center.org/education/mo-willems/'),
 (632,616,755,'page','Dave Pilkey at Home','link','post_content','','https://kids.scholastic.com/kids/books/dav-pilkey-at-home/'),
 (633,617,755,'page','DuoLingo','link','post_content','','https://www.duolingo.com/learn'),
 (634,618,755,'page','Ancient Athens 3D','link','post_content','','http://www.ancientathens3d.com/'),
 (635,619,755,'page','Royal Ontario Museum Classroom/At Home Activities','link','post_content','','https://www.rom.on.ca/en/learn/activities/classroom'),
 (636,620,755,'page','13 Virtual Train Rides','link','post_content','','https://www.travelandleisure.com/trip-ideas/bus-train/virtual-train-rides?utm_source=pocket-newtab'),
 (637,621,755,'page','London Children Ballet','link','post_content','','https://www.youtube.com/user/LCBallet/playlists'),
 (638,622,755,'page','CBC Ballet','link','post_content','','https://www.youtube.com/channel/UC1IcgtT6KdGTBZ0FJgv7LrA/playlists'),
 (639,623,755,'page','Saskia Dansschool Lessons','link','post_content','','https://www.youtube.com/watch?v=t6PmB6tMBOc&list=PLL7beOYvKrnd-Kj8dR3QuxQS54jCwSZ6L'),
 (640,624,755,'page','Howcast Hip Hop Moves','link','post_content','','https://www.howcast.com/guides/938-how-to-do-hip-hop-dance-moves'),
 (641,625,755,'page','Steam at Home Bingo','link','post_content','','https://drive.google.com/file/d/1YkVFFF0fQ3tV6xKOjgoVm3xNkeN-Lhr3/view'),
 (642,626,755,'page','Storyline Online','link','post_content','','https://www.storylineonline.net/'),
 (643,627,755,'page','Audible Elementary Age Free Audiobooks','link','post_content','','https://stories.audible.com/discovery/enterprise-discovery-21122356011?ref=adbl_ent_anon_ds_ds_dccs_sbtp-0-1'),
 (644,628,755,'page','Free Kids E-books from Barnes and Noble','link','post_content','','https://www.barnesandnoble.com/b/free-ebooks/nook-books/kids/_/N-ry0Z8qaZtu1'),
 (645,629,755,'page','Steaming with Mrs Loving resource pages','link','post_content','','https://lovingsteam.weebly.com/'),
 (646,630,755,'page','Free Resources for Home Schooling','link','post_content','','https://qns.com/story/2020/03/16/free-resources-and-subscriptions-for-remote-learning-and-home-schooling-due-to-coronavirus/'),
 (647,631,755,'page','Teacher.org Lesson Plans','link','post_content','','https://www.teacher.org/lesson-plans/'),
 (648,632,755,'page','Seussville: Dr Seuss-related Reading and Games','link','post_content','','https://www.seussville.com/play/'),
 (649,633,755,'page','Common Sense Media\'s List of Virtual Field Trips','link','post_content','','https://www.commonsense.org/education/top-picks/virtual-field-trip-apps-and-websites'),
 (650,634,755,'page','Fun Brain: Math and Reading','link','post_content','','https://www.funbrain.com/'),
 (651,635,755,'page','Free Children Stories (across all ages)','link','post_content','','https://www.freechildrenstories.com/'),
 (652,636,755,'page','Wow in the World Podcast','link','post_content','','https://www.npr.org/podcasts/510321/wow-in-the-world'),
 (653,637,755,'page','KinderArt','link','post_content','','https://kinderart.com/'),
 (654,638,755,'page','TinkerCad Training','link','post_content','','https://www.youtube.com/channel/UC4suyHp0sDoAWKmJSjR65VA'),
 (655,639,755,'page','This Illustrated Periodic Table Shows How We Regularly Interact With Each Element','link','post_content','','https://www.mentalfloss.com/article/502751/illustrated-periodic-table-shows-how-we-regularly-interact-each-element'),
 (656,640,755,'page','Ology','link','post_content','','https://www.amnh.org/explore/ology'),
 (657,641,755,'page','Videos from the Hayden Planetarium','link','post_content','','https://www.youtube.com/playlist?list=PLrfcruGtplwELiuyIEVxHBpgW_0WxZI6G'),
 (658,642,755,'page','Live lessons about museum topics','link','post_content','','https://www.youtube.com/playlist?list=PLrfcruGtplwHE3aFz6UaYFirAbCjQbXag'),
 (659,643,755,'page','Literacy Tips for Families','link','post_content','','https://docs.google.com/document/d/1C_Gwyw_4GC8PrD02DlJfr5SVy-mvtKya8Df0pY1LeNE/preview'),
 (660,644,755,'page','Reading Resources','link','post_content','','https://docs.google.com/document/d/1BILzWIDskmOAMSSLgAFwyR-n6Lq93m8ytq6kKFTWwaE/preview'),
 (661,645,755,'page','Digital Resources and Databases','link','post_content','','https://docs.google.com/document/d/113XeN5QyAmCNCmbryFR-olqRbjrYiAJTg5UTD7mYD9s/preview'),
 (662,646,755,'page','Get Moving Today Activity Calendar','link','post_content','','https://www.shapeamerica.org/uploads/teachersToolbox/earlyChildhood/ECRevisedcalendar.pdf'),
 (663,647,755,'page','Hogwarts Digital Escape Room','link','post_content','','https://docs.google.com/forms/d/e/1FAIpQLSflNxNM0jzbZJjUqOcXkwhGTfii4CM_CA3kCxImbY8c3AABEA/viewform?fbzx=-8344382832376631293'),
 (664,648,755,'page','DIY Kids Cooking Camp','link','post_content','','https://www.peanutblossom.com/blog/diy-kids-cooking-classes/'),
 (665,649,755,'page','Time Magazine List of Activities','link','post_content','','https://time.com/5803373/coronavirus-kids-at-home-activities/'),
 (666,650,755,'page','Harry Potter at Home','link','post_content','','https://www.wizardingworld.com/news/introducing-hp-at-home'),
 (667,651,755,'page','Kid Focused Apps','link','post_content','','https://9to5mac.com/2020/04/01/roundup-best-kid-focused-apps-and-podcasts-to-help-with-social-distancing/'),
 (668,652,755,'page','Free year of Vooks animated storybooks ','link','post_content','','https://www.vooks.com/teacher-appreciation'),
 (669,653,755,'page','New Music Mixing Tool from Library of Congress','link','post_content','','https://www.nytimes.com/2020/04/24/arts/music/library-of-congress-digital-dj.html'),
 (670,654,755,'page','PBS Kids Online Videos','link','post_content','','https://www.pbs.org/parents/pbskidsdaily?source=tw'),
 (671,655,755,'page','Hightlight Kids: Games, Recipes, Crafts, Activities','link','post_content','','https://www.highlightskids.com/'),
 (672,656,755,'page','Astronauts Reading From Space','link','post_content','','https://storytimefromspace.com/'),
 (673,657,755,'page','Actor Josh Gad Reads to Kids','link','post_content','','https://offspring.lifehacker.com/actor-josh-gad-will-read-to-your-kids-every-night-1842398287?utm_source=lifehacker_facebook&utm_campaign=socialflow_lifehacker_facebook&utm_medium=socialflow'),
 (674,658,755,'page','Games and Videos','link','post_content','','https://www.elmwoodparkzoo.org/education/bubbys-club/'),
 (675,659,755,'page','Zoo School Daily Live videos','link','post_content','','https://www.facebook.com/pg/EPZoo/videos/?ref=page_internal'),
 (676,660,755,'page','Animal Cams','link','post_content','','https://www.elmwoodparkzoo.org/animal-cams/'),
 (677,661,755,'page','Virtual Tour of Petra','link','post_content','','https://secretldn.com/explore-petra-jordan-google-street-view/'),
 (678,662,755,'page','Cincinnati Zoo Home Safari Resources','link','post_content','','http://cincinnatizoo.org/home-safari-resources/'),
 (679,663,755,'page','Ripley Aquarium At Home','link','post_content','','https://www.ripleyaquariums.com/canada/'),
 (680,664,755,'page','Links to 30 Virtual Field Trips','link','post_content','','https://docs.google.com/document/d/1SvIdgTx9djKO6SjyvPDsoGlkgE3iExmi3qh2KRRku_w/preview?fbclid=IwAR1VDqqYSZdRiL4EOoPUUljG2JHH4B0o1Lop9LAnhvQo5YcK5lO9Sfqo22g&pru=AAABcQevPwQ*VRSL5wYCl1Z3qr3ZLqS3ZA'),
 (681,665,755,'page','Geo Show','link','post_content','','http://geoshow.tv/'),
 (682,666,755,'page','List of 9 Virtual Field Trips','link','post_content','','https://www.waterford.org/resources/3-great-virtual-field-trips-for-early-learners/'),
 (683,667,755,'page','National Park tours','link','post_content','','https://www.travelandleisure.com/trip-ideas/national-parks/virtual-national-parks-tours'),
 (684,668,755,'page','20 Virtual Field Trips','link','post_content','','https://adventuresinfamilyhood.com/20-virtual-field-trips-to-take-with-your-kids.html'),
 (685,669,755,'page','12 Virtual Museum Tours','link','post_content','','https://www.travelandleisure.com/attractions/museums-galleries/museums-with-virtual-tours'),
 (686,670,755,'page','Intrepid Sea, Air and Space Museum virtual tours','link','post_content','','https://www.intrepidmuseum.org/digital-resources'),
 (687,671,755,'page','12 World-Class Museums You Can Visit Online','link','post_content','','https://www.mentalfloss.com/article/75809/12-world-class-museums-you-can-visit-online'),
 (688,672,755,'page','Car-themed Coloring Books','link','post_content','','https://www.motortrend.com/news/car-coloring-books-list/'),
 (689,673,755,'page','Amazon offers many free shows for various ages','link','post_content','','https://smile.amazon.com/gp/video/storefront/ref=atv_hm_hom_1_c_ZWyNDQ_fMHI51_1_1?contentId=freeforall&merchId=freeforall&smdm-noredirect=true'),
 (690,674,755,'page','New York Times has a list for middle school and up','link','post_content','','https://www.nytimes.com/2020/03/11/learning/coronavirus-resources-teaching-learning-and-thinking-critically.html'),
 (691,675,755,'page','Audible Free Audiobooks','link','post_content','','https://stories.audible.com/discovery'),
 (692,676,755,'page','Monterey Bay Aquarium Live Cams','link','post_content','','https://www.montereybayaquarium.org/animals/live-cams'),
 (693,677,755,'page','Top 12 Websites For Children With Learning Disabilities','link','post_content','','https://www.special-education-degree.net/top-12-websites-children-learning-disabilities/'),
 (694,678,755,'page','Can Do Kids','link','post_content','','http://www.ucando.org/kids.html'),
 (695,679,755,'page','Mental Health and Wellness Tips During COVID-19','link','post_content','','https://energyresourcing.com/blog/mental-health-wellness-covid-19/'),
 (696,680,755,'page','RVATogether: Ways to Help Those in Need during COVID-19','link','post_content','','https://docs.google.com/spreadsheets/d/15usodUcH4SyMbFk5TGq--gftwfkHbHHpfoUy6UKsi_Q/htmlview?fbclid=IwAR1lbRnb2YEMWsLvokwKZ4Vc6AZ4DA2So9Rh0T9KKyVtSMqumalnQ0XmK54#gid=0'),
 (697,681,755,'page','Resources for Artists in the COVID19 Crisis','link','post_content','','https://www.kickstarter.com/articles/covid-19-coronavirus-artist-resources?utm_source=Jane+Friedman+%2F+Electric+Speed&utm_campaign=7e21e39536-EMAIL_CAMPAIGN_2017_12_30_COPY_01&utm_medium=email&utm_term=0_b84a4334ba-7e21e39536-332623045'),
 (698,682,755,'page','Creative Person\'s Guide to Feeling Healthy','link','post_content','','https://thecreativeindependent.com/guides/a-creative-persons-guide-to-feeling-healthy/'),
 (699,683,755,'page','That Discomfort You\'re Feeling is Grief','link','post_content','','https://hbr.org/2020/03/that-discomfort-youre-feeling-is-grief'),
 (700,684,755,'page','exercise page','link','post_content','','https://dmweade.com/welcome/exercise-and-self-care/'),
 (701,685,755,'page','Open Space Yoga Lessons','link','post_content','','https://www.yogaopenspace.com/'),
 (702,686,755,'page','5 Minute Circuit Workout','link','post_content','','https://blog.myfitnesspal.com/watch/at-home-circuit-workout-with-sydney-torabi/'),
 (703,687,755,'page','21 Day Tabata Yoga Challenge','link','post_content','','https://www.dailyom.com/cgi-bin/courses/courseoverview.cgi?cid=873&aff=92&desc=1'),
 (704,688,755,'page','Just Watch','link','post_content','','https://www.justwatch.com/'),
 (705,689,755,'page','Sync Netflix viewing with friends','link','post_content','','https://www.netflixparty.com/'),
 (706,690,755,'page','Upcoming Concert Streams','link','post_content','','https://www.cnet.com/news/all-live-streaming-concerts/'),
 (707,691,755,'page','Free Broadway Shows (7 day trial)','link','post_content','','https://lifehacker.com/how-to-watch-broadway-shows-like-cats-and-sweeney-todd-1842439020'),
 (708,692,755,'page','New York Times Lesson of the Day','link','post_content','','https://www.nytimes.com/column/learning-article-of-the-day'),
 (709,693,755,'page','Google Virtual Museum Tours','link','post_content','','https://artsandculture.google.com/partner?hl=en'),
 (710,694,755,'page','Free Samurai Jack','link','post_content','','https://www.adultswim.com/videos/samurai-jack'),
 (711,695,755,'page','Nine Inch Nails','link','post_content','','https://www.nin.com/'),
 (712,696,755,'page','Podcasts to Binge While We\'re Cooped Up','link','post_content','','https://www.theguardian.com/lifeandstyle/2020/mar/20/readers-recommend-podcasts-to-binge-on-while-youre-cooped-up-in-self-isolation'),
 (713,697,755,'page','reading list page','link','post_content','','https://dmweade.com/welcome/reading-lists/'),
 (714,698,755,'page','Project Gutenberg','link','post_content','','http://www.gutenberg.org/'),
 (715,699,755,'page','LibreVox','link','post_content','','https://librivox.org/'),
 (716,700,755,'page','Manybooks','link','post_content','','https://manybooks.net/'),
 (717,701,755,'page','DigiLibraries','link','post_content','','https://digilibraries.com/'),
 (718,702,755,'page','Baen Free Library','link','post_content','','https://www.baen.com/allbooks/category/index/id/2012'),
 (719,703,755,'page','Lithuanian Fairy Tales','link','post_content','','https://www.jurga-creations.com/sales-page'),
 (720,704,755,'page','Apple Books offers free stay-at-home collection ','link','post_content','','https://9to5mac.com/2020/03/22/free-apple-books/'),
 (721,705,755,'page','Enchanted Living Free Magazines','link','post_content','','https://enchantedlivingmagazine.com/a-gift-for-our-readers/'),
 (722,706,755,'page','DriveThruComics','link','post_content','','https://www.drivethrucomics.com/browse.php?pto=0&pfrom=0'),
 (723,707,755,'page','Itchi.io','link','post_content','','https://itch.io/c/757294/games-to-help-you-stay-inside'),
 (724,708,755,'page','Free RPG Material','link','post_content','','https://www.drivethrurpg.com/browse.php?pto=0&pfrom=0'),
 (725,709,755,'page','Explorers Guide to Wildemount','link','post_content','','https://marketplace.roll20.net/browse/module/5353/adventure-preview-explorers-guide-to-wildemount'),
 (726,710,755,'page','Old World Adventures','link','post_content','','https://www.drivethrurpg.com/product/259967/WFRP-Old-World-Adventures--Night-of-Blood'),
 (727,711,755,'page','Adventures Afoot in Reikland','link','post_content','','https://www.drivethrurpg.com/product/260781/WFRP--Adventures-Afoot-in-the-Reikland?term=AFOOT+REIKLAND'),
 (728,712,755,'page','Lara Croft Go is free','link','post_content','','https://www.cultofmac.com/696881/lara-croft-go-goes-free-for-quarantined-tomb-raiders/'),
 (729,713,755,'page','Free Minecraft education collection','link','post_content','','https://www.minecraft.net/en-us/marketplace/education'),
 (730,714,755,'page','Yap - 6 person chat','link','post_content','','https://yap.chat/'),
 (731,715,755,'page','I\'ve added a new page with some of my favorite recipes and collected lists.','link','post_content','','https://dmweade.com/welcome/for-cooking/'),
 (732,716,755,'page','Resources for Making','link','post_content','','https://craftcouncil.org/post/resources-makers-during-covid-19'),
 (733,717,755,'page','Terrifying Tour of Paris Catacombs','link','post_content','','http://strangeandcreepy.com/take-a-terrifying-virtual-tour-of-the-paris-catacombs-from-your-couch/'),
 (734,718,755,'page','450 Ivy League courses you can take online right now for free','link','post_content','','https://www.freecodecamp.org/news/here-are-380-ivy-league-courses-you-can-take-online-right-now-for-free-9b3ffcbd7b8c/?utm_source=social-facebook&utm_medium=fb4d&utm_campaign=organic&utm_content=post-url&utm_offering=business-tools&utm_product=380-free-ivy-league-courses_04092020'),
 (735,36,755,'page','Stay Home and Skill Up (7000+ Tech Courses)','link','post_content','','https://www.metmuseum.org/art/metpublications/titles-with-full-text-online?searchtype=F'),
 (736,719,755,'page','YouTube Learn@Home','link','post_content','','https://learnathome.withyoutube.com/'),
 (737,720,755,'page','Library Collections to Explore Online','link','post_content','','http://www.ilovelibraries.org/article/amazing-library-collections-explore-online'),
 (738,721,755,'page','3 Months Free Guitar/Ukelele Lessons from Fender','link','post_content','','https://try.fender.com/play/playthrough/'),
 (739,722,755,'page','Free Nikon Photography Classes','link','post_content','','https://lifehacker.com/you-can-attend-nikons-photography-school-for-free-this-1842682960'),
 (740,723,755,'page','Escape Room Style Activities','link','post_content','','https://totbescaperooms.com/activities'),
 (741,724,755,'page','Puzzlecraft Printable Challenges','link','post_content','','https://totbescaperooms.com/puzzlecraft'),
 (742,725,755,'page','Free Star Wars Comic Books','link','post_content','','https://smile.amazon.com/b/ref=dc_prr_prime_hero?ascsubtag=ag:1399dcaf-2aa5-4e25-8fca-66d822059dd0|vg:___VIEW_GUID___|st:dtp&tag=cheapskate08-20&camp=1789&creative=9325&ie=UTF8&node=20800050011&smdm-noredirect=true'),
 (743,36,755,'page','Metropolitan Museum of Art Free Art Books','link','post_content','','https://www.metmuseum.org/art/metpublications/titles-with-full-text-online?searchtype=F'),
 (744,726,857,'page','Crockpot Chicken Taco Meat','link','post_content','','https://www.fromvalerieskitchen.com/crock-pot-chicken-tacos/'),
 (745,727,857,'page','Vietnamese marinated grilled chicken','link','post_content','','https://www.kroger.com/r/vietnamese-marinated-grilled-chicken-recipe/221803'),
 (746,728,857,'page','a citrus dipping sauce','link','post_content','','https://www.vietworldkitchen.com/blog/2008/11/basic-vietnamese-dipping-sauce-nuoc-cham.html'),
 (747,729,857,'page','Cuban Black Beans','link','post_content','','https://www.cinnamonspiceandeverythingnice.com/cuban-style-black-bean-and-rice-bowls/'),
 (748,730,857,'page','Cuban Black Beans','link','post_content','','https://www.cocoandash.com/cuban-black-beans/'),
 (749,731,857,'page','Cuban Black Beans','link','post_content','','https://simple-veganista.com/cuban-black-bean-mango-bowl'),
 (750,732,857,'page','mango salad','link','post_content','','https://simple-veganista.com/mango-salsa/print/8356/'),
 (751,733,857,'page','Vegetable Paella','link','post_content','','https://sweetsimplevegan.com/2018/02/loaded-vegan-paella/print/17328/'),
 (752,734,857,'page','Kuba Kuba','link','post_content','','https://www.kubakuba.info/'),
 (753,735,857,'page','Copycat version, with bee','link','post_content','','https://www.thechunkychef.com/copycat-skyline-cincinnati-chili/'),
 (754,736,857,'page','Healthy turkey version','link','post_content','','https://www.thechunkychef.com/heart-healthy-turkey-chili/'),
 (755,737,857,'page','Peruvian Ceviche','link','post_content','','https://www.myrecipes.com/recipe/peruvian-ceviche'),
 (756,738,857,'page','Peruvian Papa A La Huancaina','link','post_content','','https://www.allrecipes.com/recipe/236497/papa-a-la-huancaina-huancayo-style-potatoes/'),
 (757,739,857,'page','from many stores','link','post_content','','https://www.google.com/search?q=papa+a+la+huancaina+sauce&client=firefox-b-1-d&sxsrf=ALeKk01n9m6m4uVTaRGVqpFp7JMTt2pb4A:1587604739945&source=lnms&tbm=shop&sa=X&ved=2ahUKEwjJtsXEsP3oAhUTlXIEHeFYD4EQ_AUoA3oECA4QBQ&biw=1135&bih=856'),
 (758,740,857,'page','Sheet Pan Cashew Chicken','link','post_content','','https://www.ihearteating.com/sheet-pan-cashew-chicken/'),
 (759,741,857,'page','Mititei Romanian Skinless Sausages','link','post_content','','http://food52.com/recipes/12296-mititei-spicy-garlicky-grilled-sausages'),
 (760,742,857,'page','Romanian Ricotta Cheesecake','link','post_content','','https://www.jocooks.com/baking/cakes/ricotta_cheese_cake/'),
 (761,743,857,'page','Pamela’s Gluten-free Baking and Pancake Mix','link','post_content','','https://www.pamelasproducts.com/products/gluten-free-baking-pancake-mix'),
 (762,744,857,'page','No-knead Artisan Bread','link','post_content','','https://leitesculinaria.com/93789/recipes-5-minute-artisan-bread.html'),
 (763,745,857,'page','Cooking in Quarantine','link','post_content','','https://quarantine.substack.com/'),
 (764,746,857,'page','These Five Cuisines Can Save the Planet','link','post_content','','https://www.nytimes.com/2019/04/30/climate/these-five-cuisines-are-easier-on-the-planet.html?fallback=0&recId=1Kt6ZGFbOqm64fNaPIeudEPeslj&locked=0&geoContinent=NA&geoRegion=VA&recAlloc=story&geoCountry=US&blockId=home-featured&imp_id=741827454&action=click&module=editorsPicks&pgtype=Article&region=Footer'),
 (765,747,857,'page','Common Baking Substatutes','link','post_content','','https://skillet.lifehacker.com/solve-for-ingredient-shortages-with-these-common-baking-1843044779'),
 (766,748,857,'page','Asma Khan Indian Dishes','link','post_content','','https://www.greatbritishchefs.com/collections/asma-khan-recipes'),
 (767,749,857,'page','Her recipes','link','post_content','','https://www.foodandwine.com/chefs/nancy-silverton#8'),
 (768,749,857,'page','From LaBrea Bakery','link','post_content','','https://www.foodandwine.com/chefs/nancy-silverton#8'),
 (769,750,857,'page','Samin Nosrat\'s 10 Essential Persian Recipes','link','post_content','','https://www.nytimes.com/2019/05/14/dining/persian-food-recipes-samin-nosrat.html?smid=tw-nytfood&smtyp=cur'),
 (770,751,857,'page','Tejal Rao\'s 10 Essential Indian Recipes','link','post_content','','https://cooking.nytimes.com/68861692-nyt-cooking/20348167-tejal-raos-10-essential-indian-recipes'),
 (771,752,857,'page','Sean Sherman\'s 10 Essential Native American Recipes','link','post_content','','https://www.nytimes.com/2019/11/04/dining/native-american-recipes-sioux-chef.html?action=click&module=Top%20Stories&pgtype=Homepage'),
 (772,753,857,'page','A Family Feast Easy Dinners','link','post_content','','https://www.afamilyfeast.com/tag/easy-dinners/'),
 (773,754,857,'page','21 Rice Recipes From Your Pantry','link','post_content','','https://www.huffpost.com/entry/easy-rice-recipes_l_5e67e36cc5b6670e72ffe5be'),
 (774,755,857,'page','14 Satisfying Japanese Recipes','link','post_content','','https://cooking.nytimes.com/68861692-nyt-cooking/1016498-14-satisfying-japanese-recipes'),
 (775,756,857,'page','77 Slow Cooker Recipes','link','post_content','','https://greatist.com/health/healthy-crock-pot-recipes#1'),
 (776,757,857,'page','50 of the World\'s Best Desserts','link','post_content','','https://www.cnn.com/travel/article/world-50-best-desserts/index.html'),
 (777,758,857,'page','Put These Recipes on Repeat','link','post_content','','https://www.nytimes.com/2020/01/10/dining/play-these-on-repeat.html?action=click&module=Features&pgtype=Homepage'),
 (778,759,857,'page','36 Best Bread Recipes','link','post_content','','https://cooking.nytimes.com/68861692-nyt-cooking/1001962-36-of-our-best-bread-recipes'),
 (779,760,857,'page','From Pot to Plank: Polenta Eaten Off the Table','link','post_content','','https://www.nytimes.com/1998/03/18/dining/from-pot-to-plank-polenta-eaten-off-the-table.html'),
 (780,761,857,'page','Slow-Cooker Garlic-Parmesan Chicken','link','post_content','','https://www.delish.com/cooking/recipe-ideas/recipes/a46066/slow-cooker-garlic-parmesan-chicken-recipe/'),
 (781,762,857,'page','Slow-Cooker Asian Lettuce Wraps','link','post_content','','https://www.wellplated.com/asian-lettuce-wraps/'),
 (782,763,701,'post','Lifehacker serie','link','post_content','','https://lifehacker.com/tag/how-i-work'),
 (783,339,701,'post','Ingrid Sundberg\'s Color Thesaurus','link','post_content','','https://ingridsnotes.wordpress.com/2014/02/04/the-color-thesaurus/'),
 (784,764,701,'post','152 color Crayon stand','link','post_content','','https://smile.amazon.com/gp/product/B00CI6J3HA/ref=ppx_yo_dt_b_search_asin_title?ie=UTF8&psc=1'),
 (785,342,701,'post','Scrivener','link','post_content','','https://www.literatureandlatte.com/scrivener/overview'),
 (786,765,701,'post','Stack','link','post_content','','https://getstack.app/'),
 (787,766,701,'post','Dictionary.com','link','post_content','','https://www.dictionary.com/'),
 (788,767,701,'post','Thesaurus.com','link','post_content','','https://www.thesaurus.com/'),
 (789,768,701,'post','Reverse Dictionary','link','post_content','','https://reversedictionary.org/'),
 (790,769,701,'post','Wikipedia','link','post_content','','https://www.wikipedia.org/'),
 (791,54,701,'post','Inked Voices','link','post_content','','https://www.inkedvoices.com/'),
 (792,247,701,'post','Green\'s Dictionary of Slang','link','post_content','','https://greensdictofslang.com/'),
 (793,770,701,'post','Related Words','link','post_content','','https://relatedwords.org'),
 (794,343,701,'post','Aeon Timelin','link','post_content','','https://www.aeontimeline.com/'),
 (795,345,701,'post','Scapple','link','post_content','','https://www.literatureandlatte.com/scapple/overview'),
 (796,771,701,'post','Affinity graphics suite','link','post_content','','https://affinity.serif.com/en-us/'),
 (797,772,701,'post','Spit! podcast','link','post_content','','https://www.iheart.com/podcast/1119-spit-29676456/episode/what-does-it-take-to-beat-30405103/'),
 (798,148,701,'post','which is a skill','link','post_content','','https://www.psychologytoday.com/us/blog/the-intelligent-divorce/201411/boosting-creativity-10-easy-steps'),
 (799,773,701,'post','','image','post_content','','https://dmweade.com/welcome/wp-content/uploads/2020/01/writing_desktop-rotated-e1580225555624-1024x658.jpg'),
 (800,774,701,'post','','image','post_content','','https://dmweade.com/welcome/wp-content/uploads/2020/01/stack_interface-1024x771.png'),
 (3750,17,35,'page','Material Design','link','post_content','','https://material.io/tools/icons/?style=baseline'),
 (3749,16,35,'page','Icons for Everything','link','post_content','','https://thenounproject.com/'),
 (3748,15,35,'page','Iconfinder','link','post_content','','https://www.iconfinder.com/'),
 (3747,14,35,'page','Flat Icons','link','post_content','','https://www.flaticon.com/'),
 (3746,13,35,'page','Unsplash','link','post_content','','https://unsplash.com/'),
 (3745,12,35,'page','Stocksnap','link','post_content','','https://stocksnap.io/'),
 (3744,11,35,'page','Negative Space','link','post_content','','https://negativespace.co/'),
 (3743,10,35,'page','Picography','link','post_content','','https://picography.co/'),
 (3742,9,35,'page','ISO Republic','link','post_content','','https://isorepublic.com/'),
 (3741,8,35,'page','Shot Stash','link','post_content','','https://shotstash.com/'),
 (3739,6,35,'page','Freeimages','link','post_content','','https://www.freeimages.com/'),
 (3740,7,35,'page','Pexels','link','post_content','','https://www.pexels.com/'),
 (3438,112,39,'page','Moebius Gives 18 Wisdom-Filled Tips to Aspiring Artists','link','post_content','','http://www.openculture.com/2018/10/moebius-gives-18-wisdom-filled-tips-aspiring-artists.html'),
 (3435,109,39,'page','How to Use the Writing Skills You Have to Learn the Ones You Don’t','link','post_content','','https://www.tor.com/2019/03/25/one-free-trick-how-to-use-the-writing-skills-you-have-to-learn-the-ones-you-dont/?utm_source=exacttarget&utm_medium=newsletter&utm_term=tordotcom-tordotcomnewsletter&utm_content=na-readblog-blogpost&utm_campaign=tor&e=a3087719b835fd5916a5573381c09d776d7afc81b1e52fca47987d075cb3131c'),
 (3432,106,39,'page','Getting in the Writing Zone','link','post_content','','https://niemanstoryboard.org/stories/flow/'),
 (3428,102,39,'page','Keeping a Visual Diary','link','post_content','','https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/'),
 (3429,103,39,'page','2017 Ultimate Writing Guide','link','post_content','','https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&aid=randohouseinc34192-20&linkid=PRHC9E2F30E44'),
 (3426,100,39,'page','Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett','link','post_content','','https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/'),
 (3427,101,39,'page','Susan Sontag on the Four People a Great Writer Must Be','link','post_content','','https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/'),
 (3424,98,39,'page','Gotham Writer’s Workshop: George Orwell’s 6 Rules','link','post_content','','http://www.writingclasses.com/InformationPages/index.php/PageID/300'),
 (3425,99,39,'page','Vonnegut\'s 8 Tips for a Great Story','link','post_content','','http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/'),
 (3420,94,39,'page','This Morning Routine will Save us 20 Hours Every Week','link','post_content','','https://www.elephantjournal.com/2019/08/this-morning-routine-will-save-us-20-hours-per-week-benjamin-hardy/'),
 (3421,95,39,'page','The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine','link','post_content','','https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/'),
 (3422,96,39,'page','What\'s Your Novel\'s Log Line?','link','post_content','','https://www.dailywritingtips.com/whats-your-novels-log-line'),
 (3423,97,39,'page','Short Story Tips: 10 Hacks to Improve Your Creative Writing','link','post_content','','https://jerz.setonhill.edu/writing/creative1/shortstory/'),
 (3419,93,39,'page','Crowdtangle','link','post_content','','https://www.crowdtangle.com/'),
 (3417,91,39,'page','The System I Used to Write 5 Books and Over 1000 Blog Posts','link','post_content','','https://medium.com/better-marketing/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461'),
 (3415,89,39,'page','The Paid Publishing Guidebook for 2020','link','post_content','','https://lp.freedomwithwriting.com/free-book-the-paid-publishing-guidebook-for-2020-1531-publishers-that-pay-writers/'),
 (3418,92,39,'page','The Difference Between Blurbs, Queries, and Synopses','link','post_content','','https://morganhazelwood.com/2020/01/23/the-difference-between-blurbs-queries-and-synopses/'),
 (3412,83,39,'page','A Professional Editor Reveals the Dos and Don\'ts of Writing Your Query Letter','link','post_content','','https://prowritingaid.com/art/857/a-professional-editor-reveals-the-dos-and-don-ts-of-writing-your-query.aspx'),
 (3416,90,39,'page','Publishing a Book: A Guide to Becoming an Author','link','post_content','','https://bulkbooks.com/how-to-publish-a-book'),
 (3414,88,39,'page','A Writer\'s Guide to Fair Use and Permission + A Sample Permissions Letter','link','post_content','','https://www.janefriedman.com/sample-permission-letter/'),
 (3413,87,39,'page','How To Write a Query Letter That Grabs an Agent’s Attention','link','post_content','','https://jerryjenkins.com/query-letter/'),
 (3411,86,39,'page','How to Crowd-fund a Novel','link','post_content','','https://prowritingaid.com/art/926/how-to-crowdfund-a-novel.aspx?utm_source=twitter&utm_medium=crowdfundanovel'),
 (3410,85,39,'page','Pt 2 - Line-Editing and Copy-Editing','link','post_content','','https://prowritingaid.com/art/923/agent-advice-part-2:-line-editing-and-copy-editing.aspx?utm_source=twitter&utm_medium=linecopyediting'),
 (3407,82,39,'page','Types of Writing Contracts and How to Approach Them','link','post_content','','https://prowritingaid.com/art/903/types-of-writing-contracts-and-how-to-approach-them.aspx'),
 (3408,83,39,'page','A Professional Editor Reveals the Dos and Don\'ts of Writing Your Query Letter','link','post_content','','https://prowritingaid.com/art/857/a-professional-editor-reveals-the-dos-and-don-ts-of-writing-your-query.aspx'),
 (3409,84,39,'page','Pt 1 - Developmental Editing','link','post_content','','https://prowritingaid.com/art/922/agent-advice-part-1%3A-developmental-editing.aspx'),
 (3406,81,39,'page','Create a Buyer Persona','link','post_content','','https://www.hubspot.com/make-my-persona'),
 (3403,78,39,'page','How to Fight Write','link','post_content','','https://howtofightwrite.tumblr.com/'),
 (3404,79,39,'page','What Authors and Editors Wish They Could Say to One Another','link','post_content','','https://www.publishersweekly.com/pw/print/20180723/77564-what-authors-and-editors-wish-they-could-say-to-one-another.html'),
 (3405,80,39,'page','What Publishers Want','link','post_content','','https://greenleafbookgroup.com/learning-center/publishing-information/what-publishers-want'),
 (3401,76,39,'page','Fantasy and Science Fiction Writers','link','post_content','','http://www.kittywumpus.net/blog/links-and-resources-for-fantasy-and-science-fiction-writers/'),
 (3400,76,39,'page','Links and Resources for Fantasy and SF writers','link','post_content','','http://www.kittywumpus.net/blog/links-and-resources-for-fantasy-and-science-fiction-writers/'),
 (3402,77,39,'page','Clarify Editing\'s Resources for Writers','link','post_content','','http://www.clarify-editing.com/writer-resources.html'),
 (3399,75,39,'page','Writers Helping Writer\'s Help Guide','link','post_content','','https://www.dropbox.com/s/symkwa6mz4rdt8j/Writers%20Helping%20Writers%20Help%20Guide.pdf?dl=0'),
 (3398,74,39,'page','One Stop for Writers','link','post_content','','https://onestopforwriters.com/'),
 (3396,72,39,'page','Purdue\'s Online Writing Lab\'s resources','link','post_content','','https://owl.english.purdue.edu/owl/section/1/'),
 (3397,73,39,'page','Daily Writing Tips','link','post_content','','http://www.dailywritingtips.com/'),
 (3395,71,39,'page','Critters Workshop','link','post_content','','http://critters.org/'),
 (3394,70,39,'page','Writing Excuses podcast','link','post_content','','http://www.writingexcuses.com/'),
 (3393,69,39,'page','Internet Writing Workshop','link','post_content','','http://internetwritingworkshop.org/'),
 (3392,68,39,'page','WOW! &nbsp;Women on Writing','link','post_content','','http://wow-womenonwriting.com/'),
 (3391,67,39,'page','Writing.com','link','post_content','','http://www.writing.com/'),
 (3390,66,39,'page','Science Fiction and Fantasy Writers of America','link','post_content','','http://sfwa.org/'),
 (3378,54,39,'page','Inked Voices','link','post_content','','https://www.inkedvoices.com/'),
 (3379,55,39,'page','Past Lectures','link','post_content','','https://www.inkedvoices.com/lecture-series/'),
 (3380,56,39,'page','Critters','link','post_content','','http://www.critters.org/'),
 (3381,57,39,'page','5 Ways to Find the Right Freelance Book Editor','link','post_content','','https://www.janefriedman.com/find-freelance-book-editor/'),
 (3382,58,39,'page','Duotrope','link','post_content','','https://duotrope.com/'),
 (3383,59,39,'page','Critters Blackhole benchmarks','link','post_content','','http://critters.org/blackholes/index.ht'),
 (3384,60,39,'page','Ralan.com','link','post_content','','http://www.ralan.com/'),
 (3385,61,39,'page','The Grinder','link','post_content','','https://thegrinder.diabolicalplots.com/'),
 (3386,62,39,'page','Agent Query - Search agents to find their current interests','link','post_content','','http://www.agentquery.com/'),
 (3387,63,39,'page','Writer Beware','link','post_content','','https://www.sfwa.org/other-resources/for-authors/writer-beware/'),
 (3388,64,39,'page','National Novel Writing Month (NaNoWriMo)','link','post_content','','http://www.nanowrimo.org/'),
 (3389,65,39,'page','Challenge yourself to write a story in six sentences','link','post_content','','http://sixsentences.blogspot.com/');

SET FOREIGN_KEY_CHECKS = 1 ; 
COMMIT ; 
SET AUTOCOMMIT = 1 ; 
