-- ------------------------------------------------------
-- ------------------------------------------------------
--
-- WPBackItUp Database Export 
--
-- Created: 2020/04/25 on 01:02
--
-- Database : weadag5_wp496
--
-- Backup   Table  : wpus_posts
-- Snapshot Table  : 1587776537_posts
--
-- SQL    : SELECT * FROM wpus_posts LIMIT 0,10000
-- Offset : 0
-- Rows   : 464
-- ------------------------------------------------------
-- ------------------------------------------------------
SET AUTOCOMMIT = 0 ;
SET FOREIGN_KEY_CHECKS=0 ;

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40101 SET SESSION sql_mode = '' */;

--
-- Table structure for table `1587776537_posts`
--
DROP TABLE  IF EXISTS `1587776537_posts`;
CREATE TABLE `1587776537_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '1970-01-02 00:00:01',
  `post_date_gmt` datetime NOT NULL DEFAULT '1970-01-02 00:00:01',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '1970-01-02 00:00:01',
  `post_modified_gmt` datetime NOT NULL DEFAULT '1970-01-02 00:00:01',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=872 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



--
-- Data for table `wpus_posts`
-- Number of rows: 464
--
INSERT INTO `1587776537_posts` VALUES 
(218,1,'2018-08-28 18:17:36','2018-08-28 18:17:36','<p style=\"text-align: center;\"><strong>A repository of articles and resources I\'ve collected over the years\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writers</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Self Promotion / Building a Platform</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging</a></li>\r\n 	<li style=\"text-align: left;\">Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://writingcooperative.com/how-to-build-your-own-author-platform-from-scratch-9d6123858bac\" target=\"_blank\" rel=\"noopener\">How to Build your own author platform - from scratch</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://growthtools.com/#tools\" target=\"_blank\" rel=\"noopener\">Growth Tools</a> - Grow your online business</li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://thewritepractice.com/building-an-author-website/\" target=\"_blank\" rel=\"noopener\">Building an Author Website: The First Step to Publishing</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n 	<li><a href=\"http://www.ian-irvine.com/on-writing/41-ways-to-create-and-heighten-suspense/\" target=\"_blank\" rel=\"noopener\">41 Ways to Create and Heighten Suspense</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/eight-absurdities-we-force-on-female-characters/\" target=\"_blank\" rel=\"noopener\">8 Absurdities we Force on Female Characters</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n 	<li><a href=\"https://io9.gizmodo.com/7-deadly-sins-of-worldbuilding-998817537\" target=\"_blank\" rel=\"noopener\">7 Deadly Sins of Worldbuilding</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/five-common-worldbuilding-mistakes-in-new-manuscripts/\" target=\"_blank\" rel=\"noopener\">5 Common Worldbuilding Mistakes in New Manuscripts</a> (and a great blog)</li>\r\n 	<li><a href=\"https://mythcreants.com/blog/creating-a-mountain-setting/\" target=\"_blank\" rel=\"noopener\">Creating a Mountain Setting</a></li>\r\n 	<li><a href=\"https://nybookeditors.com/2017/07/fantasy-world-building-101-create-breathing-world-fantasy-novel/\" target=\"_blank\" rel=\"noopener\">Fantasy World Building 101: how to create a breathing world for your fantasy novel</a></li>\r\n 	<li>Worldbuilding Guide: <em>Excellent process</em>\r\n<ul>\r\n 	<li><a href=\"https://www.lostkingdom.net/worldbuilding-guide-1/\" target=\"_blank\" rel=\"noopener\">Part 1</a>, <a href=\"http://www.lostkingdom.net/worldbuilding-guide-2/\" target=\"_blank\" rel=\"noopener\">Part 2</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-introduction/\" target=\"_blank\" rel=\"noopener\">Fantasy Economics 101</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-labour-and-wages/\" target=\"_blank\" rel=\"noopener\">Economics: labour and wages</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://electricliterature.com/against-worldbuilding-700e4861c26b\" target=\"_blank\" rel=\"noopener\">Against Worldbuilding</a> (caused quite a ruckus)</li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2013/09/17/25-things-you-should-know-about-worldbuilding/\" target=\"_blank\" rel=\"noopener\">25 Things You Should Know About Worldbuilding</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.powerthesaurus.org/\" target=\"_blank\" rel=\"noopener\">Power Thesaurus</a></li>\r\n 	<li><a href=\"https://english.stackexchange.com/\" target=\"_blank\" rel=\"noopener\">English Language and Usage Q&amp;A</a></li>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n 	<li><a href=\"http://moby.com/la1/\" target=\"_blank\" rel=\"noopener\">Long Ambients1: Calm. Sleep.</a> by Moby (free music)</li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow. Here are some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 17.7674%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 2.13958%;\"></td>\r\n<td style=\"width: 80.093%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 39.7829%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 2.29462%;\"></td>\r\n<td style=\"width: 57.9225%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n<ul>\r\n 	<li>$6 ebook: <a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other: A Practical Approach</a></li>\r\n</ul>\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://bookriot.com/2018/02/05/casually-racist-things-that-white-authors-do/\" target=\"_blank\" rel=\"noopener\">7 Casually Racist Things That White Authors Do</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\nFinding faces for characters\r\n<ul>\r\n 	<li><a href=\"https://www.modelmanagement.com/\" target=\"_blank\" rel=\"noopener\">Model Management</a>: Too many authors use famous actors to give flesh to their characters. Search by nation for different looks and and facial types.</li>\r\n</ul>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>History and Interesting Fact(oid)s</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Terminology</strong>\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n<strong>Language</strong>\r\n<ul>\r\n 	<li><a href=\"https://scotlandwelcomesyou.com/scottish-sayings/\" target=\"_blank\" rel=\"noopener\">Old Scottish Sayings</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-28 18:17:36','2018-08-28 18:17:36','',39,'https://dmweade.com/welcome/2018/08/28/39-revision-v1/',0,'revision','',0),
 (3,2,'2018-07-21 17:46:18','2018-07-21 17:46:18','<h2>Who we are</h2>\nOur website address is: http://dmweade.com/welcome/\n<h2>What personal data we collect and why we collect it</h2>\n<h3>Comments</h3>\nWhen visitors leave comments on the site we collect the data shown in the comments form, and also the visitor’s IP address and browser user agent string to help spam detection.\n\nAn anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.\n<h3>Media</h3>\nIf you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.\n<h3>Contact forms</h3>\n<h3>Cookies</h3>\nIf you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.\n\nIf you have an account and you log in to this site, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.\n\nWhen you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select \"Remember Me\", your login will persist for two weeks. If you log out of your account, the login cookies will be removed.\n\nIf you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.\n<h3>Embedded content from other websites</h3>\nArticles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.\n\nThese websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracing your interaction with the embedded content if you have an account and are logged in to that website.\n<h3>Analytics</h3>\n<h2>Who we share your data with</h2>\n<h2></h2>\n<h2>How long we retain your data</h2>\nIf you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.\n\nFor users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.\n<h2>What rights you have over your data</h2>\nGiven the recent EU requirements, plus best practices, I\'m currently looking into the following paragraph\'s intent and will update the terms as things change. Simply put, I don\'t know exactly how to do the following at this time and need to learn before offering this promise. Until that time, expect you cannot delete or download your content.\n\nWorking on this part: \"If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.\"\n<h2>Where we send your data</h2>\nVisitor comments may be checked through an automated spam detection service.\n\nIt is my intent to use an Amazon Affiliates account to monetize some of the resource building on the site. If you do not wish for your visits to be tracked, you should look into the <a href=\"https://www.eff.org/\">Electric Frontier Foundation</a>\'s <a href=\"https://www.eff.org/privacybadger\">Privacy Badger</a> browser plugin. I use this in combination with <a href=\"https://www.ublock.org/\">uBlock</a> and believe this is the best way to protect your personal data while surfing the internet.\n<h2>Your contact information</h2>\ndweade(at)gmail(dot)com\n<h2>Additional information</h2>\nNone at this time.\n<h3>How we protect your data</h3>\nData tracking is part of the internet today, for both good and bad purposes. Running a website often requires knowing what viewers are doing in order to better prepare content and even architect the site. And monetizing some of the work through Amazon Affiliates does share some data. So be aware policies are likely to change.\n\nAt the start, there are no plans to share data or allow third parties&nbsp;to access data outside of visitor analytics offered through Wordpress. If I introduce new services which allow any form of visitor data to be used, I will update this page. Any inclusions will happen after careful research.\n<h3>What data breach procedures we have in place</h3>\nThis is a hobby site and any procedures will be in partnership with my hosting company and authorities if the situation warrants their involvement.\n<h3>What third parties we receive data from</h3>\nNone I know of at this time.\n<h3>What automated decision making and/or profiling we do with user data</h3>\nWordpress offers some visitor insights and we may use visitor data to identify best methods for advertising and sales ventures.\n<h3>Industry regulatory disclosure requirements</h3>\nNone that I know of.','Privacy Policy','','publish','closed','closed','','privacy-policy','','','2020-01-21 17:52:53','2020-01-21 17:52:53','',0,'https://dmweade.com/welcome/?page_id=3',0,'page','',0),
 (5,1,'2018-07-21 17:47:39','1970-01-02 00:00:01','','widget_image','','draft','closed','closed','','','','','2018-07-21 17:47:39','1970-01-02 00:00:01','a:0:{}',0,'https://dmweade.com/welcome/?post_type=jetpack_migration&p=5',0,'jetpack_migration','',0),
 (6,1,'2018-07-21 17:47:39','1970-01-02 00:00:01','','sidebars_widgets','','draft','closed','closed','','','','','2018-07-21 17:47:39','1970-01-02 00:00:01','a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}',0,'https://dmweade.com/welcome/?post_type=jetpack_migration&p=6',0,'jetpack_migration','',0),
 (456,1,'2019-06-22 00:30:18','2019-06-22 00:30:18','<h2>Who we are</h2>\nOur website address is: http://dmweade.com/welcome/\n<h2>What personal data we collect and why we collect it</h2>\n<h3>Comments</h3>\nWhen visitors leave comments on the site we collect the data shown in the comments form, and also the visitor’s IP address and browser user agent string to help spam detection.\n\nAn anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.\n<h3>Media</h3>\nIf you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.\n<h3>Contact forms</h3>\n<h3>Cookies</h3>\nIf you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.\n\nIf you have an account and you log in to this site, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.\n\nWhen you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select \"Remember Me\", your login will persist for two weeks. If you log out of your account, the login cookies will be removed.\n\nIf you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.\n<h3>Embedded content from other websites</h3>\nArticles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.\n\nThese websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracing your interaction with the embedded content if you have an account and are logged in to that website.\n<h3>Analytics</h3>\n<h2>Who we share your data with</h2>\n<h2></h2>\n<h2>How long we retain your data</h2>\nIf you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.\n\nFor users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.\n<h2>What rights you have over your data</h2>\nGiven the recent EU requirements, plus best practices, I\'m currently looking into the following paragraph\'s intent and will update the terms as things change. Simply put, I don\'t know exactly how to do the following at this time and need to learn before offering this promise. Until that time, expect you cannot delete or download your content.\n\nWorking on this part: \"If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.\"\n<h2>Where we send your data</h2>\nVisitor comments may be checked through an automated spam detection service.\n\nIt is my intent to use an Amazon Affiliates account to monetize some of the resource building on the site. If you do not wish for your visits to be tracked, you should look into the <a href=\"https://www.eff.org/\">Electric Frontier Foundation</a>\'s <a href=\"https://www.eff.org/privacybadger\">Privacy Badger</a> browser plugin. I use this in combination with <a href=\"https://www.ublock.org/\">uBlock</a> and believe this is the best way to protect your personal data while surfing the internet.\n<h2>Your contact information</h2>\ndweade(at)gmail(dot)com\n<h2>Additional information</h2>\nNone at this time.\n<h3>How we protect your data</h3>\nData tracking is part of the internet today, for both good and bad purposes. Running a website often requires knowing what viewers are doing in order to better prepare content and even architect the site. And monetizing some of the work through Amazon Affiliates does share some data. So be aware policies are likely to change.\n\nAt the start, there are no plans to share data or allow third parties to access data outside of visitor analytics offered through Wordpress. If I introduce new services which allow any form of visitor data to be used, I will update this page. Any inclusions will happen after careful research.\n<h3>What data breach procedures we have in place</h3>\nThis is a hobby site and any procedures will be in partnership with my hosting company and authorities if the situation warrants their involvement.\n<h3>What third parties we receive data from</h3>\nNone I know of at this time.\n<h3>What automated decision making and/or profiling we do with user data</h3>\nWordpress offers some visitor insights and we may use visitor data to identify best methods for advertising and sales ventures.\n<h3>Industry regulatory disclosure requirements</h3>\nNone that I know of.','Privacy Policy','','inherit','closed','closed','','3-revision-v1','','','2019-06-22 00:30:18','2019-06-22 00:30:18','',3,'https://dmweade.com/welcome/2019/06/22/3-revision-v1/',0,'revision','',0),
 (8,1,'2018-07-21 18:51:09','2018-07-21 18:51:09','<h2>Who we are</h2>\r\n<p>Our website address is: http://dmweade.com/newwelcome1.</p>\r\n<h2>What personal data we collect and why we collect it</h2>\r\n<h3>Comments</h3>\r\n<p>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor’s IP address and browser user agent string to help spam detection.</p>\r\n<p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p>\r\n<h3>Media</h3>\r\n<p>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p>\r\n<h3>Contact forms</h3>\r\n<h3>Cookies</h3>\r\n<p>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p>\r\n<p>If you have an account and you log in to this site, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p>\r\n<p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select \"Remember Me\", your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p>\r\n<p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p>\r\n<h3>Embedded content from other websites</h3>\r\n<p>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p>\r\n<p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracing your interaction with the embedded content if you have an account and are logged in to that website.</p>\r\n<h3>Analytics</h3>\r\n<h2>Who we share your data with</h2>\r\n<h2>&nbsp;</h2>\r\n<h2>How long we retain your data</h2>\r\n<p>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p>\r\n<p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p>\r\n<h2>What rights you have over your data</h2>\r\n<p>Given the recent EU requirements, plus best practices, I\'m currently looking into the following paragraph\'s intent and will update the terms as things change. Simply put, I don\'t know exactly how to do the following at this time and need to learn before offering this promise. Until that time, expect you cannot delete or download your content.</p>\r\n<p>Working on this part: \"If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.\"</p>\r\n<h2>Where we send your data</h2>\r\n<p>Visitor comments may be checked through an automated spam detection service.</p>\r\n<p>It is my intent to use an Amazon Affiliates account to monetize some of the resource building on the site. If you do not wish for your visits to be tracked, you should look into the <a href=\"https://www.eff.org/\">Electric Frontier Foundation</a>\'s <a href=\"https://www.eff.org/privacybadger\">Privacy Badger</a> browser plugin. I use this in combination with <a href=\"https://www.ublock.org/\">uBlock</a> and believe this is the best way to protect your personal data while surfing the internet.</p>\r\n<h2>Your contact information</h2>\r\n<p>dweade(at)gmail(dot)com</p>\r\n<h2>Additional information</h2>\r\n<p>None at this time.</p>\r\n<h3>How we protect your data</h3>\r\n<p>Data tracking is part of the internet today, for both good and bad purposes. Running a website often requires knowing what viewers are doing in order to better prepare content and even architect the site. And monetizing some of the work through Amazon Affiliates does share some data. So be aware policies are likely to change.</p>\r\n<p>At the start, there are no plans to share data or allow third parties&nbsp;to access data outside of visitor analytics offered through Wordpress. If I introduce new services which allow any form of visitor data to be used, I will update this page. Any inclusions will happen after careful research.</p>\r\n<h3>What data breach procedures we have in place</h3>\r\n<p>This is a hobby site and any procedures will be in partnership with my hosting company and authorities if the situation warrants their involvement.</p>\r\n<h3>What third parties we receive data from</h3>\r\n<p>None I know of at this time.</p>\r\n<h3>What automated decision making and/or profiling we do with user data</h3>\r\n<p>Wordpress offers some visitor insights and we may use visitor data to identify best methods for advertising and sales ventures.</p>\r\n<h3>Industry regulatory disclosure requirements</h3>\r\n<p>None that I know of.</p>','Privacy Policy','','inherit','closed','closed','','3-revision-v1','','','2018-07-21 18:51:09','2018-07-21 18:51:09','',3,'https://dmweade.com/welcome/2018/07/21/3-revision-v1/',0,'revision','',0),
 (9,2,'2018-07-21 18:57:29','2018-07-21 18:57:29','It\'s important to support creatives who provide media for the rest of us to use, sometimes free of charge. This page is a meta-list of content used on the website that might not otherwise be identified.','Media on this site','','publish','closed','closed','','media-on-this-site','','','2020-01-12 19:03:23','2020-01-12 19:03:23','',0,'https://dmweade.com/welcome/?page_id=9',0,'page','',0),
 (10,1,'2018-07-21 18:57:29','2018-07-21 18:57:29','It\'s important to support creatives who provide media for the rest of us to use, sometimes free of charge. This page is a meta-list of content used on the website that might not otherwise be identified.','Media on this site','','inherit','closed','closed','','9-revision-v1','','','2018-07-21 18:57:29','2018-07-21 18:57:29','',9,'https://dmweade.com/welcome/2018/07/21/9-revision-v1/',0,'revision','',0),
 (18,1,'2018-07-21 20:33:05','2018-07-21 20:33:05','','Home','','publish','closed','closed','','home','','','2018-07-21 20:33:05','2018-07-21 20:33:05','',0,'https://dmweade.com/welcome/2018/07/21/home/',1,'nav_menu_item','',0),
 (22,1,'2018-07-21 20:54:21','2018-07-21 20:54:21','','DMWeade Fox-face','','inherit','open','closed','','fox-face','','','2018-07-21 20:55:10','2018-07-21 20:55:10','',0,'https://dmweade.com/welcome/wp-content/uploads/2018/07/Fox-face.png',0,'attachment','image/png',0),
 (23,1,'2018-07-21 20:55:13','2018-07-21 20:55:13','https://dmweade.com/welcome/wp-content/uploads/2018/07/cropped-Fox-face.png','cropped-Fox-face.png','','inherit','open','closed','','cropped-fox-face-png','','','2018-07-21 20:55:13','2018-07-21 20:55:13','',0,'https://dmweade.com/welcome/wp-content/uploads/2018/07/cropped-Fox-face.png',0,'attachment','image/png',0),
 (24,1,'2018-07-21 20:55:32','2018-07-21 20:55:32','https://dmweade.com/welcome/wp-content/uploads/2018/07/cropped-Fox-face-1.png','cropped-Fox-face-1.png','','inherit','open','closed','','cropped-fox-face-1-png','','','2018-07-21 20:55:32','2018-07-21 20:55:32','',0,'https://dmweade.com/welcome/wp-content/uploads/2018/07/cropped-Fox-face-1.png',0,'attachment','image/png',0),
 (28,1,'2018-07-21 20:59:40','2018-07-21 20:59:40','https://www.flickr.com/photos/sonear/5314782360','5314782360_f32ff3aab7_b','','inherit','open','closed','','5314782360_f32ff3aab7_b','','','2018-07-21 21:00:15','2018-07-21 21:00:15','',0,'https://dmweade.com/welcome/wp-content/uploads/2018/07/5314782360_f32ff3aab7_b.jpg',0,'attachment','image/jpeg',0),
 (31,1,'2018-07-21 21:03:29','2018-07-21 21:03:29','','StockSnap_6WES2NC62N','','inherit','open','closed','','stocksnap_6wes2nc62n','','','2018-07-21 21:04:15','2018-07-21 21:04:15','',0,'https://dmweade.com/welcome/wp-content/uploads/2018/07/StockSnap_6WES2NC62N.jpg',0,'attachment','image/jpeg',0),
 (32,1,'2018-07-21 21:04:26','2018-07-21 21:04:26','https://pixabay.com/en/sapling-pine-young-green-plant-1830527/','sapling-1830527_640','','inherit','open','closed','','sapling-1830527_640','','','2018-07-21 21:04:42','2018-07-21 21:04:42','',0,'https://dmweade.com/welcome/wp-content/uploads/2018/07/sapling-1830527_640.jpg',0,'attachment','image/jpeg',0),
 (574,1,'2020-01-11 23:30:05','2020-01-11 23:30:05','<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><strong>My Favorite Authors and Why I Love Their Work</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Glen Cook</strong>’s publisher has started labeling him the grandfather of Grimdark with his last book launch, but he’s much more accomplished than <em><a href=\"https://www.torforgeblog.com/2018/07/31/series-order-chronicles-of-the-black-company/\">The Black Company</a></em>. I believe his standalone novel <em><a href=\"https://us.macmillan.com/books/9781466831155\">The Tower of Fear</a></em> is an amazingly well-told tale, and <em><a href=\"https://www.goodreads.com/series/42332-dread-empire\">The Dread Empire</a></em> series sets a relentless pace I have yet to experience by another author. I\'m also a fan of his <em><a href=\"https://www.penguinrandomhouse.com/series/AX3/garrett-pi\">Garrett P.I.</a> </em>series, which I\'ve read several times enjoying his noir humor.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>J. R. R. Tolkien</strong>’s <em>The Hobbit</em> remains my favorite novel and was my original favorite back in third grade. A friend recommended The <em>Fellowship of the Ring</em>, but all they had was <em>The Two Towers</em> which I somehow managed to enjoy even out of order. I did eventually get to read the three novels, all before getting my hands on <em>The Hobbit</em>. Since that first read, I\'ve read <em>The Hobbit</em> more times than any other book, the last two rounds to my daughter. She now owns her own copy.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It’s difficult to believe he published the novel 80 years ago. Both the story and his writing remain engaging, and my gold standard for including wonder in my own work. If I can ever bring such joy to anyone who read my stories, I\'ll consider myself accomplished.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Steven Brust</strong> is a wizard of a storyteller. <a href=\"https://www.torforgeblog.com/2017/10/17/where-to-start-with-vlad-taltos/\">Vlad Taltos</a> is one of my favorite characters and the <em><a href=\"https://en.wikipedia.org/wiki/Khaavren_Romances\">Khaavren Romances</a></em> are beyond my ability to describe adequately. Just go read them. Now. And then check out \"<a href=\"https://www.goodreads.com/quotes/889625-the-cool-stuff-theory-of-literature-is-as-follows-all\">The Cool Stuff Theory of Literature</a>.\"</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Martha Wells</strong>’s <em><a href=\"https://www.marthawells.com/death.htm\">Death of the Necromancer</a></em> is an amazing historical fantasy, and horror to boot. She has two novels and a trilogy set in the world of Ile-Rien, including <em><a href=\"https://www.marthawells.com/element.htm\">Element of Fire</a></em> and the <em><a href=\"https://www.marthawells.com/ilerien.htm\">Fall of Ile-Rien</a></em> trilogy. It’s also worth tracking down \"<a href=\"https://www.marthawells.com/betweenworlds.htm\">The Potter’s Daughter</a>,\" a short-story featuring the excellent character Kade Carrion. These works parallel four centuries from the 17<sup>th</sup> to 20<sup>th</sup>. I maintain hope Martha will circle back to Kade in a future work.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Anne McCaffrey</strong> changed my view of fantasy. Instead of swords and magic and inhumane villains, her stories focused on personal struggles within an alien, if human, society. Her <a href=\"https://en.wikipedia.org/wiki/The_Harper_Hall_Trilogy\">Harper Hall trilogy</a> was the first series I read to my daughter and she loved them (once the fire lizards made their appearance). Every child should experience these stories in which a mistreated girl masters skills long denied women in her society.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Andrzej Sapkowski</strong> is the marvel who gave us Geralt, <a href=\"https://en.wikipedia.org/wiki/The_Witcher\">the Witcher</a>. Sapkowski\'s use of traditional fairy tales as a backdrop for his kick-ass character makes for a fun read. Everyone should read the translations of his short stories for lessons on \"making big things small and small things big.\" </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>David Gemmell</strong> wrote more than thirty fantasy novels. His <a href=\"https://en.wikipedia.org/wiki/David_Gemmell#Drenai_Series\">Drenai series</a> are listed among the classics and were a great read as a teen, but felt flat and uninspired when I reread them as an adult. What I respect most about his bibliography is the <a href=\"https://en.wikipedia.org/wiki/David_Gemmell#Rigante_series\">Rigante series</a>, published toward the end of his life. The contrast between his earliest works and these later works should be an inspiration to all writers.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Will McIntosh</strong> is the only author on this list I’ve met. I interviewed him for a project after reading <em><a href=\"https://www.tor.com/2011/04/13/the-gradual-collapse-of-a-society-a-review-of-soft-apocalypse-by-will-mcintosh/\">Soft Apocalypse</a></em> and his Hugo Award-winning short story \"<a href=\"https://scificats.files.wordpress.com/2011/04/bridesicle.pdf\">Bridesicle</a>,\"* which he developed into <em><a href=\"https://smile.amazon.com/Love-Minus-Eighty-Will-McIntosh/dp/B01L9CV2AE?smdm-noredirect=true\">Love Minus Eighty</a></em> (overdue for a movie deal, IMHO).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Will is a smooth writer with a solid lock on humanity. When I asked him how he envisions his characters in future settings, he explained his background as a sociologist provides a solid understanding of how humans are wired to respond to stimuli. As a result, his characters respond realistically rather than falling into science fiction tropes. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>*When I interviewed Will, I mentioned his short story was on a site that might not be legit. At the time, he said to link to it because the story was no longer on the site of the magazine who purchased it. I\'m including a link here until another is available. Also, the story is available as an <a href=\"http://escapepod.org/2010/07/01/ep247-bridesicle/\">audio recording</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>William Gibson</strong> created the Cyberpunk genre with his early visions of our future (and he got a lot right). His ideas stoked my interest in science fiction with his rich focus on our looming cultural shifts. His most recent novel, <em><a href=\"https://williamgibsonbooks.com/books/the-peripheral/\">The Peripheral,</a></em> proves his value as a modern oracle. Gibson processes our current trends so clearly and his ability to parse modern events into forecasts is nothing short of genius. If you aren’t familiar with his work, <em>The Peripheral</em> gives us a view at life after the Jackpot (which has become part of the zeitgeist as climate change gains steam). It’s a brilliant and timely insight. Expect sleepless nights while reading.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Katherine Kurtz</strong> Her <a href=\"https://en.wikipedia.org/wiki/Deryni_novels\">Deryni series</a> was my first experience with historical fantasy. Up to that point, my interest in history was mostly about architecture and fighting. Kurtz really delved into the interplay of royalty and the church. By making the protagonists heretics in the eyes of the church, yet devout in their faith, she created a gripping story. While I did not keep up with the novels past the first pause, the original novels are slim and fast-moving. Well worth reading for the nuance she brings to those early ideas.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Roger Zelazny</strong>’s <em><a href=\"https://en.wikipedia.org/wiki/The_Chronicles_of_Amber\">Chronicles of Amber</a></em> are genre-breaking classics. I don’t know of any other series like what he created. Read the Corwin books for the ongoing first-person structure and stream-of-consciousness planning. Rereading Corwin’s walking through shadow, experiencing his use of color and texture, really helped with my current project. Sometimes we get lucky and chance upon exactly what we need right when we need it.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><strong>Sites With Free Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><a href=\"https://www.wattpad.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Wattpad</a>&nbsp;- <a href=\"https://uncannymagazine.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Uncanny Magazine</a> - <a href=\"https://curiousfictions.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Curious Fictions</a> - <a href=\"https://www.shimmerzine.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Shimmer</a> - <a href=\"http://enkare.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Enkare Review</a> - <a href=\"http://www.abyssapexzine.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Abyss &amp; Apex</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><a href=\"https://texttechnologies.stanford.edu/publications/beowulf-all\" target=\"_blank\" rel=\"noreferrer noopener\">Beowulf by All</a> -&nbsp;<a href=\"https://csi.asu.edu/books/vvev/\" target=\"_blank\" rel=\"noreferrer noopener\">Visions, Ventures, Escape Velocities: A Collection of Space Futures</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><strong>Find Something to Read</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://shortbooks.co/\" target=\"_blank\" rel=\"noreferrer noopener\">Shortbooks</a> - find shorter books by any subject</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><strong>Non-Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://jetpress.org/contents.htm\" target=\"_blank\" rel=\"noreferrer noopener\">Journal of Evolution and Technology</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><strong>Fictions Collections and Lists</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/more-perfect-novels-for-every-dungeons-dragons-character-class-bards-barbarians-druids-and-paladins/\" target=\"_blank\" rel=\"noreferrer noopener\">More Perfect Novels for Every Dungeons &amp; Dragons Character Class: Bards, Barbarians, Druids, and Paladins</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.unboundworlds.com/2017/09/26-underrated-sci-fi-fantasy-gems-shouldnt-miss/?ref=PRH6F3D45E1F3&amp;aid=randohouseinc10373-20&amp;linkid=PRH6F3D45E1F3\" target=\"_blank\" rel=\"noreferrer noopener\">26 Underrated Sci-Fi and Fantasy Gems You Shouldn’t Miss</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nytimes.com/2018/07/16/books/review/author-recommended-scary-books.html?action=click&amp;module=Editors%20Picks&amp;pgtype=Homepage\" target=\"_blank\" rel=\"noreferrer noopener\">The Book That Terrified Neil Gaiman. And Carmen Maria Machado. And Dan Simmons.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.unboundworlds.com/2018/07/10-new-fantasysf-novels-women-read/\" target=\"_blank\" rel=\"noreferrer noopener\">10 New Sci-Fi &amp; Fantasy Novels by Women You Shouldn’t Miss</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.weforum.org/agenda/2017/08/11-books-on-the-future-of-humanity-that-everyone-should-read?utm_content=bufferf4c90&amp;utm_medium=social&amp;utm_source=twitter.com&amp;utm_campaign=buffer\" target=\"_blank\" rel=\"noreferrer noopener\">11 books on the future of humanity that everyone should read</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://electricliterature.com/10-gothic-gems-of-historical-fiction-f54c36611ec\" target=\"_blank\" rel=\"noreferrer noopener\">10 Gothic Gems of Historical Fiction</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.curbed.com/2017/11/22/16679866/best-books-cities-black-friday-cyber-monday\" target=\"_blank\" rel=\"noreferrer noopener\">101 books about where and how we live</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mariahaskins.com/2017/06/30/17-brilliantly-awesome-short-stories-i-read-in-june/?utm_content=bufferfae6f&amp;utm_medium=social&amp;utm_source=twitter.com&amp;utm_campaign=buffer/\" target=\"_blank\" rel=\"noreferrer noopener\">17 brilliantly awesome short stories I read in June</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://electricliterature.com/9-afrofuturist-books-to-enjoy-if-youre-homesick-for-wakanda-ebb591cd9e53\" target=\"_blank\" rel=\"noreferrer noopener\">9 Afrofuturist Books to Enjoy if You’re Homesick for Wakanda</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://locusmag.com/2018/04/2018-locus-awards-finalists/?utm_source=dlvr.it&amp;amp;utm_medium=twitter\" target=\"_blank\" rel=\"noreferrer noopener\">2018 Locus Award Finalists</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.syfy.com/syfywire/17-sff-books-by-asian-women-we-want-to-see-as-movies\" target=\"_blank\" rel=\"noreferrer noopener\">17 SFF Books by Asian Women We Want To See As Movies</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mariahaskins.com/2018/05/06/10-stellar-short-stories-i-read-in-april/\" target=\"_blank\" rel=\"noreferrer noopener\">9 Extra Stellar Short Stories I Read In April</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://litreactor.com/columns/me-myself-and-i-first-person-narratives-in-fantasy\" target=\"_blank\" rel=\"noreferrer noopener\">Me, Myself, and I: First Person Narratives in Fantasy</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mobile.twitter.com/RobGMacfarlane/status/995651627225960448\" target=\"_blank\" rel=\"noreferrer noopener\">A Request and Suggestions about Descents into the Underworld</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nypl.org/blog/2017/07/28/only-love-will-save-world-wonder-woman-readalikes?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\" target=\"_blank\" rel=\"noreferrer noopener\">Wonder Woman Read-alikes</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.npr.org/2017/07/12/533862948/lets-get-graphic-100-favorite-comics-and-graphic-novels\" target=\"_blank\" rel=\"noreferrer noopener\">Let\'s Get Graphic: 100 Favorite Comics and Graphic Novels</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.tor.com/2018/08/23/six-literary-visions-of-the-future/?utm_source=exacttarget&amp;utm_medium=newsletter&amp;utm_term=tordotcom-tordotcomnewsletter&amp;utm_content=na-readblog-blogpost&amp;utm_campaign=tor\" target=\"_blank\" rel=\"noreferrer noopener\">6 Literary Visions of the Future</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://bookriot.com/2018/10/15/best-modern-fantasy-series/\" target=\"_blank\" rel=\"noreferrer noopener\">15 of Your Best Picks for the Best Modern Fantasy Series&nbsp;</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nypl.org/blog/2016/09/16/brainy-brave-hermione-granger?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\" target=\"_blank\" rel=\"noreferrer noopener\">Brainy and Brave: A Salute to Hermione Granger</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.fantasyliterature.com/reviews/modern-fantasy-the-100-best-novels-1946-1987/\" target=\"_blank\" rel=\"noreferrer noopener\">100 Best Novels</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.tor.com/2018/09/12/outside-the-lines-unique-narrative-devices-in-fantasy/?utm_source=exacttarget&amp;utm_medium=newsletter&amp;utm_term=tordotcom-tordotcomnewsletter&amp;utm_content=na-readblog-blogpost&amp;utm_campaign=9781250175489\" target=\"_blank\" rel=\"noreferrer noopener\">Outside the Lines: Unique Narrative Devices in Fantasy</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nypl.org/blog/2017/03/08/365-books-women-authors-international-womens-day?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\" target=\"_blank\" rel=\"noreferrer noopener\">365 Books by Women Authors to Celebrate International Women’s Day All Year</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://prowritingaid.com/art/845/best-books-written-by-black-women.aspx\" target=\"_blank\" rel=\"noreferrer noopener\">Best Books Written by Black Women</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://bookriot.com/2019/01/22/african-fantasy-novels/\">20 Must-Read African Novels</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.bustle.com/p/10-essential-sci-fi-novels-by-women-that-show-what-the-genre-can-do-17307273\">10 Essential Sci-Fi Novels By Women That Show What The Genre Can Do</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/6-books-featuring-killer-blade-fights/\">6 Books Featuring Killer Blade Fights</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mobile.twitter.com/ellle_em/status/1110640670266585089\">List of Novels with Historically Accurate Epic Fantasy</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ask.metafilter.com/333129/Post-post-collapse-fiction\">Post-post-collapse fiction</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://reedsy.com/discovery/blog/best-ya-fantasy-books\">30 Best YA Fantasy Books for Teens</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><strong>Short Stories</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Nnedi Okorafor</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.tor.com/2011/11/02/hello-moto/\">Hello, Moto</a></li><li><a href=\"https://slate.com/technology/2018/02/mother-of-invention-a-new-short-story-by-nnedi-okorafor.html\">Mother of Invention</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"http://www.abyssapexzine.com/2018/03/middle-of-nowhere/\" target=\"_blank\">Middle of Nowhere</a> by Walter Dinjo</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/10-harlan-ellison-short-stories-that-changed-sci-fi/\" target=\"_blank\" rel=\"noreferrer noopener\">10 Harlan Ellison Short Stories That Changed Sci-Fi</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.beneath-ceaseless-skies.com/2019/01/24/2019-awards-eligible-stories-from-bcs/\" target=\"_blank\" rel=\"noreferrer noopener\">2019 Awards-Eligible Stories from Beneath Ceaseless Skies</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/17-recent-sci-fi-fantasy-and-horror-anthologies-to-celebrate-short-story-month/\">17 Sci-Fi, Fantasy, and Horror Anthologies to Celebrate Short Story Month</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p style=\"text-align:center\"><strong>Free Audiobooks</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://player.fm/series/levar-burton-reads/live-in-chicago-the-winds-of-harmattan-by-nnedi-okorafor\" target=\"_blank\">\"The Winds of Harmattan\" by Nnedi Okorafor</a> (Levar Burton) <br><a rel=\"noreferrer noopener\" href=\"https://one.npr.org/?sharedMediaId=585302372:585302374\" target=\"_blank\">\"The Baboon War\" by Nnedi Okorafor</a> (Levar Burton)<br><a href=\"http://escapepod.org/2010/07/01/ep247-bridesicle/\">Bridesicle by Will McIntosh</a> (Amy H. Sturgis)</p>\n<!-- /wp:paragraph -->','Reading Lists','','inherit','closed','closed','','101-revision-v1','','','2020-01-11 23:30:05','2020-01-11 23:30:05','',101,'https://dmweade.com/welcome/2020/01/11/101-revision-v1/',0,'revision','',0),
 (35,2,'2018-07-21 22:39:39','2018-07-21 22:39:39','<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Design Stuff for Creatives</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:list -->\n<ul><li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li><li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li><li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li><li>Vector art: <a rel=\"noreferrer noopener\" href=\"https://www.freevector.com/\" target=\"_blank\">Free Vector</a></li><li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a>, <a rel=\"noreferrer noopener\" href=\"https://www.kirith.com/tsr-fonts/\" target=\"_blank\">TSR fonts</a>, <a href=\"https://www.1001fonts.com/trees-fonts.html\">tree fonts</a><ul><li><a href=\"https://www.websiteplanet.com/blog/best-free-fonts/\">70+ Free for Commercial Use</a></li></ul></li><li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li><li>Sound Effects: <a href=\"https://freesound.org/\">Free Sound</a>, <a href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a>, <a href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a>, <a href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.thebookdesigner.com/2018/10/110-type-ornaments-to-use-in-your-book-plus-a-free-download/?utm_source=Jane+Friedman+%2F+Electric+Speed&amp;utm_campaign=64484ef8ec-EMAIL_CAMPAIGN_2017_12_30_COPY_01&amp;utm_medium=email&amp;utm_term=0_b84a4334ba-64484ef8ec-332623045\" target=\"_blank\">100 Type Ornaments to Use in Your Book</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Art Books</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.metmuseum.org/art/metpublications/titles-with-full-text-online?searchtype=F\">500+ Free Art Books from the Met</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Tutorials</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://design.tutsplus.com/tutorials/how-to-design-a-vintage-travel-poster-in-adobe-illustrator-and-photoshop--cms-26075\">Design a Vintage Travel Poster</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:list -->\n<ul><li> <a rel=\"noreferrer noopener\" href=\"http://growthsupply.com/free/\" target=\"_blank\">Growth Supply</a> - mega list of resources</li><li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li><li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li><li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li><li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li><li><a rel=\"noreferrer noopener\" href=\"https://freedesignresources.net/\" target=\"_blank\">Free Design Resources</a>: fonts, mockups, graphics, templates &amp; more</li><li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li><li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li><li><a href=\"http://travelcoffeebook.com/\">Travel Coffee Book</a>: travel photos</li><li><a rel=\"noreferrer noopener\" href=\"https://www.pixeden.com/\" target=\"_blank\">Pixeden</a>: prints, icons, vectors, graphics,etc...</li><li><a href=\"https://www.freepik.com/\">Freepix</a>: photos and vectorsfree</li><li>Historical art collections: <a rel=\"noreferrer noopener\" href=\"https://www.watercolourworld.org/\" target=\"_blank\">Watercolour World</a> </li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Software:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li><li>GIMP: <a rel=\"noreferrer noopener\" href=\"https://www.gimp.org/\" target=\"_blank\">Free image editor</a></li><li>Inkscape: <a href=\"https://inkscape.org/\">Vector images</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Software Add-Ons</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://graphicriver.net/item/animated-real-paint-fx-photoshop-addon-extension/23116581\">Animated Real Paint FX</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->','Creative Resources','','publish','closed','closed','','creative-resources','','','2020-01-22 17:10:13','2020-01-22 17:10:13','',0,'https://dmweade.com/welcome/?page_id=35',0,'page','',0),
 (36,1,'2018-07-21 22:38:11','2018-07-21 22:38:11','My resource pages help me keep track of things. I hope you also find them useful.\r\n\r\nArt, media, design elements (always check the license for professional use)\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 516px;\">\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n 	<li>Just images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Just icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Just fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nOther lists:\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\">Growth Supply</a></li>\r\n 	<li><a href=\"https://www.reddit.com/r/AskReddit/comments/8gy4nd/what_are_some_cool_websites_where_you_can/\">Reddit: What are some cool websites where you can download free stuff?</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-07-21 22:38:11','2018-07-21 22:38:11','',35,'https://dmweade.com/welcome/2018/07/21/35-revision-v1/',0,'revision','',0),
 (37,2,'2018-07-21 22:40:15','2018-07-21 22:40:15','','Wordpress Resources','','private','closed','closed','','wordpress-resources','','','2020-01-12 19:03:32','2020-01-12 19:03:32','',0,'https://dmweade.com/welcome/?page_id=37',0,'page','',0),
 (38,1,'2018-07-21 22:40:15','2018-07-21 22:40:15','<a href=\"https://creativemarket.com/themes/wordpress/blog\">https://creativemarket.com/themes/wordpress/blog</a>','Wordpress Resources','','inherit','closed','closed','','37-revision-v1','','','2018-07-21 22:40:15','2018-07-21 22:40:15','',37,'https://dmweade.com/welcome/2018/07/21/37-revision-v1/',0,'revision','',0),
 (39,2,'2018-07-21 22:41:33','2018-07-21 22:41:33','<!-- wp:paragraph -->\n<p><strong>Articles and resources I\'ve collected over the years. Sharing does not equal recommendation. While I have read the articles, I have not used all the advice or tested all of the tools.<br></strong><em>(Keep scrolling, it\'s a long page</em>. <em>Also, getting messy and will stay that way until I have time to reconsider my organization.</em>)</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Critiquing Groups</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)<ul><li><a href=\"https://www.inkedvoices.com/lecture-series/\">Past Lectures</a> (membership required)</li></ul></li><li><a href=\"http://www.critters.org/\">Critters</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Professional Support</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\">5 Ways to Find the Right Freelance Book Editor</a></li><li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li><li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li><li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li><li><a href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li><li><a href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li><li><a href=\"https://www.sfwa.org/other-resources/for-authors/writer-beware/\">Writer Beware</a> - Warnings for writers</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Writing challenges</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo)</a></li><li><a href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Sites Supporting Writers</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America</a></li><li><a href=\"http://www.writing.com/\">Writing.com</a></li><li><a href=\"http://wow-womenonwriting.com/\">WOW! &nbsp;Women on Writing</a></li><li><a href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li><li><a href=\"http://www.writingexcuses.com/\">Writing Excuses podcast</a></li><li><a href=\"http://critters.org/\">Critters Workshop</a></li><li><a href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li><li><a href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li><li><a href=\"https://onestopforwriters.com/\">One Stop for Writers</a></li><li><a href=\"https://www.dropbox.com/s/symkwa6mz4rdt8j/Writers%20Helping%20Writers%20Help%20Guide.pdf?dl=0\">Writers Helping Writer\'s Help Guide</a></li><li><a href=\"http://www.kittywumpus.net/blog/links-and-resources-for-fantasy-and-science-fiction-writers/\">Links and Resources for Fantasy and SF writers</a></li><li><a href=\"http://www.kittywumpus.net/blog/links-and-resources-for-fantasy-and-science-fiction-writers/\">Fantasy and Science Fiction Writers</a> (Cat Rambo)</li><li><a href=\"http://www.clarify-editing.com/writer-resources.html\">Clarify Editing\'s Resources for Writers</a> </li><li><a href=\"https://howtofightwrite.tumblr.com/\">How to Fight Write</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>The Professional Author</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.publishersweekly.com/pw/print/20180723/77564-what-authors-and-editors-wish-they-could-say-to-one-another.html\" target=\"_blank\">What Authors and Editors Wish They Could Say to One Another</a></li><li><a rel=\"noreferrer noopener\" href=\"https://greenleafbookgroup.com/learning-center/publishing-information/what-publishers-want\" target=\"_blank\">What Publishers Want</a> - Greenleaf Book Group</li><li><a rel=\"noreferrer noopener\" href=\"https://www.hubspot.com/make-my-persona\" target=\"_blank\">Create a Buyer Persona</a> - Hubspot\'s tool to identify your core audience</li><li><a href=\"https://prowritingaid.com/art/903/types-of-writing-contracts-and-how-to-approach-them.aspx\">Types of Writing Contracts and How to Approach Them</a></li><li><a rel=\"noreferrer noopener\" href=\"https://prowritingaid.com/art/857/a-professional-editor-reveals-the-dos-and-don-ts-of-writing-your-query.aspx\" target=\"_blank\">A Professional Editor Reveals the Dos and Don\'ts of Writing Your Query Letter</a></li><li>Agent Advice: <ul><li><a href=\"https://prowritingaid.com/art/922/agent-advice-part-1%3A-developmental-editing.aspx\">Pt 1 - Developmental Editing</a></li><li><a href=\"https://prowritingaid.com/art/923/agent-advice-part-2:-line-editing-and-copy-editing.aspx?utm_source=twitter&amp;utm_medium=linecopyediting\">Pt 2 - Line-Editing and Copy-Editing</a> </li></ul></li><li><a href=\"https://prowritingaid.com/art/926/how-to-crowdfund-a-novel.aspx?utm_source=twitter&amp;utm_medium=crowdfundanovel\">How to Crowd-fund a Novel</a></li><li><a href=\"https://prowritingaid.com/art/857/a-professional-editor-reveals-the-dos-and-don-ts-of-writing-your-query.aspx\">A Professional Editor Reveals the Dos and Don\'ts of Writing Your Query Letter</a></li><li><a href=\"https://jerryjenkins.com/query-letter/\">How To Write a Query Letter That Grabs an Agent’s Attention</a></li><li><a href=\"https://www.janefriedman.com/sample-permission-letter/\">A Writer\'s Guide to Fair Use and Permission + A Sample Permissions Letter</a></li><li><a href=\"http://The Paid Publishing Guidebookfor 2020\">The Paid Publishing Guidebook for 2020</a> - Includes a list of publishers and what they pay.</li><li><a href=\"https://bulkbooks.com/how-to-publish-a-book\">Publishing a Book: A Guide to Becoming an Author</a> - a nice overview of the process and options</li><li><a href=\"https://medium.com/better-marketing/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\">The System I Used to Write 5 Books and Over 1000 Blog Posts</a></li><li><a href=\"https://morganhazelwood.com/2020/01/23/the-difference-between-blurbs-queries-and-synopses/\">The Difference Between Blurbs, Queries, and Synopses</a></li><li><strong>Author Web Presence</strong></li><li><a href=\"https://www.crowdtangle.com/\">Crowdtangle</a>: Track who shared your content</li><li><strong>Routine:</strong><ul><li><a href=\"https://www.elephantjournal.com/2019/08/this-morning-routine-will-save-us-20-hours-per-week-benjamin-hardy/\">This Morning Routine will Save us 20 Hours Every Week</a></li><li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Preparing Novels</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.dailywritingtips.com/whats-your-novels-log-line\">What\'s Your Novel\'s Log Line?</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Short Stories</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://jerz.setonhill.edu/writing/creative1/shortstory/\">Short Story Tips: 10 Hacks to Improve Your Creative Writing</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Writing Advice</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li><li><a href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\">Susan Sontag on the Four People a Great Writer Must Be</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\">Keeping a Visual Diary</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\">2017 Ultimate Writing Guide</a></li><li><a rel=\"noreferrer noopener\" href=\"https://cdn.prowritingaid.com/ebook/ProWritingAid_EBook2.pdf\" target=\"_blank\">Novel Writing Training Plan</a> by Pro Writing Aid</li><li><a rel=\"noreferrer noopener\" href=\"https://prowritingaid.com/art/374/8-Ways-to-Make-Your-Story-Boring-.aspx?utm_source=twitter&amp;utm_medium=social\" target=\"_blank\">8 Ways to Make Your Story Boring</a></li><li><a href=\"https://niemanstoryboard.org/stories/flow/\">Getting in the Writing Zone</a></li><li><a href=\"https://mobile.twitter.com/ccfinlay/status/1141088811553660928\">Emotional Labor of Editing</a></li><li><a href=\"http://www.jayoconnell.com/2019/06/thirteen-things-some-writers-need-to-remind-themselves/\">Thirteen Things (some) Writers Need to Remind Themselves of</a></li><li><a href=\"https://www.tor.com/2019/03/25/one-free-trick-how-to-use-the-writing-skills-you-have-to-learn-the-ones-you-dont/?utm_source=exacttarget&amp;utm_medium=newsletter&amp;utm_term=tordotcom-tordotcomnewsletter&amp;utm_content=na-readblog-blogpost&amp;utm_campaign=tor&amp;e=a3087719b835fd5916a5573381c09d776d7afc81b1e52fca47987d075cb3131c\">How to Use the Writing Skills You Have to Learn the Ones You Don’t</a></li><li><a href=\"https://prowritingaid.com/art/874/best-books-about-writing-fiction.aspx?utm_source=twitter&amp;utm_medium=booksaboutwritingfiction\">Best Books About Writing Fiction</a></li><li><a href=\"https://yeahwrite.me/writing-help-finding-editor/\">Finding and Working with an Editor</a></li><li><a href=\"http://www.openculture.com/2018/10/moebius-gives-18-wisdom-filled-tips-aspiring-artists.html\">Moebius Gives 18 Wisdom-Filled Tips to Aspiring Artists</a></li><li><a href=\"https://writersinthestormblog.com/2018/02/third-vs-first-person-narratives/\">Using Third Person vs First Person Novel Narratives </a></li><li><a href=\"https://blog.reedsy.com/writing-fantasy/\">13 Kick-Ass Tips For Writing Fantasy From Professional Fantasy Editors</a></li><li><a href=\"https://www.writersdigest.com/writing-articles/by-writing-genre/science-fiction-fantasy/4-authors-share-their-best-tips-for-writing-fantasy-science-fiction\">4 Authors Share Their Best Tips for Writing Fantasy &amp; Science-Fiction</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Self Promotion / Building a Platform</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\">An example of supporting others through your site</a></li><li><a rel=\"noreferrer noopener\" href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\">The Art and Business of Author Platform</a></li><li><a rel=\"noreferrer noopener\" href=\"//www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\">Build Your Author Platform Through Blogging</a></li><li>Wealthy Web Writer: <a href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li><li><a rel=\"noreferrer noopener\" href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\">Note to All Creatives: Marketing is Your Job</a></li><li><a rel=\"noreferrer noopener\" href=\"https://anchor.fm/\" target=\"_blank\">Anchor Podcasting App</a></li><li><a href=\"https://trystoryboard.com/\">Storyboard Podcasts</a></li><li><a rel=\"noreferrer noopener\" href=\"https://writingcooperative.com/how-to-build-your-own-author-platform-from-scratch-9d6123858bac\" target=\"_blank\">How to Build your own author platform - from scratch</a></li><li><a href=\"https://hostingfacts.com/website-builders/\">Comparison of 10 Website Builders</a></li><li><a rel=\"noreferrer noopener\" href=\"https://growthtools.com/#tools\" target=\"_blank\">Growth Tools</a> - Grow your online business</li><li><a rel=\"noreferrer noopener\" href=\"https://thewritepractice.com/building-an-author-website/\" target=\"_blank\">Building an Author Website: The First Step to Publishing</a></li><li><a rel=\"noreferrer noopener\" href=\"https://newsletterguide.org/\" target=\"_blank\">A 201 guide for taking your newsletters to the next level — growing the lists, making money, and more.</a></li><li><a href=\"https://prowritingaid.com/art/921/how-to-properly-disclose-affiliate-links-and-endorsements-online.aspx?utm_source=twitter&amp;utm_medium=affiliatelinks\">How to Properly Disclose Affiliate Links and Endorsements Online</a></li><li><a href=\"https://prowritingaid.com/art/907/5-helpful-tools-for-the-constant-blogger.aspx?utm_source=twitter&amp;utm_medium=constantblogger\">5 Helpful Tools for the Constant Blogger</a></li><li><a href=\"https://prowritingaid.com/art/924/grow-your-email-list-from-nothing.aspx\">Grow and Email List From Nothing</a></li><li><a href=\"https://www.clockpunkstudios.com/portfolio_type/author/\">Clockpunk Studios: Professional Wordpress design and development for authors</a></li><li><a href=\"https://tagdef.com/en/\">Tagdef</a> - Discover what hashtags stand for</li><li><a href=\"https://prowritingaid.com/art/999/the-5-biggest-mistakes-bloggers-make.aspx\">5 Biggest Mistakes Bloggers Make</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Feedback/Critiquing</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.inkedvoices.com/quick-guide-to-critique/\">Inked Voices Critique Guide</a></li><li><a href=\"https://morganhazelwood.com/2016/12/08/10-qas-for-beta-readers/\">10 Questions to Ask Beta-readers</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Extras</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li><li><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noreferrer noopener\">Getting Access to Paywalled Papers</a></li><li><a href=\"https://blog.findawayvoices.com/what-ive-learned-from-recording-25-of-my-own-audiobooks/\" target=\"_blank\" rel=\"noreferrer noopener\">Here\'s what I\'ve learned from recording 25 of my own audiobooks</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Marketing Books</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://kindlepreneur.com/kindle-keywords-fiction-author-strategy/\" target=\"_blank\">Kindle Keyword Strategies for Fiction Authors</a></li><li><a href=\"https://www.hiddengemsbooks.com/amazon-blurb-tool/\">Amazon Blurb Previewer</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Grammar extras</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://writingcooperative.com/useless-words-to-seek-out-and-destroy-in-your-manuscript-a6198beedc38\">Useless Words to Seek Out and Destroy in Your Manuscript</a></li><li><a href=\"https://prowritingaid.com/en/GrammarChecker/Category/Anaphora\">Anaphora</a> (deliberate repetition)</li><li><a href=\"https://prowritingaid.com/en/GrammarChecker/Category/Adverbs\">Adverbs</a></li><li><a href=\"https://prowritingaid.com/art/968/mr,-mrs,-ms-and-miss:-everything-you-need-to-know-about-titles.aspx\">Everything You Need to Know About Titles</a></li><li><a href=\"https://lgbtrc.usc.edu/trans/transgender/pronouns/\">Gender Neutral Pronouns</a></li><li><a href=\"https://writerunboxed.com/2020/01/17/the-compelling-emotional-complex-sentence/#more-61189\">The Compelling, Emotional Complex Sentence</a></li><li><a href=\"https://raw.githubusercontent.com/dwyl/english-words/master/words.txt\">Master List of English Words</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Self Care</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.psychologytoday.com/us/blog/the-intelligent-divorce/201411/boosting-creativity-10-easy-steps\">Boosting Creativity - 10 Easy Steps</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Eye strain:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.lifewire.com/reduce-eye-strain-with-blue-light-filter-apps-4134615\">Blue Light reduction</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Writing Craft</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Story Structure</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\">The MICE Quotient: How to Structure Your Story</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\">Infusing Microtension in Your Novel</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\">My Outlining Process: How I Prepare to Draft My Novels</a></li><li><a rel=\"noreferrer noopener\" href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\">Four Acts, Not Three</a></li><li><a rel=\"noreferrer noopener\" href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\">The Paradigm Worksheet</a></li><li><a rel=\"noreferrer noopener\" href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\">Trilogy Building: Star Wars and Halo Plots</a></li><li><a rel=\"noreferrer noopener\" href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\">A Four Act Structure</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\">20 Master Plots and How to Build Them</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.ian-irvine.com/on-writing/41-ways-to-create-and-heighten-suspense/\" target=\"_blank\">41 Ways to Create and Heighten Suspense</a></li><li><a rel=\"noreferrer noopener\" href=\"https://prowritingaid.com/art/387/Six-Tried-and-Tested-Methods-for-Writing-a-Novel.aspx?utm_source=twitter&amp;utm_medium=social\" target=\"_blank\">Six Tried and Tested Methods for Writing a Novel</a></li><li><a href=\"https://fictionary.co/\">Fictionary - Online Story Editing Tool</a></li><li><a href=\"https://fabuladeck.com/\">Fabula Deck - Card Deck story structure framework</a></li><li><a href=\"https://thewritepractice.com/pacing-writing/\">10 Ways to Master Pacing in Writing and Keep Your Readers Riveted</a></li><li><a href=\"https://hollowlands.com/2014/09/creating-a-book-series-bible-using-scrivener-scapple-and-aeon-timeline/\">Creating a book series “bible” using Scrivener, Scapple, and Aeon Timeline</a></li><li><a href=\"https://writingcooperative.com/the-benefits-of-story-subplot-8a61031f1ab3\">The Benefits of Story Subplot</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Character Development</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li><li><a rel=\"noreferrer noopener\" href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\">Writing Excuses 9.13: Three Pronged Character Development</a>&nbsp;(covering the sliding scale)</li><li><a href=\"https://glichy.wordpress.com/2016/09/13/creating-characters-according-to-jim-butcher/\">Creating Characters by Jim Butcher</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\">11 Secrets to Writing an Effective Character Description</a></li><li><a rel=\"noreferrer noopener\" href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\">25 Things A Great Character Needs</a></li><li><a rel=\"noreferrer noopener\" href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\">Ten Things About Strong Female Characters</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li><li><a rel=\"noreferrer noopener\" href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\">Thread on what Strength means for female characters</a></li><li><a rel=\"noreferrer noopener\" href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\">Characters by Jim Butcher</a></li><li><a rel=\"noreferrer noopener\" href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li><li><a rel=\"noreferrer noopener\" href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\">Tags and Traits: Characterization and Building Empathy</a></li><li><a rel=\"noreferrer noopener\" href=\"https://mythcreants.com/blog/eight-absurdities-we-force-on-female-characters/\" target=\"_blank\">8 Absurdities we Force on Female Characters</a></li><li><a href=\"https://www.huffpost.com/entry/post-traumatic-stress-disorder-ptsd-myths_l_5cf11d36e4b0a1997b68d87e\">10 Things Get Wrong About PTSD</a></li><li><a href=\"https://prowritingaid.com/art/1041/how-to-develop-a-character.aspx?utm_source=twitter&amp;utm_medium=ad&amp;utm_content=how-to-develop-a-character\">Mining the Mind of your Character</a></li><li><a href=\"https://prowritingaid.com/art/856/character-research:-how-to-write-authentic-emotion.aspx?utm_content=buffer7d661&amp;utm_medium=social&amp;utm_source=twitter.com&amp;utm_campaign=buffer\">Write Authentic Emotion</a></li><li><a href=\"http://penultimateword.com/fiction/dialect-in-dialogue-how-to-write-authentic-dialect-and-foreign-accents/\">Dialogue in Fiction</a></li><li><a href=\"https://prowritingaid.com/art/308/How-to-Construct-a-3D-Main-Character.aspx\">How to Construct a 3D Main Character</a></li><li><a href=\"https://anvl.co/custom-miniatures\">ANVL 3D Printed Characters</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Settings</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.thecreativepenn.com/2019/05/01/writing-tips-how-and-why-to-treat-your-setting-like-a-character/?utm_campaign=writing-tips-how-and-why-to-treat-your-setting-like-a-character\">How (And Why) To Treat Your Setting Like A Character</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Scenes</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li><li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noreferrer noopener\">Jim Butcher on Scenes</a></li><li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noreferrer noopener\">Jim Butcher on Sequels</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Short Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noreferrer noopener\">Self-Editing Checklist for Short Story Writers</a></li><li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noreferrer noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Removing Filter Words</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noreferrer noopener\">Filter Words by Sooz</a></li><li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noreferrer noopener\">Are These Filter Words Weakening Your Fiction?</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Editing</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://prowritingaid.com/art/933/clean-up-your-content:-eliminate-the-non-words.aspx\">Eliminate non-words</a></li><li><a href=\"https://magazine.metaphorosis.com/guidelines/dont-do-this/\">Don\'t do these things. Please.</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Worldbuilding</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\">Worldbuilding Questions at SFWA</a></li><li><a rel=\"noreferrer noopener\" href=\"https://io9.gizmodo.com/7-deadly-sins-of-worldbuilding-998817537\" target=\"_blank\">7 Deadly Sins of Worldbuilding</a></li><li><a rel=\"noreferrer noopener\" href=\"https://mythcreants.com/blog/five-common-worldbuilding-mistakes-in-new-manuscripts/\" target=\"_blank\">5 Common Worldbuilding Mistakes in New Manuscripts</a> (and a great blog)</li><li><a rel=\"noreferrer noopener\" href=\"https://mythcreants.com/blog/creating-a-mountain-setting/\" target=\"_blank\">Creating a Mountain Setting</a></li><li><a rel=\"noreferrer noopener\" href=\"https://nybookeditors.com/2017/07/fantasy-world-building-101-create-breathing-world-fantasy-novel/\" target=\"_blank\">Fantasy World Building 101: how to create a breathing world for your fantasy novel</a></li><li>Worldbuilding Guide: <em>Excellent process</em> <ul><li><a rel=\"noreferrer noopener\" href=\"https://www.lostkingdom.net/worldbuilding-guide-1/\" target=\"_blank\">Part 1</a>, <a rel=\"noreferrer noopener\" href=\"http://www.lostkingdom.net/worldbuilding-guide-2/\" target=\"_blank\">Part 2</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.lostkingdom.net/fantasy-world-economics-101-introduction/\" target=\"_blank\">Fantasy Economics 101</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.lostkingdom.net/fantasy-world-economics-101-labour-and-wages/\" target=\"_blank\">Economics: labour and wages</a> </li></ul></li><li><a rel=\"noreferrer noopener\" href=\"https://electricliterature.com/against-worldbuilding-700e4861c26b\" target=\"_blank\">Against Worldbuilding</a> (caused quite a ruckus)</li><li><a rel=\"noreferrer noopener\" href=\"http://terribleminds.com/ramble/2013/09/17/25-things-you-should-know-about-worldbuilding/\" target=\"_blank\">25 Things You Should Know About Worldbuilding</a></li><li><a href=\"https://www.wired.com/story/nk-jemisin-how-to-write-science-fiction-wired25/\">For N. K. Jemisin, World-Building Is a Lesson in Oppression</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Storytelling</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\">Fairy Tales and the Necessity of Fear</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\">Fantastic Beasts and How to Rank Them</a></li><li><a rel=\"noreferrer noopener\" href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\">In the shadows of dark forests</a></li><li><a href=\"https://www.nytimes.com/2019/04/17/opinion/what-tolkien-knew-about-love.html\">What Tolkien Knew About Love</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.atlasobscura.com/articles/cyoa-choose-your-own-adventure-maps?utm_source=facebook.com&amp;utm_medium=atlas-page\" target=\"_blank\">Maps of Hidden Structures of Choose Your Own Adventure Books</a></li><li><a href=\"https://blogs.scientificamerican.com/observations/the-real-reason-fans-hate-the-last-season-of-game-of-thrones/?redirect=1\">The Real Reason Fans Hate the Last Season of Game of Thrones - sociological vs psychological story styles</a></li><li><a href=\"https://www.historyextra.com/period/medieval/history-middle-ages-fantasy-stories-genre-how-inspired-inspiration/?fbclid=IwAR2H_15zvFmiOHaK0S_ToEVnMM_E01iKSw0yoXy_PIfcQoue_n-0CB7jBc8\">Medieval inspiration: what the fantasy genre owes to the 14th century</a></li><li><a href=\"https://thefriendlyeditor.com/2015/03/26/how-rowling-revised-harry-potter-phoenix/\">How Rowling Revised ‘Harry Potter and the Order of the Phoenix’</a></li><li><a href=\"https://www.writermag.com/improve-your-writing/fiction/writing-magical-realism/\">Writing Magical Realism</a></li><li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\">Infuse Microtension in Your Novel</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Advice From Writers</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://hollylisle.com/\">Holly Lisle</a></li><li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Jim Butcher</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Beginnings</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\">Best Opening Lines in Young Adult Books</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Perspective</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://penultimateword.com/editing-blogs/how-to-write-deep-pov-its-all-in-your-perspective/\">How to Write Deep POV</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Best Practices</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noreferrer noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li><li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noreferrer noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Fight Scenes</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noreferrer noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Names</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://s-gabriel.org/names/index.shtml\">Medieval Names Archive</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\">Anthony Ryan On Naming Fantasy Characters</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.fantasynamegenerators.com/witch-names.php\" target=\"_blank\">Witch name generator</a> (and lots others)</li><li><a href=\"https://www.seventhsanctum.com/index-name.php\">Seventh Sanctum name generators (many types)</a></li><li><a href=\"https://donjon.bin.sh/\">Massive List of Generators</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Idea Generators</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.lifeformz.com/cgi-bin/idea/idea.fcgi\">Random Logline Generator</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Other</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://tvtropes.org/pmwiki/pmwiki.php/Main/Tropes\">TVtropes</a> - Megalist of tropes used in storytelling</li><li><a href=\"https://pudding.cool/2019/07/book-covers/\">11 Years of Best Selling Novel Covers</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Templates, References, Guides</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Quick References</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noreferrer noopener\">Inkilicious Cheat Sheet</a></li><li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noreferrer noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li><li><a href=\"https://onestopforwriters.com/image_tips\">Checklists and Tip Sheets</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Templates for Writers</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noreferrer noopener\">The Organized Writer</a> Annie Neugebauer - Novel development and professional templates</li><li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noreferrer noopener\">The Editorium\'s Freebies</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Grammar and Punctuation</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.bartleby.com/141/\">Strunk\'s&nbsp;<em>The Elements of Style</em></a></li><li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a>&nbsp;-&nbsp;<a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a>&nbsp;-&nbsp;<a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li><li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li><li><a href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li><li><a href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation</a></li><li><a href=\"http://www.edufind.com/English/Grammar/\">Edufind\'s&nbsp;Online English Grammar Resources</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.lousywriter.com/\" target=\"_blank\">Lousy Writer</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.englishgrammar101.com/\" target=\"_blank\">English Grammar 101</a></li><li><a rel=\"noreferrer noopener\" href=\"https://capitalizemytitle.com/\" target=\"_blank\">Capitalize My Title</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Finding Words (beyond dictionaries and Google)</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.powerthesaurus.org/\" target=\"_blank\">Power Thesaurus</a></li><li><a rel=\"noreferrer noopener\" href=\"https://english.stackexchange.com/\" target=\"_blank\">English Language and Usage Q&amp;A</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.urbandictionary.com/\" target=\"_blank\">Urban Dictionary</a></li><li><a rel=\"noreferrer noopener\" href=\"https://greensdictofslang.com/\" target=\"_blank\">Green’s Dictionary of Slang</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.etymonline.com/\" target=\"_blank\">Etymology.com</a>: word history</li><li><a rel=\"noreferrer noopener\" href=\"http://phrontistery.info/index.html\" target=\"_blank\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words. <ul><li><a rel=\"noreferrer noopener\" href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\">Specialty glossaries</a> (worth bookmarking on its own) </li></ul></li><li><a rel=\"noreferrer noopener\" href=\"http://www.gutenberg.org/ebooks/18362\" target=\"_blank\">Fifteen Thousand Useful Phrases by Grenville Kleiser</a></li><li><a href=\"https://www.descriptionari.com/\">Descriptionari</a></li><li><a href=\"https://www.newyorker.com/culture/rabbit-holes/time-travelling-with-merriam-websters-dictionary\">Time-Travelling with Merriam-Webster’s Dictionary</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Publishing Tools</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://vellum.pub/\" target=\"_blank\">Vellum: Create Beautiful Books</a></li><li><a href=\"https://sigil-ebook.com/get/\">Sigil: multi-platform EPUB ebook Editor</a></li><li><a rel=\"noreferrer noopener\" href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\">Responsive Storytelling Best Practices</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\">Premium Book Design Templates</a></li><li><a href=\"https://payhip.com/\">Payhip - sell digital memberships and downloads</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Mapping</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"http://mapfrappe.com/\" target=\"_blank\">MapFrappe</a>: Compare two locations on Earth side by side.</li><li><a rel=\"noreferrer noopener\" href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\">National Geographic Vintage Map Archive</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.atlasobscura.com/articles/writers-maps?utm_source=twitter.com&amp;utm_medium=referral&amp;utm_campaign=SocialFlow\" target=\"_blank\">How Writers Map Their Imaginary Worlds</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.fantasyliterature.com/reviews/modern-fantasy-the-100-best-novels-1946-1987/\" target=\"_blank\">Medieval Fantasy City Generator</a></li><li><a href=\"http://www.hexographer.com/\">Hexographer</a></li><li>Samples: <ul><li><a rel=\"noreferrer noopener\" href=\"https://mobile.twitter.com/foxtosser/status/1085558337947820032\" target=\"_blank\">Matthäus Merian\'s beautiful 1636 map of the Republic of Venice</a> </li></ul></li><li><a rel=\"noreferrer noopener\" href=\"https://www.tor.com/2019/03/19/what-does-a-fantasy-map-look-like/?utm_source=exacttarget&amp;utm_medium=newsletter&amp;utm_term=tordotcom-tordotcomnewsletter&amp;utm_content=na-readblog-blogpost&amp;utm_campaign=tor&amp;e=a3087719b835fd5916a5573381c09d776d7afc81b1e52fca47987d075cb3131c\" target=\"_blank\">What does a fantasy map look like?</a></li><li><a href=\"https://www.nbos.com/products/astrosynthesis\">AstroSynthesis</a></li><li><a href=\"https://www.cartographyassets.com/\">Cartography Resources</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Sounds/Music for Writing</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noreferrer noopener\">Spring Walk nature sounds generator</a></li><li><a href=\"http://moby.com/la1/\" target=\"_blank\" rel=\"noreferrer noopener\">Long Ambients1: Calm. Sleep.</a> by Moby (free music)</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Idea Generators</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.descriptionari.com/\" target=\"_blank\">Descriptionari</a>: Search for book quotes by terms</li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p><strong>Visuals</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:list -->\n<ul><li><a href=\"https://digitalcollections.nypl.org/\">NY Public Library digital collections</a></li><li><a href=\"http://tolkiengateway.net/wiki/Category:Images_by_J.R.R._Tolkien\">Images by J.R.R. Tolkien</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.texturemate.com/index.php/\" target=\"_blank\">Texture repository</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\">29 Surreal Landscapes</a></li><li><a href=\"https://digitalcollections.nypl.org/\">The Beauty and the Power of African Blacksmiths</a></li><li><a href=\"https://arthusiast.art/amazing-macro-shots-taken-inside-instruments-by-adrian-borda/\">Macro Shots Inside Instruments</a></li><li><a href=\"https://www.rd.com/home/nature-takes-over-abandoned-homes/?trkid=soc-rd-atlas&amp;fbclid=IwAR1LJORFDxpX8CrR0FDKngHaaQ7ysmvQYkqBPjF0M7wrtN1TR7dO04tca3c\">20 Abandoned Places That Were Overrun By Nature</a></li><li><a href=\"https://www.sunnyskyz.com/blog/2932/If-We-Drew-Modern-Animals-The-Way-We-Draw-Dinosaurs-Based-On-Bones-Alone\">Animals Drawn Based on Bones Alone</a> (like dinosaurs)</li><li><a href=\"https://kotaku.com/this-is-who-we-thank-for-bastions-gorgeous-art-5940147\">Game Art from Bastion</a></li><li><a href=\"https://somuchviral.com/27-dreamy-cottages/\">Fairy-Tale Cottages</a></li><li>Fall Colors: <a href=\"https://blog.vitalchek.com/vital-records/best-vacations-to-see-fall-colors-in-2018/\">1</a></li><li><a href=\"https://abandonedspaces.co/this-magical-village-with-no-roads-at-all-is-straight-out-of-a-fairy-tale-book/\">Giethoorn Canal Village</a></li><li><a href=\"https://50nerdsofgrey.com/this-makeup-artist-creates-optical-illusions-on-her-face-to-mess-with-peoples-minds/\">Makeup Artist Creates Optical Illusions On Her Face</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:list -->\n<ul><li><a href=\"https://digitalcollections.nypl.org/\">Mountains Shot in Infrared</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.artofmtg.com/\" target=\"_blank\">Art of Magic the Gathering</a> (2500+ fantasy images)</li><li><a rel=\"noreferrer noopener\" href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\">Hieronymous Bosch Pinatas</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.atlasobscura.com/articles/pies-that-look-like-people\" target=\"_blank\">People Pot Pies</a> </li><li><a rel=\"noreferrer noopener\" href=\"https://www.rachaeltalibart.com/ocean\" target=\"_blank\">Sirens</a> by Rachel Talibart</li><li>Storms: <a rel=\"noreferrer noopener\" href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\">Dirty Thunderstorm</a> (Wikipedia)<a rel=\"noreferrer noopener\" href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\">Dirty Storms</a> (lightning around volcanoes)</li><li><a href=\"https://digitalcollections.nypl.org/\">Storms from a cockpit</a></li><li><a rel=\"noreferrer noopener\" href=\"https://mobile.twitter.com/welcomet0nature/status/1086926308565811200\" target=\"_blank\">South Dakota supercell</a> </li><li><a href=\"https://hotco.co/collections/roman-booteen\">Roman Boteen\'s hobo nickels</a></li><li><a href=\"https://www.cnn.com/style/article/china-photos-19th-century-loewentheil-collection/index.html\">Rare 19th-century images show China at the dawn of photography</a></li><li><a href=\"https://www.rearfront.com/dogs-as-warriors/\">Dogs Re-imagined as Warriors</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Genre Resources</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>General</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Researching historical costs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.thepeoplehistory.com/\">The People\'s History</a> - includes cost of items sold by year</li><li><a href=\"https://blog.chron.com/carsandtrucks/2016/04/cost-of-a-car-in-the-year-you-were-born/\">Cost of Cars by Year</a></li><li><a href=\"https://www.usinflationcalculator.com/\">Inflation Calculator</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.hollowtop.com/spt_html/spt.html\">Society of Primitive Technology</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fantas</strong>y</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Magic: Types of: <a href=\"https://goteenwriters.com/2013/09/06/storyworld-building-types-of-magic/\">1</a>, <a href=\"https://paranormal.lovetoknow.com/clairvoyant-abilities/types-magic\">2</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Building Magic Systems</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://myliteraryquest.wordpress.com/2017/09/08/magic-systems-101-pt-1-why-write-good-magic/\">Why Write Good Magic</a></li><li><a href=\"https://myliteraryquest.wordpress.com/2017/09/13/magic-systems-101-pt-2-hard-magic-vs-soft-magic/\">Hard Magic vs Soft Magic</a></li><li><a href=\"https://myliteraryquest.wordpress.com/2017/09/15/magic-systems-101-pt-3-sandersons-laws-of-magic/\">Sanderson\'s Laws of Magic</a></li><li><a href=\"https://myliteraryquest.wordpress.com/2017/09/19/magic-systems-101-pt-4-literary-magic-systems/\">Literary Magic Systems</a></li><li><a href=\"https://myliteraryquest.wordpress.com/2017/09/25/magic-systems-101-pt-5-create-your-own-magic-system/\">Create Your Own Magic System</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.lunalunamagazine.com/dark/how-to-make-magikal-sachets-with-herbs\">Make Magical Sachets with Herbs</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.writermag.com/improve-your-writing/fiction/writing-magical-realism/\">Writing Magical Realism</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Science Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li> <a rel=\"noreferrer noopener\" href=\"http://www.projectrho.com/public_html/rocket/sfbackground.php\" target=\"_blank\">Atomic Rockets</a> <ul><li><a href=\"http://www.projectrho.com/public_html/rocket/mission.php#id--Tourist_Season\">Starship Travel</a></li></ul></li><li>NASA\'s <a href=\"https://er.jsc.nasa.gov/seh/scifi.html\">Science Fiction \\ Space Technology : Tools for Learning</a> <ul><li><a href=\"https://er.jsc.nasa.gov/seh/SFTerms.html\">Science Fiction Space Technology Terms</a></li></ul></li><li><a href=\"https://www.sciencealert.com/x-ray-pulsar-space-navigation-nasa-world-first-success\">New Space Navigation Technique</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>YA Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li><li><a href=\"https://www.standoutbooks.com/key-ingredients-young-adult-novels/\">5 Key Ingredients All Young Adult Novels Must Have</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Mysteries</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.nypl.org/blog/2017/05/22/arthur-conan-doyle?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\">Arthur Conan Doyle: Researching Crimes and Detectives with NYPL\'s E-Resources</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Romance</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noreferrer noopener\">20 Key Scenes</a></li><li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">The Essential Elements of Writing a Romance Novel</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Futurism</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://futuretodayinstitute.com/\">Future Today Institute</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Writing About Disability</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://disabilityinkidlit.com/\">Disability in Kidlit</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Writing about LGBTQ</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://blog.hubspot.com/marketing/gender-neutral-pronouns\">Gender Neutral Pronouns: What They Are &amp; How to Use Them</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://lgbtrc.usc.edu/trans/transgender/pronouns/\">Gender Neutral Pronouns</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Writing About People of Color and Women</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>As a white author, I\'ve found these resources helpful when developing and writing characters of color.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noreferrer noopener\">Writing the Other Roundtable: How to Stay in Your lane</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>$6 ebook: <a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noreferrer noopener\">Writing the Other: A Practical Approach</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Two excellent articles by Mod Colette:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noreferrer noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li><li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noreferrer noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\">Writing People of Color (if you happen to be a person of another color)</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://writingwithcolor.tumblr.com/Recommendations\">Writing About Color Resources</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://bookriot.com/2018/02/05/casually-racist-things-that-white-authors-do/\" target=\"_blank\" rel=\"noreferrer noopener\">7 Casually Racist Things That White Authors Do</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\">A discussion of describing the skin tone of people of color</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noreferrer noopener\">300 Words to Describe Skin</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.publishersweekly.com/pw/by-topic/columns-and-blogs/soapbox/article/77726-sensitivity-readers-what-are-they-good-for-a-lot.html?utm_source=Publishers+Weekly&amp;utm_campaign=e9fbb28448-EMAIL_CAMPAIGN_2018_08_13_02_56&amp;utm_medium=email&amp;utm_term=0_0bb2959cbb-e9fbb28448-306103905\" target=\"_blank\" rel=\"noreferrer noopener\">Sensitivity Readers! What are they good for?</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Parallel to this topic:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://mobile.twitter.com/lilrednacho/status/909914206270615552\" target=\"_blank\">\"How does kids dressing up as Pocahontas reinforce genocide?\"</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.femalista.com/women-share-the-biggest-mistakes-male-authors-make-with-female-characters/amp/\">Women Share The Biggest Mistakes Male Authors Make With Female Characters</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://writingwithcolor.tumblr.com/Navigation2\">Stereotypes and Tropes Navigation</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://pictorial.jezebel.com/the-problem-of-the-improper-princess-1836498155\">The Problem of the Improper Princess</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Human Coloration</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\">Skin Undertone and Colour Matching</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://everything4writers.tumblr.com/post/98365413596/skin-tones-human-skin-colours-range-from-palest/amp\">Handy Words for Skin Tones</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Eye color </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\">What color are your eyes exactly?</a></li><li><a rel=\"noreferrer noopener\" href=\"https://kathysteinemann.com/Musings/eyes/\" target=\"_blank\">400+ Ways to Describe Eyes</a> </li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\">Red Hair Color Shades</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\">Bodies in Motion</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\">Body language cheat sheets</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://www.modelmanagement.com/\" target=\"_blank\">Model Management</a>:  Great site with models of all shapes, colors and styles from around the world.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Color references</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Writing With Color<br></strong>Color terminology, visual references, and usage.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"align\":\"left\",\"id\":141,\"linkDestination\":\"custom\"} -->\n<div class=\"wp-block-image\"><figure class=\"alignleft\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" class=\"wp-image-141\"/></a></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ingridsnotes.wordpress.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noreferrer noopener\" aria-label=\"Color Thesaurus (opens in a new tab)\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\">Complete list of Crayola Crayon colors.</a> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The Phrontistery\'s <a rel=\"noreferrer noopener\" href=\"http://phrontistery.info/colours.html\" target=\"_blank\">list of \"obscure colour terms.\"</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Software, Apps and Scripts</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>My Favorites</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.literatureandlatte.com/scrivener/overview\">Scrivener</a></li><li><a href=\"https://www.aeontimeline.com/\">Aeon Timeline </a></li><li><a href=\"https://milanote.com/\">Milanote</a>: Offers templates for story outlines, novel plans, character profiles, world building, and story mapping</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Mind-mapping</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.literatureandlatte.com/scapple/overview\">Scapple</a></li><li><a href=\"https://www.mindmeister.com/\">Mind Meister</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.techradar.com/news/best-mind-map-software\" target=\"_blank\">Best mind map software of 2018</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Worldbuilding/Mapping</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li><li><a rel=\"noreferrer noopener\" href=\"http://www.world-machine.com/\" target=\"_blank\">World Machine</a></li><li><a rel=\"noreferrer noopener\" href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\">Terragen</a></li><li><a href=\"https://watabou.itch.io/medieval-fantasy-city-generator\">Fantasy City Generator</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Social Headache Remedies</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://chrome.google.com/webstore/detail/twitter-follower-blocker/clmjfekijbbiblcnelcmmfnlaaancehn?hl=en\" target=\"_blank\">Twitter follower blocker</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Everything Else</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Fact(oid)s</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.forbiddenhistories.com/uromancy-lindsey-fitzharris/\">Divination and medicine</a></li><li><a href=\"http://londonist.com/london/maps/fake-britain-map-fictional-locations-england-scotland-wales\">Fake Britain: A Map Of Fictional Locations In England, Scotland And Wales</a></li><li><a rel=\"noreferrer noopener\" href=\"https://mobile.twitter.com/DrLindseyFitz/status/1083778992052858880\" target=\"_blank\">10 Fascinating Mummies</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster\" target=\"_blank\">Fantastic Beasts and How to Rank Them</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li><li><a rel=\"noreferrer noopener\" href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\">Eight of the Deadliest Assassin Groups in History</a></li><li><a rel=\"noreferrer noopener\" href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\">Nigerian Witch Doctors</a></li><li><a href=\"https://lifehacker.com/here-are-all-the-ways-you-can-dispose-of-a-dead-body-1836055910\">Here Are All the Ways You Can (Legally) Dispose of a Dead Body</a></li><li>Cow-hoof footwear to evade police<ul><li><a href=\"https://kottke.org/12/05/moonshiners-cow-shoes\">Profile of shoe</a></li><li><a href=\"https://www.mentalfloss.com/article/65110/footwear-helped-moonshiners-evade-police\">Bottom view</a></li></ul></li><li><a href=\"https://www.theatlantic.com/science/archive/2018/06/toolmaking-language-brain/562385/\">A Sneaky Theory of Where Language Came From</a></li><li><a href=\"https://www.nytimes.com/2019/11/22/world/asia/the-jungle-prince-of-delhi.html\">Jungle Prince of Delhi</a></li><li><a href=\"https://news.artnet.com/art-world/sorcerer-trove-discovered-pompeii-1623607\">Sorcerer\'s Arsenal of Charms</a></li><li><a href=\"https://gizmodo.com/will-there-ever-be-new-colors-that-we-can-see-1834500228\">Will There Ever Be New Colors That We Can See?</a></li><li><a href=\"http://www.allflorists.co.uk/advice_flowerMeanings.asp\">The Language of Flowers</a></li><li><a href=\"https://www.atlasobscura.com/articles/what-haint-blue-means-to-descendants-enslaved-africans\">What the Color ‘Haint Blue’ Means to the Descendants of Enslaved Africans</a> </li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Terminology</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\">Settlement Hierarchies (names/usage)</a></li><li><a href=\"https://www.hatsunlimited.com/hat-styles-guide/\">Ultimate Hat Guide</a></li><li><a href=\"https://www.thisoldhouse.com/ideas/roof-shapes\">Roof shapes</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Heraldry</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"http://www.internationalheraldry.com/\">International Heraldry and Heralds</a></li><li><a href=\"https://www.heraldsnet.org/saitou/parker/index.htm\">Glossary of terms</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Language</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.nypl.org/blog/2018/08/23/electronic-resources-world-languages\">World Languages Electronic Resources</a></li><li><a href=\"https://ocw.mit.edu/courses/linguistics-and-philosophy/24-917-conlangs-how-to-construct-a-language-fall-2018/index.htm\">ConLang: How to Construct a Language</a> (MIT Open Course)</li><li><a rel=\"noreferrer noopener\" href=\"https://scotlandwelcomesyou.com/scottish-sayings/\" target=\"_blank\">Old Scottish Sayings</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Medieval Life</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://thehistoryofengland.co.uk/resource/medieval-prices-and-wages/\">Medieval Prices and Wages</a></li><li><a href=\"http://medieval.ucdavis.edu/120D/Money.html\">List of Prices of Medieval Items</a></li><li><a href=\"https://www.thebalance.com/gold-price-history-3305646\">Gold Price History from 30 B.C. to Today </a></li><li>Medieval LightingPart <a href=\"http://jillwilliamson.com/2010/01/medieval-facts-lighting-part-one/\">1</a>, <a href=\"http://jillwilliamson.com/2010/01/medieval-facts-lighting-part-two-torches/\">2</a>, <a href=\"http://jillwilliamson.com/2010/05/medieval-facts-lighting-part-three-oil-lamps/\">3</a><br>Examples: <a href=\"http://www.larsdatter.com/lamps.htm\">Lamps</a>, <a href=\"http://www.larsdatter.com/candleholders.htm\">candlesticks</a>, <a href=\"http://www.larsdatter.com/lanterns.htm\">lanterns</a>, <a href=\"http://www.larsdatter.com/torches.htm\">torches</a> (from <a href=\"http://www.larsdatter.com/index.html\">Medieval &amp; Renaissance Material Culture</a>)</li><li><a href=\"http://www.castlewales.com/life.html\">Life in a Medieval Castle</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>History</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li>(A+ series) <a href=\"https://www.theguardian.com/cities/series/the-story-of-cities?page=3\">The Guardian\'s Story of Cities series</a></li><li><a href=\"https://www.neilport.com/2019/04/the-bronze-age-collapse.html\">The Bronze Age Collapse</a></li><li> <a href=\"https://www.wynnchester.com/history-of-the-canvas-bedroll/\">History of the canvas bedroll</a></li><li><a href=\"https://www.iflscience.com/environment/what-was-the-worst-time-to-be-alive-in-human-history/\">When Was the Worst Time to be Alive in Human History</a></li><li><a href=\"https://history.stackexchange.com/questions/14343/did-ancient-medieval-indians-produce-and-consume-alcohol\">Alcohol in Ancient/Medieval India</a></li><li><a href=\"https://www.cnn.com/style/article/turbans-tales-history/index.html\">4,000 Year History of the Turban</a></li><li> <a rel=\"noreferrer noopener\" href=\"https://www.atlasobscura.com/articles/civil-war-salt\" target=\"_blank\">How Salt Helped Win the Civil War</a>&nbsp;- fascinating look at how attacking a food resource impacted the South during the war </li><li>Knights:<ul><li><a href=\"http://www.medieval-life.net/knight_training.htm\">Training a Knight</a></li><li><a href=\"https://timothyrjeveland.com/2019/06/28/why-fantasy-knights-are-unrealistic/\">Why Fantasy Knights are Unrealistic</a></li></ul></li><li>Woman knights:<ul><li><a href=\"https://en.wikipedia.org/wiki/Orders_of_chivalry_for_women\">Orders of Chivalry for Women</a></li><li><a href=\"https://www.heraldica.org/topics/orders/wom-kn.htm\">Women Knights in the Middle Ages</a></li><li><a href=\"https://www.npr.org/2020/01/12/795661047/remains-of-ancient-female-fighters-discovered\">Remains Of Ancient Female Fighters Discovered</a></li></ul></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Weapons</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.thearma.org/essays/weights.htm\">What Did Historical Swords Weigh?</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Clothing</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://bellatory.com/fashion-industry/FashionHistoryoftheHIghandLateMiddleAgesClothingo-the11th-15thCentury\">Fashion History of the High and Late Middle Ages—Medieval Clothing</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.historyundressed.com/2009/06/medieval-ladys-closet.html\">A Medieval Lady\'s Closet</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->','Writing Resources','','publish','closed','closed','','writing-resources','','','2020-02-22 02:40:00','2020-02-22 02:40:00','',0,'https://dmweade.com/welcome/?page_id=39',0,'page','',0),
 (40,1,'2018-07-21 22:40:51','2018-07-21 22:40:51','My resource pages help me keep track of things. I hope you also find them useful.\r\n<table style=\"width: 100%; border-collapse: collapse;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 50%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 50%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li>Find publishers and editors\r\n<a href=\"https://duotrope.com/\">Duotrope</a></li>\r\n 	<li>Average wait time from publishers\r\n<a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a></li>\r\n 	<li>Market overviews\r\n<a href=\"http://www.ralan.com/\">Ralan.com</a></li>\r\n 	<li>Submission tracker\r\n<a href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>The Craft of Writing</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"><img class=\"size-full wp-image-419 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\" alt=\"\" width=\"95\" height=\"150\" /> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\"><img class=\"size-full wp-image-423 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\" alt=\"\" width=\"99\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\"><img class=\"size-full wp-image-420 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><img class=\"size-full wp-image-421 alignnone\" style=\"font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Oxygen-Sans, Ubuntu, Cantarell, \'Helvetica Neue\', sans-serif;\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/dialogue_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\"><img class=\"wp-image-432 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\" alt=\"\" width=\"100\" height=\"150\" /> </a>\r\n\r\n&nbsp;\r\n\r\n<strong>Creativity</strong>\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Writing Science Fiction and Fantasy</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\"><img class=\"size-full wp-image-424 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\" alt=\"\" width=\"97\" height=\"150\" /></a> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\"><img class=\"size-full wp-image-425 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\" alt=\"\" width=\"98\" height=\"150\" /></a>','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-07-21 22:40:51','2018-07-21 22:40:51','',39,'https://dmweade.com/welcome/2018/07/21/39-revision-v1/',0,'revision','',0),
 (219,1,'2018-09-01 01:20:08','2018-09-01 01:20:08','<p style=\"text-align: center;\"><strong>A repository of articles and resources I\'ve collected over the years\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writers</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\nThe Professional Author\r\n<ul>\r\n 	<li><a href=\"https://www.publishersweekly.com/pw/print/20180723/77564-what-authors-and-editors-wish-they-could-say-to-one-another.html\" target=\"_blank\" rel=\"noopener\">What Authors and Editors Wish They Could Say to One Another</a></li>\r\n 	<li><a href=\"https://greenleafbookgroup.com/learning-center/publishing-information/what-publishers-want\" target=\"_blank\" rel=\"noopener\">What Publishers Want</a> - Greenleaf Book Group</li>\r\n 	<li><a href=\"https://www.hubspot.com/make-my-persona\" target=\"_blank\" rel=\"noopener\">Create a Buyer Persona</a> - Hubspot\'s tool to identify your core audience</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://cdn.prowritingaid.com/ebook/ProWritingAid_EBook2.pdf\" target=\"_blank\" rel=\"noopener\">Novel Writing Training Plan</a> by Pro Writing Aid</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Self Promotion / Building a Platform</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging</a></li>\r\n 	<li style=\"text-align: left;\">Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://writingcooperative.com/how-to-build-your-own-author-platform-from-scratch-9d6123858bac\" target=\"_blank\" rel=\"noopener\">How to Build your own author platform - from scratch</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://growthtools.com/#tools\" target=\"_blank\" rel=\"noopener\">Growth Tools</a> - Grow your online business</li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://thewritepractice.com/building-an-author-website/\" target=\"_blank\" rel=\"noopener\">Building an Author Website: The First Step to Publishing</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n 	<li><a href=\"http://www.ian-irvine.com/on-writing/41-ways-to-create-and-heighten-suspense/\" target=\"_blank\" rel=\"noopener\">41 Ways to Create and Heighten Suspense</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/eight-absurdities-we-force-on-female-characters/\" target=\"_blank\" rel=\"noopener\">8 Absurdities we Force on Female Characters</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n 	<li><a href=\"https://io9.gizmodo.com/7-deadly-sins-of-worldbuilding-998817537\" target=\"_blank\" rel=\"noopener\">7 Deadly Sins of Worldbuilding</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/five-common-worldbuilding-mistakes-in-new-manuscripts/\" target=\"_blank\" rel=\"noopener\">5 Common Worldbuilding Mistakes in New Manuscripts</a> (and a great blog)</li>\r\n 	<li><a href=\"https://mythcreants.com/blog/creating-a-mountain-setting/\" target=\"_blank\" rel=\"noopener\">Creating a Mountain Setting</a></li>\r\n 	<li><a href=\"https://nybookeditors.com/2017/07/fantasy-world-building-101-create-breathing-world-fantasy-novel/\" target=\"_blank\" rel=\"noopener\">Fantasy World Building 101: how to create a breathing world for your fantasy novel</a></li>\r\n 	<li>Worldbuilding Guide: <em>Excellent process</em>\r\n<ul>\r\n 	<li><a href=\"https://www.lostkingdom.net/worldbuilding-guide-1/\" target=\"_blank\" rel=\"noopener\">Part 1</a>, <a href=\"http://www.lostkingdom.net/worldbuilding-guide-2/\" target=\"_blank\" rel=\"noopener\">Part 2</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-introduction/\" target=\"_blank\" rel=\"noopener\">Fantasy Economics 101</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-labour-and-wages/\" target=\"_blank\" rel=\"noopener\">Economics: labour and wages</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://electricliterature.com/against-worldbuilding-700e4861c26b\" target=\"_blank\" rel=\"noopener\">Against Worldbuilding</a> (caused quite a ruckus)</li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2013/09/17/25-things-you-should-know-about-worldbuilding/\" target=\"_blank\" rel=\"noopener\">25 Things You Should Know About Worldbuilding</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.powerthesaurus.org/\" target=\"_blank\" rel=\"noopener\">Power Thesaurus</a></li>\r\n 	<li><a href=\"https://english.stackexchange.com/\" target=\"_blank\" rel=\"noopener\">English Language and Usage Q&amp;A</a></li>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n 	<li><a href=\"http://moby.com/la1/\" target=\"_blank\" rel=\"noopener\">Long Ambients1: Calm. Sleep.</a> by Moby (free music)</li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.atlasobscura.com/articles/pies-that-look-like-people\" target=\"_blank\" rel=\"noopener\">People Pot Pies</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow. Here are some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 17.7674%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 2.13958%;\"></td>\r\n<td style=\"width: 80.093%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 39.7829%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 2.29462%;\"></td>\r\n<td style=\"width: 57.9225%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n<ul>\r\n 	<li>$6 ebook: <a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other: A Practical Approach</a></li>\r\n</ul>\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://bookriot.com/2018/02/05/casually-racist-things-that-white-authors-do/\" target=\"_blank\" rel=\"noopener\">7 Casually Racist Things That White Authors Do</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\n<a href=\"https://www.publishersweekly.com/pw/by-topic/columns-and-blogs/soapbox/article/77726-sensitivity-readers-what-are-they-good-for-a-lot.html?utm_source=Publishers+Weekly&amp;utm_campaign=e9fbb28448-EMAIL_CAMPAIGN_2018_08_13_02_56&amp;utm_medium=email&amp;utm_term=0_0bb2959cbb-e9fbb28448-306103905\" target=\"_blank\" rel=\"noopener\">Sensitivity Readers! What are they good for?</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\nFinding characters\r\n<ul>\r\n 	<li><a href=\"https://www.modelmanagement.com/\" target=\"_blank\" rel=\"noopener\">Model Management</a>: Too many authors use famous actors to give flesh to their characters. Search by nation for different looks and and facial types.</li>\r\n</ul>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>History and Interesting Fact(oid)s</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Terminology</strong>\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n<strong>Language</strong>\r\n<ul>\r\n 	<li><a href=\"https://scotlandwelcomesyou.com/scottish-sayings/\" target=\"_blank\" rel=\"noopener\">Old Scottish Sayings</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-09-01 01:20:08','2018-09-01 01:20:08','',39,'https://dmweade.com/welcome/2018/09/01/39-revision-v1/',0,'revision','',0),
 (222,1,'2018-09-03 23:46:55','2018-09-03 23:46:55','<p style=\"text-align: center;\"><strong>A repository of articles and resources I\'ve collected over the years\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writers</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>The Professional Author</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.publishersweekly.com/pw/print/20180723/77564-what-authors-and-editors-wish-they-could-say-to-one-another.html\" target=\"_blank\" rel=\"noopener\">What Authors and Editors Wish They Could Say to One Another</a></li>\r\n 	<li><a href=\"https://greenleafbookgroup.com/learning-center/publishing-information/what-publishers-want\" target=\"_blank\" rel=\"noopener\">What Publishers Want</a> - Greenleaf Book Group</li>\r\n 	<li><a href=\"https://www.hubspot.com/make-my-persona\" target=\"_blank\" rel=\"noopener\">Create a Buyer Persona</a> - Hubspot\'s tool to identify your core audience</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://cdn.prowritingaid.com/ebook/ProWritingAid_EBook2.pdf\" target=\"_blank\" rel=\"noopener\">Novel Writing Training Plan</a> by Pro Writing Aid</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Self Promotion / Building a Platform</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging</a></li>\r\n 	<li style=\"text-align: left;\">Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://writingcooperative.com/how-to-build-your-own-author-platform-from-scratch-9d6123858bac\" target=\"_blank\" rel=\"noopener\">How to Build your own author platform - from scratch</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://growthtools.com/#tools\" target=\"_blank\" rel=\"noopener\">Growth Tools</a> - Grow your online business</li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://thewritepractice.com/building-an-author-website/\" target=\"_blank\" rel=\"noopener\">Building an Author Website: The First Step to Publishing</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Marketing Books</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://kindlepreneur.com/kindle-keywords-fiction-author-strategy/\" target=\"_blank\" rel=\"noopener\">Kindle Keyword Strategies for Fiction Authors</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n 	<li><a href=\"http://www.ian-irvine.com/on-writing/41-ways-to-create-and-heighten-suspense/\" target=\"_blank\" rel=\"noopener\">41 Ways to Create and Heighten Suspense</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/eight-absurdities-we-force-on-female-characters/\" target=\"_blank\" rel=\"noopener\">8 Absurdities we Force on Female Characters</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n 	<li><a href=\"https://io9.gizmodo.com/7-deadly-sins-of-worldbuilding-998817537\" target=\"_blank\" rel=\"noopener\">7 Deadly Sins of Worldbuilding</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/five-common-worldbuilding-mistakes-in-new-manuscripts/\" target=\"_blank\" rel=\"noopener\">5 Common Worldbuilding Mistakes in New Manuscripts</a> (and a great blog)</li>\r\n 	<li><a href=\"https://mythcreants.com/blog/creating-a-mountain-setting/\" target=\"_blank\" rel=\"noopener\">Creating a Mountain Setting</a></li>\r\n 	<li><a href=\"https://nybookeditors.com/2017/07/fantasy-world-building-101-create-breathing-world-fantasy-novel/\" target=\"_blank\" rel=\"noopener\">Fantasy World Building 101: how to create a breathing world for your fantasy novel</a></li>\r\n 	<li>Worldbuilding Guide: <em>Excellent process</em>\r\n<ul>\r\n 	<li><a href=\"https://www.lostkingdom.net/worldbuilding-guide-1/\" target=\"_blank\" rel=\"noopener\">Part 1</a>, <a href=\"http://www.lostkingdom.net/worldbuilding-guide-2/\" target=\"_blank\" rel=\"noopener\">Part 2</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-introduction/\" target=\"_blank\" rel=\"noopener\">Fantasy Economics 101</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-labour-and-wages/\" target=\"_blank\" rel=\"noopener\">Economics: labour and wages</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://electricliterature.com/against-worldbuilding-700e4861c26b\" target=\"_blank\" rel=\"noopener\">Against Worldbuilding</a> (caused quite a ruckus)</li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2013/09/17/25-things-you-should-know-about-worldbuilding/\" target=\"_blank\" rel=\"noopener\">25 Things You Should Know About Worldbuilding</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.powerthesaurus.org/\" target=\"_blank\" rel=\"noopener\">Power Thesaurus</a></li>\r\n 	<li><a href=\"https://english.stackexchange.com/\" target=\"_blank\" rel=\"noopener\">English Language and Usage Q&amp;A</a></li>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n 	<li><a href=\"http://moby.com/la1/\" target=\"_blank\" rel=\"noopener\">Long Ambients1: Calm. Sleep.</a> by Moby (free music)</li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.texturemate.com/index.php/\" target=\"_blank\" rel=\"noopener\">Texture repository</a></li>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.atlasobscura.com/articles/pies-that-look-like-people\" target=\"_blank\" rel=\"noopener\">People Pot Pies</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow. Here are some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 17.7674%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 2.13958%;\"></td>\r\n<td style=\"width: 80.093%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 39.7829%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 2.29462%;\"></td>\r\n<td style=\"width: 57.9225%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n<ul>\r\n 	<li>$6 ebook: <a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other: A Practical Approach</a></li>\r\n</ul>\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://bookriot.com/2018/02/05/casually-racist-things-that-white-authors-do/\" target=\"_blank\" rel=\"noopener\">7 Casually Racist Things That White Authors Do</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\n<a href=\"https://www.publishersweekly.com/pw/by-topic/columns-and-blogs/soapbox/article/77726-sensitivity-readers-what-are-they-good-for-a-lot.html?utm_source=Publishers+Weekly&amp;utm_campaign=e9fbb28448-EMAIL_CAMPAIGN_2018_08_13_02_56&amp;utm_medium=email&amp;utm_term=0_0bb2959cbb-e9fbb28448-306103905\" target=\"_blank\" rel=\"noopener\">Sensitivity Readers! What are they good for?</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\nFinding characters\r\n<ul>\r\n 	<li><a href=\"https://www.modelmanagement.com/\" target=\"_blank\" rel=\"noopener\">Model Management</a>: Too many authors use famous actors to give flesh to their characters. Search by nation for different looks and and facial types.</li>\r\n</ul>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>History and Interesting Fact(oid)s</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Terminology</strong>\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n<strong>Language</strong>\r\n<ul>\r\n 	<li><a href=\"https://scotlandwelcomesyou.com/scottish-sayings/\" target=\"_blank\" rel=\"noopener\">Old Scottish Sayings</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-09-03 23:46:55','2018-09-03 23:46:55','',39,'https://dmweade.com/welcome/2018/09/03/39-revision-v1/',0,'revision','',0),
 (329,1,'2019-04-13 01:23:41','2019-04-13 01:23:41','<p style=\"text-align: left;\">Now over a year since I built a Tevo Tarantula, but it\'s been a crazy one and I\'ve yet to put it to use. Time to get going, starting with collecting my information and making a plan. Recommendations always welcome if you run across this page.</p>\n<p style=\"text-align: center;\">_________________</p>\n<p style=\"text-align: center;\"><strong>Choosing and Building</strong></p>\n<table>\n<tbody>\n<tr>\n<td>\n<p><strong>Choosing a Printer</strong><br /><a href=\"https://www.productchart.com/3d_printers/\" target=\"_blank\" rel=\"noopener noreferrer\">3D Printer Product Chart</a></p>\n<p><strong>Enclosures<br /></strong><a href=\"https://www.thingiverse.com/thing:2792618\">Smart enclosure</a></p>\n<p><strong>Storage/organization<br /></strong>Poor man\'s polybox (by <a href=\"https://www.facebook.com/rwarwqerwqer?fref=gs&amp;hc_ref=ARSbYY5WmlcdREC7rwKx6frURtGQ-rfSgHYAVuxAC53Kr4Qcy2-CWloIptE-pFc_Of0&amp;dti=197938987045417&amp;hc_location=group\" target=\"_blank\" rel=\"noopener noreferrer\">Rich Lee</a>) - <a href=\"https://www.thingiverse.com/thing:2818547\" target=\"_blank\" rel=\"noopener noreferrer\">https://www.thingiverse.com/thing:2818547</a></p>\n<ul>\n<li><a href=\"https://smile.amazon.com/gp/product/B007V4IWIU/r\" target=\"_blank\" rel=\"noopener noreferrer\">Snapware 40-cup Airtight container</a></li>\n<li><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=4mm+pneumatic+connectors+push+fit\" target=\"_blank\" rel=\"noopener noreferrer\">4mm Pneumatic connectors (\"Push Fit\")</a></li>\n<li><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing&amp;rh=i%3Aaps%2Ck%3A2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing\" target=\"_blank\" rel=\"noopener noreferrer\">2mm ID / 4mm OD PTFE (Teflon™) Tubing</a></li>\n</ul>\n</td>\n<td>\n<p><strong>Tevo Tarantula Upgrades<br /></strong><a href=\"https://www.thingiverse.com/thing:2480577\" target=\"_blank\" rel=\"noopener noreferrer\">EZ gimbal for z-banding</a></p>\n<p>Cable management: <a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1894586220635343/\" target=\"_blank\" rel=\"noopener noreferrer\">one</a>, <a href=\"https://smile.amazon.com/dp/B0785LH2DC/ref=tsm_1_fb_lk?sa-no-redirect=1\" target=\"_blank\" rel=\"noopener noreferrer\">Stepper cables</a>, <a href=\"https://www.thingiverse.com/thing:2878127\" target=\"_blank\" rel=\"noopener noreferrer\">Spool weight measurement</a>,</p>\n<p><a href=\"https://3dprint.wiki/reprap/electronics/heatbed_mosfet\" target=\"_blank\" rel=\"noopener noreferrer\">How to Connect Your Hotbed to a Mosfet</a></p>\n<p><a href=\"https://m.aliexpress.com/item/32839714006.html?trace=wwwdetail2mobilesitedetail&amp;productId=32839714006&amp;productSubject=Random-Black-White-Blue-2meter-6mm-Flat-Seal-2020-Aluminum-Profile-Slot-Cover-Panel-Holder-For&amp;aff_platform=link-c-tool&amp;cpt=1519665605635&amp;sk=jA6URzB&amp;aff_trace_key=98f848353aa440eb95f00c86e4a50c9a-1519665605635-09573-jA6URzB&amp;terminal_id=29d0825156634f92a8c46080751efb13\" target=\"_blank\" rel=\"noopener noreferrer\">T-slotted Extrusion Bar Covers</a></p>\n<p><a href=\"https://hackaday.com/2018/04/12/to-ferrule-or-not-to-ferrule/\">To Ferrule or Not to Ferrule? (wire ends)</a></p>\n<p><strong>Filament</strong><br /><a href=\"https://www.facebook.com/groups/makerbot/permalink/1656440171140147/\" target=\"_blank\" rel=\"noopener noreferrer\">PLA suggestions</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p style=\"text-align: center;\"><strong>Troubleshooting</strong></p>\n<table>\n<tbody>\n<tr>\n<td>\n<p><strong>Calibration<br /></strong><a href=\"https://3dprint.com/207828/103dp-calibration-test-prints/\" target=\"_blank\" rel=\"noopener noreferrer\">Ten 3D Printable Calibration &amp; Test Print Things</a></p>\n<p> </p>\n</td>\n<td>\n<p><strong>Managing Errors<br /></strong><a href=\"https://www.thingiverse.com/thing:2814724\">Filament runout sensor</a></p>\n<p><a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1722003637893603/\">Z-banding</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p style=\"text-align: center;\"><strong>Things to Print</strong></p>\n<table style=\"width: 835px;\">\n<tbody>\n<tr>\n<td style=\"width: 416px;\">\n<p><strong>Fun Ideas to Try<br /></strong><a href=\"https://www.instructables.com/id/How-to-3D-Print-Onto-Fabric/\">Print onto Fabric</a></p>\n<p><a href=\"https://n-e-r-v-o-u-s.com/blog/?p=8011\" target=\"_blank\" rel=\"noopener noreferrer\">Self forming structures on pre-stretched fabric</a></p>\n<p><a href=\"https://phys.org/news/2018-06-d-printer-physical.html\">3D Printing Data Sets</a></p>\n</td>\n<td style=\"width: 411px;\">\n<p><strong>Household Items<br /></strong><a href=\"http://www.geeetech.com/blog/2018/03/8-diy-3d-prints-for-every-kitchen/\" target=\"_blank\" rel=\"noopener noreferrer\">Kitchen items list</a></p>\n<p> </p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n\n<!-- wp:themify-builder/canvas /-->','3D Printing Resources','','inherit','closed','closed','','86-revision-v1','','','2019-04-13 01:23:41','2019-04-13 01:23:41','',86,'https://dmweade.com/welcome/2019/04/13/86-revision-v1/',0,'revision','',0),
 (73,1,'2018-08-09 13:50:11','2018-08-09 13:50:11','','fox-face-logo-64x64','','inherit','open','closed','','fox-face-logo-64x64','','','2018-08-09 13:50:11','2018-08-09 13:50:11','',0,'https://dmweade.com/welcome/wp-content/uploads/2018/08/fox-face-logo-64x64.png',0,'attachment','image/png',0),
 (119,1,'2018-08-11 02:06:38','2018-08-11 02:06:38','Design elements for creatives.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 516px;\">\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li>Just images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Just icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Just fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nOther lists:\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\">Growth Supply</a></li>\r\n 	<li><a href=\"https://www.reddit.com/r/AskReddit/comments/8gy4nd/what_are_some_cool_websites_where_you_can/\">Reddit: What are some cool websites where you can download free stuff?</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-11 02:06:38','2018-08-11 02:06:38','',35,'https://dmweade.com/welcome/2018/08/11/35-revision-v1/',0,'revision','',0),
 (82,1,'2018-08-10 00:42:28','2018-08-10 00:42:28','My resource pages help me keep track of things. I hope you also find them useful.\r\n<table style=\"width: 100%; border-collapse: collapse;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 50%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 50%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li>Find publishers and editors\r\n<a href=\"https://duotrope.com/\">Duotrope</a></li>\r\n 	<li>Average wait time from publishers\r\n<a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a></li>\r\n 	<li>Market overviews\r\n<a href=\"http://www.ralan.com/\">Ralan.com</a></li>\r\n 	<li>Submission tracker\r\n<a href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>The Craft of Writing</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"><img class=\"size-full wp-image-419 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\" alt=\"\" width=\"95\" height=\"150\" /> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\"><img class=\"size-full wp-image-423 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\" alt=\"\" width=\"99\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\"><img class=\"size-full wp-image-420 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><img class=\"size-full wp-image-421 alignnone\" style=\"font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Oxygen-Sans, Ubuntu, Cantarell, \'Helvetica Neue\', sans-serif;\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/dialogue_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\"><img class=\"wp-image-432 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\" alt=\"\" width=\"100\" height=\"150\" /> </a>\r\n\r\n&nbsp;\r\n\r\n<strong>Creativity</strong>\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Writing Science Fiction and Fantasy</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\"><img class=\"size-full wp-image-424 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\" alt=\"\" width=\"97\" height=\"150\" /></a> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\"><img class=\"size-full wp-image-425 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\" alt=\"\" width=\"98\" height=\"150\" /></a>','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-10 00:42:28','2018-08-10 00:42:28','',39,'https://dmweade.com/welcome/2018/08/10/39-revision-v1/',0,'revision','',0),
 (83,1,'2018-08-10 00:49:55','2018-08-10 00:49:55','','For Creating','','publish','closed','closed','','83','','','2020-04-24 17:51:31','2020-04-24 17:51:31','',0,'https://dmweade.com/welcome/?p=83',2,'nav_menu_item','',0),
 (84,1,'2018-08-10 00:49:55','2018-08-10 00:49:55','','For Writing','','publish','closed','closed','','84','','','2020-04-24 17:51:31','2020-04-24 17:51:31','',0,'https://dmweade.com/welcome/?p=84',1,'nav_menu_item','',0),
 (86,2,'2018-08-10 01:26:29','2018-08-10 01:26:29','<!-- wp:paragraph -->\n<p>Link recommendations always welcome.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Choosing and Building</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Choosing a Printer</strong><br><a href=\"https://www.productchart.com/3d_printers/\" target=\"_blank\" rel=\"noreferrer noopener\">3D Printer Product Chart</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Enclosures<br></strong><a href=\"https://www.thingiverse.com/thing:2792618\">Smart enclosure</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.fabbaloo.com/blog/2015/3/1/finally-a-3d-printer-filter-accessory\">Enclosure filter</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.htgsupply.com/products/the-watch-dog-automatic-fire-extinguisher-2-kg/\">Watchdog Fire Extinguisher</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Materials (filament)<br></strong><a href=\"https://www.facebook.com/groups/makerbot/permalink/1656440171140147/\" target=\"_blank\" rel=\"noreferrer noopener\">PLA suggestions</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://all3dp.com/1/petg-filament-3d-printing/\">PetG Filament Overview</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.tomsguide.com/us/3d-printing-materials,news-24392.html\">3D Printing Materials: Pros and Cons</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.feel-color.com/3d-filament-pla-anthracite-grey?___store=en_en&amp;___from_store=en_en\">Anthracite Grey PLA</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://all3dp.com/2/how-to-dry-filament-pla-abs-and-nylon/\">How to Dry Filament</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://letsprint3d.net/2018/04/20/how-to-make-a-filament-dryer/\">Build a $30 Filament Dryer</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://all3dp.com/1/pla-filament-3d-printing/\">PLA Filament Guide</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://all3dp.com/1/3d-printer-filament-types-3d-printing-3d-filament/#basic\">3D Printer Filament Guide</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Software</strong><br><a href=\"https://www.tinkercad.com/\">Tinkercad</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Tevo Tarantula Upgrades<br></strong><a href=\"https://www.thingiverse.com/thing:2480577\" target=\"_blank\" rel=\"noreferrer noopener\">EZ gimbal for z-banding</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Cable management: <a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1894586220635343/\" target=\"_blank\" rel=\"noreferrer noopener\">one</a>, <a href=\"https://smile.amazon.com/dp/B0785LH2DC/ref=tsm_1_fb_lk?sa-no-redirect=1\" target=\"_blank\" rel=\"noreferrer noopener\">Stepper cables</a>, <a href=\"https://www.thingiverse.com/thing:2878127\" target=\"_blank\" rel=\"noreferrer noopener\">Spool weight measurement</a>,</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://github.com/JimBrown/MarlinTarantula\" target=\"_blank\" rel=\"noreferrer noopener\">Marlin firmware</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://3dprint.wiki/reprap/electronics/heatbed_mosfet\" target=\"_blank\" rel=\"noreferrer noopener\">How to Connect Your Hotbed to a Mosfet</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://m.aliexpress.com/item/32839714006.html?trace=wwwdetail2mobilesitedetail&amp;productId=32839714006&amp;productSubject=Random-Black-White-Blue-2meter-6mm-Flat-Seal-2020-Aluminum-Profile-Slot-Cover-Panel-Holder-For&amp;aff_platform=link-c-tool&amp;cpt=1519665605635&amp;sk=jA6URzB&amp;aff_trace_key=98f848353aa440eb95f00c86e4a50c9a-1519665605635-09573-jA6URzB&amp;terminal_id=29d0825156634f92a8c46080751efb13\" target=\"_blank\" rel=\"noreferrer noopener\">T-slotted Extrusion Bar Covers</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://hackaday.com/2018/04/12/to-ferrule-or-not-to-ferrule/\">To Ferrule or Not to Ferrule? (wire ends)</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://all3dp.com/1/tevo-tarantula-upgrades-mods/\">26 Tarantula upgrades</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://all3dp.com/1/tevo-tornado-upgrades-mods-3d-printer/\">19 Must-have Tarantula upgrades</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Storage/organization<br></strong>Poor man\'s polybox (by <a href=\"https://www.facebook.com/rwarwqerwqer?fref=gs&amp;hc_ref=ARSbYY5WmlcdREC7rwKx6frURtGQ-rfSgHYAVuxAC53Kr4Qcy2-CWloIptE-pFc_Of0&amp;dti=197938987045417&amp;hc_location=group\" target=\"_blank\" rel=\"noreferrer noopener\">Rich Lee</a>) -&nbsp;<a href=\"https://www.thingiverse.com/thing:2818547\" target=\"_blank\" rel=\"noreferrer noopener\">https://www.thingiverse.com/thing:2818547</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://smile.amazon.com/gp/product/B007V4IWIU/r\" target=\"_blank\" rel=\"noreferrer noopener\">Snapware 40-cup Airtight container</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=4mm+pneumatic+connectors+push+fit\" target=\"_blank\" rel=\"noreferrer noopener\">4mm Pneumatic connectors (\"Push Fit\")</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing&amp;rh=i%3Aaps%2Ck%3A2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing\" target=\"_blank\" rel=\"noreferrer noopener\">2mm ID / 4mm OD PTFE (Teflon™) Tubing</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Troubleshooting</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Managing Errors</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.thingiverse.com/thing:2814724\">Filament runout sensor</a></li><li><a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1722003637893603/\">Z-banding</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Calibration</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://3dprint.com/207828/103dp-calibration-test-prints/\" target=\"_blank\">Ten 3D Printable Calibration &amp; Test Print Things</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a href=\"https://m.all3dp.com/1/common-3d-printing-problems-troubleshooting-3d-printer-issues/\">41 Common Problems</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.simplify3d.com/support/print-quality-troubleshooting/\">Print Quality Troubleshooting Guide</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.antonmansson.com/how-to-cold-pull-clogged-nozzle/\">How to Cold-pull a Clogged Nozzle</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Things to Print</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>3D Model Sites</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.myminifactory.com/\">MyMiniFactory</a></li><li><a rel=\"noreferrer noopener\" href=\"https://fab365.net/\" target=\"_blank\">Fab365</a></li><li><a href=\"https://www.thingiverse.com\">Thingiverse</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Ideas to Try</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.instructables.com/id/How-to-3D-Print-Onto-Fabric/\">Print onto Fabric</a></li><li><a rel=\"noreferrer noopener\" href=\"https://n-e-r-v-o-u-s.com/blog/?p=8011\" target=\"_blank\">Self forming structures on pre-stretched fabric</a></li><li><a href=\"https://phys.org/news/2018-06-d-printer-physical.html\">3D Printing Data Sets</a></li><li><a href=\"https://www.myminifactory.com/object/3d-print-cubemail-bowl-49476\">Cubemail Fabric</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Household Items</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"http://www.geeetech.com/blog/2018/03/8-diy-3d-prints-for-every-kitchen/\" target=\"_blank\">Kitchen items list</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Toys</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://cults3d.com/en/3d-model/art/owl-tower-harry-potter?utm_source=social&amp;utm_medium=owlery\">Harry Potter Tower</a></li><li><a href=\"https://printabrick.org/\">Print-a-brick</a></li><li><a href=\"https://fab365.net/items/145\">Foldable car</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Machines</strong><br><a href=\"https://www.yankodesign.com/2019/02/07/you-can-now-3d-print-your-own-iconic-bladeless-fan/\">Bladeless Fans</a><br><a href=\"https://www.thingiverse.com/search?q=clock&amp;dwh=15cb3d020cda08\" target=\"_blank\" rel=\"noreferrer noopener\">Clocks</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Everything Else</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Research</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://dyzedesign.com/2016/10/printing-300-mm-s-part-1-basics-hardware/\">Printing at 300 mm/s</a></li><li><a href=\"https://hackaday.com/2017/03/24/half-baked-idea-put-your-pla-in-the-oven/\">Baking PLA for Strength</a></li><li><a href=\"https://pinshape.com/blog/3d-printing-food-safe/\">10 things you need to know about 3D printing &amp; food safety</a></li><li><a href=\"https://www.instructables.com/id/Pinya3-a-3d-food-printer-platform/\">3D Food Printer Platform</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Printing to Help People</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.theverge.com/2019/3/12/18261893/ikea-thisables-3d-printed-add-ons-people-with-disabilities\">Ikea’s 3D-printed add-ons make its furniture more accessible for people with disabilities</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Software</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.aniwaa.com/best-3d-scanning-apps-smartphones/\">8 Best 3D Scanning Apps</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','3D Printing Resources','','publish','closed','closed','','3d-printing-resources','','','2020-01-21 21:21:44','2020-01-21 21:21:44','',0,'https://dmweade.com/welcome/?page_id=86',0,'page','',0),
 (87,1,'2018-08-10 00:55:32','2018-08-10 00:55:32','3D Printing Re','3D Printing Resources','','inherit','closed','closed','','86-revision-v1','','','2018-08-10 00:55:32','2018-08-10 00:55:32','',86,'https://dmweade.com/welcome/2018/08/10/86-revision-v1/',0,'revision','',0),
 (88,1,'2018-08-10 00:55:35','2018-08-10 00:55:35','','3D Printing Resources','','inherit','closed','closed','','86-revision-v1','','','2018-08-10 00:55:35','2018-08-10 00:55:35','',86,'https://dmweade.com/welcome/2018/08/10/86-revision-v1/',0,'revision','',0),
 (89,2,'2018-08-10 01:27:09','2018-08-10 01:27:09','','Scrivener Resources','','private','closed','closed','','scrivener-resources','','','2020-01-12 19:03:51','2020-01-12 19:03:51','',0,'https://dmweade.com/welcome/?page_id=89',0,'page','',0),
 (90,1,'2018-08-10 01:27:09','2018-08-10 01:27:09','','Scrivener Resources','','inherit','closed','closed','','89-revision-v1','','','2018-08-10 01:27:09','2018-08-10 01:27:09','',89,'https://dmweade.com/welcome/2018/08/10/89-revision-v1/',0,'revision','',0),
 (231,1,'2018-09-15 00:48:09','2018-09-15 00:48:09','','3D Printing Resources','','inherit','closed','closed','','86-revision-v1','','','2018-09-15 00:48:09','2018-09-15 00:48:09','',86,'https://dmweade.com/welcome/2018/09/15/86-revision-v1/',0,'revision','',0),
 (97,1,'2018-08-17 17:03:06','2018-08-17 17:03:06','I\'ve now been writing for over a decade, slowly growing through learning and practice. My current project has reached its fourth major revision. Won\'t be the last, but it does feel like the most important so far due to finally feeling my craft has developed to where I can keep track of all the threads I\'m weaving into the story such as what the character is experiencing, what the reader needs to know, and how the current scene links to the overall plot - not just the current book, but across the series, and other important threads.\r\n\r\nI recall hearing once that the only way to reach publishing quality is to hone yourself like an athlete, who much develop their endurance, work on their gait, develop timing, and maintain healthy self-care rutuals. I\'ve focused on those, but the most important skill I\'ve developed appears to be measuring how well I\'m capturing the feeling of the piece.\r\n\r\nI\'m sure there are better terms to describe my point than the \"feeling,\" which changes with each work and is often expected within the genre. Sometimes the name of the genre captures the element, like Horror in which the reader maintains a constant feeling of unease. Thrillers are similar, keeping the reader\'s heart racing. Most all genres engage the mind, but a Mystery promises to keep us engaged sifting through evidence and comments and hints to figure out \"Who done it?\" And there\'s Romance, through which the reader\'s heart is tugged in a different way.\r\n\r\nSometimes a series captures many feelings, such as Louis L\'Amore\'s Sackett series in which he captures the early days of America from Barnabas Sackett leaving England for the New World to arrive and cross the Blue Ridge Mountains before leaping to the the Civil War era.\r\n\r\nWith Harry Potter, J.K. Rowling follows the protagonist through his discovery of the Wizarding World through to the final battles against Voldemort, spicing the series with horror, mystery and thrills galore. In addition to our own sense of wonder with each new discovery, we get to experience Harry\'s fascination as well. Plus the horror of Voldemort, the thrill of the Horcruxes, and the many mysteries the kids must unravel to survive and eventually defeat the dark wizard.\r\n\r\nFilm and television falls into the same genres.\r\n\r\n&nbsp;','Crafting Words to Capture the Essence','','draft','open','open','','crafting-words-to-capture-the-essence','','','2018-08-17 18:34:58','2018-08-17 18:34:58','',0,'https://dmweade.com/welcome/?p=97',0,'post','',0),
 (98,1,'2018-08-10 12:53:56','2018-08-10 12:53:56','','Bilbo at Bag End','','inherit','open','closed','','bilbo-at-bag-end','','','2018-08-10 12:54:00','2018-08-10 12:54:00','',97,'https://dmweade.com/welcome/wp-content/uploads/2018/08/Bilbo-at-Bag-End.jpg',0,'attachment','image/jpeg',0),
 (99,1,'2018-08-10 13:13:27','2018-08-10 13:13:27','My main focus for several years has been the craft of writing. My oldest dream, second only to the boyhood desire to grow up and be their fathers, is to be a published author. Even that objective has softened in the age of self-publishing, yet the desire to see my name on a book on a shelf in a bookstore or library remains strong.\n\nThe only path to success in anything is growth through consistent learning and practice. Writing is no different.\n\nI\'m working on a major revision of my first novel at the moment, the fourth major revision overall. This won\'t be the last, but it feels like the most important so far. This is due to finally building the skill to keep all the necessary viewpoints in my RAM (memory) at the same time. These include, but are not limited to, what the character is experiencing, what the reader needs to know, how the current scene links into the overall plot - not just the current book, but across the series.\n\nBuilding these skills is similar to an athlete developing their endurance, gait, timing and self-care rituals toward something elite. But of the skills I\'ve developed, the best and most important may be a better sense of measuring how well I\'m crafting toward capturing the feeling of the piece.\n\nI\'m sure there are better terms to describe this, maybe by genre. The name of the genre sometimes speaks for itself, like Horror in which the reader maintains a constant feeling of unease. Sometimes a series captures the feeling, such as Louis L\'Amore\'s Sackett family series in which he captures the early days of America from Barnabas Sackett leaving England for the New World through the family\'s adventures as they moved westward.','Crafting Words to Capture the Essence','','inherit','closed','closed','','97-revision-v1','','','2018-08-10 13:13:27','2018-08-10 13:13:27','',97,'https://dmweade.com/welcome/2018/08/10/97-revision-v1/',0,'revision','',0),
 (100,1,'2018-08-10 17:20:25','2018-08-10 17:20:25','I\'ve now been writing for over a decade, slowly growing through learning and practice. My current project has reached its fourth major revision. Won\'t be the last, but it does feel like the most important so far due to finally feeling my craft has developed to where I can keep track of all the threads I\'m weaving into the story such as what the character is experiencing, what the reader needs to know, and how the current scene links to the overall plot - not just the current book, but across the series, and other important threads.\n\nI recall hearing once that the only way to reach publishing quality is to hone yourself like an athlete, who much develop their endurance, work on their gait, develop timing, and maintain healthy self-care rutuals. I\'ve focused on those, but the most important skill I\'ve developed appears to be measuring how well I\'m capturing the feeling of the piece.\n\nI\'m sure there are better terms to describe my point than the \"feeling,\" which changes with each work and is often expected within the genre. Sometimes the name of the genre captures the element, like Horror in which the reader maintains a constant feeling of unease. Thrillers are similar, keeping the reader\'s heart racing. Most all genres engage the mind, but a Mystery promises to keep us engaged sifting through evidence and comments and hints to figure out \"Who done it?\" And there\'s Romance, through which the reader\'s heart is tugged in a different way.\n\nSometimes a series captures many feelings, such as Louis L\'Amore\'s Sackett series in which he captures the early days of America from Barnabas Sackett leaving England for the New World to arrive and cross the Blue Ridge Mountains before leaping to the the Civil War era.\n\nWith Harry Potter, J.K. Rowling follows the protagonist through his discovery of the Wizarding World through to the final battles against Voldemort, spicing the series with horror, mystery and thrills galore. In addition to our own sense of wonder with each new discovery, we get to experience Harry\'s fascination as well. Plus the horror of Voldemort, the thrill of the Horcruxes, and the many mysteries the kids must unravel to survive and eventually defeat the dark wizard.\n\nFilm and television falls into the same genres.\n\n&nbsp;','Crafting Words to Capture the Essence','','inherit','closed','closed','','97-revision-v1','','','2018-08-10 17:20:25','2018-08-10 17:20:25','',97,'https://dmweade.com/welcome/2018/08/10/97-revision-v1/',0,'revision','',0),
 (101,2,'2018-08-11 01:10:26','2018-08-11 01:10:26','<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>My Favorite Authors and Why I Love Their Work</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Glen Cook</strong>’s publisher has started labeling him the grandfather of Grimdark with his last book launch, but he’s much more accomplished than <em><a href=\"https://www.torforgeblog.com/2018/07/31/series-order-chronicles-of-the-black-company/\">The Black Company</a></em>. I believe his standalone novel <em><a href=\"https://us.macmillan.com/books/9781466831155\">The Tower of Fear</a></em> is an amazingly well-told tale, and <em><a href=\"https://www.goodreads.com/series/42332-dread-empire\">The Dread Empire</a></em> series sets a relentless pace I have yet to experience by another author. I\'m also a fan of his <em><a href=\"https://www.penguinrandomhouse.com/series/AX3/garrett-pi\">Garrett P.I.</a> </em>series, which I\'ve read several times enjoying his noir humor.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>J. R. R. Tolkien</strong>’s <em>The Hobbit</em> remains my favorite novel and was my original favorite back in third grade. A friend recommended The <em>Fellowship of the Ring</em>, but all they had was <em>The Two Towers</em> which I somehow managed to enjoy even out of order. I did eventually get to read the three novels, all before getting my hands on <em>The Hobbit</em>. Since that first read, I\'ve read <em>The Hobbit</em> more times than any other book, the last two rounds to my daughter. She now owns her own copy.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It’s difficult to believe he published the novel 80 years ago. Both the story and his writing remain engaging, and my gold standard for including wonder in my own work. If I can ever bring such joy to anyone who read my stories, I\'ll consider myself accomplished.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Steven Brust</strong> is a wizard of a storyteller. <a href=\"https://www.torforgeblog.com/2017/10/17/where-to-start-with-vlad-taltos/\">Vlad Taltos</a> is one of my favorite characters and the <em><a href=\"https://en.wikipedia.org/wiki/Khaavren_Romances\">Khaavren Romances</a></em> are beyond my ability to describe adequately. Just go read them. Now. And then check out \"<a href=\"https://www.goodreads.com/quotes/889625-the-cool-stuff-theory-of-literature-is-as-follows-all\">The Cool Stuff Theory of Literature</a>.\"</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Martha Wells</strong>’s <em><a href=\"https://www.marthawells.com/death.htm\">Death of the Necromancer</a></em> is an amazing historical fantasy, and horror to boot. She has two novels and a trilogy set in the world of Ile-Rien, including <em><a href=\"https://www.marthawells.com/element.htm\">Element of Fire</a></em> and the <em><a href=\"https://www.marthawells.com/ilerien.htm\">Fall of Ile-Rien</a></em> trilogy. It’s also worth tracking down \"<a href=\"https://www.marthawells.com/betweenworlds.htm\">The Potter’s Daughter</a>,\" a short-story featuring the excellent character Kade Carrion. These works parallel four centuries from the 17<sup>th</sup> to 20<sup>th</sup>. I maintain hope Martha will circle back to Kade in a future work.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Anne McCaffrey</strong> changed my view of fantasy. Instead of swords and magic and inhumane villains, her stories focused on personal struggles within an alien, if human, society. Her <a href=\"https://en.wikipedia.org/wiki/The_Harper_Hall_Trilogy\">Harper Hall trilogy</a> was the first series I read to my daughter and she loved them (once the fire lizards made their appearance). Every child should experience these stories in which a mistreated girl masters skills long denied women in her society.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Andrzej Sapkowski</strong> is the marvel who gave us Geralt, <a href=\"https://en.wikipedia.org/wiki/The_Witcher\">the Witcher</a>. Sapkowski\'s use of traditional fairy tales as a backdrop for his kick-ass character makes for a fun read. Everyone should read the translations of his short stories for lessons on \"making big things small and small things big.\" </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>David Gemmell</strong> wrote more than thirty fantasy novels. His <a href=\"https://en.wikipedia.org/wiki/David_Gemmell#Drenai_Series\">Drenai series</a> are listed among the classics and were a great read as a teen, but felt flat and uninspired when I reread them as an adult. What I respect most about his bibliography is the <a href=\"https://en.wikipedia.org/wiki/David_Gemmell#Rigante_series\">Rigante series</a>, published toward the end of his life. The contrast between his earliest works and these later works should be an inspiration to all writers.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Will McIntosh</strong> is the only author on this list I’ve met. I interviewed him for a project after reading <em><a href=\"https://www.tor.com/2011/04/13/the-gradual-collapse-of-a-society-a-review-of-soft-apocalypse-by-will-mcintosh/\">Soft Apocalypse</a></em> and his Hugo Award-winning short story \"<a href=\"https://scificats.files.wordpress.com/2011/04/bridesicle.pdf\">Bridesicle</a>,\"* which he developed into <em><a href=\"https://smile.amazon.com/Love-Minus-Eighty-Will-McIntosh/dp/B01L9CV2AE?smdm-noredirect=true\">Love Minus Eighty</a></em> (overdue for a movie deal, IMHO).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Will is a smooth writer with a solid lock on humanity. When I asked him how he envisions his characters in future settings, he explained his background as a sociologist provides a solid understanding of how humans are wired to respond to stimuli. As a result, his characters respond realistically rather than falling into science fiction tropes. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>*When I interviewed Will, I mentioned his short story was on a site that might not be legit. At the time, he said to link to it because the story was no longer on the site of the magazine who purchased it. I\'m including a link here until another is available. Also, the story is available as an <a href=\"http://escapepod.org/2010/07/01/ep247-bridesicle/\">audio recording</a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>William Gibson</strong> created the Cyberpunk genre with his early visions of our future (and he got a lot right). His ideas stoked my interest in science fiction with his rich focus on our looming cultural shifts. His most recent novel, <em><a href=\"https://williamgibsonbooks.com/books/the-peripheral/\">The Peripheral,</a></em> proves his value as a modern oracle. Gibson processes our current trends so clearly and his ability to parse modern events into forecasts is nothing short of genius. If you aren’t familiar with his work, <em>The Peripheral</em> gives us a view at life after the Jackpot (which has become part of the zeitgeist as climate change gains steam). It’s a brilliant and timely insight. Expect sleepless nights while reading.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Katherine Kurtz</strong> Her <a href=\"https://en.wikipedia.org/wiki/Deryni_novels\">Deryni series</a> was my first experience with historical fantasy. Up to that point, my interest in history was mostly about architecture and fighting. Kurtz really delved into the interplay of royalty and the church. By making the protagonists heretics in the eyes of the church, yet devout in their faith, she created a gripping story. While I did not keep up with the novels past the first pause, the original novels are slim and fast-moving. Well worth reading for the nuance she brings to those early ideas.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Roger Zelazny</strong>’s <em><a href=\"https://en.wikipedia.org/wiki/The_Chronicles_of_Amber\">Chronicles of Amber</a></em> are genre-breaking classics. I don’t know of any other series like what he created. Read the Corwin books for the ongoing first-person structure and stream-of-consciousness planning. Rereading Corwin’s walking through shadow, experiencing his use of color and texture, really helped with my current project. Sometimes we get lucky and chance upon exactly what we need right when we need it.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Sites With Free Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><a href=\"https://www.wattpad.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Wattpad</a>&nbsp;- <a href=\"https://uncannymagazine.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Uncanny Magazine</a> - <a href=\"https://curiousfictions.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Curious Fictions</a> - <a href=\"https://www.shimmerzine.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Shimmer</a> - <a href=\"http://enkare.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Enkare Review</a> - <a href=\"http://www.abyssapexzine.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Abyss &amp; Apex</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><a rel=\"noreferrer noopener\" href=\"https://texttechnologies.stanford.edu/publications/beowulf-all\" target=\"_blank\">Beowulf by All</a> -&nbsp;<a rel=\"noreferrer noopener\" href=\"https://csi.asu.edu/books/vvev/\" target=\"_blank\">Visions, Ventures, Escape Velocities: A Collection of Space Futures</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><a href=\"https://whetstonemag.blogspot.com/\">Whetstone: Amateur Magazine of Pulp Sword and Sorcery</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Non-Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://jetpress.org/contents.htm\" target=\"_blank\" rel=\"noreferrer noopener\">Journal of Evolution and Technology</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Fictions Collections and Lists</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/more-perfect-novels-for-every-dungeons-dragons-character-class-bards-barbarians-druids-and-paladins/\" target=\"_blank\" rel=\"noreferrer noopener\">More Perfect Novels for Every Dungeons &amp; Dragons Character Class: Bards, Barbarians, Druids, and Paladins</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.unboundworlds.com/2017/09/26-underrated-sci-fi-fantasy-gems-shouldnt-miss/?ref=PRH6F3D45E1F3&amp;aid=randohouseinc10373-20&amp;linkid=PRH6F3D45E1F3\" target=\"_blank\" rel=\"noreferrer noopener\">26 Underrated Sci-Fi and Fantasy Gems You Shouldn’t Miss</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nytimes.com/2018/07/16/books/review/author-recommended-scary-books.html?action=click&amp;module=Editors%20Picks&amp;pgtype=Homepage\" target=\"_blank\" rel=\"noreferrer noopener\">The Book That Terrified Neil Gaiman. And Carmen Maria Machado. And Dan Simmons.</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.unboundworlds.com/2018/07/10-new-fantasysf-novels-women-read/\" target=\"_blank\" rel=\"noreferrer noopener\">10 New Sci-Fi &amp; Fantasy Novels by Women You Shouldn’t Miss</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.weforum.org/agenda/2017/08/11-books-on-the-future-of-humanity-that-everyone-should-read?utm_content=bufferf4c90&amp;utm_medium=social&amp;utm_source=twitter.com&amp;utm_campaign=buffer\" target=\"_blank\" rel=\"noreferrer noopener\">11 books on the future of humanity that everyone should read</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://electricliterature.com/10-gothic-gems-of-historical-fiction-f54c36611ec\" target=\"_blank\" rel=\"noreferrer noopener\">10 Gothic Gems of Historical Fiction</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.curbed.com/2017/11/22/16679866/best-books-cities-black-friday-cyber-monday\" target=\"_blank\" rel=\"noreferrer noopener\">101 books about where and how we live</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mariahaskins.com/2017/06/30/17-brilliantly-awesome-short-stories-i-read-in-june/?utm_content=bufferfae6f&amp;utm_medium=social&amp;utm_source=twitter.com&amp;utm_campaign=buffer/\" target=\"_blank\" rel=\"noreferrer noopener\">17 brilliantly awesome short stories I read in June</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://electricliterature.com/9-afrofuturist-books-to-enjoy-if-youre-homesick-for-wakanda-ebb591cd9e53\" target=\"_blank\" rel=\"noreferrer noopener\">9 Afrofuturist Books to Enjoy if You’re Homesick for Wakanda</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://locusmag.com/2018/04/2018-locus-awards-finalists/?utm_source=dlvr.it&amp;amp;utm_medium=twitter\" target=\"_blank\" rel=\"noreferrer noopener\">2018 Locus Award Finalists</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.syfy.com/syfywire/17-sff-books-by-asian-women-we-want-to-see-as-movies\" target=\"_blank\" rel=\"noreferrer noopener\">17 SFF Books by Asian Women We Want To See As Movies</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mariahaskins.com/2018/05/06/10-stellar-short-stories-i-read-in-april/\" target=\"_blank\" rel=\"noreferrer noopener\">9 Extra Stellar Short Stories I Read In April</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://litreactor.com/columns/me-myself-and-i-first-person-narratives-in-fantasy\" target=\"_blank\" rel=\"noreferrer noopener\">Me, Myself, and I: First Person Narratives in Fantasy</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mobile.twitter.com/RobGMacfarlane/status/995651627225960448\" target=\"_blank\" rel=\"noreferrer noopener\">A Request and Suggestions about Descents into the Underworld</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nypl.org/blog/2017/07/28/only-love-will-save-world-wonder-woman-readalikes?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\" target=\"_blank\" rel=\"noreferrer noopener\">Wonder Woman Read-alikes</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.npr.org/2017/07/12/533862948/lets-get-graphic-100-favorite-comics-and-graphic-novels\" target=\"_blank\" rel=\"noreferrer noopener\">Let\'s Get Graphic: 100 Favorite Comics and Graphic Novels</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.tor.com/2018/08/23/six-literary-visions-of-the-future/?utm_source=exacttarget&amp;utm_medium=newsletter&amp;utm_term=tordotcom-tordotcomnewsletter&amp;utm_content=na-readblog-blogpost&amp;utm_campaign=tor\" target=\"_blank\" rel=\"noreferrer noopener\">6 Literary Visions of the Future</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a href=\"http://www.fantasyliterature.com/reviews/2018-locus-award-finalists/\">2018 Locus Award Finalists</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/9-slim-horror-reads-to-squeeze-in-before-halloween/\">9 Slim Horror Reads</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/sci-fi-fantasy-short-fiction-roundup-october-2019/\">Sci-Fi &amp; Fantasy Short Fiction Roundup: October 2019</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.wired.co.uk/article/best-fantasy-books-novels-series\">17 of the best fantasy books everyone should read</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://thetattooedbookgeek.wordpress.com/2018/08/06/top-finished-fantasy-trilogies-you-should-read/\">Top Finished Fantasy Trilogies You Should Read</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nypl.org/blog/2017/03/08/365-books-women-authors-international-womens-day?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\" target=\"_blank\" rel=\"noreferrer noopener\">365 Books by Women Authors to Celebrate International Women’s Day All Year</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://prowritingaid.com/art/845/best-books-written-by-black-women.aspx\" target=\"_blank\" rel=\"noreferrer noopener\">Best Books Written by Black Women</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://bookriot.com/2019/01/22/african-fantasy-novels/\">20 Must-Read African Novels</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.bustle.com/p/10-essential-sci-fi-novels-by-women-that-show-what-the-genre-can-do-17307273\">10 Essential Sci-Fi Novels By Women That Show What The Genre Can Do</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/6-books-featuring-killer-blade-fights/\">6 Books Featuring Killer Blade Fights</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://mobile.twitter.com/ellle_em/status/1110640670266585089\">List of Novels with Historically Accurate Epic Fantasy</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://ask.metafilter.com/333129/Post-post-collapse-fiction\">Post-post-collapse fiction</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://reedsy.com/discovery/blog/best-ya-fantasy-books\">30 Best YA Fantasy Books for Teens</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://bookriot.com/2018/10/15/best-modern-fantasy-series/\" target=\"_blank\" rel=\"noreferrer noopener\">15 of Your Best Picks for the Best Modern Fantasy Series&nbsp;</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.nypl.org/blog/2016/09/16/brainy-brave-hermione-granger?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\" target=\"_blank\" rel=\"noreferrer noopener\">Brainy and Brave: A Salute to Hermione Granger</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.fantasyliterature.com/reviews/modern-fantasy-the-100-best-novels-1946-1987/\" target=\"_blank\" rel=\"noreferrer noopener\">100 Best Novels</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.tor.com/2018/09/12/outside-the-lines-unique-narrative-devices-in-fantasy/?utm_source=exacttarget&amp;utm_medium=newsletter&amp;utm_term=tordotcom-tordotcomnewsletter&amp;utm_content=na-readblog-blogpost&amp;utm_campaign=9781250175489\" target=\"_blank\" rel=\"noreferrer noopener\">Outside the Lines: Unique Narrative Devices in Fantasy</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Short Fiction</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"http://shortbooks.co/\" target=\"_blank\">Shortbooks</a> - find shorter books by any subject</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Nnedi Okorafor - <a href=\"http://nnedi.com/books/online_fiction.html\">All her online fiction</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"http://www.beneath-ceaseless-skies.com/2019/01/24/2019-awards-eligible-stories-from-bcs/\" target=\"_blank\" rel=\"noreferrer noopener\">2019 Awards-Eligible Stories from Beneath Ceaseless Skies</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"http://www.abyssapexzine.com/2018/03/middle-of-nowhere/\" target=\"_blank\">Middle of Nowhere</a> by Walter Dinjo</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/10-harlan-ellison-short-stories-that-changed-sci-fi/\" target=\"_blank\" rel=\"noreferrer noopener\">10 Harlan Ellison Short Stories That Changed Sci-Fi</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/17-recent-sci-fi-fantasy-and-horror-anthologies-to-celebrate-short-story-month/\">17 Sci-Fi, Fantasy, and Horror Anthologies to Celebrate Short Story Month</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"><strong>Free Audiobooks</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://player.fm/series/levar-burton-reads/live-in-chicago-the-winds-of-harmattan-by-nnedi-okorafor\" target=\"_blank\">\"The Winds of Harmattan\" by Nnedi Okorafor</a> (Levar Burton) <br><a rel=\"noreferrer noopener\" href=\"https://one.npr.org/?sharedMediaId=585302372:585302374\" target=\"_blank\">\"The Baboon War\" by Nnedi Okorafor</a> (Levar Burton)<br><a href=\"http://escapepod.org/2010/07/01/ep247-bridesicle/\">Bridesicle by Will McIntosh</a> (Amy H. Sturgis)</p>\n<!-- /wp:paragraph -->','Reading Lists','','publish','closed','closed','','reading-lists','','','2020-03-23 17:07:31','2020-03-23 17:07:31','',0,'https://dmweade.com/welcome/?page_id=101',0,'page','',0),
 (103,1,'2018-08-11 01:11:38','2018-08-11 01:11:38','','To Read','','publish','closed','closed','','103','','','2020-04-24 17:51:31','2020-04-24 17:51:31','',0,'https://dmweade.com/welcome/?p=103',3,'nav_menu_item','',0),
 (116,1,'2018-08-11 01:59:56','2018-08-11 01:59:56','My resource pages help me keep track of things. I hope you also find them useful.\r\n\r\nArt, media, design elements (always check the license for professional use)\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 516px;\">\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n 	<li>Just images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Just icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Just fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nOther lists:\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\">Growth Supply</a></li>\r\n 	<li><a href=\"https://www.reddit.com/r/AskReddit/comments/8gy4nd/what_are_some_cool_websites_where_you_can/\">Reddit: What are some cool websites where you can download free stuff?</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-11 01:59:56','2018-08-11 01:59:56','',35,'https://dmweade.com/welcome/2018/08/11/35-revision-v1/',0,'revision','',0),
 (117,1,'2018-08-11 01:59:58','2018-08-11 01:59:58','My resource pages help me keep track of things. I hope you also find them useful.\r\n\r\nArt, media, design elements (always check the license for professional use)\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 516px;\">\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n 	<li>Just images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li>Just icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Just fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nOther lists:\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\">Growth Supply</a></li>\r\n 	<li><a href=\"https://www.reddit.com/r/AskReddit/comments/8gy4nd/what_are_some_cool_websites_where_you_can/\">Reddit: What are some cool websites where you can download free stuff?</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-11 01:59:58','2018-08-11 01:59:58','',35,'https://dmweade.com/welcome/2018/08/11/35-revision-v1/',0,'revision','',0),
 (118,1,'2018-08-11 02:01:53','2018-08-11 02:01:53','My resource pages help me keep track of things. I hope you also find them useful.\r\n\r\nArt, media, design elements (always check the license for professional use)\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 516px;\">\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 50%; height: 516px;\">\r\n<ul>\r\n 	<li>Just images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Just icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Just fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nOther lists:\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\">Growth Supply</a></li>\r\n 	<li><a href=\"https://www.reddit.com/r/AskReddit/comments/8gy4nd/what_are_some_cool_websites_where_you_can/\">Reddit: What are some cool websites where you can download free stuff?</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-11 02:01:53','2018-08-11 02:01:53','',35,'https://dmweade.com/welcome/2018/08/11/35-revision-v1/',0,'revision','',0),
 (120,1,'2018-08-11 02:16:57','2018-08-11 02:16:57','Design elements for creatives.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"1\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48.706%;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 3.20903%;\"></td>\r\n<td style=\"width: 48.0849%;\">\r\n<ul>\r\n 	<li>Just images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Just icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Just fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nOther lists:\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\">Growth Supply</a></li>\r\n 	<li><a href=\"https://www.reddit.com/r/AskReddit/comments/8gy4nd/what_are_some_cool_websites_where_you_can/\">Reddit: What are some cool websites where you can download free stuff?</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-11 02:16:57','2018-08-11 02:16:57','',35,'https://dmweade.com/welcome/2018/08/11/35-revision-v1/',0,'revision','',0),
 (121,1,'2018-08-11 02:18:32','2018-08-11 02:18:32','Design elements for creatives.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li>Just images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Just icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Just fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nOther lists:\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\">Growth Supply</a></li>\r\n 	<li><a href=\"https://www.reddit.com/r/AskReddit/comments/8gy4nd/what_are_some_cool_websites_where_you_can/\">Reddit: What are some cool websites where you can download free stuff?</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-11 02:18:32','2018-08-11 02:18:32','',35,'https://dmweade.com/welcome/2018/08/11/35-revision-v1/',0,'revision','',0),
 (575,1,'2020-01-11 23:37:31','2020-01-11 23:37:31','<!-- wp:paragraph -->\n<p>Aging sucks. Sitting for long periods of time is damaging. Get off your ass and do something, there are too many options to choose doing nothing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Gaining Strength<br></strong>(Choose one and get started) </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.fatherly.com/health-science/7-best-core-exercises-for-men/?utm_content=fatherly&amp;utm_campaign=twowned&amp;utm_source=twitter&amp;utm_medium=social\" target=\"_blank\" rel=\"noreferrer noopener\">7 Essential Exercises For Building A Strong Core</a></li><li><a href=\"https://vitals.lifehacker.com/get-closer-to-doing-a-handstand-in-12-minutes-1796377028\" target=\"_blank\" rel=\"noreferrer noopener\">Get Closer to Doing a Handstand in 12 Minutes</a></li><li><a href=\"http://strength.stack52.com/periodic-table-of-bodyweight-exercises/\" target=\"_blank\" rel=\"noreferrer noopener\">Periodic Table of Exercises</a> (with how-to)</li><li><a href=\"https://www.artofmanliness.com/articles/gymnastic-rings-101-a-beginners-routine-faqs/\" target=\"_blank\" rel=\"noreferrer noopener\">Gymnastic Rings 101: A Beginner’s Routine &amp; FAQs</a></li><li><a href=\"https://www.urbanstrength.com.au/blogs/articles/gymnastic-rings-workout-exercises-for-beginners#\" target=\"_blank\" rel=\"noreferrer noopener\">GYMNASTIC RINGS WORKOUT EXERCISES FOR BEGINNERS</a></li><li><a href=\"https://well.blogs.nytimes.com/2013/06/19/the-4-minute-workout/?runwell&amp;_r=1\" target=\"_blank\" rel=\"noreferrer noopener\">Four Minute Workout</a></li><li><a href=\"https://well.blogs.nytimes.com/2013/05/09/the-scientific-7-minute-workout/?_r=0\" target=\"_blank\" rel=\"noreferrer noopener\">Scientific Seven Minute Workout</a></li><li><a href=\"https://darebee.com/modifications.html\" target=\"_blank\" rel=\"noreferrer noopener\">Exercise adjustments if injured</a></li><li><a href=\"https://www.businessinsider.com/best-everyday-stretches-2016-4\" target=\"_blank\" rel=\"noreferrer noopener\">12 everyday stretches to stay flexible and fit at any age</a></li><li><a href=\"https://www.gq.com/story/five-moves-full-body-workout\">Only 5 Exercises You\'ll Ever Need</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Flexibility</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://gmb.io/hip-mobility/\" target=\"_blank\" rel=\"noreferrer noopener\">8 Exercises to Improve Hip Mobility &amp; Loosen Tight Hips</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Repair</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://healthnewstips.today/backpain/index98162569.html?voluumdata=deprecated&amp;eda=deprecated&amp;cep=k2FyJKJn-Y1fpOlglraghl9fpoCpNsvuoP8auhdbU7xF0QVEZgiWIsBpXBfd9Af8CPwaP3xtQ-c2oHAVk8V-0ZNrYIR0_7ASQDP1PitsvckG5eUEuSpqPry5nG-Mq2AwQnFS_bMORRQGiCLRoNyzDYSUgv1X5YnFguq3iNzLkOEcJfHa20_3thkMS3Ck3Nn_j0mkqEyZAlAekg4ByjxQAS4ua_M3Wg6QYGjFQb6eKyBfKGIWYOwLzbUGitp9hds0aFhiJFLZKU0BhNQGTDtGHqmCOLxNiG4d6YdK9kn9PBU5FUQKutHvPpLdelRMpgc2wzdj53hBqEpM6SSqjPwtzr2ARJovBeCRBe-RP05oyfe6zI55xsaq-2KJX6DaZWKlklm7THPUJok5kpmrWvtTb_wgINGr6ulyqSz9UIMgjrmTEPrddv1HQLwu-MJqASfZLeaDKjic4RVVbRC0tZ0q9Mvh0myuTMImfHFn1SGB9xlXrdm_MZN6aoBanP571QuLEMm_U8NFJ1-mf3eyeM7gCM3g2kfR6c-GVerzlD7iQtNLN7FTV5jGCcy-y0zwmUVT_53gRdwfcvzx50GDeYhrJQU2dehy7URlKmPkTq5rgxf7FeJOtlxjyUAfeCtd7Qevi2O7N_X04R5C9ypkkitlRk1e_tSwApso6ZNQKkYNfs4&amp;utm_content=Chiropractors%20Baffled:%20Simple%20Stretch%20Relieves%20Years%20of%20Back%20Pain%20(Wat&amp;utm_term=002f47524a4d52e792bdafd472a8a59f46&amp;Doc_title=Erase%20My%20Back%20Pain%20%7C%20Health%20News%20Tips&amp;utm_site=espn.com/blog&amp;utm_pub=ESPN%20(ESPN)&amp;newad=2&amp;utm_adid=0099e7015bc5f22a3ffd6c2f75588d3a8a&amp;utm_doc_id=0050095ecbe5398c9b98b4d8cecb4f189b&amp;utm_new=002f47524a4d52e792bdafd472a8a59f46_espn.com/blog&amp;utm_cam=TabTier1NewVersion&amp;ob_click_id=7cb27d9a197ff36ebc26e48764a37bc1-000be295f74876f5c74c82e3c8a2545eae\" target=\"_blank\" rel=\"noreferrer noopener\">10 Minute Stretch Routine for Back Pain</a></li><li><a href=\"https://www.bodybuilding.com/content/what-is-the-best-hiit-workout.html\" target=\"_blank\" rel=\"noreferrer noopener\">High Intensity Interval Training</a></li><li><a href=\"https://gmb.io/elbows/?utm_source=drip&amp;utm_medium=email&amp;utm_campaign=17%2F10%2F30+Elbows&amp;utm_content=The+loneliest+body+part\" target=\"_blank\" rel=\"noreferrer noopener\">Fixing Elbow Pain</a></li><li><a href=\"https://lifehacker.com/do-these-three-exercises-in-four-minutes-to-improve-you-1777522021?utm_campaign=socialflow_lifehacker_facebook&amp;utm_source=lifehacker_facebook&amp;utm_medium=socialflow\" target=\"_blank\" rel=\"noreferrer noopener\">3 Exercises for Hunched Posture</a></li><li><a href=\"https://www.vox.com/science-and-health/2017/8/4/15929484/chronic-back-pain-treatment-mainstream-vs-alternative\" target=\"_blank\" rel=\"noreferrer noopener\">A comprehensive guide to the new science of treating lower back pain</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Other forms of care</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f\" target=\"_blank\" rel=\"noreferrer noopener\">14 Ways Reading Improves Your Mind and Body</a></li><li><a href=\"https://www.npr.org/sections/health-shots/2018/07/30/632480321/off-your-mental-game-you-could-be-mildly-dehydrated\" target=\"_blank\" rel=\"noreferrer noopener\">Off Your Mental Game? You Could Be Mildly Dehydrated</a></li><li><a href=\"http://www.bbc.com/future/story/20170707-the-24-best-podcasts-to-make-you-smarter\" target=\"_blank\" rel=\"noreferrer noopener\">24 Podcasts to Make You Smarter</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->','Exercise and Self-care','','inherit','closed','closed','','153-revision-v1','','','2020-01-11 23:37:31','2020-01-11 23:37:31','',153,'https://dmweade.com/welcome/2020/01/11/153-revision-v1/',0,'revision','',0),
 (243,1,'2018-10-19 14:15:50','2018-10-19 14:15:50','<p style=\"text-align: center;\"><strong>A repository of articles and resources I\'ve collected over the years\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writers</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>The Professional Author</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.publishersweekly.com/pw/print/20180723/77564-what-authors-and-editors-wish-they-could-say-to-one-another.html\" target=\"_blank\" rel=\"noopener\">What Authors and Editors Wish They Could Say to One Another</a></li>\r\n 	<li><a href=\"https://greenleafbookgroup.com/learning-center/publishing-information/what-publishers-want\" target=\"_blank\" rel=\"noopener\">What Publishers Want</a> - Greenleaf Book Group</li>\r\n 	<li><a href=\"https://www.hubspot.com/make-my-persona\" target=\"_blank\" rel=\"noopener\">Create a Buyer Persona</a> - Hubspot\'s tool to identify your core audience</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://cdn.prowritingaid.com/ebook/ProWritingAid_EBook2.pdf\" target=\"_blank\" rel=\"noopener\">Novel Writing Training Plan</a> by Pro Writing Aid</li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Self Promotion / Building a Platform</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging</a></li>\r\n 	<li style=\"text-align: left;\">Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://writingcooperative.com/how-to-build-your-own-author-platform-from-scratch-9d6123858bac\" target=\"_blank\" rel=\"noopener\">How to Build your own author platform - from scratch</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://growthtools.com/#tools\" target=\"_blank\" rel=\"noopener\">Growth Tools</a> - Grow your online business</li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://thewritepractice.com/building-an-author-website/\" target=\"_blank\" rel=\"noopener\">Building an Author Website: The First Step to Publishing</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Marketing Books</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://kindlepreneur.com/kindle-keywords-fiction-author-strategy/\" target=\"_blank\" rel=\"noopener\">Kindle Keyword Strategies for Fiction Authors</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n 	<li><a href=\"http://www.ian-irvine.com/on-writing/41-ways-to-create-and-heighten-suspense/\" target=\"_blank\" rel=\"noopener\">41 Ways to Create and Heighten Suspense</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/eight-absurdities-we-force-on-female-characters/\" target=\"_blank\" rel=\"noopener\">8 Absurdities we Force on Female Characters</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n 	<li><a href=\"https://io9.gizmodo.com/7-deadly-sins-of-worldbuilding-998817537\" target=\"_blank\" rel=\"noopener\">7 Deadly Sins of Worldbuilding</a></li>\r\n 	<li><a href=\"https://mythcreants.com/blog/five-common-worldbuilding-mistakes-in-new-manuscripts/\" target=\"_blank\" rel=\"noopener\">5 Common Worldbuilding Mistakes in New Manuscripts</a> (and a great blog)</li>\r\n 	<li><a href=\"https://mythcreants.com/blog/creating-a-mountain-setting/\" target=\"_blank\" rel=\"noopener\">Creating a Mountain Setting</a></li>\r\n 	<li><a href=\"https://nybookeditors.com/2017/07/fantasy-world-building-101-create-breathing-world-fantasy-novel/\" target=\"_blank\" rel=\"noopener\">Fantasy World Building 101: how to create a breathing world for your fantasy novel</a></li>\r\n 	<li>Worldbuilding Guide: <em>Excellent process</em>\r\n<ul>\r\n 	<li><a href=\"https://www.lostkingdom.net/worldbuilding-guide-1/\" target=\"_blank\" rel=\"noopener\">Part 1</a>, <a href=\"http://www.lostkingdom.net/worldbuilding-guide-2/\" target=\"_blank\" rel=\"noopener\">Part 2</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-introduction/\" target=\"_blank\" rel=\"noopener\">Fantasy Economics 101</a></li>\r\n 	<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-labour-and-wages/\" target=\"_blank\" rel=\"noopener\">Economics: labour and wages</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://electricliterature.com/against-worldbuilding-700e4861c26b\" target=\"_blank\" rel=\"noopener\">Against Worldbuilding</a> (caused quite a ruckus)</li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2013/09/17/25-things-you-should-know-about-worldbuilding/\" target=\"_blank\" rel=\"noopener\">25 Things You Should Know About Worldbuilding</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.powerthesaurus.org/\" target=\"_blank\" rel=\"noopener\">Power Thesaurus</a></li>\r\n 	<li><a href=\"https://english.stackexchange.com/\" target=\"_blank\" rel=\"noopener\">English Language and Usage Q&amp;A</a></li>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n 	<li><a href=\"http://moby.com/la1/\" target=\"_blank\" rel=\"noopener\">Long Ambients1: Calm. Sleep.</a> by Moby (free music)</li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.texturemate.com/index.php/\" target=\"_blank\" rel=\"noopener\">Texture repository</a></li>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.atlasobscura.com/articles/pies-that-look-like-people\" target=\"_blank\" rel=\"noopener\">People Pot Pies</a></li>\r\n 	<li><a href=\"https://www.rachaeltalibart.com/ocean\" target=\"_blank\" rel=\"noopener\">Sirens</a> by Rachel Talibart</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow. Here are some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 17.7674%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 2.13958%;\"></td>\r\n<td style=\"width: 80.093%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 39.7829%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 2.29462%;\"></td>\r\n<td style=\"width: 57.9225%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n<ul>\r\n 	<li>$6 ebook: <a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other: A Practical Approach</a></li>\r\n</ul>\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://bookriot.com/2018/02/05/casually-racist-things-that-white-authors-do/\" target=\"_blank\" rel=\"noopener\">7 Casually Racist Things That White Authors Do</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\n<a href=\"https://www.publishersweekly.com/pw/by-topic/columns-and-blogs/soapbox/article/77726-sensitivity-readers-what-are-they-good-for-a-lot.html?utm_source=Publishers+Weekly&amp;utm_campaign=e9fbb28448-EMAIL_CAMPAIGN_2018_08_13_02_56&amp;utm_medium=email&amp;utm_term=0_0bb2959cbb-e9fbb28448-306103905\" target=\"_blank\" rel=\"noopener\">Sensitivity Readers! What are they good for?</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\nFinding characters\r\n<ul>\r\n 	<li><a href=\"https://www.modelmanagement.com/\" target=\"_blank\" rel=\"noopener\">Model Management</a>: Too many authors use famous actors to give flesh to their characters. Search by nation for different looks and and facial types.</li>\r\n</ul>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>History and Interesting Fact(oid)s</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Terminology</strong>\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n<strong>Language</strong>\r\n<ul>\r\n 	<li><a href=\"https://scotlandwelcomesyou.com/scottish-sayings/\" target=\"_blank\" rel=\"noopener\">Old Scottish Sayings</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://www.atlasobscura.com/articles/civil-war-salt\" target=\"_blank\" rel=\"noopener\">How Salt Helped Win the Civil War</a> - fascinating look at how attacking a food resource impacted the South during the war</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Lists</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.techradar.com/news/best-mind-map-software\" target=\"_blank\" rel=\"noopener\">Best mind map software of 2018</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-10-19 14:15:50','2018-10-19 14:15:50','',39,'https://dmweade.com/welcome/2018/10/19/39-revision-v1/',0,'revision','',0),
 (232,1,'2018-09-15 01:34:13','2018-09-15 01:34:13','I\'ve long been interested in the field of 3D printing. Since purchasing a Tevo Tarantula in February, I\'ve managed to build it. That\'s it, just build it. Since then, life has been so freaking busy I\'ve barely kept up with life. Now I\'m ill. Nothing major, but may take another month or two to get back up to full speed. Such is life.\r\n\r\nBut it is time to get this going, so I\'m starting by reviewing all of the articles and building a list of resources to use going forward. Wish me luck.\r\n<p style=\"text-align: center;\">____________________</p>\r\n&nbsp;\r\n\r\n<strong>TT upgrades</strong>\r\n\r\n<a href=\"https://www.thingiverse.com/thing:2480577\" target=\"_blank\" rel=\"noopener\">EZ gimbal for z-banding</a>\r\n\r\nCable management: <a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1894586220635343/\" target=\"_blank\" rel=\"noopener\">one</a>,\r\n\r\n<a href=\"https://smile.amazon.com/dp/B0785LH2DC/ref=tsm_1_fb_lk?sa-no-redirect=1\" target=\"_blank\" rel=\"noopener\">Stepper cables</a>, <a href=\"https://www.thingiverse.com/thing:2878127\" target=\"_blank\" rel=\"noopener\">Spool weight measurement</a>,\r\n\r\n&nbsp;\r\n\r\n<strong>Enclosures</strong>\r\n\r\nSmart enclosure - <a href=\"https://www.thingiverse.com/thing:2792618\" target=\"_blank\" rel=\"noopener\">https://www.thingiverse.com/thing:2792618</a>\r\n\r\n<a href=\"https://www.facebook.com/groups/makerbot/permalink/1610991019018396/\" target=\"_blank\" rel=\"noopener\">A few options shared on Facebook</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Storage/organization</strong>\r\n\r\nPoor man\'s polybox (by <a href=\"https://www.facebook.com/rwarwqerwqer?fref=gs&amp;hc_ref=ARSbYY5WmlcdREC7rwKx6frURtGQ-rfSgHYAVuxAC53Kr4Qcy2-CWloIptE-pFc_Of0&amp;dti=197938987045417&amp;hc_location=group\" target=\"_blank\" rel=\"noopener\">Rich Lee</a>) - <a href=\"https://www.thingiverse.com/thing:2818547\" target=\"_blank\" rel=\"noopener\">https://www.thingiverse.com/thing:2818547</a>\r\n<ul>\r\n 	<li><a href=\"https://smile.amazon.com/gp/product/B007V4IWIU/r\" target=\"_blank\" rel=\"noopener\">Snapware 40-cup Airtight container</a></li>\r\n 	<li><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=4mm+pneumatic+connectors+push+fit\" target=\"_blank\" rel=\"noopener\">4mm Pneumatic connectors (\"Push Fit\")</a></li>\r\n 	<li><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing&amp;rh=i%3Aaps%2Ck%3A2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing\" target=\"_blank\" rel=\"noopener\">2mm ID / 4mm OD PTFE (Teflon™) Tubing</a></li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Managing Errors</strong>\r\n\r\nFilament runout sensor - <a href=\"https://www.thingiverse.com/thing:2814724\" target=\"_blank\" rel=\"noopener\">https://www.thingiverse.com/thing:2814724</a>\r\n\r\nZ-bading - <a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1722003637893603/\" target=\"_blank\" rel=\"noopener\">https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1722003637893603/</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Stuff to Print</strong>\r\n\r\nLists - <a href=\"http://www.geeetech.com/blog/2018/03/8-diy-3d-prints-for-every-kitchen/\" target=\"_blank\" rel=\"noopener\">Kitchen items</a>\r\n\r\n&nbsp;\r\n\r\nFilament - <a href=\"https://www.facebook.com/groups/makerbot/permalink/1656440171140147/\" target=\"_blank\" rel=\"noopener\">PLA suggestions</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Research</strong>\r\n\r\n<a href=\"https://n-e-r-v-o-u-s.com/blog/?p=8011\" target=\"_blank\" rel=\"noopener\">SELF FORMING STRUCTURES: AN EXPLORATION INTO 3D PRINTING ON PRE-STRETCHED FABRIC</a>\r\n\r\n<a href=\"https://phys.org/news/2018-06-d-printer-physical.html\" target=\"_blank\" rel=\"noopener\">3D Printing Data Sets</a>','3D Printing Resources','','inherit','closed','closed','','86-revision-v1','','','2018-09-15 01:34:13','2018-09-15 01:34:13','',86,'https://dmweade.com/welcome/2018/09/15/86-revision-v1/',0,'revision','',0),
 (128,1,'2018-08-14 00:52:36','2018-08-14 00:52:36','<strong>Design elements for creatives.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://freedesignresources.net/\" target=\"_blank\" rel=\"noopener\">Free Design Resources</a>: fonts, mockups, graphic, template &amp; more</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Cofee Book</a>: travel photos</li>\r\n 	<li><a href=\"https://www.pixeden.com/\" target=\"_blank\" rel=\"noopener\">Pixeden</a>: prints, icons, vectors, graphics,etc...</li>\r\n 	<li><a href=\"http://growthsupply.com/free/\" target=\"_blank\" rel=\"noopener\">Growth Supply</a> - mega list of resources</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-14 00:52:36','2018-08-14 00:52:36','',35,'https://dmweade.com/welcome/2018/08/14/35-revision-v1/',0,'revision','',0),
 (143,1,'2018-08-14 20:28:33','2018-08-14 20:28:33','<strong>Design stuff for creatives:</strong>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 318px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 318px;\">\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\" target=\"_blank\" rel=\"noopener\">Growth Supply</a> - mega list of resources</li>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://freedesignresources.net/\" target=\"_blank\" rel=\"noopener\">Free Design Resources</a>: fonts, mockups, graphics, templates &amp; more</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Coffee Book</a>: travel photos</li>\r\n 	<li><a href=\"https://www.pixeden.com/\" target=\"_blank\" rel=\"noopener\">Pixeden</a>: prints, icons, vectors, graphics,etc...</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%; height: 318px;\"></td>\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Vector art: <a href=\"https://www.freevector.com/\" target=\"_blank\" rel=\"noopener\">Free Vector</a></li>\r\n 	<li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n<strong>Software:</strong>\r\n<ul>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>GIMP: <a href=\"https://www.gimp.org/\" target=\"_blank\" rel=\"noopener\">Free image editor</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-14 20:28:33','2018-08-14 20:28:33','',35,'https://dmweade.com/welcome/2018/08/14/35-revision-v1/',0,'revision','',0),
 (131,1,'2018-08-14 01:03:22','2018-08-14 01:03:22','<strong>Design stuff for creatives:</strong>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 318px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 318px;\">\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\" target=\"_blank\" rel=\"noopener\">Growth Supply</a> - mega list of resources</li>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://freedesignresources.net/\" target=\"_blank\" rel=\"noopener\">Free Design Resources</a>: fonts, mockups, graphics, templates &amp; more</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Coffee Book</a>: travel photos</li>\r\n 	<li><a href=\"https://www.pixeden.com/\" target=\"_blank\" rel=\"noopener\">Pixeden</a>: prints, icons, vectors, graphics,etc...</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%; height: 318px;\"></td>\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n<strong>Software:</strong>\r\n<ul>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>GIMP: <a href=\"https://www.gimp.org/\" target=\"_blank\" rel=\"noopener\">Free image editor</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-14 01:03:22','2018-08-14 01:03:22','',35,'https://dmweade.com/welcome/2018/08/14/35-revision-v1/',0,'revision','',0),
 (130,1,'2018-08-14 01:01:07','2018-08-14 01:01:07','<strong>Design stuff for creatives:</strong>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 318px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 318px;\">\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\" target=\"_blank\" rel=\"noopener\">Growth Supply</a> - mega list of resources</li>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://freedesignresources.net/\" target=\"_blank\" rel=\"noopener\">Free Design Resources</a>: fonts, mockups, graphics, templates &amp; more</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Coffee Book</a>: travel photos</li>\r\n 	<li><a href=\"https://www.pixeden.com/\" target=\"_blank\" rel=\"noopener\">Pixeden</a>: prints, icons, vectors, graphics,etc...</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%; height: 318px;\"></td>\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n<strong>Software:</strong>\r\n<ul>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n 	<li>GIMP: <a href=\"https://www.gimp.org/\" target=\"_blank\" rel=\"noopener\">Free image editor</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Software:</strong>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 318px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 318px;\">\r\n<td style=\"width: 48%; height: 318px;\"></td>\r\n<td style=\"width: 4%; height: 318px;\"></td>\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n<ul>\r\n 	<li></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-14 01:01:07','2018-08-14 01:01:07','',35,'https://dmweade.com/welcome/2018/08/14/35-revision-v1/',0,'revision','',0),
 (129,1,'2018-08-14 00:59:52','2018-08-14 00:59:52','<strong>Design stuff for creatives:</strong>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 318px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 318px;\">\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li><a href=\"http://growthsupply.com/free/\" target=\"_blank\" rel=\"noopener\">Growth Supply</a> - mega list of resources</li>\r\n 	<li><a href=\"https://librestock.com/\">LibreStock</a>: metasearch for free images</li>\r\n 	<li><a href=\"https://video.librestock.com/\">Video.LibreStock</a>: metasearch for free videos</li>\r\n 	<li><a href=\"https://resourcecards.com/\">Resource Cards</a>: meta list of photography, fonts, icons, color schemes, etc...</li>\r\n 	<li><a href=\"https://pixabay.com/\">Pixabay</a>: photos, illustrations, vector graphics, videos</li>\r\n 	<li><a href=\"https://freedesignresources.net/\" target=\"_blank\" rel=\"noopener\">Free Design Resources</a>: fonts, mockups, graphics, templates &amp; more</li>\r\n 	<li><a href=\"https://www.stockio.com/\">Stockio</a>: photos, vectors, icons, fonts and video</li>\r\n 	<li><a href=\"https://gratisography.com/\">Gratisography</a>: quirky photos</li>\r\n 	<li><a href=\"http://travelcoffeebook.com/\">Travel Coffee Book</a>: travel photos</li>\r\n 	<li><a href=\"https://www.pixeden.com/\" target=\"_blank\" rel=\"noopener\">Pixeden</a>: prints, icons, vectors, graphics,etc...</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%; height: 318px;\"></td>\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n<strong>Software:</strong>\r\n<ul>\r\n 	<li></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Software:</strong>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 318px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 318px;\">\r\n<td style=\"width: 48%; height: 318px;\"></td>\r\n<td style=\"width: 4%; height: 318px;\"></td>\r\n<td style=\"width: 48%; height: 318px;\">\r\n<ul>\r\n 	<li>Images: <a href=\"https://www.freeimages.com/\">Freeimages</a>, <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.pexels.com/\">Pexels</a>, <a href=\"https://shotstash.com/\">Shot Stash</a>, <a href=\"https://isorepublic.com/\">ISO Republic</a>, <a href=\"https://picography.co/\">Picography</a>, <a href=\"https://negativespace.co/\">Negative Space</a>, <a href=\"https://stocksnap.io/\">Stocksnap</a>, <a href=\"https://unsplash.com/\">Unsplash</a></li>\r\n 	<li>Icons: <a href=\"https://www.flaticon.com/\">Flat Icons</a>, <a href=\"https://www.iconfinder.com/\">Iconfinder</a>, <a href=\"https://thenounproject.com/\">Icons for Everything</a>, <a href=\"https://material.io/tools/icons/?style=baseline\">Material Design</a>, <a href=\"https://fontawesome.com/\">Font Awesome</a>, <a href=\"https://github.com/heyalexej/awesome-images\">More Image Libraries</a></li>\r\n 	<li>Background patterns: <a href=\"https://www.toptal.com/designers/subtlepatterns/\">Subtle Patterns</a>, <a href=\"https://www.vecteezy.com/free-vector/free-vector-pattern-background\">Vecteasy</a>, <a href=\"http://thepatternlibrary.com/\">Pattern Library</a></li>\r\n 	<li>Fonts: <a href=\"https://fonts.google.com/\">Google Fonts</a>, <a href=\"https://www.dafont.com/\">Dafont</a>, <a href=\"https://www.fontsquirrel.com/\">Font Squirrel</a></li>\r\n 	<li>Game art: <a href=\"https://opengameart.org/\">Open Game Art</a>,</li>\r\n 	<li>Sound Effects: <a style=\"font-family: inherit; font-size: inherit;\" href=\"https://freesound.org/\">Free Sound</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://bbcsfx.acropolis.org.uk/\">BBC Sound Effects</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.audioblocks.com/royalty-free-audio/sound-effects\">Story Blocks</a><span style=\"font-family: inherit; font-size: inherit;\">, </span><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://www.zapsplat.com/sound-effect-categories/\">Zap Splat</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n<ul>\r\n 	<li>Audacity: <a href=\"https://www.audacityteam.org/\">Free audio editor</a></li>\r\n</ul>','Creative Resources','','inherit','closed','closed','','35-revision-v1','','','2018-08-14 00:59:52','2018-08-14 00:59:52','',35,'https://dmweade.com/welcome/2018/08/14/35-revision-v1/',0,'revision','',0),
 (140,1,'2018-08-14 19:38:39','2018-08-14 19:38:39','<strong>Links. Lots of them. Trying to bring order from chaos.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a> and <a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n</ul>\r\n<strong>Free Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.beneath-ceaseless-skies.com/\" target=\"_blank\" rel=\"noopener\">Beneath Ceaseless Skies</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>Writing Colorfully\r\n</strong>There are colors beyond the rainbow and some sites which provide terminology, visual references, and usage.\r\n\r\n&nbsp;\r\n\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 19:38:39','2018-08-14 19:38:39','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (133,1,'2018-08-14 01:18:57','2018-08-14 01:18:57','<strong>Links. Lots of them. Trying to bring order from chaos.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>The Craft of Writing</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"><img class=\"size-full wp-image-419 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\" alt=\"\" width=\"95\" height=\"150\" /> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\"><img class=\"size-full wp-image-423 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\" alt=\"\" width=\"99\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\"><img class=\"size-full wp-image-420 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><img class=\"size-full wp-image-421 alignnone\" style=\"font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Oxygen-Sans, Ubuntu, Cantarell, \'Helvetica Neue\', sans-serif;\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/dialogue_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\"><img class=\"wp-image-432 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\" alt=\"\" width=\"100\" height=\"150\" /> </a>\r\n\r\n&nbsp;\r\n\r\n<strong>Creativity</strong>\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Writing Science Fiction and Fantasy</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\"><img class=\"size-full wp-image-424 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\" alt=\"\" width=\"97\" height=\"150\" /></a> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\"><img class=\"size-full wp-image-425 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\" alt=\"\" width=\"98\" height=\"150\" /></a>','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 01:18:57','2018-08-14 01:18:57','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (136,1,'2018-08-14 01:58:01','2018-08-14 01:58:01','<strong>Links. Lots of them. Trying to bring order from chaos.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a> and <a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n</ul>\r\n<strong>Free Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.beneath-ceaseless-skies.com/\" target=\"_blank\" rel=\"noopener\">Beneath Ceaseless Skies</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 01:58:01','2018-08-14 01:58:01','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (134,1,'2018-08-14 01:30:19','2018-08-14 01:30:19','<strong>Links. Lots of them. Trying to bring order from chaos.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a> and <a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n</ul>\r\n<strong>Free Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.beneath-ceaseless-skies.com/\" target=\"_blank\" rel=\"noopener\">Beneath Ceaseless Skies</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>The Craft of Writing</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"><img class=\"size-full wp-image-419 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\" alt=\"\" width=\"95\" height=\"150\" /> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\"><img class=\"size-full wp-image-423 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/plotstructure_0.jpg\" alt=\"\" width=\"99\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\"><img class=\"size-full wp-image-420 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/descriptionsetting_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /></a><a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/sceneandstructure_0_0.jpg\"> </a><img class=\"size-full wp-image-421 alignnone\" style=\"font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Oxygen-Sans, Ubuntu, Cantarell, \'Helvetica Neue\', sans-serif;\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/dialogue_0.jpg\" alt=\"\" width=\"100\" height=\"150\" /> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\"><img class=\"wp-image-432 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/revisionandselfediting.jpg\" alt=\"\" width=\"100\" height=\"150\" /> </a>\r\n\r\n&nbsp;\r\n\r\n<strong>Creativity</strong>\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<strong>Writing Science Fiction and Fantasy</strong>\r\n\r\n<a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\"><img class=\"size-full wp-image-424 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/worldsofwonder_0.jpg\" alt=\"\" width=\"97\" height=\"150\" /></a> <a href=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\"><img class=\"size-full wp-image-425 alignnone\" src=\"https://dmweade.com/copywelcome/wp-content/uploads/2018/07/oscscififantasy_0.jpg\" alt=\"\" width=\"98\" height=\"150\" /></a>','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 01:30:19','2018-08-14 01:30:19','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (137,1,'2018-08-14 13:44:55','2018-08-14 13:44:55','<a href=\"https://creativemarket.com/themes/wordpress/blog\">https://creativemarket.com/themes/wordpress/blog</a>','Wordpress Resources','','inherit','closed','closed','','37-revision-v1','','','2018-08-14 13:44:55','2018-08-14 13:44:55','',37,'https://dmweade.com/welcome/2018/08/14/37-revision-v1/',0,'revision','',0),
 (211,1,'2018-08-17 14:06:13','2018-08-17 14:06:13','','Wordpress Resources','','inherit','closed','closed','','37-revision-v1','','','2018-08-17 14:06:13','2018-08-17 14:06:13','',37,'https://dmweade.com/welcome/2018/08/17/37-revision-v1/',0,'revision','',0),
 (139,1,'2018-08-14 13:45:46','2018-08-14 13:45:46','&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%; height: 22px;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 22px;\">\r\n<td style=\"width: 50%; height: 22px;\">a\r\n\r\na\r\n\r\na\r\n\r\na\r\n\r\na</td>\r\n<td style=\"width: 50%; height: 22px;\">b\r\n\r\nb\r\n\r\nb</td>\r\n</tr>\r\n</tbody>\r\n</table>','Wordpress Resources','','inherit','closed','closed','','37-revision-v1','','','2018-08-14 13:45:46','2018-08-14 13:45:46','',37,'https://dmweade.com/welcome/2018/08/14/37-revision-v1/',0,'revision','',0),
 (138,1,'2018-08-14 13:44:58','2018-08-14 13:44:58','<a href=\"https://creativemarket.com/themes/wordpress/blog\">https://creativemarket.com/themes/wordpress/blog</a>\r\n\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%; height: 22px;\" border=\"1\">\r\n<tbody>\r\n<tr style=\"height: 22px;\">\r\n<td style=\"width: 50%; height: 22px;\">a\r\n\r\na\r\n\r\na\r\n\r\na\r\n\r\na</td>\r\n<td style=\"width: 50%; height: 22px;\">b\r\n\r\nb\r\n\r\nb</td>\r\n</tr>\r\n</tbody>\r\n</table>','Wordpress Resources','','inherit','closed','closed','','37-revision-v1','','','2018-08-14 13:44:58','2018-08-14 13:44:58','',37,'https://dmweade.com/welcome/2018/08/14/37-revision-v1/',0,'revision','',0),
 (141,1,'2018-08-14 19:40:49','2018-08-14 19:40:49','','colorthesaurus','','inherit','open','closed','','colorthesaurus','','','2018-08-14 19:42:08','2018-08-14 19:42:08','',39,'https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus.png',0,'attachment','image/png',0),
 (280,1,'2019-01-30 18:20:21','2019-01-30 18:20:21','<p style=\"text-align: center;\"><strong>A repository of articles and resources I\'ve collected over the years<br /></strong><em>(Long page, so keep scrolling)</em></p>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 48%;\">\n<p><strong>Critiquing Groups<br /></strong></p>\n<ul>\n<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\n<li><a href=\"http://www.critters.org/\">Critters</a></li>\n</ul>\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\n<ul>\n<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\n</ul>\n<p><strong>Writing challenges</strong></p>\n<ul>\n<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\n<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\n</ul>\n<p style=\"text-align: left;\"><strong>Sites supporting writers</strong></p>\n<ul>\n<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\n</ul>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\n</ul>\n<p><strong>The Professional Author</strong></p>\n<ul>\n<li><a href=\"https://www.publishersweekly.com/pw/print/20180723/77564-what-authors-and-editors-wish-they-could-say-to-one-another.html\" target=\"_blank\" rel=\"noopener\">What Authors and Editors Wish They Could Say to One Another</a></li>\n<li><a href=\"https://greenleafbookgroup.com/learning-center/publishing-information/what-publishers-want\" target=\"_blank\" rel=\"noopener\">What Publishers Want</a> - Greenleaf Book Group</li>\n<li><a href=\"https://www.hubspot.com/make-my-persona\" target=\"_blank\" rel=\"noopener\">Create a Buyer Persona</a> - Hubspot\'s tool to identify your core audience</li>\n</ul>\n</td>\n<td style=\"width: 4%;\"> </td>\n<td style=\"width: 48%; text-align: center;\">\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\n<ul>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\n<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\n<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\n<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\n<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\n<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\n<li style=\"text-align: left;\"><a href=\"https://cdn.prowritingaid.com/ebook/ProWritingAid_EBook2.pdf\" target=\"_blank\" rel=\"noopener\">Novel Writing Training Plan</a> by Pro Writing Aid</li>\n<li style=\"text-align: left;\"><a href=\"https://prowritingaid.com/art/374/8-Ways-to-Make-Your-Story-Boring-.aspx?utm_source=twitter&amp;utm_medium=social\" target=\"_blank\" rel=\"noopener\">8 Ways to Make Your Story Boring</a></li>\n</ul>\n<p style=\"text-align: left;\"><strong>Self Promotion / Building a Platform</strong></p>\n<ul>\n<li style=\"text-align: left;\"><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\n<li style=\"text-align: left;\"><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\n<li style=\"text-align: left;\"><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging</a></li>\n<li style=\"text-align: left;\">Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\n<li style=\"text-align: left;\"><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\n<li style=\"text-align: left;\"><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\n<li style=\"text-align: left;\"><a href=\"https://writingcooperative.com/how-to-build-your-own-author-platform-from-scratch-9d6123858bac\" target=\"_blank\" rel=\"noopener\">How to Build your own author platform - from scratch</a></li>\n<li style=\"text-align: left;\"><a href=\"https://growthtools.com/#tools\" target=\"_blank\" rel=\"noopener\">Growth Tools</a> - Grow your online business</li>\n<li style=\"text-align: left;\"><a href=\"https://thewritepractice.com/building-an-author-website/\" target=\"_blank\" rel=\"noopener\">Building an Author Website: The First Step to Publishing</a></li>\n</ul>\n<p style=\"text-align: left;\"><strong>Marketing Books</strong></p>\n<ul>\n<li style=\"text-align: left;\"><a href=\"https://kindlepreneur.com/kindle-keywords-fiction-author-strategy/\" target=\"_blank\" rel=\"noopener\">Kindle Keyword Strategies for Fiction Authors</a></li>\n</ul>\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\n<ul>\n<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\n<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\n</ul>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 48%;\">\n<p><strong>Story Structure</strong></p>\n<ul>\n<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\n<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\n<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\n<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\n<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\n<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\n<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\n<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\n<li><a href=\"http://www.ian-irvine.com/on-writing/41-ways-to-create-and-heighten-suspense/\" target=\"_blank\" rel=\"noopener\">41 Ways to Create and Heighten Suspense</a></li>\n<li><a href=\"https://prowritingaid.com/art/387/Six-Tried-and-Tested-Methods-for-Writing-a-Novel.aspx?utm_source=twitter&amp;utm_medium=social\" target=\"_blank\" rel=\"noopener\">Six Tried and Tested Methods for Writing a Novel</a></li>\n</ul>\n<p><strong>Character Development</strong></p>\n<ul>\n<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\n<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\n<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\n<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\n<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\n<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\n<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\n<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\n<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\n<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\n<li><a href=\"https://mythcreants.com/blog/eight-absurdities-we-force-on-female-characters/\" target=\"_blank\" rel=\"noopener\">8 Absurdities we Force on Female Characters</a></li>\n</ul>\n<p><strong>Scenes</strong></p>\n<ul>\n<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\n<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\n<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\n</ul>\n<p><strong>Short Fiction</strong></p>\n<ul>\n<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\n<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\n</ul>\n<p><strong>Removing Filter Words</strong></p>\n<ul>\n<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\n<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\n</ul>\n</td>\n<td style=\"width: 4%;\"> </td>\n<td style=\"width: 48%;\">\n<p><strong>Worldbuilding</strong></p>\n<ul>\n<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\n<li><a href=\"https://io9.gizmodo.com/7-deadly-sins-of-worldbuilding-998817537\" target=\"_blank\" rel=\"noopener\">7 Deadly Sins of Worldbuilding</a></li>\n<li><a href=\"https://mythcreants.com/blog/five-common-worldbuilding-mistakes-in-new-manuscripts/\" target=\"_blank\" rel=\"noopener\">5 Common Worldbuilding Mistakes in New Manuscripts</a> (and a great blog)</li>\n<li><a href=\"https://mythcreants.com/blog/creating-a-mountain-setting/\" target=\"_blank\" rel=\"noopener\">Creating a Mountain Setting</a></li>\n<li><a href=\"https://nybookeditors.com/2017/07/fantasy-world-building-101-create-breathing-world-fantasy-novel/\" target=\"_blank\" rel=\"noopener\">Fantasy World Building 101: how to create a breathing world for your fantasy novel</a></li>\n<li>Worldbuilding Guide: <em>Excellent process</em>\n<ul>\n<li><a href=\"https://www.lostkingdom.net/worldbuilding-guide-1/\" target=\"_blank\" rel=\"noopener\">Part 1</a>, <a href=\"http://www.lostkingdom.net/worldbuilding-guide-2/\" target=\"_blank\" rel=\"noopener\">Part 2</a></li>\n<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-introduction/\" target=\"_blank\" rel=\"noopener\">Fantasy Economics 101</a></li>\n<li><a href=\"http://www.lostkingdom.net/fantasy-world-economics-101-labour-and-wages/\" target=\"_blank\" rel=\"noopener\">Economics: labour and wages</a></li>\n</ul>\n</li>\n<li><a href=\"https://electricliterature.com/against-worldbuilding-700e4861c26b\" target=\"_blank\" rel=\"noopener\">Against Worldbuilding</a> (caused quite a ruckus)</li>\n<li><a href=\"http://terribleminds.com/ramble/2013/09/17/25-things-you-should-know-about-worldbuilding/\" target=\"_blank\" rel=\"noopener\">25 Things You Should Know About Worldbuilding</a></li>\n</ul>\n<p><strong>Storytelling</strong></p>\n<ul>\n<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\n<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\n<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\n<li><a href=\"https://www.atlasobscura.com/articles/cyoa-choose-your-own-adventure-maps?utm_source=facebook.com&amp;utm_medium=atlas-page\" target=\"_blank\" rel=\"noopener\">Maps of Hidden Structures of Choose Your Own Adventure Books</a></li>\n</ul>\n<p><strong>Writers with Writing Advice</strong></p>\n<ul>\n<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\n<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\n</ul>\n<p><strong>Best Opening Lines</strong></p>\n<ul>\n<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\n</ul>\n<p><strong>Best Practices</strong></p>\n<ul>\n<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\n<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\n<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\n</ul>\n<p><strong>Fight Scenes</strong></p>\n<ul>\n<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\n</ul>\n<p><strong>Names</strong></p>\n<ul>\n<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\n<li><a href=\"https://www.fantasynamegenerators.com/witch-names.php\" target=\"_blank\" rel=\"noopener\">Witch name generator</a> (and lots others)</li>\n</ul>\n<p><strong>Romance</strong></p>\n<ul>\n<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\n<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\n</ul>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\n<table style=\"border-collapse: collapse; width: 100%; height: 1138px;\" border=\"0\">\n<tbody>\n<tr style=\"height: 1138px;\">\n<td style=\"width: 48%; height: 1138px;\">\n<p><strong>Quick References</strong></p>\n<ul>\n<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\n<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\n</ul>\n<p><strong>Templates for Writers</strong></p>\n<ul>\n<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\n<ul>\n<li>Novel development and professional templates</li>\n</ul>\n</li>\n<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\n</ul>\n<p><strong>General Gramm</strong></p>\n<ul>\n<li> </li>\n<li> </li>\n</ul>\n<p><strong>Grammar and Punctuation</strong></p>\n<ul>\n<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\n<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\n<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\n<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\n<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\n<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\n<li><a href=\"http://www.lousywriter.com/\" target=\"_blank\" rel=\"noopener\">Lousy Writer</a></li>\n<li><a href=\"https://www.englishgrammar101.com/\" target=\"_blank\" rel=\"noopener\">English Grammar 101</a></li>\n<li><a href=\"https://capitalizemytitle.com/\" target=\"_blank\" rel=\"noopener\">Capitalize My Title</a></li>\n</ul>\n<p><b>Finding Words (beyond dictionaries and Google)</b></p>\n<ul>\n<li><a href=\"https://www.powerthesaurus.org/\" target=\"_blank\" rel=\"noopener\">Power Thesaurus</a></li>\n<li><a href=\"https://english.stackexchange.com/\" target=\"_blank\" rel=\"noopener\">English Language and Usage Q&amp;A</a></li>\n<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\n<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\n<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\n<ul>\n<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\n</ul>\n</li>\n</ul>\n</td>\n<td style=\"width: 4%; height: 1138px;\"> </td>\n<td style=\"width: 48%; height: 1138px;\">\n<p><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong></p>\n<ul>\n<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\n<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\n<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\n</ul>\n<p>I<strong>dea Generators</strong></p>\n<ul>\n<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\n</ul>\n<p><strong>Mapping</strong></p>\n<ul>\n<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\n<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\n<li><a href=\"https://www.atlasobscura.com/articles/writers-maps?utm_source=twitter.com&amp;utm_medium=referral&amp;utm_campaign=SocialFlow\" target=\"_blank\" rel=\"noopener\">How Writers Map Their Imaginary Worlds</a></li>\n<li><a href=\"http://www.fantasyliterature.com/reviews/modern-fantasy-the-100-best-novels-1946-1987/\" target=\"_blank\" rel=\"noopener\">Medieval Fantasy City Generator</a></li>\n<li>Samples:\n<ul>\n<li><a href=\"https://mobile.twitter.com/foxtosser/status/1085558337947820032\" target=\"_blank\" rel=\"noopener\">Matthäus Merian\'s beautiful 1636 map of the Republic of Venice</a></li>\n</ul>\n</li>\n</ul>\n<p><strong>Sounds/Music for Writing</strong></p>\n<ul>\n<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\n<li><a href=\"http://moby.com/la1/\" target=\"_blank\" rel=\"noopener\">Long Ambients1: Calm. Sleep.</a> by Moby (free music)</li>\n</ul>\n<p><strong>Visuals</strong></p>\n<ul>\n<li><a href=\"http://www.texturemate.com/index.php/\" target=\"_blank\" rel=\"noopener\">Texture repository</a></li>\n<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\n<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\n<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\n<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\n</ul>\n<ul>\n<li><a href=\"https://www.atlasobscura.com/articles/pies-that-look-like-people\" target=\"_blank\" rel=\"noopener\">People Pot Pies</a></li>\n<li><a href=\"https://www.rachaeltalibart.com/ocean\" target=\"_blank\" rel=\"noopener\">Sirens</a> by Rachel Talibart</li>\n<li>Storms:\n<ul>\n<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\n<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)</li>\n<li><a href=\"https://mobile.twitter.com/CNN/status/1083264955162472448\" target=\"_blank\" rel=\"noopener\">Storms from a cockpit</a></li>\n<li><a href=\"https://mobile.twitter.com/welcomet0nature/status/1086926308565811200\" target=\"_blank\" rel=\"noopener\">South Dakota supercell</a></li>\n</ul>\n</li>\n</ul>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p><strong>Writing With Color<br /></strong>There are colors beyond the rainbow. Here are some sites providing terminology, visual references, and usage.</p>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 17.7674%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\n<td style=\"width: 2.13958%;\"> </td>\n<td style=\"width: 80.093%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\n</tr>\n</tbody>\n</table>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 39.7829%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\n<td style=\"width: 2.29462%;\"> </td>\n<td style=\"width: 57.9225%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\n</tr>\n</tbody>\n</table>\n<p>The Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a></p>\n<p> </p>\n<p><strong>Writing About the Color of People (and other aspects of humanity)<br /></strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.</p>\n<p><a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a></p>\n<ul>\n<li>$6 ebook: <a href=\"http://writingtheother.com/roundtable-stay-lane/\" target=\"_blank\" rel=\"noopener\">Writing the Other: A Practical Approach</a></li>\n</ul>\n<p>Two excellent articles by Mod Colette to get you started:</p>\n<ul>\n<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\n<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\n</ul>\n<p><a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a></p>\n<p><a href=\"https://bookriot.com/2018/02/05/casually-racist-things-that-white-authors-do/\" target=\"_blank\" rel=\"noopener\">7 Casually Racist Things That White Authors Do</a></p>\n<p><a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a></p>\n<p><a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a></p>\n<p><a href=\"https://www.publishersweekly.com/pw/by-topic/columns-and-blogs/soapbox/article/77726-sensitivity-readers-what-are-they-good-for-a-lot.html?utm_source=Publishers+Weekly&amp;utm_campaign=e9fbb28448-EMAIL_CAMPAIGN_2018_08_13_02_56&amp;utm_medium=email&amp;utm_term=0_0bb2959cbb-e9fbb28448-306103905\" target=\"_blank\" rel=\"noopener\">Sensitivity Readers! What are they good for?</a></p>\n<p>Parallel to this topic:</p>\n<ul>\n<li><a href=\"https://mobile.twitter.com/lilrednacho/status/909914206270615552\" target=\"_blank\" rel=\"noopener\">\"How does kids dressing up as Pocahontas reinforce genocide?\"</a></li>\n</ul>\n<p>Articles with visual references of human coloration:</p>\n<ul>\n<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\n<li>Eye color\n<ul>\n<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\n</ul>\n</li>\n<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\n</ul>\n<p>Other aspects of our humanity:</p>\n<ul>\n<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\n<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\n</ul>\n<p>Finding characters</p>\n<ul>\n<li><a href=\"https://www.modelmanagement.com/\" target=\"_blank\" rel=\"noopener\">Model Management</a>: Too many authors use famous actors to give flesh to their characters. Search by nation for different looks and and facial types.</li>\n</ul>\n<p style=\"text-align: center;\"><strong>Research for Different Stories</strong></p>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 48%;\">\n<p><strong>Mysteries</strong></p>\n<ul>\n<li><a href=\"https://www.nypl.org/blog/2017/05/22/arthur-conan-doyle?utm_campaign=SocialFlow&amp;utm_source=twitter.com&amp;utm_medium=referral\">Arthur Conan Doyle: Researching Crimes and Detectives with NYPL\'s E-Resources</a></li>\n</ul>\n</td>\n<td style=\"width: 4%;\"> </td>\n<td style=\"width: 48%;\">\n<ul>\n<li>...</li>\n</ul>\n</td>\n</tr>\n</tbody>\n</table>\n<p style=\"text-align: center;\"><strong>History and Interesting Fact(oid)s</strong></p>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 48%;\">\n<p><strong>Terminology</strong></p>\n<ul>\n<li><a style=\"font-family: inherit; font-weight: inherit;\" href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\n</ul>\n<p><strong>Language</strong></p>\n<ul>\n<li><a href=\"https://scotlandwelcomesyou.com/scottish-sayings/\" target=\"_blank\" rel=\"noopener\">Old Scottish Sayings</a></li>\n</ul>\n<p><strong>Maps</strong></p>\n<ul>\n<li><a href=\"http://londonist.com/london/maps/fake-britain-map-fictional-locations-england-scotland-wales\">Fake Britain: A Map Of Fictional Locations In England, Scotland And Wales</a></li>\n</ul>\n<p>Info for Sci Fi Writers</p>\n<ul>\n<li><a href=\"http://www.projectrho.com/public_html/rocket/sfbackground.php\" target=\"_blank\" rel=\"noopener\">Atomic Rockets</a></li>\n</ul>\n</td>\n<td style=\"width: 4%;\"> </td>\n<td style=\"width: 48%;\">\n<ul>\n<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\n<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\n<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\n<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\n<li><a href=\"https://www.atlasobscura.com/articles/civil-war-salt\" target=\"_blank\" rel=\"noopener\">How Salt Helped Win the Civil War</a> - fascinating look at how attacking a food resource impacted the South during the war</li>\n<li><a href=\"https://mobile.twitter.com/DrLindseyFitz/status/1083778992052858880\" target=\"_blank\" rel=\"noopener\">10 Fascinating Mummies</a></li>\n</ul>\n</td>\n</tr>\n</tbody>\n</table>\n<p style=\"text-align: center;\"><strong>Software</strong></p>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 48%;\">\n<p><strong>Worldbuilding/Mapping</strong></p>\n<ul>\n<li><a style=\"font-family: inherit; font-weight: inherit;\" href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\n<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\n<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\n</ul>\n</td>\n<td style=\"width: 4%;\"> </td>\n<td style=\"width: 48%;\">\n<p><strong>Social Headache Remedies</strong></p>\n<ul>\n<li><a href=\"https://chrome.google.com/webstore/detail/twitter-follower-blocker/clmjfekijbbiblcnelcmmfnlaaancehn?hl=en\" target=\"_blank\" rel=\"noopener\">Twitter follower blocker</a></li>\n</ul>\n<p><strong>Lists</strong></p>\n<ul>\n<li><a style=\"font-family: inherit; font-weight: inherit;\" href=\"https://www.techradar.com/news/best-mind-map-software\" target=\"_blank\" rel=\"noopener\">Best mind map software of 2018</a></li>\n</ul>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p> </p>\n<p><em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em></p>\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\n<tbody>\n<tr>\n<td style=\"width: 48%;\"> </td>\n<td style=\"width: 4%;\"> </td>\n<td style=\"width: 48%;\"> </td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n\n<!-- wp:themify-builder/canvas /-->','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2019-01-30 18:20:21','2019-01-30 18:20:21','',39,'https://dmweade.com/welcome/2019/01/30/39-revision-v1/',0,'revision','',0),
 (142,1,'2018-08-14 19:53:15','2018-08-14 19:53:15','','Crayon color grid','','inherit','open','closed','','crayon-color-grid','','','2018-08-14 19:53:15','2018-08-14 19:53:15','',39,'https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid.jpg',0,'attachment','image/jpeg',0),
 (144,1,'2018-08-14 20:29:08','2018-08-14 20:29:08','<strong>Links. Lots of them. Trying to bring order from chaos.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Sites Offering Specialty Information</strong>\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a> and <a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n</ul>\r\n<strong>Free Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.beneath-ceaseless-skies.com/\" target=\"_blank\" rel=\"noopener\">Beneath Ceaseless Skies</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li></li>\r\n</ul>','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 20:29:08','2018-08-14 20:29:08','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (145,1,'2018-08-14 20:44:13','2018-08-14 20:44:13','<strong>Links. Lots of them. Trying to bring order from chaos.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Sites Offering Specialty Information</strong>\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a> and <a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n</ul>\r\n<strong>Free Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.beneath-ceaseless-skies.com/\" target=\"_blank\" rel=\"noopener\">Beneath Ceaseless Skies</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n<strong>Map and Distance Calculations</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 20:44:13','2018-08-14 20:44:13','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (146,1,'2018-08-14 20:45:47','2018-08-14 20:45:47','<strong>Links. Lots of them. Trying to bring order from chaos.</strong>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Online Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<strong>Getting started</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://oncewritten.com/\">Once Written</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a> (online)</li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Sites Offering Specialty Information</strong>\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Sites supporting writing</strong>\r\n<ul>\r\n 	<li><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a> and <a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Submitting to Publishers</strong>\r\n<ul>\r\n 	<li><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n</ul>\r\n<strong>Free Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.beneath-ceaseless-skies.com/\" target=\"_blank\" rel=\"noopener\">Beneath Ceaseless Skies</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n<strong>Map and Distance Calculations</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 20:45:47','2018-08-14 20:45:47','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (147,1,'2018-08-14 23:13:24','2018-08-14 23:13:24','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Publishing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Getting Started</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>General Craft</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"text-align: center;\"><strong>Specialty Information and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 23:13:24','2018-08-14 23:13:24','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (148,1,'2018-08-14 23:14:19','2018-08-14 23:14:19','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Publishing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Getting Started</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>General Craft</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"text-align: center;\"><strong>Specialty Information and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 23:14:19','2018-08-14 23:14:19','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0);

INSERT INTO `1587776537_posts` VALUES 
(149,1,'2018-08-14 23:14:47','2018-08-14 23:14:47','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Publishing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Getting Started</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>General Craft</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.theshortform.com/tips-for-writing-very-short-fiction\">Tips for Writing Very Short Fiction</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a>\r\n<ul>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Sequels to Scenes</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n</ul>\r\n<strong>Extras</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Specialty Information and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-14 23:14:47','2018-08-14 23:14:47','',39,'https://dmweade.com/welcome/2018/08/14/39-revision-v1/',0,'revision','',0),
 (151,1,'2018-08-15 02:45:06','2018-08-15 02:45:06','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\nSelf Promotion\r\n<ul>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Getting Started</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">&nbsp;\r\n\r\n<strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n<ul>\r\n 	<li></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n 	<li></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n&nbsp;\r\n<p style=\"text-align: center;\"></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 02:45:06','2018-08-15 02:45:06','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (152,1,'2018-08-15 02:46:23','2018-08-15 02:46:23','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\nSelf Promotion\r\n<ul>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Getting Started</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">&nbsp;\r\n\r\n<strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n<ul>\r\n 	<li></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n 	<li></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 02:46:23','2018-08-15 02:46:23','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (153,2,'2018-08-15 13:54:57','2018-08-15 13:54:57','<!-- wp:paragraph -->\n<p>Aging sucks. Sitting for long periods of time is damaging. Get off your ass and do something, there are too many options to choose doing nothing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Motivation</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.cnn.com/2019/12/09/health/sports-improves-brain-health-wellness/index.html#\">Athletes have healthier brains that can actually hear better</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://qz.com/quartzy/1413808/heres-what-a-brief-jog-can-do-for-your-brain/\">What a Brief Jog Can Do For Your Brain</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.theguardian.com/lifeandstyle/2020/feb/24/10-biggest-myths-in-fitness-scales-are-pointless\">10 Biggest Myths of Fitness</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Warnings</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://lifehacker.com/this-graphic-explains-all-the-health-hazards-of-sitting-1595834900\">Hazards of Sitting Too Long</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Happier/Smarter/Better</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f\" target=\"_blank\">24 Podcasts to Make You Smarter</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.vox.com/science-and-health/2019/1/4/17989224/intellectual-humility-explained-psychology-replication\">Intellectual Humility</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.huffpost.com/entry/ways-to-be-happier-2020_l_5dfc23a9e4b05b08bab2981c\">20 Ways To Be A Happier Person In 2020, According To Therapists</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f\" target=\"_blank\">14 Ways Reading Improves Your Mind and Body</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.businessinsider.com/15-signs-your-life-more-on-track-you-may-think-2019-8\">15 Signs Your Life is More on Track Than You Think it is</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a rel=\"noreferrer noopener\" href=\"https://www.npr.org/sections/health-shots/2018/07/30/632480321/off-your-mental-game-you-could-be-mildly-dehydrated\" target=\"_blank\">Off Your Mental Game? You Could Be Mildly Dehydrated</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator -->\n<hr class=\"wp-block-separator\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"className\":\"has-2-columns\"} -->\n<div class=\"wp-block-columns has-2-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Gaining Strength<br></strong>(Choose one and get started) </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.outsideonline.com/2243691/absolute-minimalists-strength-workout\">Minimalist Workout for All-Around Strength</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.fatherly.com/health-science/7-best-core-exercises-for-men/?utm_content=fatherly&amp;utm_campaign=twowned&amp;utm_source=twitter&amp;utm_medium=social\" target=\"_blank\">7 Essential Exercises For Building A Strong Core</a></li><li><a rel=\"noreferrer noopener\" href=\"https://vitals.lifehacker.com/get-closer-to-doing-a-handstand-in-12-minutes-1796377028\" target=\"_blank\">Get Closer to Doing a Handstand in 12 Minutes</a></li><li><a rel=\"noreferrer noopener\" href=\"http://strength.stack52.com/periodic-table-of-bodyweight-exercises/\" target=\"_blank\">Periodic Table of Exercises</a> (with how-to)</li><li><a rel=\"noreferrer noopener\" href=\"https://www.artofmanliness.com/articles/gymnastic-rings-101-a-beginners-routine-faqs/\" target=\"_blank\">Gymnastic Rings 101: A Beginner’s Routine &amp; FAQs</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.urbanstrength.com.au/blogs/articles/gymnastic-rings-workout-exercises-for-beginners#\" target=\"_blank\">Gymnastic rings workout exercises for beginners</a></li><li><a rel=\"noreferrer noopener\" href=\"https://well.blogs.nytimes.com/2013/06/19/the-4-minute-workout/?runwell&amp;_r=1\" target=\"_blank\">Four Minute Workout</a></li><li><a rel=\"noreferrer noopener\" href=\"https://well.blogs.nytimes.com/2013/05/09/the-scientific-7-minute-workout/?_r=0\" target=\"_blank\">Scientific Seven Minute Workout</a></li><li><a href=\"https://www.youtube.com/watch?v=WiCgWNLl56w&amp;list=PLgS9GW2BKv-OixUzY3WCbwT8QJVBjH7tu&amp;index=2&amp;t=0s\">YMCA Live On Demand Group Exercise</a></li><li><a href=\"https://www.gq.com/story/five-moves-full-body-workout\">Only 5 Exercises You\'ll Ever Need</a></li><li><a href=\"https://www.outsideonline.com/2049441/11-moves-help-athletes-get-better-age\">11 Moves To Help Get Better With Age</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Flexibility</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://gmb.io/hip-mobility/\" target=\"_blank\">8 Exercises to Improve Hip Mobility &amp; Loosen Tight Hips</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.businessinsider.com/best-everyday-stretches-2016-4\" target=\"_blank\">12 everyday stretches to stay flexible and fit at any age</a></li><li><a href=\"https://www.youtube.com/user/yogawithadriene\">Yoga with Adrienne</a></li></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p><strong>Repair</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://healthnewstips.today/backpain/index98162569.html?voluumdata=deprecated&amp;eda=deprecated&amp;cep=k2FyJKJn-Y1fpOlglraghl9fpoCpNsvuoP8auhdbU7xF0QVEZgiWIsBpXBfd9Af8CPwaP3xtQ-c2oHAVk8V-0ZNrYIR0_7ASQDP1PitsvckG5eUEuSpqPry5nG-Mq2AwQnFS_bMORRQGiCLRoNyzDYSUgv1X5YnFguq3iNzLkOEcJfHa20_3thkMS3Ck3Nn_j0mkqEyZAlAekg4ByjxQAS4ua_M3Wg6QYGjFQb6eKyBfKGIWYOwLzbUGitp9hds0aFhiJFLZKU0BhNQGTDtGHqmCOLxNiG4d6YdK9kn9PBU5FUQKutHvPpLdelRMpgc2wzdj53hBqEpM6SSqjPwtzr2ARJovBeCRBe-RP05oyfe6zI55xsaq-2KJX6DaZWKlklm7THPUJok5kpmrWvtTb_wgINGr6ulyqSz9UIMgjrmTEPrddv1HQLwu-MJqASfZLeaDKjic4RVVbRC0tZ0q9Mvh0myuTMImfHFn1SGB9xlXrdm_MZN6aoBanP571QuLEMm_U8NFJ1-mf3eyeM7gCM3g2kfR6c-GVerzlD7iQtNLN7FTV5jGCcy-y0zwmUVT_53gRdwfcvzx50GDeYhrJQU2dehy7URlKmPkTq5rgxf7FeJOtlxjyUAfeCtd7Qevi2O7N_X04R5C9ypkkitlRk1e_tSwApso6ZNQKkYNfs4&amp;utm_content=Chiropractors%20Baffled:%20Simple%20Stretch%20Relieves%20Years%20of%20Back%20Pain%20(Wat&amp;utm_term=002f47524a4d52e792bdafd472a8a59f46&amp;Doc_title=Erase%20My%20Back%20Pain%20%7C%20Health%20News%20Tips&amp;utm_site=espn.com/blog&amp;utm_pub=ESPN%20(ESPN)&amp;newad=2&amp;utm_adid=0099e7015bc5f22a3ffd6c2f75588d3a8a&amp;utm_doc_id=0050095ecbe5398c9b98b4d8cecb4f189b&amp;utm_new=002f47524a4d52e792bdafd472a8a59f46_espn.com/blog&amp;utm_cam=TabTier1NewVersion&amp;ob_click_id=7cb27d9a197ff36ebc26e48764a37bc1-000be295f74876f5c74c82e3c8a2545eae\" target=\"_blank\">10 Minute Stretch Routine for Back Pain</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.bodybuilding.com/content/what-is-the-best-hiit-workout.html\" target=\"_blank\">High Intensity Interval Training</a></li><li><a rel=\"noreferrer noopener\" href=\"https://gmb.io/elbows/?utm_source=drip&amp;utm_medium=email&amp;utm_campaign=17%2F10%2F30+Elbows&amp;utm_content=The+loneliest+body+part\" target=\"_blank\">Fixing Elbow Pain</a></li><li><a rel=\"noreferrer noopener\" href=\"https://lifehacker.com/do-these-three-exercises-in-four-minutes-to-improve-you-1777522021?utm_campaign=socialflow_lifehacker_facebook&amp;utm_source=lifehacker_facebook&amp;utm_medium=socialflow\" target=\"_blank\">3 Exercises for Hunched Posture</a></li><li><a rel=\"noreferrer noopener\" href=\"https://www.vox.com/science-and-health/2017/8/4/15929484/chronic-back-pain-treatment-mainstream-vs-alternative\" target=\"_blank\">A comprehensive guide to the new science of treating lower back pain</a></li><li><a rel=\"noreferrer noopener\" href=\"https://darebee.com/modifications.html\" target=\"_blank\">Exercise adjustments if injured</a></li><li><a href=\"https://www.outsideonline.com/2407208/shoulder-pain-exercises-rotator-cuff-injury\">7 Exercises to Fix Shoulder Pain</a></li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Climbing</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Climbing Mag Home Wall Primer</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol><li><a href=\"https://www.climbing.com/skills/home-wall-primer-part-1planning-and-construction/\">Planning and Construction</a></li><li><a href=\"https://www.climbing.com/skills/home-wall-primer-choosing-holds/\">Choosing Holds</a></li><li><a href=\"https://www.climbing.com/skills/home-wall-primer-route-setting/\">Route Setting</a></li><li><a href=\"https://www.rei.com/blog/climb/build-home-climbing-wall\">How to Build a Home Climbing Wall</a></li></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Affordable Holds</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.elementclimbing.com/Bulk-Climbing-Holds-s/1826.htm\">Element Climbing bulk clearance</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://escapeclimbing.com/collections/holds/products/factory-seconds\">Escape Climbing factory seconds</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.rockymountainclimbinggear.com/sample-pack\">Rocky Mountain Climbing Gear $15 sample pack</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"https://www.atomikclimbingholds.com/free-sample-holds-bolt-on\">Atomic Climbing free holds sample</a> (you pay shipping)</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->','Exercise and Self-care','','publish','closed','closed','','exercise-and-self-care','','','2020-03-30 18:58:32','2020-03-30 18:58:32','',0,'https://dmweade.com/welcome/?page_id=153',0,'page','',0),
 (154,1,'2018-08-15 13:07:28','2018-08-15 13:07:28','Off Your Mental Game? You Could Be Mildly Dehydrated\n\nhttps://www.npr.org/sections/health-shots/2018/07/30/632480321/off-your-mental-game-you-could-be-mildly-dehydrated\n\n&nbsp;','Exercise and Self Care','','inherit','closed','closed','','153-revision-v1','','','2018-08-15 13:07:28','2018-08-15 13:07:28','',153,'https://dmweade.com/welcome/2018/08/15/153-revision-v1/',0,'revision','',0),
 (155,1,'2018-08-15 13:13:47','2018-08-15 13:13:47','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n 	<li></li>\r\n</ul>\r\n<strong>Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books </a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 13:13:47','2018-08-15 13:13:47','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (157,1,'2018-08-15 13:28:43','2018-08-15 13:28:43','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n 	<li></li>\r\n</ul>\r\n<strong>Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books </a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other things)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly? </a></li>\r\n</ul>\r\n</li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 13:28:43','2018-08-15 13:28:43','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (159,1,'2018-08-15 13:54:32','2018-08-15 13:54:32','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n 	<li></li>\r\n</ul>\r\n<strong>Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 13:54:32','2018-08-15 13:54:32','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (352,1,'2019-07-03 14:11:19','1970-01-02 00:00:01','<!-- wp:paragraph -->\n<p>After a few weeks, <a href=\"https://niemanstoryboard.org/stories/flow/\">this article</a> by <a href=\"https://niemanstoryboard.org/authors/jacqui-banaszynski/\">Jacqui Banaszynski</a>, I find myself still thinking about my writing flow. I\'ve had a turbulent couple of years, though some of the events were wonderful. The birth of our second child, back in 2016, was the wonderful part, and the rest was just bumpy. Bumpiness includes our son suffering ear infections for three months before getting tubes, considering multiple job offers for my wife, and my 6-month bout of chronic mononucleosis.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Add in a few vacations and the normal events, such as colds my son brings home from daycare, and flow has been very hard to come by. I\'ve had moments, but recall requiring some time (a good bit of runway, as I call it) to get some air beneath my wings. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Without this, I continue to churn with only short periods of well-crafted content. Dipping into that mental space on and off is exhausting. It comes at a price, which is usually burnout by mid-day. Part of this is still fighting back from my illness-<a href=\"https://www.mayoclinic.org/diseases-conditions/mononucleosis/expert-answers/mononucleosis/faq-20058564\">the virus is again dormant</a>, but I\'m not back to the full health I was enjoying a year ago. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Part of the reason <a href=\"https://twitter.com/JacquiB\">JacquiB</a>\'s article sticks with me is my view that regaining both my physical health and mental focus are combined. I don\'t recall the first author who pointed out the need to connect health and writing, but I\'ve long considered the two entwined. To keep this short, here are the five requirements in the article and how I\'m approaching each:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>1. Focus on the craft or effort itself, and not on whether you think  you are doing things “right” or what others might be thinking about you</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>I\'m in very different places with this pre- and post-illness. I don\'t have a strong background in writing before jumping into it with both feet. Following advice given on the Writing Excuses podcast, I delved into writing as a full-time focus and read/watched/listened to as much information about storytelling as possible.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This was a double-edged sword, because I did not focus on the grammar side. Last summer, before my illness, another writer gave me some wonderful feedback that my stories and characters are solid. His critical feedback was a need to eradicate ongoing tendencies such as filter words. None of his feedback proved difficult last summer, when I was working at a higher level of skill. Since my illness, my lows are much lower. And so I\'m always considering what others might think. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I don\'t think that\'s a bad thing when one is attempting to connect with the reader\'s perspective, but debilitating when it triggers moments of imposter syndrome. To fix this, I\'ve been fortunate to find a local MFA graduate, soon to begin her PhD, for a few weeks this summer. Feedback from someone with expertise has really helped to identify my strengths and weaknesses, which may have been THE problem-you can\'t fix what you can\'t identify.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>2. Confidence, which can come from the belief that a skill is as much  about learning and practice as it is about some innate, magical talent</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>This is my strength. I take pride in approaching my problems with a professional demeanor. This doesn\'t guarantee anything, but it damn well doesn\'t hurt. I see this as providing a reason to step back from the problem for a broad view rather than fixating on the issue to where it develops gravity. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This gives me an excuse to filter out anything and everything, because approaching something professionally includes giving it all your attention. My problem then becomes how much attentiveness I possess in that moment. Some days are better than others. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Autonomy, which involves the ability to choose when you want feedback or guidance</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>Autonomy is an idea I\'ve never considered. Perhaps because none of my work is yet publicly accessible. I have told off a few people who came in with barrels blazing, always part of attempt to force me into their viewpoint/approach/values. That\'s just bullshit in the art world between experienced artists as there are so many ways to skin a cat.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I\'ve also learned how to weight feedback, including an ability to filter out criticism without merit. That\'s not the same as not accepting feedback that makes me feel bad. I once listened to feedback that nudged at a repressed concern, one I thought I\'d accepted, which sent me on a wild goose chase. I learned a bit from the chase, but eventually learned the person providing the criticism wasn\'t giving sound advice. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>The elusive practice of quieting the mind — just doing the thing you’re doing rather than <em>thinking</em> about the thin you’re doing</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>I\'ve always thought this is the heart of \"flow\" as the term is defined in my mind. This is also the element I believe compares to the athletic mindset. I\'ve had to build up stamina for <a href=\"http://www.publishingcrawl.com/2013/01/28/butt-in-chair-hands-on-keyboard/\">BICHOK</a> (Butt in chair, hands on keyboard), which then helped me build up the mental endurance for longer, and more focused, stretches of writing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Once in that flow, the ability to access memory (I call it \"filling my RAM with the details\") as one creates becomes a state rather than a process. Gaining altitude comes naturally when a challenge in the project pushes me out: checking a definition, checking character notes, referring to a map, researching terms, etc...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>I\'ve been both strong and weak with quieting my mind. I\'m struggling right now, just too many life events taking up mental energy, but hope to return from vacation ready to dive into building towards relaxed flow. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>And finally, of course, practice, practice and more practice. Simply  put, doing the thing, and doing it again and again, until it is part of  you</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>I left the requirements in order, but for me #5 was (and is) a prerequisite for #4. On the other hand, being aware of what I was seeking BEFORE all the practice might have helped. Though these things always seem to be something one must find on their own as Buddha comes from within. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Over the last few years, approaching this professionally gave me a solid path of practice while attempting to find my flow. Now if I can just get it back.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> Other links:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><li><a href=\"https://www.chronicle.com/blogs/profhacker/the-writer-as-athlete/22905\">The Writer as Athlete by Billie Nara</a></li><li><a href=\"https://niemanstoryboard.org/stories/narrative-sweat-flow-seven-writers-one-inquiring-student/\">“Narrative Sweat &amp; Flow:” Seven writers, one inquiring student</a> by Simina Mistreanu</li></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->','Five Primary Requirements for Writing Flow','','draft','open','open','','','','','2019-07-03 14:11:19','2019-07-03 14:11:19','',0,'https://dmweade.com/welcome/?p=352',0,'post','',0),
 (161,1,'2018-08-15 17:58:22','2018-08-15 17:58:22','<p style=\"text-align: center;\"><strong>Aging is hard, and sitting for long periods makes it worse</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Gaining Strength</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.fatherly.com/health-science/7-best-core-exercises-for-men/?utm_content=fatherly&amp;utm_campaign=twowned&amp;utm_source=twitter&amp;utm_medium=social\" target=\"_blank\" rel=\"noopener\">7 Essential Exercises For Building A Strong Core</a></li>\r\n 	<li><a href=\"https://vitals.lifehacker.com/get-closer-to-doing-a-handstand-in-12-minutes-1796377028\" target=\"_blank\" rel=\"noopener\">Get Closer to Doing a Handstand in 12 Minutes</a></li>\r\n 	<li><a href=\"http://strength.stack52.com/periodic-table-of-bodyweight-exercises/\" target=\"_blank\" rel=\"noopener\">Periodic Table of Exercises</a> (with how-to)</li>\r\n 	<li><a href=\"https://www.artofmanliness.com/articles/gymnastic-rings-101-a-beginners-routine-faqs/\" target=\"_blank\" rel=\"noopener\">Gymnastic Rings 101: A Beginner’s Routine &amp; FAQs</a></li>\r\n 	<li><a href=\"https://www.urbanstrength.com.au/blogs/articles/gymnastic-rings-workout-exercises-for-beginners#\" target=\"_blank\" rel=\"noopener\">GYMNASTIC RINGS WORKOUT EXERCISES FOR BEGINNERS</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Repair</strong>\r\n<ul>\r\n 	<li><a href=\"https://healthnewstips.today/backpain/index98162569.html?voluumdata=deprecated&amp;eda=deprecated&amp;cep=k2FyJKJn-Y1fpOlglraghl9fpoCpNsvuoP8auhdbU7xF0QVEZgiWIsBpXBfd9Af8CPwaP3xtQ-c2oHAVk8V-0ZNrYIR0_7ASQDP1PitsvckG5eUEuSpqPry5nG-Mq2AwQnFS_bMORRQGiCLRoNyzDYSUgv1X5YnFguq3iNzLkOEcJfHa20_3thkMS3Ck3Nn_j0mkqEyZAlAekg4ByjxQAS4ua_M3Wg6QYGjFQb6eKyBfKGIWYOwLzbUGitp9hds0aFhiJFLZKU0BhNQGTDtGHqmCOLxNiG4d6YdK9kn9PBU5FUQKutHvPpLdelRMpgc2wzdj53hBqEpM6SSqjPwtzr2ARJovBeCRBe-RP05oyfe6zI55xsaq-2KJX6DaZWKlklm7THPUJok5kpmrWvtTb_wgINGr6ulyqSz9UIMgjrmTEPrddv1HQLwu-MJqASfZLeaDKjic4RVVbRC0tZ0q9Mvh0myuTMImfHFn1SGB9xlXrdm_MZN6aoBanP571QuLEMm_U8NFJ1-mf3eyeM7gCM3g2kfR6c-GVerzlD7iQtNLN7FTV5jGCcy-y0zwmUVT_53gRdwfcvzx50GDeYhrJQU2dehy7URlKmPkTq5rgxf7FeJOtlxjyUAfeCtd7Qevi2O7N_X04R5C9ypkkitlRk1e_tSwApso6ZNQKkYNfs4&amp;utm_content=Chiropractors%20Baffled:%20Simple%20Stretch%20Relieves%20Years%20of%20Back%20Pain%20(Wat&amp;utm_term=002f47524a4d52e792bdafd472a8a59f46&amp;Doc_title=Erase%20My%20Back%20Pain%20%7C%20Health%20News%20Tips&amp;utm_site=espn.com/blog&amp;utm_pub=ESPN%20(ESPN)&amp;newad=2&amp;utm_adid=0099e7015bc5f22a3ffd6c2f75588d3a8a&amp;utm_doc_id=0050095ecbe5398c9b98b4d8cecb4f189b&amp;utm_new=002f47524a4d52e792bdafd472a8a59f46_espn.com/blog&amp;utm_cam=TabTier1NewVersion&amp;ob_click_id=7cb27d9a197ff36ebc26e48764a37bc1-000be295f74876f5c74c82e3c8a2545eae\" target=\"_blank\" rel=\"noopener\">10 Minute Stretch Routine for Back Pain</a></li>\r\n 	<li><a href=\"https://www.bodybuilding.com/content/what-is-the-best-hiit-workout.html\" target=\"_blank\" rel=\"noopener\">High Intensity Interval Training</a></li>\r\n 	<li><a href=\"https://gmb.io/elbows/?utm_source=drip&amp;utm_medium=email&amp;utm_campaign=17%2F10%2F30+Elbows&amp;utm_content=The+loneliest+body+part\" target=\"_blank\" rel=\"noopener\">Fixing Elbow Pain</a></li>\r\n 	<li><a href=\"https://lifehacker.com/do-these-three-exercises-in-four-minutes-to-improve-you-1777522021?utm_campaign=socialflow_lifehacker_facebook&amp;utm_source=lifehacker_facebook&amp;utm_medium=socialflow\" target=\"_blank\" rel=\"noopener\">3 Exercises for Hunched Posture</a></li>\r\n</ul>\r\n<strong>Other forms of care</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f\" target=\"_blank\" rel=\"noopener\">14 Ways Reading Improves Your Mind and Body</a></li>\r\n 	<li><a href=\"https://www.npr.org/sections/health-shots/2018/07/30/632480321/off-your-mental-game-you-could-be-mildly-dehydrated\" target=\"_blank\" rel=\"noopener\">Off Your Mental Game? You Could Be Mildly Dehydrated</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Exercise and Self Care','','inherit','closed','closed','','153-revision-v1','','','2018-08-15 17:58:22','2018-08-15 17:58:22','',153,'https://dmweade.com/welcome/2018/08/15/153-revision-v1/',0,'revision','',0),
 (162,1,'2018-08-15 17:58:24','2018-08-15 17:58:24','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n 	<li></li>\r\n</ul>\r\n<strong>Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 17:58:24','2018-08-15 17:58:24','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (164,1,'2018-08-15 18:13:21','2018-08-15 18:13:21','<p style=\"text-align: center;\"><strong>Aging is hard, and sitting for long periods makes it worse</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Gaining Strength</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.fatherly.com/health-science/7-best-core-exercises-for-men/?utm_content=fatherly&amp;utm_campaign=twowned&amp;utm_source=twitter&amp;utm_medium=social\" target=\"_blank\" rel=\"noopener\">7 Essential Exercises For Building A Strong Core</a></li>\r\n 	<li><a href=\"https://vitals.lifehacker.com/get-closer-to-doing-a-handstand-in-12-minutes-1796377028\" target=\"_blank\" rel=\"noopener\">Get Closer to Doing a Handstand in 12 Minutes</a></li>\r\n 	<li><a href=\"http://strength.stack52.com/periodic-table-of-bodyweight-exercises/\" target=\"_blank\" rel=\"noopener\">Periodic Table of Exercises</a> (with how-to)</li>\r\n 	<li><a href=\"https://www.artofmanliness.com/articles/gymnastic-rings-101-a-beginners-routine-faqs/\" target=\"_blank\" rel=\"noopener\">Gymnastic Rings 101: A Beginner’s Routine &amp; FAQs</a></li>\r\n 	<li><a href=\"https://www.urbanstrength.com.au/blogs/articles/gymnastic-rings-workout-exercises-for-beginners#\" target=\"_blank\" rel=\"noopener\">GYMNASTIC RINGS WORKOUT EXERCISES FOR BEGINNERS</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Repair</strong>\r\n<ul>\r\n 	<li><a href=\"https://healthnewstips.today/backpain/index98162569.html?voluumdata=deprecated&amp;eda=deprecated&amp;cep=k2FyJKJn-Y1fpOlglraghl9fpoCpNsvuoP8auhdbU7xF0QVEZgiWIsBpXBfd9Af8CPwaP3xtQ-c2oHAVk8V-0ZNrYIR0_7ASQDP1PitsvckG5eUEuSpqPry5nG-Mq2AwQnFS_bMORRQGiCLRoNyzDYSUgv1X5YnFguq3iNzLkOEcJfHa20_3thkMS3Ck3Nn_j0mkqEyZAlAekg4ByjxQAS4ua_M3Wg6QYGjFQb6eKyBfKGIWYOwLzbUGitp9hds0aFhiJFLZKU0BhNQGTDtGHqmCOLxNiG4d6YdK9kn9PBU5FUQKutHvPpLdelRMpgc2wzdj53hBqEpM6SSqjPwtzr2ARJovBeCRBe-RP05oyfe6zI55xsaq-2KJX6DaZWKlklm7THPUJok5kpmrWvtTb_wgINGr6ulyqSz9UIMgjrmTEPrddv1HQLwu-MJqASfZLeaDKjic4RVVbRC0tZ0q9Mvh0myuTMImfHFn1SGB9xlXrdm_MZN6aoBanP571QuLEMm_U8NFJ1-mf3eyeM7gCM3g2kfR6c-GVerzlD7iQtNLN7FTV5jGCcy-y0zwmUVT_53gRdwfcvzx50GDeYhrJQU2dehy7URlKmPkTq5rgxf7FeJOtlxjyUAfeCtd7Qevi2O7N_X04R5C9ypkkitlRk1e_tSwApso6ZNQKkYNfs4&amp;utm_content=Chiropractors%20Baffled:%20Simple%20Stretch%20Relieves%20Years%20of%20Back%20Pain%20(Wat&amp;utm_term=002f47524a4d52e792bdafd472a8a59f46&amp;Doc_title=Erase%20My%20Back%20Pain%20%7C%20Health%20News%20Tips&amp;utm_site=espn.com/blog&amp;utm_pub=ESPN%20(ESPN)&amp;newad=2&amp;utm_adid=0099e7015bc5f22a3ffd6c2f75588d3a8a&amp;utm_doc_id=0050095ecbe5398c9b98b4d8cecb4f189b&amp;utm_new=002f47524a4d52e792bdafd472a8a59f46_espn.com/blog&amp;utm_cam=TabTier1NewVersion&amp;ob_click_id=7cb27d9a197ff36ebc26e48764a37bc1-000be295f74876f5c74c82e3c8a2545eae\" target=\"_blank\" rel=\"noopener\">10 Minute Stretch Routine for Back Pain</a></li>\r\n 	<li><a href=\"https://www.bodybuilding.com/content/what-is-the-best-hiit-workout.html\" target=\"_blank\" rel=\"noopener\">High Intensity Interval Training</a></li>\r\n 	<li><a href=\"https://gmb.io/elbows/?utm_source=drip&amp;utm_medium=email&amp;utm_campaign=17%2F10%2F30+Elbows&amp;utm_content=The+loneliest+body+part\" target=\"_blank\" rel=\"noopener\">Fixing Elbow Pain</a></li>\r\n 	<li><a href=\"https://lifehacker.com/do-these-three-exercises-in-four-minutes-to-improve-you-1777522021?utm_campaign=socialflow_lifehacker_facebook&amp;utm_source=lifehacker_facebook&amp;utm_medium=socialflow\" target=\"_blank\" rel=\"noopener\">3 Exercises for Hunched Posture</a></li>\r\n</ul>\r\n<strong>Other forms of care</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f\" target=\"_blank\" rel=\"noopener\">14 Ways Reading Improves Your Mind and Body</a></li>\r\n 	<li><a href=\"https://www.npr.org/sections/health-shots/2018/07/30/632480321/off-your-mental-game-you-could-be-mildly-dehydrated\" target=\"_blank\" rel=\"noopener\">Off Your Mental Game? You Could Be Mildly Dehydrated</a></li>\r\n 	<li><a href=\"http://www.bbc.com/future/story/20170707-the-24-best-podcasts-to-make-you-smarter\" target=\"_blank\" rel=\"noopener\">24 Podcasts to Make You Smarter</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Exercise and Self Care','','inherit','closed','closed','','153-revision-v1','','','2018-08-15 18:13:21','2018-08-15 18:13:21','',153,'https://dmweade.com/welcome/2018/08/15/153-revision-v1/',0,'revision','',0),
 (165,1,'2018-08-15 18:35:08','2018-08-15 18:35:08','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 18:35:08','2018-08-15 18:35:08','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (166,1,'2018-08-15 18:38:35','2018-08-15 18:38:35','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 18:38:35','2018-08-15 18:38:35','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (338,1,'2019-04-14 01:22:38','2019-04-14 01:22:38','<p style=\"text-align: left;\">Now over a year since I built a Tevo Tarantula, but it\'s been a crazy one and I\'ve yet to put it to use. Time to get going, starting with collecting my information and making a plan. Recommendations always welcome if you run across this page.</p>\n<p style=\"text-align: center;\">_________________</p>\n<p style=\"text-align: center;\"><strong>Choosing and Building</strong></p>\n<table>\n<tbody>\n<tr>\n<td style=\"width: 281px;\">\n<p><strong>Choosing a Printer</strong><br /><a href=\"https://www.productchart.com/3d_printers/\" target=\"_blank\" rel=\"noopener noreferrer\">3D Printer Product Chart</a></p>\n<p><strong>Enclosures<br /></strong><a href=\"https://www.thingiverse.com/thing:2792618\">Smart enclosure</a></p>\n<p><a href=\"https://www.fabbaloo.com/blog/2015/3/1/finally-a-3d-printer-filter-accessory\">Enclosure filter</a></p>\n<p><a href=\"https://www.htgsupply.com/products/the-watch-dog-automatic-fire-extinguisher-2-kg/\">Watchdog Fire Extinguisher</a></p>\n<p><strong>Materials (filament)<br /></strong><a href=\"https://www.facebook.com/groups/makerbot/permalink/1656440171140147/\" target=\"_blank\" rel=\"noopener noreferrer\">PLA suggestions</a></p>\n<p><a href=\"https://all3dp.com/1/petg-filament-3d-printing/\">PetG Filament Overview</a></p>\n<p><a href=\"https://www.tomsguide.com/us/3d-printing-materials,news-24392.html\">3D Printing Materials: Pros and Cons</a></p>\n<p><a href=\"https://www.feel-color.com/3d-filament-pla-anthracite-grey?___store=en_en&amp;___from_store=en_en\">Anthracite Grey PLA</a></p>\n<p><a href=\"https://all3dp.com/2/how-to-dry-filament-pla-abs-and-nylon/\">How to Dry Filament</a></p>\n<p><a href=\"https://letsprint3d.net/2018/04/20/how-to-make-a-filament-dryer/\">Build a $30 Filament Dryer</a></p>\n<p><a href=\"https://all3dp.com/1/pla-filament-3d-printing/\">PLA Filament Guide</a></p>\n<p><a href=\"https://all3dp.com/1/3d-printer-filament-types-3d-printing-3d-filament/#basic\">3D Printer Filament Guide</a></p>\n</td>\n<td style=\"width: 390px;\">\n<p><strong>Tevo Tarantula Upgrades<br /></strong><a href=\"https://www.thingiverse.com/thing:2480577\" target=\"_blank\" rel=\"noopener noreferrer\">EZ gimbal for z-banding</a></p>\n<p>Cable management: <a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1894586220635343/\" target=\"_blank\" rel=\"noopener noreferrer\">one</a>, <a href=\"https://smile.amazon.com/dp/B0785LH2DC/ref=tsm_1_fb_lk?sa-no-redirect=1\" target=\"_blank\" rel=\"noopener noreferrer\">Stepper cables</a>, <a href=\"https://www.thingiverse.com/thing:2878127\" target=\"_blank\" rel=\"noopener noreferrer\">Spool weight measurement</a>,</p>\n<p><a href=\"https://github.com/JimBrown/MarlinTarantula\" target=\"_blank\" rel=\"noopener noreferrer\">Marlin firmware</a></p>\n<p><a href=\"https://3dprint.wiki/reprap/electronics/heatbed_mosfet\" target=\"_blank\" rel=\"noopener noreferrer\">How to Connect Your Hotbed to a Mosfet</a></p>\n<p><a href=\"https://m.aliexpress.com/item/32839714006.html?trace=wwwdetail2mobilesitedetail&amp;productId=32839714006&amp;productSubject=Random-Black-White-Blue-2meter-6mm-Flat-Seal-2020-Aluminum-Profile-Slot-Cover-Panel-Holder-For&amp;aff_platform=link-c-tool&amp;cpt=1519665605635&amp;sk=jA6URzB&amp;aff_trace_key=98f848353aa440eb95f00c86e4a50c9a-1519665605635-09573-jA6URzB&amp;terminal_id=29d0825156634f92a8c46080751efb13\" target=\"_blank\" rel=\"noopener noreferrer\">T-slotted Extrusion Bar Covers</a></p>\n<p><a href=\"https://hackaday.com/2018/04/12/to-ferrule-or-not-to-ferrule/\">To Ferrule or Not to Ferrule? (wire ends)</a></p>\n<p><a href=\"https://all3dp.com/1/tevo-tarantula-upgrades-mods/\">26 Tarantula upgrades</a></p>\n<p><a href=\"https://all3dp.com/1/tevo-tornado-upgrades-mods-3d-printer/\">19 Must-have Tarantula upgrades</a></p>\n<p><strong>Storage/organization<br /></strong>Poor man\'s polybox (by <a href=\"https://www.facebook.com/rwarwqerwqer?fref=gs&amp;hc_ref=ARSbYY5WmlcdREC7rwKx6frURtGQ-rfSgHYAVuxAC53Kr4Qcy2-CWloIptE-pFc_Of0&amp;dti=197938987045417&amp;hc_location=group\" target=\"_blank\" rel=\"noopener noreferrer\">Rich Lee</a>) - <a href=\"https://www.thingiverse.com/thing:2818547\" target=\"_blank\" rel=\"noopener noreferrer\">https://www.thingiverse.com/thing:2818547</a></p>\n<p><a href=\"https://smile.amazon.com/gp/product/B007V4IWIU/r\" target=\"_blank\" rel=\"noopener noreferrer\">Snapware 40-cup Airtight container</a></p>\n<p><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=4mm+pneumatic+connectors+push+fit\" target=\"_blank\" rel=\"noopener noreferrer\">4mm Pneumatic connectors (\"Push Fit\")</a></p>\n<p><a href=\"https://smile.amazon.com/s/ref=nb_sb_noss?url=search-alias%3Daps&amp;field-keywords=2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing&amp;rh=i%3Aaps%2Ck%3A2mm+ID+%2F+4mm+OD+PTFE+Teflon%E2%84%A2+Tubing\" target=\"_blank\" rel=\"noopener noreferrer\">2mm ID / 4mm OD PTFE (Teflon™) Tubing</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p style=\"text-align: center;\"><strong>Troubleshooting</strong></p>\n<table>\n<tbody>\n<tr>\n<td>\n<p><a href=\"https://m.all3dp.com/1/common-3d-printing-problems-troubleshooting-3d-printer-issues/\">41 Common Problems</a></p>\n<p><a href=\"https://www.simplify3d.com/support/print-quality-troubleshooting/\">Print Quality Troubleshooting Guide</a></p>\n<p><a href=\"https://www.antonmansson.com/how-to-cold-pull-clogged-nozzle/\">How to Cold-pull Clogged Nozzle</a></p>\n<p><strong>Calibration<br /></strong><a href=\"https://3dprint.com/207828/103dp-calibration-test-prints/\" target=\"_blank\" rel=\"noopener noreferrer\">Ten 3D Printable Calibration &amp; Test Print Things</a></p>\n<p> </p>\n</td>\n<td>\n<p><strong>Managing Errors<br /></strong><a href=\"https://www.thingiverse.com/thing:2814724\">Filament runout sensor</a></p>\n<p><a href=\"https://www.facebook.com/groups/TEVO.3dprinter.owners/permalink/1722003637893603/\">Z-banding</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p style=\"text-align: center;\"><strong>Things to Print</strong></p>\n<table style=\"width: 835px;\">\n<tbody>\n<tr>\n<td style=\"width: 416px;\">\n<p><strong>3D Model Sites</strong><br /><a href=\"https://www.myminifactory.com/\">MyMiniFactory</a></p>\n<p> </p>\n<p><strong>Fun Ideas to Try<br /></strong><a href=\"https://www.instructables.com/id/How-to-3D-Print-Onto-Fabric/\">Print onto Fabric</a></p>\n<p><a href=\"https://n-e-r-v-o-u-s.com/blog/?p=8011\" target=\"_blank\" rel=\"noopener noreferrer\">Self forming structures on pre-stretched fabric</a></p>\n<p><a href=\"https://phys.org/news/2018-06-d-printer-physical.html\">3D Printing Data Sets</a></p>\n</td>\n<td style=\"width: 411px;\">\n<p><strong>Household Items<br /></strong><a href=\"http://www.geeetech.com/blog/2018/03/8-diy-3d-prints-for-every-kitchen/\" target=\"_blank\" rel=\"noopener noreferrer\">Kitchen items list</a></p>\n<p><strong>Mesh<br /></strong><a href=\"https://www.myminifactory.com/object/3d-print-cubemail-bowl-49476\">Cubemail Fabric</a></p>\n<p><strong>Toys</strong><br /><a href=\"https://cults3d.com/en/3d-model/art/owl-tower-harry-potter?utm_source=social&amp;utm_medium=owlery\">Harry Potter Tower</a></p>\n<p><strong>Machines</strong><br /><a href=\"https://www.yankodesign.com/2019/02/07/you-can-now-3d-print-your-own-iconic-bladeless-fan/\">Bladeless Fans</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n<p> </p>\n<p><strong>Research<br /></strong><a href=\"https://dyzedesign.com/2016/10/printing-300-mm-s-part-1-basics-hardware/\">Printing at 300 mm/s</a></p>\n<p><a href=\"https://hackaday.com/2017/03/24/half-baked-idea-put-your-pla-in-the-oven/\">Baking PLA for Strength</a></p>\n<p><a href=\"https://pinshape.com/blog/3d-printing-food-safe/\">10 things you need to know about 3D printing &amp; food safety</a></p>\n<p><a href=\"https://www.instructables.com/id/Pinya3-a-3d-food-printer-platform/\">3D Food Printer Platform</a></p>\n<p><strong>Printing to Help People</strong><br /><a href=\"https://www.theverge.com/2019/3/12/18261893/ikea-thisables-3d-printed-add-ons-people-with-disabilities\">Ikea’s 3D-printed add-ons make its furniture more accessible for people with disabilities</a></p>\n<p><strong>Software<br /></strong><a href=\"https://www.aniwaa.com/best-3d-scanning-apps-smartphones/\">8 Best 3D Scanning Apps</a></p>\n\n<!-- wp:themify-builder/canvas /-->','3D Printing Resources','','inherit','closed','closed','','86-revision-v1','','','2019-04-14 01:22:38','2019-04-14 01:22:38','',86,'https://dmweade.com/welcome/2019/04/14/86-revision-v1/',0,'revision','',0),
 (168,1,'2018-08-15 18:58:39','2018-08-15 18:58:39','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides and Apps</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 18:58:39','2018-08-15 18:58:39','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (171,1,'2018-08-15 19:33:02','2018-08-15 19:33:02','<p style=\"text-align: center;\"><strong>Bringing order to my links or tilting at windmills.\r\nYou make the call.\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 19:33:02','2018-08-15 19:33:02','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (169,1,'2018-08-15 19:21:19','2018-08-15 19:21:19','<p style=\"text-align: center;\"><strong>Links. Lots of them.\r\n</strong><strong>Bringing order to chaos or tilting at windmills.\r\nYou make the call.</strong></p>\r\n<p style=\"text-align: center;\"><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 19:21:19','2018-08-15 19:21:19','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (170,1,'2018-08-15 19:28:25','2018-08-15 19:28:25','<p style=\"text-align: center;\"><strong>Aging is hard, and sitting for long periods makes it worse</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Gaining Strength\r\n</strong>(Choose one if you don\'t have one)\r\n<ul>\r\n 	<li><a href=\"https://www.fatherly.com/health-science/7-best-core-exercises-for-men/?utm_content=fatherly&amp;utm_campaign=twowned&amp;utm_source=twitter&amp;utm_medium=social\" target=\"_blank\" rel=\"noopener\">7 Essential Exercises For Building A Strong Core</a></li>\r\n 	<li><a href=\"https://vitals.lifehacker.com/get-closer-to-doing-a-handstand-in-12-minutes-1796377028\" target=\"_blank\" rel=\"noopener\">Get Closer to Doing a Handstand in 12 Minutes</a></li>\r\n 	<li><a href=\"http://strength.stack52.com/periodic-table-of-bodyweight-exercises/\" target=\"_blank\" rel=\"noopener\">Periodic Table of Exercises</a> (with how-to)</li>\r\n 	<li><a href=\"https://www.artofmanliness.com/articles/gymnastic-rings-101-a-beginners-routine-faqs/\" target=\"_blank\" rel=\"noopener\">Gymnastic Rings 101: A Beginner’s Routine &amp; FAQs</a></li>\r\n 	<li><a href=\"https://www.urbanstrength.com.au/blogs/articles/gymnastic-rings-workout-exercises-for-beginners#\" target=\"_blank\" rel=\"noopener\">GYMNASTIC RINGS WORKOUT EXERCISES FOR BEGINNERS</a></li>\r\n 	<li><a href=\"https://well.blogs.nytimes.com/2013/06/19/the-4-minute-workout/?runwell&amp;_r=1\" target=\"_blank\" rel=\"noopener\">Four Minute Workout</a></li>\r\n 	<li><a href=\"https://well.blogs.nytimes.com/2013/05/09/the-scientific-7-minute-workout/?_r=0\" target=\"_blank\" rel=\"noopener\">Scientific Seven Minute Workout</a></li>\r\n 	<li><a href=\"https://darebee.com/modifications.html\" target=\"_blank\" rel=\"noopener\">Exercise adjustments if injured</a></li>\r\n 	<li><a href=\"https://www.businessinsider.com/best-everyday-stretches-2016-4\" target=\"_blank\" rel=\"noopener\">12 everyday stretches to stay flexible and fit at any age</a></li>\r\n</ul>\r\n<strong>Flexibility</strong>\r\n<ul>\r\n 	<li><a href=\"https://gmb.io/hip-mobility/\" target=\"_blank\" rel=\"noopener\">8 Exercises to Improve Hip Mobility &amp; Loosen Tight Hips</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Repair</strong>\r\n<ul>\r\n 	<li><a href=\"https://healthnewstips.today/backpain/index98162569.html?voluumdata=deprecated&amp;eda=deprecated&amp;cep=k2FyJKJn-Y1fpOlglraghl9fpoCpNsvuoP8auhdbU7xF0QVEZgiWIsBpXBfd9Af8CPwaP3xtQ-c2oHAVk8V-0ZNrYIR0_7ASQDP1PitsvckG5eUEuSpqPry5nG-Mq2AwQnFS_bMORRQGiCLRoNyzDYSUgv1X5YnFguq3iNzLkOEcJfHa20_3thkMS3Ck3Nn_j0mkqEyZAlAekg4ByjxQAS4ua_M3Wg6QYGjFQb6eKyBfKGIWYOwLzbUGitp9hds0aFhiJFLZKU0BhNQGTDtGHqmCOLxNiG4d6YdK9kn9PBU5FUQKutHvPpLdelRMpgc2wzdj53hBqEpM6SSqjPwtzr2ARJovBeCRBe-RP05oyfe6zI55xsaq-2KJX6DaZWKlklm7THPUJok5kpmrWvtTb_wgINGr6ulyqSz9UIMgjrmTEPrddv1HQLwu-MJqASfZLeaDKjic4RVVbRC0tZ0q9Mvh0myuTMImfHFn1SGB9xlXrdm_MZN6aoBanP571QuLEMm_U8NFJ1-mf3eyeM7gCM3g2kfR6c-GVerzlD7iQtNLN7FTV5jGCcy-y0zwmUVT_53gRdwfcvzx50GDeYhrJQU2dehy7URlKmPkTq5rgxf7FeJOtlxjyUAfeCtd7Qevi2O7N_X04R5C9ypkkitlRk1e_tSwApso6ZNQKkYNfs4&amp;utm_content=Chiropractors%20Baffled:%20Simple%20Stretch%20Relieves%20Years%20of%20Back%20Pain%20(Wat&amp;utm_term=002f47524a4d52e792bdafd472a8a59f46&amp;Doc_title=Erase%20My%20Back%20Pain%20%7C%20Health%20News%20Tips&amp;utm_site=espn.com/blog&amp;utm_pub=ESPN%20(ESPN)&amp;newad=2&amp;utm_adid=0099e7015bc5f22a3ffd6c2f75588d3a8a&amp;utm_doc_id=0050095ecbe5398c9b98b4d8cecb4f189b&amp;utm_new=002f47524a4d52e792bdafd472a8a59f46_espn.com/blog&amp;utm_cam=TabTier1NewVersion&amp;ob_click_id=7cb27d9a197ff36ebc26e48764a37bc1-000be295f74876f5c74c82e3c8a2545eae\" target=\"_blank\" rel=\"noopener\">10 Minute Stretch Routine for Back Pain</a></li>\r\n 	<li><a href=\"https://www.bodybuilding.com/content/what-is-the-best-hiit-workout.html\" target=\"_blank\" rel=\"noopener\">High Intensity Interval Training</a></li>\r\n 	<li><a href=\"https://gmb.io/elbows/?utm_source=drip&amp;utm_medium=email&amp;utm_campaign=17%2F10%2F30+Elbows&amp;utm_content=The+loneliest+body+part\" target=\"_blank\" rel=\"noopener\">Fixing Elbow Pain</a></li>\r\n 	<li><a href=\"https://lifehacker.com/do-these-three-exercises-in-four-minutes-to-improve-you-1777522021?utm_campaign=socialflow_lifehacker_facebook&amp;utm_source=lifehacker_facebook&amp;utm_medium=socialflow\" target=\"_blank\" rel=\"noopener\">3 Exercises for Hunched Posture</a></li>\r\n 	<li><a href=\"https://www.vox.com/science-and-health/2017/8/4/15929484/chronic-back-pain-treatment-mainstream-vs-alternative\" target=\"_blank\" rel=\"noopener\">A comprehensive guide to the new science of treating lower back pain</a></li>\r\n</ul>\r\n<strong>Other forms of care</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/14-ways-reading-improves-your-mind-and-body-d2518367712f\" target=\"_blank\" rel=\"noopener\">14 Ways Reading Improves Your Mind and Body</a></li>\r\n 	<li><a href=\"https://www.npr.org/sections/health-shots/2018/07/30/632480321/off-your-mental-game-you-could-be-mildly-dehydrated\" target=\"_blank\" rel=\"noopener\">Off Your Mental Game? You Could Be Mildly Dehydrated</a></li>\r\n 	<li><a href=\"http://www.bbc.com/future/story/20170707-the-24-best-podcasts-to-make-you-smarter\" target=\"_blank\" rel=\"noopener\">24 Podcasts to Make You Smarter</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Exercise and Self Care','','inherit','closed','closed','','153-revision-v1','','','2018-08-15 19:28:25','2018-08-15 19:28:25','',153,'https://dmweade.com/welcome/2018/08/15/153-revision-v1/',0,'revision','',0),
 (172,1,'2018-08-15 20:10:41','2018-08-15 20:10:41','<p style=\"text-align: center;\"><strong>Bringing order to my links or tilting at windmills.\r\nYou make the call.\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-15 20:10:41','2018-08-15 20:10:41','',39,'https://dmweade.com/welcome/2018/08/15/39-revision-v1/',0,'revision','',0),
 (173,1,'2018-08-16 00:02:07','2018-08-16 00:02:07','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name','','','2018-08-16 00:02:07','2018-08-16 00:02:07','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name/',0,'pf_contact','',0),
 (174,1,'2018-08-16 00:09:09','2018-08-16 00:09:09','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-2','','','2018-08-16 00:09:09','2018-08-16 00:09:09','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-2/',0,'pf_contact','',0),
 (176,0,'2015-04-06 17:18:12','2015-04-06 17:18:12','{\"email_to\":\"[admin_email]\",\"cc\":\"\",\"bcc\":\"\",\"reply_to\":\"\",\"from\":\"[sitename] <[admin_email]>\",\"email_subject\":\"\",\"email_message\":\"[default-message]\",\"event\":[\"create\"],\"conditions\":{\"send_stop\":\"send\",\"any_all\":\"any\"},\"inc_user_info\":\"0\",\"plain_text\":\"0\"}','Email Notification','email','publish','open','open','','1_email_1-2','','','2015-04-06 17:18:12','2015-04-06 17:18:12','',0,'https://dmweade.com/welcome/frm_form_actions/1_email_1/',2,'frm_form_actions','',0),
 (177,1,'2018-08-16 00:17:43','2018-08-16 00:17:43','{\"custom_css\":\"\",\"form_align\":\"left\",\"form_width\":\"100%\",\"fieldset_bg_color\":\"\",\"fieldset\":\"0px\",\"fieldset_color\":\"000000\",\"fieldset_padding\":\"0 0 15px 0\",\"font\":\"Muli\",\"direction\":\"ltr\",\"title_size\":\"20px\",\"title_color\":\"444444\",\"title_margin_top\":\"10px\",\"title_margin_bottom\":\"10px\",\"form_desc_size\":\"14px\",\"form_desc_color\":\"666666\",\"form_desc_margin_top\":\"10px\",\"form_desc_margin_bottom\":\"25px\",\"label_color\":\"444444\",\"weight\":\"bold\",\"font_size\":\"14px\",\"position\":\"none\",\"align\":\"left\",\"width\":\"150px\",\"label_padding\":\"0 0 3px 0\",\"required_color\":\"B94A48\",\"required_weight\":\"bold\",\"description_color\":\"666666\",\"description_weight\":\"normal\",\"description_style\":\"normal\",\"description_font_size\":\"12px\",\"description_align\":\"left\",\"description_margin\":\"0\",\"bg_color\":\"ffffff\",\"text_color\":\"555555\",\"border_color\":\"cccccc\",\"field_border_width\":\"1px\",\"field_border_style\":\"solid\",\"bg_color_active\":\"ffffff\",\"border_color_active\":\"66afe9\",\"bg_color_error\":\"ffffff\",\"text_color_error\":\"444444\",\"border_color_error\":\"B94A48\",\"border_width_error\":\"1px\",\"border_style_error\":\"solid\",\"bg_color_disabled\":\"ffffff\",\"text_color_disabled\":\"A1A1A1\",\"border_color_disabled\":\"E5E5E5\",\"field_font_size\":\"14px\",\"field_height\":\"32px\",\"field_width\":\"100%\",\"field_pad\":\"6px 10px\",\"field_margin\":\"20px\",\"border_radius\":\"4px\",\"field_weight\":\"normal\",\"radio_align\":\"block\",\"check_align\":\"block\",\"check_label_color\":\"444444\",\"check_weight\":\"normal\",\"check_font_size\":\"13px\",\"submit_font_size\":\"14px\",\"submit_width\":\"auto\",\"submit_height\":\"auto\",\"submit_weight\":\"normal\",\"submit_border_radius\":\"4px\",\"submit_bg_color\":\"ffffff\",\"submit_text_color\":\"444444\",\"submit_border_color\":\"cccccc\",\"submit_border_width\":\"1px\",\"submit_shadow_color\":\"eeeeee\",\"submit_bg_img\":\"\",\"submit_margin\":\"10px\",\"submit_padding\":\"6px 11px\",\"submit_hover_bg_color\":\"efefef\",\"submit_hover_color\":\"444444\",\"submit_hover_border_color\":\"cccccc\",\"submit_active_bg_color\":\"efefef\",\"submit_active_color\":\"444444\",\"submit_active_border_color\":\"cccccc\",\"success_bg_color\":\"DFF0D8\",\"success_border_color\":\"D6E9C6\",\"success_text_color\":\"468847\",\"success_font_size\":\"14px\",\"error_bg\":\"F2DEDE\",\"error_border\":\"EBCCD1\",\"error_text\":\"B94A48\",\"error_font_size\":\"14px\",\"theme_css\":\"ui-lightness\",\"theme_name\":\"UI Lightness\",\"center_form\":\"\",\"line_height\":\"normal\",\"auto_width\":\"\",\"remove_box_shadow\":\"\",\"remove_box_shadow_active\":\"\",\"section_font_size\":\"18px\",\"section_color\":\"444444\",\"section_weight\":\"bold\",\"section_pad\":\"15px 0 3px 0\",\"section_mar_top\":\"15px\",\"section_mar_bottom\":\"12px\",\"section_bg_color\":\"\",\"section_border_color\":\"e8e8e8\",\"section_border_width\":\"2px\",\"section_border_style\":\"solid\",\"section_border_loc\":\"-top\",\"collapse_icon\":\"6\",\"collapse_pos\":\"after\",\"repeat_icon\":\"1\",\"submit_style\":\"\",\"important_style\":\"\",\"progress_bg_color\":\"dddddd\",\"progress_active_color\":\"ffffff\",\"progress_active_bg_color\":\"008ec2\",\"progress_color\":\"ffffff\",\"progress_border_color\":\"dfdfdf\",\"progress_border_size\":\"2px\",\"progress_size\":\"30px\"}','Formidable Style','','publish','closed','closed','','formidable-style','','','2018-08-16 00:31:46','2018-08-16 00:31:46','',0,'https://dmweade.com/welcome/frm_styles/formidable-style/',1,'frm_styles','',0),
 (179,1,'2018-08-16 01:09:02','2018-08-16 01:09:02','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-3','','','2018-08-16 01:09:02','2018-08-16 01:09:02','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-3/',0,'pf_contact','',0),
 (180,1,'2018-08-16 01:11:44','2018-08-16 01:11:44','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-4','','','2018-08-16 01:11:44','2018-08-16 01:11:44','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-4/',0,'pf_contact','',0),
 (181,1,'2018-08-16 01:12:02','2018-08-16 01:12:02','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-5','','','2018-08-16 01:12:02','2018-08-16 01:12:02','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-5/',0,'pf_contact','',0),
 (182,1,'2018-08-16 01:12:47','2018-08-16 01:12:47','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-6','','','2018-08-16 01:12:47','2018-08-16 01:12:47','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-6/',0,'pf_contact','',0),
 (183,1,'2018-08-16 01:46:33','2018-08-16 01:46:33','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-7','','','2018-08-16 01:46:33','2018-08-16 01:46:33','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-7/',0,'pf_contact','',0),
 (184,1,'2018-08-16 01:47:15','2018-08-16 01:47:15','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-8','','','2018-08-16 01:47:15','2018-08-16 01:47:15','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-8/',0,'pf_contact','',0),
 (185,1,'2018-08-16 01:47:31','2018-08-16 01:47:31','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-9','','','2018-08-16 01:47:31','2018-08-16 01:47:31','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-9/',0,'pf_contact','',0),
 (186,1,'2018-08-16 01:51:13','2018-08-16 01:51:13','<h2>Contact form submission from DMWeade: thoughts/projects (https://dmweade.com/welcome)</h2>\r\n<table>\r\n<tbody>\r\n<tr>\r\n<th>Name:</th>\r\n<td>Test Name</td>\r\n</tr>\r\n<tr>\r\n<th>Email:</th>\r\n<td>dweade@gmail.com</td>\r\n</tr>\r\n<tr>\r\n<th>Subject:</th>\r\n<td>Test Email</td>\r\n</tr>\r\n<tr>\r\n<th>Message:</th>\r\n<td>This is a test.</td>\r\n</tr>\r\n<tr>\r\n<th>Checkbox:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>IP search:</th>\r\n<td>http://whatismyipaddress.com/ip/</td>\r\n</tr>\r\n<tr>\r\n<th>Came from:</th>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<th>Sent from page:</th>\r\n<td></td>\r\n</tr>\r\n</tbody>\r\n</table>','Thursday, Aug 16, 2018 by \"Test Name\"','','private','closed','closed','','thursday-aug-16-2018-by-test-name-10','','','2018-08-16 01:51:13','2018-08-16 01:51:13','',0,'https://dmweade.com/welcome/pf_contact/thursday-aug-16-2018-by-test-name-10/',0,'pf_contact','',0),
 (197,1,'2018-08-16 18:28:58','2018-08-16 18:28:58','<p style=\"text-align: center;\"><strong>Bringing order to my links or tilting at windmills,\r\nyou make the call.\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow. Here are some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 17.7674%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 2.13958%;\"></td>\r\n<td style=\"width: 80.093%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 39.7829%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 2.29462%;\"></td>\r\n<td style=\"width: 57.9225%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-16 18:28:58','2018-08-16 18:28:58','',39,'https://dmweade.com/welcome/2018/08/16/39-revision-v1/',0,'revision','',0),
 (189,1,'2018-08-16 18:04:22','2018-08-16 18:04:22','<p style=\"text-align: center;\"><strong>Bringing order to my links or tilting at windmills,\r\nyou make the call.\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 23.6941%;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 76.3059%;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%; height: 10px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 10px;\">\r\n<td style=\"width: 11.1007%; height: 10px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 88.8993%; height: 10px;\">Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-16 18:04:22','2018-08-16 18:04:22','',39,'https://dmweade.com/welcome/2018/08/16/39-revision-v1/',0,'revision','',0),
 (190,1,'2018-08-16 18:08:21','2018-08-16 18:08:21','<p style=\"text-align: center;\"><strong>Bringing order to my links or tilting at windmills,\r\nyou make the call.\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%; height: 104px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 104px;\">\r\n<td style=\"width: 39.1628%; height: 104px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 alignleft\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 3.2248%; height: 104px;\"></td>\r\n<td style=\"width: 57.6124%; height: 104px;\"><a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 22.5737%; text-align: left;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 4.15498%;\"></td>\r\n<td style=\"width: 73.2713%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-16 18:08:21','2018-08-16 18:08:21','',39,'https://dmweade.com/welcome/2018/08/16/39-revision-v1/',0,'revision','',0),
 (191,1,'2018-08-16 18:09:35','2018-08-16 18:09:35','<p style=\"text-align: center;\"><strong>Bringing order to my links or tilting at windmills,\r\nyou make the call.\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-character-description\" target=\"_blank\" rel=\"noopener\">11 Secrets to Writing an Effective Character Description</a></li>\r\n 	<li><a href=\"http://terribleminds.com/ramble/2014/01/13/25-things-a-great-character-needs/\" target=\"_blank\" rel=\"noopener\">25 Things A Great Character Needs</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/Joannechocolat/status/888811458179543041\" target=\"_blank\" rel=\"noopener\">Ten Things About Strong Female Characters</a></li>\r\n 	<li><a href=\"https://www.theguardian.com/film/2017/aug/16/from-wonder-woman-to-spirited-away-what-really-makes-a-superhero\" target=\"_blank\" rel=\"noopener\">From Wonder Woman to Spirited Away: what really makes a superhero?</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/fozmeadows/status/903600239109484544\" target=\"_blank\" rel=\"noopener\">Thread on what Strength means for female characters</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/1698.html\" target=\"_blank\" rel=\"noopener\">Characters by Jim Butcher</a></li>\r\n 	<li><a href=\"https://medium.com/@RachSwy/from-basic-to-beauty-transformations-of-female-villains-in-batman-films-3071b719cf1b\" target=\"_blank\" rel=\"noopener\">From Basic to Beauty: Transformations of Female Villains in Batman Films</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2013/06/tags-traits-characterization-and-building-empathy.html\" target=\"_blank\" rel=\"noopener\">Tags and Traits: Characterization and Building Empathy</a></li>\r\n</ul>\r\n<strong>Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://johnaugust.com/2007/write-scene\">John August’s How to Write a Scene</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2647.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Scenes</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/2880.html#\" target=\"_blank\" rel=\"noopener\">Jim Butcher on Sequels</a></li>\r\n</ul>\r\n<strong>Short Fiction</strong>\r\n<ul>\r\n 	<li><a href=\"https://electricliterature.com/how-to-escape-the-slush-pile-101b3d1b5168\" target=\"_blank\" rel=\"noopener\">Self-Editing Checklist for Short Story Writers</a></li>\r\n 	<li><a href=\"https://electricliterature.com/a-good-short-story-is-a-pill-that-lets-us-see-the-real-3b169e0a8267\" target=\"_blank\" rel=\"noopener\">A Good Short Story Is “A Pill That Lets Us See the Real”</a></li>\r\n</ul>\r\n<strong>Removing Filter Words</strong>\r\n<ul>\r\n 	<li><a href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Filter Words by Sooz</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://writeitsideways.com/are-these-filter-words-weakening-your-fiction/\" target=\"_blank\" rel=\"noopener\">Are These Filter Words Weakening Your Fiction?</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sfwa.org/?s=fantasy+worldbuilding+questions\" target=\"_blank\" rel=\"noopener\">Worldbuilding Questions at SFWA</a></li>\r\n</ul>\r\n<strong>Storytelling</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.brainpickings.org/2016/04/22/wislawa-szymborska-fairy-tales-fear/\" target=\"_blank\" rel=\"noopener\">Fairy Tales and the Necessity of Fear</a></li>\r\n 	<li><a href=\"https://www.newyorker.com/magazine/2017/11/06/is-bigfoot-likelier-than-the-loch-ness-monster?mbid=social_tablet_t\" target=\"_blank\" rel=\"noopener\">Fantastic Beasts and How to Rank Them</a></li>\r\n 	<li><a href=\"https://middleearthreflections.com/2016/07/27/in-the-shadows-of-dark-forests/\" target=\"_blank\" rel=\"noopener\">In the shadows of dark forests</a></li>\r\n</ul>\r\n<strong>Writers with Writing Advice</strong>\r\n<ul>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://hollylisle.com/\">Holly Lisle</a></li>\r\n 	<li><a href=\"https://jimbutcher.livejournal.com/\" target=\"_blank\" rel=\"noopener\">Jim Butcher</a></li>\r\n</ul>\r\n<strong>Best Opening Lines</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.readbreatherelax.com/best-opening-lines-in-young-adult-books/\" target=\"_blank\" rel=\"noopener\">Best Opening Lines in Young Adult Books</a></li>\r\n</ul>\r\n<strong>Best Practices</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.theatlantic.com/entertainment/archive/2013/10/the-8-habits-of-highly-successful-young-adult-fiction-authors/280722/\" target=\"_blank\" rel=\"noopener\">The 8 Habits of Highly Successful Young-Adult Fiction Authors</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/the-system-i-used-to-write-5-books-and-over-1-000-blog-posts-5872451d7461\" target=\"_blank\" rel=\"noopener\">The System I Used to Write 5 Books and Over 1,000 Blog Posts</a></li>\r\n 	<li><a href=\"https://www.brainpickings.org/2014/08/25/the-psychology-of-writing-daily-routine/\" target=\"_blank\" rel=\"noopener\">The Psychology of Writing and the Cognitive Science of the Perfect Daily Routine</a></li>\r\n</ul>\r\n<strong>Fight Scenes</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.betternovelproject.com/blog/attack-fight-scene/\" target=\"_blank\" rel=\"noopener\">Write a Fight Scene: Hero Fends Off an Attack to Protect Friend</a></li>\r\n</ul>\r\n<strong>Names</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.barnesandnoble.com/blog/sci-fi-fantasy/anthony-ryan-naming-fantasy-characters-making-sure-theyre-just-names/\" target=\"_blank\" rel=\"noopener\">Anthony Ryan On Naming Fantasy Characters</a></li>\r\n</ul>\r\n<strong>Romance</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.livewritethrive.com/2016/08/22/20-key-scenes-for-writers-of-romance-novels/\" target=\"_blank\" rel=\"noopener\">20 Key Scenes</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Essential_Elements.pdf\" target=\"_blank\" rel=\"noopener\">The Essential Elements of Writing a Romance Novel</a></li>\r\n</ul>\r\n&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Templates, References, Guides</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Quick References</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.writerscheatsheet.com/writing/cheatsheet.pdf\" target=\"_blank\" rel=\"noopener\">Writer\'s Cheat Sheet</a>, <a href=\"http://www.inkalicious.com/cheatsheets.html\" target=\"_blank\" rel=\"noopener\">Inkilicious Cheat Sheet</a></li>\r\n 	<li><a href=\"https://electricliterature.com/infographic-the-69-rules-of-punctuation-28bd3c913f7\" target=\"_blank\" rel=\"noopener\">INFOGRAPHIC: The 69 Rules of Punctuation</a></li>\r\n</ul>\r\n<strong>Templates for Writers</strong>\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"https://annieneugebauer.com/the-organized-writer-2/\" target=\"_blank\" rel=\"noopener\">The Organized Writer</a> (Annie Neugebauer)\r\n<ul>\r\n 	<li>Novel development and professional templates</li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"http://www.editorium.com/freebies.htm\" target=\"_blank\" rel=\"noopener\">The Editorium\'s Freebies</a></li>\r\n</ul>\r\n<strong>Grammar and Punctuation</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.bartleby.com/141/\">Strunk\'s <em>The Elements of Style</em></a></li>\r\n 	<li><a href=\"http://www.amazon.com/gp/product/B00BQ1P142/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00BQ1P142&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=KRBIWOZK7TET774S\">Pocket copy</a> - <a href=\"http://www.amazon.com/gp/product/B00HX6DK5Q/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B00HX6DK5Q&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=2KJGQSTVU3DTEGSF\">Ebook with illustrations</a> - <a href=\"http://www.amazon.com/gp/product/B005IT0V8O/ref=as_li_tl?ie=UTF8&amp;camp=1789&amp;creative=390957&amp;creativeASIN=B005IT0V8O&amp;linkCode=as2&amp;tag=regardtomor07-20&amp;linkId=WVIFICFUILJLJC6M\">Free ebook</a></li>\r\n 	<li><a href=\"http://grammar.ccc.commnet.edu/grammar/#\">Guide to Grammar and Writing</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://grammar.quickanddirtytips.com/\">Grammar Girl: Quick and Dirty Tips</a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dumblittleman.com/2006/12/40-tips-to-improve-your-grammar-and.html\">Dumb Little Man’s 40+ Tips to Improve your Grammar and Punctuation </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.edufind.com/English/Grammar/\"><span id=\"6caf5517-4fec-4d3c-baa5-fde9ca486b06\" class=\"GINGER_SOFTWARE_mark\">Edufind\'s</span> Online English Grammar Resources</a></li>\r\n 	<li></li>\r\n</ul>\r\n<b>Finding Words (beyond dictionaries and Google)</b>\r\n<ul>\r\n 	<li><a href=\"https://www.urbandictionary.com/\" target=\"_blank\" rel=\"noopener\">Urban Dictionary</a></li>\r\n 	<li><a href=\"https://www.etymonline.com/\" target=\"_blank\" rel=\"noopener\">Etymology.com</a>: word history</li>\r\n 	<li><a href=\"http://phrontistery.info/index.html\" target=\"_blank\" rel=\"noopener\">The Phrontistery</a>: Dictionary of rare, cool, and unusual words; lost words.\r\n<ul>\r\n 	<li><a href=\"http://phrontistery.info/glossaries.html\" target=\"_blank\" rel=\"noopener\">Specialty glossaries</a> (worth bookmarking on its own)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"><strong style=\"font-family: inherit; font-size: inherit;\">Publishing Tools</strong>\r\n<ul>\r\n 	<li><a href=\"https://vellum.pub/\" target=\"_blank\" rel=\"noopener\">Vellum: Create Beautiful Books</a></li>\r\n 	<li><a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Responsive Storytelling Best Practices</a></li>\r\n 	<li><a href=\"https://www.bookdesigntemplates.com/\" target=\"_blank\" rel=\"noopener\">Premium Book Design Templates</a></li>\r\n</ul>\r\nI<strong>dea Generators</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.descriptionari.com/\" target=\"_blank\" rel=\"noopener\">Descriptionari</a>: Search for book quotes by terms</li>\r\n</ul>\r\n<strong>Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"http://mapfrappe.com/\" target=\"_blank\" rel=\"noopener\">MapFrappe</a>: Compare two locations on Earth side by side.</li>\r\n 	<li><a href=\"https://news.nationalgeographic.com/2018/05/map-of-the-day-cartography-vintage-archive-culture/?utm_source=Twitter&amp;utm_medium=Social&amp;utm_content=link_tw20180511news-vintagemaps&amp;utm_campaign=Content&amp;sf189367684=1\" target=\"_blank\" rel=\"noopener\">National Geographic Vintage Map Archive</a></li>\r\n</ul>\r\n<strong>Sounds/Music for Writing</strong>\r\n<ul>\r\n 	<li><a href=\"https://mynoise.net/NoiseMachines/springWalkSoundscapeGenerator.php\" target=\"_blank\" rel=\"noopener\">Spring Walk nature sounds generator</a></li>\r\n</ul>\r\n<strong>Visuals</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.sciencealert.com/29-weirdest-landscapes-on-the-planet-must-see\" target=\"_blank\" rel=\"noopener\">29 Surreal Landscapes</a></li>\r\n 	<li><a href=\"https://www.wired.com/2016/02/mountains-shot-in-infrared-look-haunting-as-all-get-out/#slide-10\" target=\"_blank\" rel=\"noopener\">Mountains Shot in Infrared</a></li>\r\n 	<li><a href=\"http://www.artofmtg.com/\" target=\"_blank\" rel=\"noopener\">Art of Magic the Gathering</a> (2500+ fantasy images)</li>\r\n 	<li><a href=\"https://dangerousminds.net/comments/fantastical_hieronymus_bosch_pinatas_by_roberto_benavidez\" target=\"_blank\" rel=\"noopener\">Hieronymous Bosch Pinatas</a></li>\r\n 	<li><a href=\"https://mobile.twitter.com/iamshinerk/status/1013365513659904000\" target=\"_blank\" rel=\"noopener\">Dirty Storms</a> (lightning around volcanoes)\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Dirty_thunderstorm\" target=\"_blank\" rel=\"noopener\">Dirty Thunderstorm</a> (Wikipedia)</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing With Color\r\n</strong>There are colors beyond the rainbow and some sites providing terminology, visual references, and usage.\r\n\r\n&nbsp;\r\n<table style=\"border-collapse: collapse; width: 100%; height: 104px;\" border=\"0\">\r\n<tbody>\r\n<tr style=\"height: 104px;\">\r\n<td style=\"width: 39.1628%; height: 104px;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\"><img class=\"size-full wp-image-142 aligncenter\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/Crayon-color-grid-e1534276417501.jpg\" alt=\"\" width=\"244\" height=\"92\" /></a></td>\r\n<td style=\"width: 3.2248%; height: 104px;\"></td>\r\n<td style=\"width: 57.6124%; height: 104px;\">&nbsp;\r\n\r\n<a href=\"http://www.wikiwand.com/en/List_of_Crayola_crayon_colors\" target=\"_blank\" rel=\"noopener\">Complete list of Crayola Crayon colors.</a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\nThe Phrontistery\'s <a href=\"http://phrontistery.info/colours.html\" target=\"_blank\" rel=\"noopener\">list of \"obscure colour terms.\"</a>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 18.2326%; text-align: left;\"><a href=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\"><img class=\"wp-image-141 size-full alignnone\" src=\"https://dmweade.com/welcome/wp-content/uploads/2018/08/colorthesaurus-e1534275712220.png\" alt=\"Screen grab of the red color card.\" width=\"105\" height=\"66\" /></a></td>\r\n<td style=\"width: 2.91467%;\"></td>\r\n<td style=\"width: 78.8527%;\"><a href=\"http://ingridsundberg.com/2014/02/04/the-color-thesaurus/\" target=\"_blank\" rel=\"noopener\">Color Thesaurus</a>: Ingrid Sundberg hosts a series of cards filled with a variety of each color (white, beige, yellow, orange, red, pink, purple, green, brown, grey and black). A wonderful resource.</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n<strong>Writing About the Color of People (and other aspects of humanity)\r\n</strong>Selecting words to describe characters, especially as a white author, is a must. Hopefully these will help you grow.\r\n\r\n<a href=\"https://pudding.cool/process/responsive-scrollytelling/\" target=\"_blank\" rel=\"noopener\">Writing the Other Roundtable: How to Stay in Your lane</a>\r\n\r\nTwo excellent articles by Mod Colette to get you started:\r\n<ul>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/95955707903/skin-writing-with-color-has-received-several\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 1: POC and Food Descriptions</a></li>\r\n 	<li><a href=\"http://writingwithcolor.tumblr.com/post/96830966357/writing-with-color-description-guide-words-for\" target=\"_blank\" rel=\"noopener\">Writing with Color: Description Guide - Skin Color pt 2: Words for Skin Tone</a></li>\r\n</ul>\r\n<a href=\"http://midnightbreakfast.com/writing-people-of-color\" target=\"_blank\" rel=\"noopener\">Writing People of Color (if you happen to be a person of another color)</a>\r\n\r\n<a href=\"https://mythicscribes.com/community/threads/describing-pocs-skin.17082/\" target=\"_blank\" rel=\"noopener\">A discussion of describing the skin tone of people of color (not all of the comments have value, but the discussion offers some insight on what people think)</a>\r\n\r\n<a href=\"https://kathysteinemann.com/Musings/words-to-describe-skin/\" target=\"_blank\" rel=\"noopener\">300 Words to Describe Skin</a>\r\n\r\nArticles with visual references of human coloration:\r\n<ul>\r\n 	<li><a href=\"https://hommes.my/style/skin-undertone-colour-matching-men/#.U_fE9aNuJ8M\" target=\"_blank\" rel=\"noopener\">Skin Undertone and Colour Matching</a></li>\r\n 	<li>Eye color\r\n<ul>\r\n 	<li><a href=\"https://www.edow.com/general-eye-care/eyecolor/\" target=\"_blank\" rel=\"noopener\">What color are your eyes exactly?</a></li>\r\n</ul>\r\n</li>\r\n 	<li><a href=\"https://www.matrix.com/blog/the-21-most-popular-red-hair-color-shades\" target=\"_blank\" rel=\"noopener\">Red Hair Color Shades</a></li>\r\n</ul>\r\nOther aspects of our humanity:\r\n<ul>\r\n 	<li><a href=\"https://www.bodiesinmotion.photo/\" target=\"_blank\" rel=\"noopener\">Bodies in Motion</a></li>\r\n 	<li><a href=\"https://writerswrite.co.za/cheat-sheets-for-writing-body-language/\" target=\"_blank\" rel=\"noopener\">Body language cheat sheets</a></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><strong>History and Facts</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://en.wikipedia.org/wiki/Settlement_hierarchy\" target=\"_blank\" rel=\"noopener\">Settlement Hierarchies (names and usage)</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\">\r\n<ul>\r\n 	<li><a href=\"https://historycollection.co/assassination-bureau-8-groups-assassins-history/\" target=\"_blank\" rel=\"noopener\">Eight of the Deadliest Assassin Groups in History</a></li>\r\n 	<li><a href=\"https://www.ranker.com/list/surprising-pirate-traditions/genevieve-carlton\" target=\"_blank\" rel=\"noopener\">14 Bizarre Pirate Traditions Most People Don\'t Know About</a></li>\r\n 	<li><a href=\"http://books-forlife.blogspot.com/2018/06/author-post-walter-dinjos.html?m=1\" target=\"_blank\" rel=\"noopener\">Nigerian Witch Doctors</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>Software</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Worldbuilding/Mapping</strong>\r\n<ul>\r\n 	<li><a href=\"https://sourceforge.net/projects/autorealm/\" target=\"_blank\" rel=\"noopener\">AutoREALM: Vector based drawing for RPGs (mapping)</a></li>\r\n 	<li><a href=\"http://www.world-machine.com/\" target=\"_blank\" rel=\"noopener\">World Machine</a></li>\r\n 	<li><a href=\"https://planetside.co.uk/terragen-product-comparison/\" target=\"_blank\" rel=\"noopener\">Terragen</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<em>This is a living page. If you have any recommendations for additional or better resources, I would appreciate if you share them with me through the contact form below.</em>\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"></td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%;\"></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;','Writing Resources','','inherit','closed','closed','','39-revision-v1','','','2018-08-16 18:09:35','2018-08-16 18:09:35','',39,'https://dmweade.com/welcome/2018/08/16/39-revision-v1/',0,'revision','',0),
 (192,1,'2018-08-16 18:10:13','2018-08-16 18:10:13','<p style=\"text-align: center;\"><strong>Bringing order to my links or tilting at windmills,\r\nyou make the call.\r\n</strong><em>(Long page, so keep scrolling)</em></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Critiquing Groups</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.inkedvoices.com/\">Inked Voices</a> (Where I hang out)</li>\r\n 	<li><a href=\"http://www.critters.org/\">Critters</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Professional Support</strong></p>\r\n\r\n<ul>\r\n 	<li><a href=\"https://www.janefriedman.com/find-freelance-book-editor/\" target=\"_blank\" rel=\"noopener\">5 Ways to Find the Right Freelance Book Editor</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://duotrope.com/\">Duotrope</a>: Find publishers and editor</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://critters.org/blackholes/index.ht\">Critters Blackhole benchmarks</a>: Average wait time from publishers</li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.ralan.com/\">Ralan.com</a>: Market overviews</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://thegrinder.diabolicalplots.com/\">The Grinder</a>: Submission tracker</li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.agentquery.com/\">Agent Query - Search agents to find their current interests</a></li>\r\n</ul>\r\n<strong>Writing challenges</strong>\r\n<ul>\r\n 	<li><a href=\"http://www.nanowrimo.org/\">National Novel Writing Month (NaNoWriMo) </a></li>\r\n 	<li><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://sixsentences.blogspot.com/\">Challenge yourself to write a story in six sentences</a></li>\r\n</ul>\r\n<strong>Self Promotion / Building a Platform</strong>\r\n<ul>\r\n 	<li><a href=\"https://www.annfriedman.com/recommendations/\" target=\"_blank\" rel=\"noopener\">An example of supporting others through your site</a></li>\r\n 	<li><a href=\"https://drive.google.com/file/d/1xj3JnC31ab0On_fRCqtZ--RroC_c9nqF/view\" target=\"_blank\" rel=\"noopener\">The Art and Business of Author Platform</a></li>\r\n 	<li><a href=\"%20https://www.writersdigestshop.com/build-your-author-platform-through-blogging-webinar\" target=\"_blank\" rel=\"noopener\">Build Your Author Platform Through Blogging OnDemand Webinar</a> by Jane Friedman</li>\r\n 	<li>Wealthy Web Writer: <a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.wealthywebwriter.com/\">Make money online with your writing</a></li>\r\n 	<li><a href=\"https://medium.com/the-mission/note-to-all-creatives-marketing-is-your-job-6c4adecc38bf\" target=\"_blank\" rel=\"noopener\">Note to All Creatives: Marketing is Your Job</a></li>\r\n 	<li><a href=\"https://anchor.fm/\" target=\"_blank\" rel=\"noopener\">Anchor Podcasting App</a></li>\r\n</ul>\r\n</td>\r\n<td style=\"width: 4%;\"></td>\r\n<td style=\"width: 48%; text-align: center;\">\r\n<p style=\"text-align: left;\"><strong>Writing Advice</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingclasses.com/InformationPages/index.php/PageID/300\">Gotham Writer’s Workshop: George Orwell’s 6 Rules</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.brainpickings.org/index.php/2012/04/03/kurt-vonnegut-on-writing-stories/\">Vonnegut\'s 8 Tips for a Great Story</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.tor.com/2015/06/29/five-things-epic-fantasy-writers-could-learn-from-dorothy-dunnett/\" target=\"_blank\" rel=\"noopener\">Five Things Epic Fantasy Writers Could Learn from Dorothy Dunnett</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2013/06/05/susan-sontag-on-writing-2/\" target=\"_blank\" rel=\"noopener\">Susan Sontag on the Four People a Great Writer Must Be</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.brainpickings.org/2014/12/02/lynda-barry-syllabus-book/\" target=\"_blank\" rel=\"noopener\">Keeping a Visual Diary</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"https://www.signature-reads.com/download/2017-ultimate-writing-guide/?ref=PRHC9E2F30E44&amp;aid=randohouseinc34192-20&amp;linkid=PRHC9E2F30E44\" target=\"_blank\" rel=\"noopener\">2017 Ultimate Writing Guide</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Sites supporting writing</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://sfwa.org/\">Science Fiction and Fantasy Writers of America </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writing.com/\">Writing.com</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://wow-womenonwriting.com/\">WOW!  Women on Writing</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://internetwritingworkshop.org/\">Internet Writing Workshop</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.writingexcuses.com/\">Writing Excuses podcast </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://critters.org/\">Critters Workshop </a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"https://owl.english.purdue.edu/owl/section/1/\">Purdue\'s Online Writing Lab\'s resources</a></li>\r\n 	<li style=\"text-align: left;\"><a style=\"font-family: inherit; font-size: inherit;\" href=\"http://www.dailywritingtips.com/\">Daily Writing Tips</a></li>\r\n</ul>\r\n<p style=\"text-align: left;\"><strong>Extras</strong></p>\r\n\r\n<ul>\r\n 	<li style=\"text-align: left;\"><a href=\"http://www.sfwa.org/other-resources/for-authors/writer-beware/\">Research scams to get a fair deal on your writing</a></li>\r\n 	<li style=\"text-align: left;\"><a href=\"http://holly.witteman.ca/index.php/2017/12/11/getting-access-to-paywalled-papers/\" target=\"_blank\" rel=\"noopener\">Getting Access to Paywalled Papers</a></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<p style=\"text-align: center;\"><strong>The Craft of Writing</strong></p>\r\n\r\n<table style=\"border-collapse: collapse; width: 100%;\" border=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 48%;\"><strong>Story Structure</strong>\r\n<ul>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2012/10/orson-scott-card-mice-quotient-how-to.html\" target=\"_blank\" rel=\"noopener\">The MICE Quotient: How to Structure Your Story</a></li>\r\n 	<li><a href=\"https://www.livewritethrive.com/2014/10/08/infusing-microtension-in-your-novel/\" target=\"_blank\" rel=\"noopener\">Infusing Microtension in Your Novel</a></li>\r\n 	<li><a href=\"http://www.well-storied.com/blog/my-outlining-process\" target=\"_blank\" rel=\"noopener\">My Outlining Process: How I Prepare to Draft My Novels</a></li>\r\n 	<li><a href=\"https://narrativefirst.com/articles/four-acts-not-three\" target=\"_blank\" rel=\"noopener\">Four Acts, Not Three</a></li>\r\n 	<li><a href=\"https://sydfield.com/writers-tools/the-paradigm-worksheet/\" target=\"_blank\" rel=\"noopener\">The Paradigm Worksheet</a></li>\r\n 	<li><a href=\"http://actfourscreenplays.com/screenwriting-blog/trilogy-building-halo-and-star-wars/\" target=\"_blank\" rel=\"noopener\">Trilogy Building: Star Wars and Halo Plots</a></li>\r\n 	<li><a href=\"http://blog.karenwoodward.org/2014/03/a-four-act-structure.html\" target=\"_blank\" rel=\"noopener\">A Four Act Structure</a></li>\r\n 	<li><a href=\"http://www.writersdigest.com/wp-content/uploads/Master-Plots-Exclusive.pdf\" target=\"_blank\" rel=\"noopener\">20 Master Plots and How to Build Them</a></li>\r\n</ul>\r\n<strong>Character Development</strong>\r\n<ul>\r\n 	<li><a href=\"https://epicallywritten.wordpress.com/2014/04/02/character-traits-as-sliding-scales/\" target=\"_blank\" rel=\"noopener\">Character Traits as Sliding Scales</a>: Competence, Proactivity and Sympathy</li>\r\n 	<li><a href=\"https://writingexcuses.com/2014/03/30/writing-excuses-9-13-three-prong-character-development/\" target=\"_blank\" rel=\"noopener\">Writing Excuses 9.13: Three Pronged Character Development</a> (covering the sliding scale)</li>\r\n 	<li><a href=\"http://www.writersdigest.com/editor-blogs/there-are-no-rules/11-secrets-to-writing-effective-charac