# Gutenberg Blocks and Template Library by Otter #
**Contributors:** [themeisle](https://profiles.wordpress.org/themeisle), [hardeepasrani](https://profiles.wordpress.org/hardeepasrani)  
**Tags:** gutenberg blocks, gutenberg, block,post grid block, google map block, columns block, advanced columns, section, row, layout  
**Requires at least:** 5.2      
**Tested up to:** 5.3    
**Requires PHP:** 5.4    
**Stable tag:** trunk  
**License:** GPLv3    
**License URI:** https://www.gnu.org/licenses/gpl-3.0.en.html    

Create beautiful and attracting posts, pages, and landing pages with Gutenberg Blocks and Template Library by Otter. Otter comes with dozens of Gutenberg blocks that are all you need to build beautiful pages in Gutenberg.

## Description ##

Gutenberg Blocks and Template Library by Otter is a lightweight WordPress plugin that brings extra Gutenberg blocks to your site. So if you want to create complex pages and posts optimized for e-commerce, business, social media, blogs - you name it -comes with dozens of Gutenberg blocks that are all you need to build beautiful pages.

See what you can do with Otter:

https://www.youtube.com/watch?v=ypIeTgvYeRE

A feature that is worth mentioning is the Section Block that allows you to build columns and various layouts in Gutenberg. Moreover, aside from the Gutenberg blocks, the plugin provides a beautiful library of pre-built Gutenberg-compatible templates that you can simply import via one click. The templates have block-friendly layouts that can be customized with no effort.

Every block can be customized in a few seconds, as they come with an easy and intuitive user 

It has:

- Section Block
- Advanced Heading Block
- Button Group Block
- Slider Block
- Google Maps Block
- Post Grid Block
- Service Block
- Pricing Block
- Testimonial Block
- About Author Block
- Font Awesome Block
- Sharing Icons Block
- Plugin Card Block

## Screenshots ##

1. Section Block
2. Google Map Block
3. Posts Block

## Changelog ##

##### [Version 1.4.1](https://github.com/Codeinwp/otter-blocks/compare/v1.4.0...v1.4.1) (2020-02-29)

- Fix issue with Button Group & Global Defaults
- Add Offset to Posts Block
- Allow custom IDs in Section & Advanced Heading Block
- Add speed option in Slider Block
- Fix issue with Overlay Gradient not working in Section Block




#### [Version 1.4.0](https://github.com/Codeinwp/otter-blocks/compare/v1.3.3...v1.4.0) (2020-02-23)

- Add Column Width control to Sidebar
- Remove Inline CSS from Blocks
- Fix Block ID Mechanism
- Add Global Defaults
- Improve Vertical Alignment to Section Block
- Add option to disable Arrows/Bullets in Slider Block
- Option to reverse columns in Section
- Add theme_support for global defaults
- Inherit Sizing values
- Button Group consistency with Button Block
- Add Anchor field to Advanced Heading Block




##### [Version 1.3.3](https://github.com/Codeinwp/otter-blocks/compare/v1.3.2...v1.3.3) (2020-01-19)

Fix issue with Custom CSS module not working




##### [Version 1.3.2](https://github.com/Codeinwp/otter-blocks/compare/v1.3.1...v1.3.2) (2020-01-10)

- Add Slider Transforms [#142](https://github.com/Codeinwp/otter-blocks/issues/142)
- Improve Onboarding Experience & New Icons: [#144](https://github.com/Codeinwp/otter-blocks/issues/144)
- Remove deprecated blocks: [#103](https://github.com/Codeinwp/otter-blocks/issues/103)
- React Hooks: [#145](https://github.com/Codeinwp/otter-blocks/issues/145)
- Remove background from Posts Block: [#149](https://github.com/Codeinwp/otter-blocks/issues/149)
- Allow changing Title tag in Posts Block: [#147](https://github.com/Codeinwp/otter-blocks/issues/147)
- Change Category from H6 to Span: [#148](https://github.com/Codeinwp/otter-blocks/issues/148)
- Option to remove the image's box-shadow: [#146](https://github.com/Codeinwp/otter-blocks/issues/146)
- Fix domino effect in Sizing Component: [#151](https://github.com/Codeinwp/otter-blocks/issues/151)
- Add tracking toggle to Option Page
- Use React Hooks for Option Panel



### 1.3.1 - 2019-12-03  ###

* - Added Slider Block
* - Fixed issue with extensions failing with ServerSideRenderer


### 1.3.0 - 2019-11-05  ###

* Lazy load Font Awesome Picker to improve load time.
* Fixed link fetching in WP 5.0
* Added Style Switcher to Block Controls
* Added Map Styles to Google Map Block
* Improved CSS handling for blocks
* Added block navigator to Section block
* Added inserter to Button Group
* Fixed Marker Modal closing on search
* Fixed sizing control focus
* Fixed post excerpt now showing in Posts Grid
* Added meta control options to Posts Block
* Added improved Gradient Picker control


### 1.2.5 - 2019-09-10  ###

* Fix AMP compatibility errors.


### 1.2.4 - 2019-07-30  ###

* Fix Internet Explorer incompatibility
* Add option to choose Marker color for Google Map block
* Refreshed "New Marker" UI for Google Map block


### 1.2.3 - 2019-05-24  ###

* Add BlockInserter
* Google Maps Improvements
* Link Component Improvements
* Fix Sizing Control value type


### 1.2.2 - 2019-05-08  ###

* Add HTML Anchor to Section Block.
* Change Default Section setting.
* Fix resizer styles.
* Add Link Component.
* Add Marker button to Map.
* Remove Padding Resizer.
* Better UI for Sizing Control.
* Fix Dynamic CSS not rendering on reusable blocks.
* Validate blocks before importing.


### 1.2.1 - 2019-04-20  ###

* Fixed issue with constant not being checked in Otter
* Added error handling in Backbone functions

### 1.2.0 - 2019-04-18  ###

* Added Otter Option page
* Added update notice on Template Library
* Redesigned Google Map block
* Redesigned Post Grid block
* Removed Handsontable from Chart block


### 1.1.5 - 2019-03-08  ###

* Redesign Template Library
* Added Dynamic Column Resizing
* Added option to Auto Display Columns on Pages
* Added Section Outline to make it easier to edit sections
* Added Hover and Link settings to Font Awesome Block
* Removed Google + icon from Sharing Icons Block
* Fixed alignment controls
* Fixed issue with non-editors not being able to use inline CSS and template library.
* Fixed Button Group errors
* Fixed Sharing Icons block having wrong icon order in front-end

### 1.1.4 - 2019-01-31  ###

* Fix Font Awesome Block update path
* Show selected font in Google Font picker
* Fix Font Awesome Picker component being case-sensitive

### 1.1.3 - 2019-01-30  ###

* Adds Feedback for Button Group Switch
* Fixes Post Grid throwing an error
* Fixes issue with multiple block templates being inserted on the same post
* Fixes Font Awesome block alignment on the backend

### 1.1.2 - 2019-01-28  ###

* Fix Button Group Migration
* Revamped Font Awesome Icon Picker

### 1.1.1 - 2019-01-25  ###

* Added Developer Documentation
* Added Typography Option to Block Toolbar
* Fixed Padding Resizer
* Made Template Library Responsive
* Fixed Close Icon Alignment on Chrome
* Fixed Alignment with Span Tag in Advanced Heading Block
* Added Line Height Option to Button Group
* Added Option to Collapse Buttons
* Fixed Icon Issue in Button Group
* Increased Maximum Font Size Limit
* Fixed Font Weight Value Error
* Fixed Fatal Error Caused by Gutenberg Plugin
* Fixed Unescaped Character Preview in Post Grid
* Improved Handling of Unique Block IDs
* Added Left/Right Margin Options to Section Column
* Added Controls for Responsive Alignment to Advanced Heading Block
* Fixed Vertical Alignment in Section Block
* Fixed Alignment Issue in Social Sharing Block

### 1.1.0 - 2019-01-18 ###
* Added Section Block, with Template Library
* Added Advanced Heading Block
* Added Button Group Block
* Deprecated Notice, Click to Tweet, Chart, Accordion, blocks

### 1.0.4 - 2018-12-07 ###
* Fixed dependencies issue
 
### 1.0.3 - 2018-12-07 ###
* Fixes issue with Posts Grid block displaying wrong author
 
### 1.0.2 - 2018-12-05 ###
* Fixed Notice Block and Font Awesome Icons
* Optimized build size
 
### 1.0.1 - 2018-10-29 ###
* Bug fixed with Google Map block.
 
### 1.0.0 - 2018-10-17 ###
* Adds docker env.
* Adds hash back.
